.TH BUDGE 1 "Release 5" "X Version 11"
.SH NAME
Budge - an arcade/puzzle game for X written in Tcl/Tk
.LP
.SH SYNOPSIS
.B budge
[-\fIwish option\fP ...] [-lf <level file>]
.LP
.SH DESCRIPTION
The player controls
.I Budge,
a creature of indeterminate species, who owns a stud farm where he breeds
monsters and sells them to people who write MUDs. Unfortunately he has a 
problem: due to recent sun-spot activity, the monsters have all gone completely
mad! Since he has to fulfil a large order for monsters by tomorrow, he must 
venture into the breeding pens and force the critters to breed himself.

There are two types of monsters in the pens: spiky monsters and fluffy
monsters. Due to the sun-spot activity, the spiky monsters have been driven
into a killing frenzy and chase 
.I Budge
around the pens; luckily they are quite stupid and can be blocked off behind
walls. The fluffy monsters on the other hand have withdrawn into a trance and
wander around their pens, turning anti-clockwise whenever they bump into a
wall. If 
.I Budge
can make the two monsters in each pen bump into each other, nature will take
over; he can then leave them to it and go on to deal with the monsters in the
next pen.

The monsters' pens are built from several pre-fabricated parts, which must be
used to maneuver the monsters together:
.RS 4
.IP "Walls:" 20
nothing can move through these
.IP "Gates:" 20
these block monsters but can be opened by the player
.IP "Disks:" 20
these block monsters but can be pushed around by the player
.IP "Killers:" 20
these block monsters and kill the player if he moves onto them
.IP "Invisible blocks:" 20
nothing can move through these, but you can't see them!
.IP "Freeze pills:" 20
moving onto one of these will stop the monsters moving for a few seconds
.RE

Beware - bumping into any of the monsters is fatal!
.SH OPTIONS
.LP
.I Budge
accepts all of the standard Wish command line options along with the
additional options listed below:
.TP 8
.B -lf \fIpath\fP
Sets the file which
.I budge
will read the levels from. The format of level files is described below.
.PP
.SH DEFAULT CONTROLS
.TP 8
\fBCursor Keys\fP
Move \fIBudge\fP
.TP 8
\fBF2\fP
Pause Game
.TP 8
\fBF1\fP
Start Game
.TP 8
\fBF4\fP
Change Keys
.TP 8
\fBF3\fP
Lose a life and restart level
.TP 8
\fBF8\fP
Quit game (when playing) or quit program (when not playing)
.PP

.SH RESOURCES
.PP
As well as the standard resources of the Tk widget set, 
.I Budge
has these additional resources:
.TP 8
.B \.monsterDelay (class MonsterDelay)
Sets the delay between the monsters' moves, in milliseconds. This resource 
defaults to 250, ie: a quarter of a second.
.TP 8
.B \.freezeDelay (class FreezeDelay)
Sets the length of time that the monsters are frozen for after a freeze pill is
collected, in milliseconds. This resource defaults to 10000, ie: ten seconds.
.TP 8
.B \.levelFile (class LevelFile)
Sets the directory in which
.I budge
will look for level files. The format of level files is detailed below. This 
resource defaults to \"$budge(lib)/levels\"
.TP 8
.B \.up (class Up)
Sets the key to move \fIBudge\fP up (specified as a keysym).
.TP 8
.B \.down (class Down)
Sets the key to move \fIBudge\fP down (specified as a keysym).
.TP 8
.B \.left (class Left)
Sets the key to move \fIBudge\fP left (specified as a keysym).
.TP 8
.B \.right (class Right)
Sets the key to move \fIBudge\fP right (specified as a keysym).
.TP 8
.B \.pause (class Pause)
Sets the key to pause the game (specified as a keysym).
.TP 8
.B \.die (class Die)
Sets the key to kill \fIBudge\fP and restart the current level (specified as a
keysym).
.TP 8
.B \.play (class Play)
Sets the key to start a new game from the information display
(specified as a keysym).
.TP 8
.B \.quit (class Quit)
Sets the key to quit the current game when playing, or quit the program when
not playing 
(specified as a keysym).

.PP
.SH CREATING NEW LEVELS
.I Budge
reads its levels from the file specified by the
.I -lf
command-line option, by the
.I levelFile
resource or (as default) from the levels file in the budge lib directory.

The file contains descriptions of each level in ASCII characters, and so new
levels and level-files can be created with any text editor.

Levels are made up of objects laid out on an invisible grid of 15 rows and
20 columns. Every 16 lines of the file describes a level, with 
.I no
blank lines in between levels. The first line of each level is the level's 
title which must be in quotes. Each character on the 15 following lines 
describe the object at the corresponding position in the level's grid. If a
newline character is found before the twenty-first character on a line, the 
rest of the corresponding row in the level will be filled with empty spaces.
.PP
If an end-of-file character is found before the end of the last level in the
file, the rest of the last level will be filled with empty spaces.

Each object in the game is represented by a character:
.RS 4
.IP <space> 8
Empty space
.IP # 8
Block
.IP + *
Gate
.IP o 8
Disk
.IP x 8
Killer
.IP - 8
Invisible block
.IP f 8
Freeze pill
.IP * 8
Spiky monster's start position. If more than one * character is found, strange 
things will happen.
.IP @ 8
Fluffy monster's start position. If more than one @ character is found, strange 
things will happen.
.IP P 8
Player's start position. If more than one P character is found, strange 
things will happen.
.RE

New levels can be tested by creating them in a separate file and running
.I budge
with the 
.I -lf
option to set the level file to the new level.
.PP
.SH ENVIRONMENT
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH FILES
.PP
/usr/lib/X11/app-defaults/Budge	-  required resources.
.PP
/usr/lib/games/budge/levels		-  default level file.
.PP
/usr/lib/games/budge/bitmaps/*	-  bitmap files
.SH "SEE ALSO"
X(1) wish(1) Tcl(n) bind(n)

Budge II - One Budge & His Bot. Coming soon to a display near you!!
.SH DIAGNOSTICS
.TP 8
"no level-file specified for -lf option"
You must give a filename for the -lf option.
.PP
.TP 8
"level file <file> not readable"
.I Budge
cannot open the level file. Either the access permissions are incorrect or 
.I budge
is looking in the wrong place for the level file and its location must be set
via the budge(level_file) variable, X resources or the command line arguments.
.PP
.SH BUGS
.PP
The plot at the top of this man page is
.I really
awful!
.PP
Email any bug reports, comments or improvements to the author.
.SH COPYRIGHT
.PP
Copyright 1994, Nat Pryce.
.SH AUTHOR
.PP
Nat Pryce, Undergraduate, Department of Computing, Imperial College, London
(np2@doc.ic.ac.uk).

Level 17 was designed by Simon Cuff (sc2@doc.ic.ac.uk).






