#!/data/users/ding/bin/wish -f
# Program: addressManager1
# Tcl version: 7.3 (Tcl/Tk/XF)
# Tk version: 3.6
# XF version: 2.2
#

# to set the auto path to load all the necessary procedure automatically

#set auto_path "$auto_path /data/users/ding/TclTk/procedures"

# the address database file name
set addressDB ""

# the lists for all the entries
set ID_list ""
set Name_list ""
set Tel_W_list ""
set Tel_H_list ""
set Tel_O_list ""
set Fax_list ""
set Email_list ""
set Sex_list ""
set DOB_list ""
set Title_list ""
set Occupation_list ""
set Address_list ""
set Note_list ""
set Comment_list ""

set allLists "Name_list ID_list Tel_W_list Tel_H_list \
    Tel_O_list Fax_list Email_list Sex_list DOB_list Title_list \
    Occupation_list Address_list Note_list Comment_list"

# set all the entry name

set ID_listEntry .entry1
set Name_listEntry .entry4
set Tel_W_listEntry .entry6
set Tel_H_listEntry .entry5
set Tel_O_listEntry .entry8
set Fax_listEntry .entry10
set Email_listEntry .entry12
set Sex_listEntry .entry14
set DOB_listEntry .entry16
set Title_listEntry .entry18
set Occupation_listEntry .entry20
set Address_listEntry .frame21.frame.frame3.entry5
set Note_listEntry .frame25.frame.frame3.entry5

set Comment_listEntry .frame23.frame.text2

set allEntryWins ".entry1 .entry4 .entry6 .entry5 .entry8 .entry10 \
                  .entry12 .entry14 .entry16 .entry18  .entry20 \
                  .frame21.frame.frame3.entry5 .frame25.frame.frame3.entry5"
set textWin ".frame23.frame.text2"

# the listsBuffer for all the entries, #
# they are used for copy and paste functions
set ID_listBuffer ""
set Name_listBuffer ""
set Tel_W_listBuffer ""
set Tel_H_listBuffer ""
set Tel_O_listBuffer ""
set Fax_listBuffer ""
set Email_listBuffer ""
set Sex_listBuffer ""
set DOB_listBuffer ""
set Title_listBuffer ""
set Occupation_listBuffer ""
set Address_listBuffer ""
set Note_listBuffer ""
set Comment_listBuffer  ""

# the size of the address database
set databaseSize 0

# crrntDBindex
set crrntDBindex 0

# envVal envValName
#   Looks up the envValName environment variable and returns its
#   value, or {} if it does not exists
proc envVal {envValName} {
  global env
  if [info exists env($envValName)] {return $env($envValName)} {return {}}
}
# to initialize addressManager1 
proc addressManager1Init { } {

  global addressDB databaseSize
  global ID_list Name_list Tel_W_list Tel_H_list Tel_O_list Fax_list \
         Email_list \
         Sex_list DOB_list Title_list Occupation_list Address_list \
         Note_list Comment_list
  global allLists
  global ID_listEntry Name_listEntry Tel_W_listEntry Tel_H_listEntry\
         Tel_O_listEntry Fax_listEntry Email_listEntry Sex_listEntry \
         DOB_listEntry Title_listEntry Occupation_listEntry \
         Address_listEntry Note_listEntry Comment_listEntry

  global allEntryWins textWin

    set databaseSize 0
set addressDB [envVal ADDRESS_DATABASE]
if { $addressDB == "" } {
   set addressDB {/home/users/ding/Mail/friends.db}
}

loadFile $addressDB

# To bind the <Left> and <Right> arrow keys to all the entries

  foreach crrntEntry $allEntryWins {
    bind $crrntEntry <Left> {
      set tmp [%W index insert]
      %W icursor [expr $tmp - 1]
    }
    bind $crrntEntry <Right> {
      set tmp [%W index insert]
      %W icursor [expr $tmp + 1]
    }
# To bind accelerator keys

   bind $crrntEntry <Control-o> {newEntry}
   bind $crrntEntry <Control-p> { set n [expr $crrntDBindex -1]
           viewRecord $n}
   bind $crrntEntry <Control-n> { set n [expr $crrntDBindex +1]
           viewRecord $n  }
   bind $crrntEntry <Control-c> {copyEntry}
   bind $crrntEntry <Control-y> {pasteEntry}
   bind $crrntEntry <Control-s> {writeNewEntry
              incr databaseSize
              addressManagerMessage "The current entry is saved " 3
              if { [winfo exists .topViewAll ]} viewAll}

  }

# To bind the four error keys to the comment text
  bind $textWin <1> {focus %W; %W mark set insert @%x,%y}
  bind $textWin <Left> {%W mark set insert "insert -1 chars"}
  bind $textWin <Right> {%W mark set insert "insert +1 chars"}
  bind $textWin <Up> {%W mark set insert "insert -1 lines"}
  bind $textWin <Down> {%W mark set insert "insert +1 lines"}


# To bind accelerator keys

 bind $textWin <Control-o> {newEntry}
 bind $textWin <Control-p> { set n [expr $crrntDBindex -1]
        viewRecord $n}
 bind $textWin <Control-n> { set n [expr $crrntDBindex +1]
        viewRecord $n  }
 bind $textWin <Control-c> {copyEntry}
 bind $textWin <Control-y> {pasteEntry}
 bind $textWin <Control-s> {writeNewEntry
              incr databaseSize
              addressManagerMessage "The current entry is saved " 3
              if { [winfo exists .topViewAll ]} viewAll}


 bind . <Control-o> {newEntry}
 bind . <Control-p> { set n [expr $crrntDBindex -1]
        viewRecord $n}
 bind . <Control-n> { set n [expr $crrntDBindex +1]
        viewRecord $n  }
 bind . <Control-c> {copyEntry}
 bind . <Control-y> {pasteEntry}
 bind . <Control-s> {writeNewEntry
              incr databaseSize
              addressManagerMessage "The current entry is saved " 3
              if { [winfo exists .topViewAll ]} viewAll}
 bind all <Escape><Shift-less> {set n 0
        viewRecord $n  }
 bind all <Escape><Shift-greater> {set n [expr $databaseSize -1]
        viewRecord $n  }

  global {fsBox}
  set {fsBox(activeBackground)} {}
  set {fsBox(activeForeground)} {}
  set {fsBox(all)} {0}
  set {fsBox(background)} {}
  set {fsBox(button)} {0}
  set {fsBox(extensions)} {0}
  set {fsBox(font)} {}
  set {fsBox(foreground)} {}
  set {fsBox(internalPath)} [pwd]
  set {fsBox(name)} {}
  set {fsBox(path)} [pwd]
  set {fsBox(pattern)} {*}
  set {fsBox(scrollActiveForeground)} {}
  set {fsBox(scrollBackground)} {}
  set {fsBox(scrollForeground)} {}
  set {fsBox(scrollSide)} {left}
  set {fsBox(showPixmap)} {0}
  global {yesNoBox}
  set {yesNoBox(activeBackground)} {}
  set {yesNoBox(activeForeground)} {}
  set {yesNoBox(afterNo)} {0}
  set {yesNoBox(afterYes)} {0}
  set {yesNoBox(anchor)} {n}
  set {yesNoBox(background)} {}
  set {yesNoBox(button)} {0}
  set {yesNoBox(font)} {*times-bold-r-normal*24*}
  set {yesNoBox(foreground)} {}
  set {yesNoBox(justify)} {center}


}
#to save all the contents to the file, saveFileName
# if saveBlank == 1, then save the all the fields, otherwise, don't
# save the comments and don't save the field whose content is null

proc saveAddressDB {saveFileName saveBlank } {

  global databaseSize

  global allLists

  global ID_list Name_list Tel_W_list Tel_H_list Tel_O_list Fax_list \
         Email_list \
         Sex_list DOB_list Title_list Occupation_list Address_list \
         Note_list Comment_list

  set pFile [open $saveFileName w]

  puts $pFile "# Address Database \n"
  set tmp [exec date]
 
  puts $pFile "# Last modified at $tmp \n"
  puts $pFile "# Database size is $databaseSize \n"

  for { set i 0 } { $i < $databaseSize} {incr i } {
     foreach crrntlist $allLists {
 
       if { $crrntlist != "Comment_list" } {
          # To get the field name
          set tmp [expr [string last _ $crrntlist] -1]
          set fieldName [string range $crrntlist 0 $tmp]

          # To get the field content
          set cmd [concat $$crrntlist]
          set fieldContent [eval lindex $cmd $i]
          if { $saveBlank != 1} {
          # don't save the field whose content is null
            set contentLength [string length $fieldContent]
            if { $contentLength > 0 } {
              puts $pFile "$fieldName : $fieldContent"
            }
          } else {
          # save all the fields
            puts $pFile "$fieldName : $fieldContent"
          }
       } else {
          if { $saveBlank == 1} {
          # save the comments
       
          set cmd $Comment_list
          set fieldContent [lindex $Comment_list $i]
          puts $pFile "Comment : $fieldContent"
          }
       }
     }  
     puts $pFile "--------------------------"
  }
  close $pFile
}
# To write the current entry to the address database in the memory

proc writeNewEntry { } {
  global databaseSize
  global ID_list Name_list Tel_W_list Tel_H_list Tel_O_list Fax_list \
         Email_list \
         Sex_list DOB_list Title_list Occupation_list Address_list \
         Note_list Comment_list

  global allLists

  global ID_listEntry Name_listEntry Tel_W_listEntry Tel_H_listEntry\
         Tel_O_listEntry Fax_listEntry Email_listEntry Sex_listEntry \
         DOB_listEntry Title_listEntry Occupation_listEntry \
         Address_listEntry Note_listEntry Comment_listEntry

  foreach crrntlist $allLists {
    set crrntlistEntry $crrntlist\Entry
    if { $crrntlist == "Comment_list" } {
      set cmd [concat $$crrntlist\Entry]
      set wkEntry [eval $cmd get 1.0 end]
    } else {
      set cmd [concat $$crrntlistEntry]
      set wkEntry [eval $cmd get]
    }
    lappend $crrntlist $wkEntry
  }


}


# procedure to show window .top0
proc ShowWindow.top0 {args} {# xf ignore me 7

  # build widget .top0
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .top0"
  } {
    catch "destroy .top0"
  }
  toplevel .top0 

  # Window manager configurations
  global tkVersion
  wm positionfrom .top0 ""
  wm sizefrom .top0 ""
  wm maxsize .top0 1000 1000
  wm minsize .top0 10 10
  wm title .top0 {Choose one }


  # build widget .top0.frame1
  frame .top0.frame1 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top0.frame1.button2
  button .top0.frame1.button2 \
    -text {Save & Quit} \
    -command {saveAddressDB $addressDB 1
             addressManagerMessage "File was saved" 2
             exit}

  # build widget .top0.frame1.button3
  button .top0.frame1.button3 \
    -text {Quit} \
    -command {exit}

  # build widget .top0.frame1.button4
  button .top0.frame1.button4 \
    -text {Cancel} \
    -command {DestroyWindow.top0}

  # pack widget .top0.frame1
  pack append .top0.frame1 \
    .top0.frame1.button2 {left frame center} \
    .top0.frame1.button3 {left frame center} \
    .top0.frame1.button4 {top frame center}

  # pack widget .top0
  pack append .top0 \
    .top0.frame1 {top frame center}

  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .top0"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.top0 {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .top0]" != ""} {
      global xfShowWindow.top0
      set xfShowWindow.top0 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .top0; XFEditSetShowWindows"
    }
  } {
    catch "destroy .top0"
    update
  }
}


# procedure to clean all the entry content of the corrent record
# from screen, not from the the lists

proc newEntry { } {

 
  global ID_list Name_list Tel_W_list Tel_H_list Tel_O_list Fax_list \
         Email_list \
         Sex_list DOB_list Title_list Occupation_list Address_list \
         Note_list Comment_list

  global allLists

  global ID_listEntry Name_listEntry Tel_W_listEntry Tel_H_listEntry\
         Tel_O_listEntry Fax_listEntry Email_listEntry Sex_listEntry \
         DOB_listEntry Title_listEntry Occupation_listEntry \
         Address_listEntry Note_listEntry Comment_listEntry

  foreach crrntlist $allLists {
    set crrntlistEntry $crrntlist\Entry
    if { $crrntlist == "Comment_list" } {
      set cmd [concat $$crrntlist\Entry]
      eval $cmd delete 0.0 end
    } else {
      set cmd [concat $$crrntlistEntry]
      eval $cmd delete 0 end
    }
  }


}
# proc to view the n th record, and set n as crrntDBindex

proc viewRecord {n} {

  global databaseSize crrntDBindex

  global ID_list Name_list Tel_W_list Tel_H_list Tel_O_list Fax_list \
         Email_list \
         Sex_list DOB_list Title_list Occupation_list Address_list \
         Note_list Comment_list

  global allLists

  global ID_listEntry Name_listEntry Tel_W_listEntry Tel_H_listEntry\
         Tel_O_listEntry Fax_listEntry Email_listEntry Sex_listEntry \
         DOB_listEntry Title_listEntry Occupation_listEntry \
         Address_listEntry Note_listEntry Comment_listEntry

  if { $n >= [expr $databaseSize ] } {
  # reached the end of the database
    addressManagerMessage "The end of the database is reached " 3
    return 
  } elseif { $n < 0 } {
    addressManagerMessage "The beginning of the database is reached" 3
    return
  } else {
  # set the new crrntDBindex

  set crrntDBindex $n

  # to view n th record

  # to clean all the entry content from the screen first
  newEntry

    foreach crrntlist $allLists {
      set crrntlistEntry $crrntlist\Entry


    if { $crrntlist == "Comment_list" } {
      # To get the content of the comment
      set cmd [concat $$crrntlist]
      set fieldContent [eval lindex $cmd $n]

      # To insert the fieldContent to the field
      set cmd [concat $$crrntlist\Entry]
      set fieldContent "\{$fieldContent\}"
      eval $cmd insert 0.0 $fieldContent
    } else {
      # to get the content of the crrnt field
      set cmd [concat $$crrntlist]
      set fieldContent [eval lindex $cmd $n]


      # To insert the fieldContent to the field
      set cmd [concat $$crrntlistEntry]
      set fieldContent "\{$fieldContent\}"
      eval $cmd insert 0 $fieldContent

    }
  }
 
  # if the View All database window exists, highlight the current record
  if { [winfo exists .topViewAll] } {
     .topViewAll.frame2.frame4.frame.listbox1 select from $crrntDBindex
  # If the selected record is invisible, put it in the middle of the
  # listbox
     set minVisableY [.topViewAll.frame2.frame4.frame.listbox1 nearest 0]
    set maxVisableY [.topViewAll.frame2.frame4.frame.listbox1 nearest 10000000]
     if { $crrntDBindex < $minVisableY || $crrntDBindex > $maxVisableY } {
        .topViewAll.frame2.frame4.frame.listbox1 yview \
          [expr $crrntDBindex - int( 0.5 * ($maxVisableY - $minVisableY))]
     }

  # To put the current entry on the top of the listbox
#     .topViewAll.frame2.frame4.frame.listbox1 yview $crrntDBindex

  }

  }

}
# To copy all the field content of the current record
# to the list buffers, so that they can be used for paste

proc copyEntry { } {

  global ID_listBuffer Name_listBuffer Tel_W_listBuffer \
         Tel_H_listBuffer Tel_O_listBuffer Fax_listBuffer \
         Email_listBuffer Sex_listBuffer DOB_listBuffer \
         Title_listBuffer Occupation_listBuffer Address_listBuffer \
         Note_listBuffer Comment_listBuffer

  global ID_list Name_list Tel_W_list Tel_H_list Tel_O_list Fax_list \
         Email_list \
         Sex_list DOB_list Title_list Occupation_list Address_list \
         Note_list Comment_list

  global allLists crrntDBindex

    foreach crrntlist $allLists {
      set crrntlistBuffer $crrntlist\Buffer

    if { $crrntlist == "Comment_list" } {
      # To get the content of the comment
      set cmd [concat $$crrntlist]
      set fieldContent [eval lindex $cmd $crrntDBindex]

      # To put the fieldContent to the buffer
      set Comment_listBuffer $fieldContent
    } else {
      # to get the content of the crrnt field
      set cmd [concat $$crrntlist]
      set fieldContent [eval lindex $cmd $crrntDBindex]

      # To put the fieldContent to the buffer
      set $crrntlistBuffer $fieldContent

    }
    }

}
# To paste all the field content saved in listBuffers
# to the list fields.

proc pasteEntry { } {

  global ID_listBuffer Name_listBuffer Tel_W_listBuffer \
         Tel_H_listBuffer Tel_O_listBuffer Fax_listBuffer \
         Email_listBuffer Sex_listBuffer DOB_listBuffer \
         Title_listBuffer Occupation_listBuffer Address_listBuffer \
         Note_listBuffer Comment_listBuffer

  global ID_list Name_list Tel_W_list Tel_H_list Tel_O_list Fax_list \
         Email_list \
         Sex_list DOB_list Title_list Occupation_list Address_list \
         Note_list Comment_list

  global allLists crrntDBindex
  
  global ID_listEntry Name_listEntry Tel_W_listEntry Tel_H_listEntry\
         Tel_O_listEntry Fax_listEntry Email_listEntry Sex_listEntry \
         DOB_listEntry Title_listEntry Occupation_listEntry \
         Address_listEntry Note_listEntry Comment_listEntry

    foreach crrntlist $allLists {
      set crrntlistBuffer $crrntlist\Buffer
      set crrntlistEntry $crrntlist\Entry

    if { $crrntlist == "Comment_list" } {
      # To get the content of the comment
      set cmd [concat $$crrntlist\Buffer]
      eval set fieldContent $cmd

      # To put the fieldContent to the buffer
      set cmd [concat $$crrntlist\Entry]
      set fieldContent "\{$fieldContent\}"
      eval $cmd insert 0.0 $fieldContent

    } else {
      # to get the content of the crrnt field
      set cmd [concat $$crrntlist\Buffer]
      eval set fieldContent $cmd

      # To put the fieldContent to the buffer
      set cmd [concat $$crrntlistEntry]
      set fieldContent "\{$fieldContent\}"
      eval $cmd insert 0 $fieldContent

    }
    }

}

# to display a message on a top level for $waitingTime second
#  then delete it.

proc addressManagerMessage { message waitingTime} {

  toplevel .addressManagerMessage
  label .addressManagerMessage.label -text $message \
        -font {-*-times-bold-r-normal-*-24-240-*-*-p-*-iso8859-1}
  pack .addressManagerMessage.label
  after [expr $waitingTime * 1000 ]  {destroy .addressManagerMessage}

}

# To delete the current entry

proc deleteCrrntEntry { } {

  global ID_list Name_list Tel_W_list Tel_H_list Tel_O_list Fax_list \
         Email_list \
         Sex_list DOB_list Title_list Occupation_list Address_list \
         Note_list Comment_list

  global allLists crrntDBindex

  foreach crrntlist $allLists {
    set cmd [concat $$crrntlist]
    set tmplist [eval lreplace $cmd $crrntDBindex $crrntDBindex]
    set $crrntlist $tmplist
  }
}
# to sort the database alphabatically according the name

proc sortDatabase { } {

  global allLists databaseSize
  global ID_list Name_list Tel_W_list Tel_H_list Tel_O_list Fax_list \
         Email_list \
         Sex_list DOB_list Title_list Occupation_list Address_list \
         Note_list Comment_list

  global allEntryWins textWin

# put all the list together into allDatabase
#global allDatabase sortedDatabase
  set anItem ""
  set allDatabase ""
  for {set i 0} {$i < $databaseSize} { incr i} {
    set anItem ""
    foreach crrntlist $allLists {
      set cmd [concat $$crrntlist]
      lappend anItem [eval lindex $cmd $i]
    }
    lappend allDatabase $anItem
  }

# sort all the database
  set sortedDatabase [lsort $allDatabase]

# to clean all the lists

  foreach crrntlist $allLists {
     set $crrntlist ""
  }

# put the sorted database back
  for {set i 0} {$i < $databaseSize} { incr i} {
    set anItem [lindex $sortedDatabase $i]
    set j 0
    foreach crrntlist $allLists {
      lappend $crrntlist [lindex $anItem $j]
      incr j
    }
  }

}
# to view all the databasse

proc viewAll { } {
 
  global ID_list Name_list Tel_W_list Tel_H_list Tel_O_list Fax_list \
         Email_list \
         Sex_list DOB_list Title_list Occupation_list Address_list \
         Note_list Comment_list

  global allLists crrntDBindex databaseSize

  set viewAllList "Name_list Tel_W_list Tel_H_list Email_list"

# To open a toplevel
  ShowWindow.topViewAll
   
  for { set i 0 } { $i < $databaseSize} { incr i } {
    set record ""
    set j 0
    foreach crrntlist $viewAllList {
      set cmd [concat $$crrntlist]
      set fc$j [eval lindex $cmd $i]
      incr j
    }
#    set formattedRec [format "%18.17s %10.9s %10.9s %35.34s" $fc0 $fc1 $fc2 $fc3]
    set formattedRec [format "%18s %10s %10s %35s" $fc0 $fc1 $fc2 $fc3]
    .topViewAll.frame2.frame4.frame.listbox1 insert $i $formattedRec
  }

# To highlight the current entry
#     .topViewAll.frame2.frame4.frame.listbox1 select from $crrntDBindex
# to put the current entry in the middle of the listbox
     set n [expr $crrntDBindex]
     viewRecord $n
# To put the current entry on the top of the listbox
#     .topViewAll.frame2.frame4.frame.listbox1 yview $crrntDBindex

}

# procedure to show window .topViewAll
proc ShowWindow.topViewAll {args} {# xf ignore me 7

  # build widget .topViewAll
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .topViewAll"
  } {
    catch "destroy .topViewAll"
  }
  toplevel .topViewAll 

  # Window manager configurations
  global tkVersion
  wm positionfrom .topViewAll ""
  wm sizefrom .topViewAll ""
  wm maxsize .topViewAll 809 1000
  wm minsize .topViewAll 10 10
  wm title .topViewAll {Address Database}
  wm geometry .topViewAll {809x397+439+11}


  # build widget .topViewAll.frame2
  frame .topViewAll.frame2 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .topViewAll.frame2.frame3
  frame .topViewAll.frame2.frame3 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .topViewAll.frame2.frame3.button5
  button .topViewAll.frame2.frame3.button5 \
    -text {Dismiss} \
    -command {destroy .topViewAll}

  # pack widget .topViewAll.frame2.frame3
  pack append .topViewAll.frame2.frame3 \
    .topViewAll.frame2.frame3.button5 {left frame center}

  # build widget .topViewAll.frame2.frame4
  frame .topViewAll.frame2.frame4 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .topViewAll.frame2.frame4.frame
  frame .topViewAll.frame2.frame4.frame

  # build widget .topViewAll.frame2.frame4.frame.scrollbar3
  scrollbar .topViewAll.frame2.frame4.frame.scrollbar3 \
    -command {.topViewAll.frame2.frame4.frame.listbox1 xview} \
    -orient {horizontal} \
    -relief {raised}

  # build widget .topViewAll.frame2.frame4.frame.scrollbar2
  scrollbar .topViewAll.frame2.frame4.frame.scrollbar2 \
    -command {.topViewAll.frame2.frame4.frame.listbox1 yview} \
    -relief {raised}

  # build widget .topViewAll.frame2.frame4.frame.listbox1
  listbox .topViewAll.frame2.frame4.frame.listbox1 \
    -relief {raised} \
    -xscrollcommand {.topViewAll.frame2.frame4.frame.scrollbar3 set} \
    -yscrollcommand {.topViewAll.frame2.frame4.frame.scrollbar2 set} \
    -font {-misc-fixed-medium-r-normal--20-200-75-75-c-100-iso8859-1}
  bind .topViewAll.frame2.frame4.frame.listbox1 <1> {listBoxAction %W %y}

  # pack widget .topViewAll.frame2.frame4.frame
  pack append .topViewAll.frame2.frame4.frame \
    .topViewAll.frame2.frame4.frame.scrollbar2 {left frame center filly} \
    .topViewAll.frame2.frame4.frame.listbox1 {top frame center expand fill} \
    .topViewAll.frame2.frame4.frame.scrollbar3 {bottom frame center fillx}

  # pack widget .topViewAll.frame2.frame4
  pack append .topViewAll.frame2.frame4 \
    .topViewAll.frame2.frame4.frame {top frame center expand fill}

  # pack widget .topViewAll.frame2
  pack append .topViewAll.frame2 \
    .topViewAll.frame2.frame3 {top frame center fillx} \
    .topViewAll.frame2.frame4 {top frame center expand fill}

  # pack widget .topViewAll
  pack append .topViewAll \
    .topViewAll.frame2 {top frame center expand fill}

  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .topViewAll"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.topViewAll {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .topViewAll]" != ""} {
      global xfShowWindow.topViewAll
      set xfShowWindow.topViewAll 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .topViewAll; XFEditSetShowWindows"
    }
  } {
    catch "destroy .topViewAll"
    update
  }
}
# to reset listbox behaviour

proc listBoxAction {w y} {

  set selectedIndex [$w nearest $y]
  $w select from $selectedIndex

  viewRecord $selectedIndex


}
# procedure to show window .topSearch
proc ShowWindow.topSearch {args} {# xf ignore me 7

  # build widget .topSearch
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .topSearch"
  } {
    catch "destroy .topSearch"
  }
  toplevel .topSearch  \
    -relief {raised}

  # Window manager configurations
  global tkVersion
  wm positionfrom .topSearch program
  wm sizefrom .topSearch program
  wm title .topSearch {Search Records}


  # build widget .topSearch.frame1
  frame .topSearch.frame1 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .topSearch.frame1.frame2
  frame .topSearch.frame1.frame2 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .topSearch.frame1.frame2.button4
  button .topSearch.frame1.frame2.button4 \
    -text {Forward} \
    -command {searchRecords forward}

  # build widget .topSearch.frame1.frame2.button5
  button .topSearch.frame1.frame2.button5 \
    -text {Backward} \
     -command {searchRecords backward}

  # build widget .topSearch.frame1.frame2.button6
  button .topSearch.frame1.frame2.button6 \
    -text {Dismiss} \
    -command {destroy .topSearch}

  # pack widget .topSearch.frame1.frame2
  pack append .topSearch.frame1.frame2 \
    .topSearch.frame1.frame2.button4 {left frame center expand fillx} \
    .topSearch.frame1.frame2.button5 {left frame center expand fillx} \
    .topSearch.frame1.frame2.button6 {left frame center expand fillx}

  # build widget .topSearch.frame1.frame3
  frame .topSearch.frame1.frame3 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .topSearch.frame1.frame3.frame
  frame .topSearch.frame1.frame3.frame \
    -relief {raised}

  # build widget .topSearch.frame1.frame3.frame.label4
  label .topSearch.frame1.frame3.frame.label4 \
    -padx {2} \
    -relief {flat} \
    -text {ID}

  # build widget .topSearch.frame1.frame3.frame.entry5
  entry .topSearch.frame1.frame3.frame.entry5 \
    -relief {sunken}
  bind .topSearch.frame1.frame3.frame.entry5 <Return> {focus .topSearch.frame1.frame3.frame9.entry5; .topSearch.frame1.frame3.frame9.entry5  icursor 0}

  # pack widget .topSearch.frame1.frame3.frame
  pack append .topSearch.frame1.frame3.frame \
    .topSearch.frame1.frame3.frame.label4 {left frame center} \
    .topSearch.frame1.frame3.frame.entry5 {top frame center expand fill}

  # build widget .topSearch.frame1.frame3.frame9
  frame .topSearch.frame1.frame3.frame9 \
    -relief {raised}

  # build widget .topSearch.frame1.frame3.frame9.label4
  label .topSearch.frame1.frame3.frame9.label4 \
    -padx {2} \
    -relief {flat} \
    -text {Name}

  # build widget .topSearch.frame1.frame3.frame9.entry5
  entry .topSearch.frame1.frame3.frame9.entry5 \
    -relief {sunken}
  bind .topSearch.frame1.frame3.frame9.entry5 <Return> {focus .topSearch.frame1.frame3.frame10.entry5; .topSearch.frame1.frame3.frame10.entry5 icursor 0}


  # pack widget .topSearch.frame1.frame3.frame9
  pack append .topSearch.frame1.frame3.frame9 \
    .topSearch.frame1.frame3.frame9.label4 {left frame center} \
    .topSearch.frame1.frame3.frame9.entry5 {top frame center expand fill}

  # build widget .topSearch.frame1.frame3.frame10
  frame .topSearch.frame1.frame3.frame10 \
    -relief {raised}

  # build widget .topSearch.frame1.frame3.frame10.label4
  label .topSearch.frame1.frame3.frame10.label4 \
    -padx {2} \
    -relief {flat} \
    -text {Tel (Work)}

  # build widget .topSearch.frame1.frame3.frame10.entry5
  entry .topSearch.frame1.frame3.frame10.entry5 \
    -relief {sunken}
  bind .topSearch.frame1.frame3.frame10.entry5 <Return> {focus .topSearch.frame1.frame3.frame11.entry5; .topSearch.frame1.frame3.frame11.entry5 icursor 0}

  # pack widget .topSearch.frame1.frame3.frame10
  pack append .topSearch.frame1.frame3.frame10 \
    .topSearch.frame1.frame3.frame10.label4 {left frame center} \
    .topSearch.frame1.frame3.frame10.entry5 {top frame center expand fill}

  # build widget .topSearch.frame1.frame3.frame11
  frame .topSearch.frame1.frame3.frame11 \
    -relief {raised}

  # build widget .topSearch.frame1.frame3.frame11.label4
  label .topSearch.frame1.frame3.frame11.label4 \
    -padx {2} \
    -relief {flat} \
    -text {Tel (Home)}

  # build widget .topSearch.frame1.frame3.frame11.entry5
  entry .topSearch.frame1.frame3.frame11.entry5 \
    -relief {sunken}
  bind .topSearch.frame1.frame3.frame11.entry5 <Return> {focus .topSearch.frame1.frame3.frame12.entry5; .topSearch.frame1.frame3.frame12.entry5 icursor 0}

  # pack widget .topSearch.frame1.frame3.frame11
  pack append .topSearch.frame1.frame3.frame11 \
    .topSearch.frame1.frame3.frame11.label4 {left frame center} \
    .topSearch.frame1.frame3.frame11.entry5 {top frame center expand fill}

  # build widget .topSearch.frame1.frame3.frame12
  frame .topSearch.frame1.frame3.frame12 \
    -relief {raised}

  # build widget .topSearch.frame1.frame3.frame12.label4
  label .topSearch.frame1.frame3.frame12.label4 \
    -padx {2} \
    -relief {flat} \
    -text {Tel (Others)}

  # build widget .topSearch.frame1.frame3.frame12.entry5
  entry .topSearch.frame1.frame3.frame12.entry5 \
    -relief {sunken}
  bind .topSearch.frame1.frame3.frame12.entry5 <Return> {focus .topSearch.frame1.frame3.frame13.entry5; .topSearch.frame1.frame3.frame13.entry5 icursor 0}

  # pack widget .topSearch.frame1.frame3.frame12
  pack append .topSearch.frame1.frame3.frame12 \
    .topSearch.frame1.frame3.frame12.label4 {left frame center} \
    .topSearch.frame1.frame3.frame12.entry5 {top frame center expand fill}

  # build widget .topSearch.frame1.frame3.frame13
  frame .topSearch.frame1.frame3.frame13 \
    -relief {raised}

  # build widget .topSearch.frame1.frame3.frame13.label4
  label .topSearch.frame1.frame3.frame13.label4 \
    -padx {2} \
    -relief {flat} \
    -text {Fax}

  # build widget .topSearch.frame1.frame3.frame13.entry5
  entry .topSearch.frame1.frame3.frame13.entry5 \
    -relief {sunken}
  bind .topSearch.frame1.frame3.frame13.entry5 <Return> {focus .topSearch.frame1.frame3.frame14.entry5; .topSearch.frame1.frame3.frame14.entry5 icursor 0}

  # pack widget .topSearch.frame1.frame3.frame13
  pack append .topSearch.frame1.frame3.frame13 \
    .topSearch.frame1.frame3.frame13.label4 {left frame center} \
    .topSearch.frame1.frame3.frame13.entry5 {top frame center expand fill}

  # build widget .topSearch.frame1.frame3.frame14
  frame .topSearch.frame1.frame3.frame14 \
    -relief {raised}

  # build widget .topSearch.frame1.frame3.frame14.label4
  label .topSearch.frame1.frame3.frame14.label4 \
    -padx {2} \
    -relief {flat} \
    -text {Email}

  # build widget .topSearch.frame1.frame3.frame14.entry5
  entry .topSearch.frame1.frame3.frame14.entry5 \
    -relief {sunken}
  bind .topSearch.frame1.frame3.frame14.entry5 <Return> {focus .topSearch.frame1.frame3.frame15.entry5; .topSearch.frame1.frame3.frame15.entry5 icursor 0}

  # pack widget .topSearch.frame1.frame3.frame14
  pack append .topSearch.frame1.frame3.frame14 \
    .topSearch.frame1.frame3.frame14.label4 {left frame center} \
    .topSearch.frame1.frame3.frame14.entry5 {top frame center expand fill}

  # build widget .topSearch.frame1.frame3.frame15
  frame .topSearch.frame1.frame3.frame15 \
    -relief {raised}

  # build widget .topSearch.frame1.frame3.frame15.label4
  label .topSearch.frame1.frame3.frame15.label4 \
    -padx {2} \
    -relief {flat} \
    -text {Sex}

  # build widget .topSearch.frame1.frame3.frame15.entry5
  entry .topSearch.frame1.frame3.frame15.entry5 \
    -relief {sunken}
  bind .topSearch.frame1.frame3.frame15.entry5 <Return> {focus .topSearch.frame1.frame3.frame16.entry5; .topSearch.frame1.frame3.frame16.entry5 icursor 0}

  # pack widget .topSearch.frame1.frame3.frame15
  pack append .topSearch.frame1.frame3.frame15 \
    .topSearch.frame1.frame3.frame15.label4 {left frame center} \
    .topSearch.frame1.frame3.frame15.entry5 {top frame center expand fill}

  # build widget .topSearch.frame1.frame3.frame16
  frame .topSearch.frame1.frame3.frame16 \
    -relief {raised}

  # build widget .topSearch.frame1.frame3.frame16.label4
  label .topSearch.frame1.frame3.frame16.label4 \
    -padx {2} \
    -relief {flat} \
    -text {DOB}

  # build widget .topSearch.frame1.frame3.frame16.entry5
  entry .topSearch.frame1.frame3.frame16.entry5 \
    -relief {sunken}
  bind .topSearch.frame1.frame3.frame16.entry5 <Return> {focus .topSearch.frame1.frame3.frame17.entry5; .topSearch.frame1.frame3.frame17.entry5 icursor 0}

  # pack widget .topSearch.frame1.frame3.frame16
  pack append .topSearch.frame1.frame3.frame16 \
    .topSearch.frame1.frame3.frame16.label4 {left frame center} \
    .topSearch.frame1.frame3.frame16.entry5 {top frame center expand fill}

  # build widget .topSearch.frame1.frame3.frame17
  frame .topSearch.frame1.frame3.frame17 \
    -relief {raised}

  # build widget .topSearch.frame1.frame3.frame17.label4
  label .topSearch.frame1.frame3.frame17.label4 \
    -padx {2} \
    -relief {flat} \
    -text {Title}

  # build widget .topSearch.frame1.frame3.frame17.entry5
  entry .topSearch.frame1.frame3.frame17.entry5 \
    -relief {sunken}
  bind .topSearch.frame1.frame3.frame17.entry5 <Return> {focus .topSearch.frame1.frame3.frame18.entry5; .topSearch.frame1.frame3.frame18.entry5 icursor 0}

  # pack widget .topSearch.frame1.frame3.frame17
  pack append .topSearch.frame1.frame3.frame17 \
    .topSearch.frame1.frame3.frame17.label4 {left frame center} \
    .topSearch.frame1.frame3.frame17.entry5 {top frame center expand fill}

  # build widget .topSearch.frame1.frame3.frame18
  frame .topSearch.frame1.frame3.frame18 \
    -relief {raised}

  # build widget .topSearch.frame1.frame3.frame18.label4
  label .topSearch.frame1.frame3.frame18.label4 \
    -padx {2} \
    -relief {flat} \
    -text {Occupation}

  # build widget .topSearch.frame1.frame3.frame18.entry5
  entry .topSearch.frame1.frame3.frame18.entry5 \
    -relief {sunken}
  bind .topSearch.frame1.frame3.frame18.entry5 <Return> {focus .topSearch.frame1.frame3.frame19.entry5; .topSearch.frame1.frame3.frame19.entry5 icursor 0}

  # pack widget .topSearch.frame1.frame3.frame18
  pack append .topSearch.frame1.frame3.frame18 \
    .topSearch.frame1.frame3.frame18.label4 {left frame center} \
    .topSearch.frame1.frame3.frame18.entry5 {top frame center expand fill}

  # build widget .topSearch.frame1.frame3.frame19
  frame .topSearch.frame1.frame3.frame19 \
    -relief {raised}

  # build widget .topSearch.frame1.frame3.frame19.label4
  label .topSearch.frame1.frame3.frame19.label4 \
    -padx {2} \
    -relief {flat} \
    -text {Address}

  # build widget .topSearch.frame1.frame3.frame19.entry5
  entry .topSearch.frame1.frame3.frame19.entry5 \
    -relief {sunken}
  bind .topSearch.frame1.frame3.frame19.entry5 <Return> {focus .topSearch.frame1.frame3.frame20.entry5; .topSearch.frame1.frame3.frame20.entry5 icursor 0}

  # pack widget .topSearch.frame1.frame3.frame19
  pack append .topSearch.frame1.frame3.frame19 \
    .topSearch.frame1.frame3.frame19.label4 {left frame center} \
    .topSearch.frame1.frame3.frame19.entry5 {top frame center expand fill}

  # build widget .topSearch.frame1.frame3.frame20
  frame .topSearch.frame1.frame3.frame20 \
    -relief {raised}

  # build widget .topSearch.frame1.frame3.frame20.label4
  label .topSearch.frame1.frame3.frame20.label4 \
    -padx {2} \
    -relief {flat} \
    -text {Note}

  # build widget .topSearch.frame1.frame3.frame20.entry5
  entry .topSearch.frame1.frame3.frame20.entry5 \
    -relief {sunken}
  bind .topSearch.frame1.frame3.frame20.entry5 <Return> {focus .topSearch.frame1.frame3.frame.entry5; .topSearch.frame1.frame3.frame.entry5 icursor 0}

  # pack widget .topSearch.frame1.frame3.frame20
  pack append .topSearch.frame1.frame3.frame20 \
    .topSearch.frame1.frame3.frame20.label4 {left frame center} \
    .topSearch.frame1.frame3.frame20.entry5 {top frame center expand fill}

  # pack widget .topSearch.frame1.frame3
  pack append .topSearch.frame1.frame3 \
    .topSearch.frame1.frame3.frame {top frame center fill} \
    .topSearch.frame1.frame3.frame9 {top frame center fill} \
    .topSearch.frame1.frame3.frame10 {top frame center fill} \
    .topSearch.frame1.frame3.frame11 {top frame center fill} \
    .topSearch.frame1.frame3.frame12 {top frame center fill} \
    .topSearch.frame1.frame3.frame13 {top frame center fill} \
    .topSearch.frame1.frame3.frame14 {top frame center fill} \
    .topSearch.frame1.frame3.frame15 {top frame center fill} \
    .topSearch.frame1.frame3.frame16 {top frame center fill} \
    .topSearch.frame1.frame3.frame17 {top frame center fill} \
    .topSearch.frame1.frame3.frame18 {top frame center fill} \
    .topSearch.frame1.frame3.frame19 {top frame center fill} \
    .topSearch.frame1.frame3.frame20 {top frame center fill}

  # pack widget .topSearch.frame1
  pack append .topSearch.frame1 \
    .topSearch.frame1.frame2 {top frame center expand fillx} \
    .topSearch.frame1.frame3 {top frame center}

  # pack widget .topSearch
  pack append .topSearch \
    .topSearch.frame1 {top frame center}

  .topSearch.frame1.frame3.frame.entry5 insert end {}
  .topSearch.frame1.frame3.frame9.entry5 insert end {}
  .topSearch.frame1.frame3.frame10.entry5 insert end {}
  .topSearch.frame1.frame3.frame11.entry5 insert end {}
  .topSearch.frame1.frame3.frame12.entry5 insert end {}
  .topSearch.frame1.frame3.frame13.entry5 insert end {}
  .topSearch.frame1.frame3.frame14.entry5 insert end {}
  .topSearch.frame1.frame3.frame15.entry5 insert end {}
  .topSearch.frame1.frame3.frame16.entry5 insert end {}
  .topSearch.frame1.frame3.frame17.entry5 insert end {}
  .topSearch.frame1.frame3.frame18.entry5 insert end {}
  .topSearch.frame1.frame3.frame19.entry5 insert end {}
  .topSearch.frame1.frame3.frame20.entry5 insert end {}



  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .topSearch"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.topSearch {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .topSearch]" != ""} {
      global xfShowWindow.topSearch
      set xfShowWindow.topSearch 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .topSearch; XFEditSetShowWindows"
    }
  } {
    catch "destroy .topSearch"
    update
  }
}

# To search the database

proc searchRecords { searchDirection} {

  global databaseSize crrntDBindex

  set ShID_listEntry .topSearch.frame1.frame3.frame.entry5
  set ShName_listEntry .topSearch.frame1.frame3.frame9.entry5
  set ShTel_W_listEntry .topSearch.frame1.frame3.frame10.entry5
  set ShTel_H_listEntry .topSearch.frame1.frame3.frame11.entry5
  set ShTel_O_listEntry .topSearch.frame1.frame3.frame12.entry5
  set ShFax_listEntry .topSearch.frame1.frame3.frame13.entry5
  set ShEmail_listEntry .topSearch.frame1.frame3.frame14.entry5
  set ShSex_listEntry  .topSearch.frame1.frame3.frame15.entry5
  set ShDOB_listEntry .topSearch.frame1.frame3.frame16.entry5
  set ShTitle_listEntry .topSearch.frame1.frame3.frame17.entry5
  set ShOccupation_listEntry .topSearch.frame1.frame3.frame18.entry5
  set ShAddress_listEntry .topSearch.frame1.frame3.frame19.entry5
  set ShNote_listEntry .topSearch.frame1.frame3.frame20.entry5

  set allShEntries "ShID_listEntry ShName_listEntry ShTel_W_listEntry \
                    ShTel_H_listEntry ShTel_O_listEntry ShFax_listEntry \
                    ShEmail_listEntry ShSex_listEntry ShDOB_listEntry \
                    ShTitle_listEntry ShOccupation_listEntry \
                    ShAddress_listEntry ShNote_listEntry"

# Only the fileds whose name is in the searchFieldNames list will be searched
  set searchFieldNames ""

# the searchFieldContent list is corresponding the searchFieldNames
  set searchFieldContent ""


# To get search fields

  foreach crrntEntry $allShEntries {
    set cmd [concat $$crrntEntry]
    # To get the content of the current entry
    set fieldContent [eval $cmd get]

    if {[string length $fieldContent ] > 0} {
    # there is something in this field
       lappend searchFieldNames $crrntEntry
       lappend searchFieldContent $fieldContent
    }
  }

  if { [llength $searchFieldNames] == 0 } {
  # Nothing at all on the search fields
    addressManagerMessage "You should set some fields to search" 3
    return
  }

# To start searching

  set found 0

  if { $searchDirection == "forward" } {
  # The searching direction is forward
    for { set i [expr $crrntDBindex + 1] } { $i < $databaseSize } { incr i } {
      set found [ searchCrrntRec $searchFieldNames $searchFieldContent $i]
      if { $found == 1 } {
      # found a matching record
        viewRecord $i
  if { [winfo exists .topViewAll] } {
# To put the current entry on the top of the listbox
#     .topViewAll.frame2.frame4.frame.listbox1 yview $i

  }
        return
      }
    }
  } else {
  # The searching direction is backward
    set i [expr $crrntDBindex - 1]
    while { $i>=0} {
      set found [ searchCrrntRec $searchFieldNames $searchFieldContent $i]
      if { $found == 1 } {
      # found a matching record
        viewRecord $i
  if { [winfo exists .topViewAll] } {
# To put the current entry on the top of the listbox
#     .topViewAll.frame2.frame4.frame.listbox1 yview $i

# to put the current entry in the niddle of the listbox
    set n $i
    viewRecord $n
  }
        return
      }
      set i [expr $i - 1]
    }
  }
  addressManagerMessage "Record not found. You may try different searching \
direction" 3
}

proc searchCrrntRec { searchFieldNames searchFieldContent recordNo } {

# To search the recordNo th record in the database to see if
# all the fields in the list, searchFieldNames, contain the contents, 
# searchFieldContent. If yes, retuen 1, otherwise, return 0

  global ID_list Name_list Tel_W_list Tel_H_list Tel_O_list Fax_list \
         Email_list \
         Sex_list DOB_list Title_list Occupation_list Address_list \
         Note_list Comment_list


  set searchFldNo [llength $searchFieldNames]
  # searchFldNo fields to be sarched

  for { set i 0 } { $i < $searchFldNo } { incr i } {
    set crrntFldName [ lindex $searchFieldNames $i ]
#    set crrntFldContent [ lindex $searchFieldContent $i ]
 
   # To get the crrntListName
    set tmp [string length $crrntFldName]
    set crrntListName [string range $crrntFldName 2 [expr $tmp - 6]]

   # to get the search pattern
    set shPattern [lindex $searchFieldContent $i]

   # to get the search string
    set cmd [concat $$crrntListName]
    set shString [eval lindex $cmd $recordNo]
   # to search the list, crrntListName, to see if it contains the
   # $i th string in the list, searchFieldContent
    
    set foundPattern [regexp -nocase $shPattern $shString]
    if { $foundPattern == 0 } {
    # Not found
      return 0
    }
  }
  return 1  
}

# to show save as window

# procedure to show window .showSaveAsWin
proc ShowWindow.showSaveAsWin {args} {# xf ignore me 7

  # build widget .showSaveAsWin
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .showSaveAsWin"
  } {
    catch "destroy .showSaveAsWin"
  }
  toplevel .showSaveAsWin 

  # Window manager configurations
  global tkVersion
  wm positionfrom .showSaveAsWin ""
  wm sizefrom .showSaveAsWin ""
  wm maxsize .showSaveAsWin 1000 1000
  wm minsize .showSaveAsWin 10 10
  wm title .showSaveAsWin {Save File As}


  # build widget .showSaveAsWin.frame1
  frame .showSaveAsWin.frame1 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .showSaveAsWin.frame1.frame2
  frame .showSaveAsWin.frame1.frame2 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .showSaveAsWin.frame1.frame2.frame
  frame .showSaveAsWin.frame1.frame2.frame \
    -relief {raised}

  # build widget .showSaveAsWin.frame1.frame2.frame.label4
  label .showSaveAsWin.frame1.frame2.frame.label4 \
    -padx {2} \
    -relief {raised} \
    -text {File Name}

  # build widget .showSaveAsWin.frame1.frame2.frame.entry5
  entry .showSaveAsWin.frame1.frame2.frame.entry5 \
    -relief {sunken}

  # pack widget .showSaveAsWin.frame1.frame2.frame
  pack append .showSaveAsWin.frame1.frame2.frame \
    .showSaveAsWin.frame1.frame2.frame.label4 {left frame center expand fillx} \
    .showSaveAsWin.frame1.frame2.frame.entry5 {top frame center expand fill}

  # pack widget .showSaveAsWin.frame1.frame2
  pack append .showSaveAsWin.frame1.frame2 \
    .showSaveAsWin.frame1.frame2.frame {top frame center expand fill}

  # build widget .showSaveAsWin.frame1.frame3
  frame .showSaveAsWin.frame1.frame3 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .showSaveAsWin.frame1.frame3.checkbutton4
#  checkbutton .showSaveAsWin.frame1.frame3.checkbutton4 \
#    -text {Save Comment} \
#    -variable {saveComment}

  # build widget .showSaveAsWin.frame1.frame3.button6
  button .showSaveAsWin.frame1.frame3.button6 \
    -text {OK} \
    -command {
      set saveAsFileName [.showSaveAsWin.frame1.frame2.frame.entry5 get]
      set saveBlank 1
      saveAddressDB $saveAsFileName $saveBlank
      addressManagerMessage "$saveAsFileName has been saved" 2
      DestroyWindow.showSaveAsWin
    }

  # build widget .showSaveAsWin.frame1.frame3.button7
  button .showSaveAsWin.frame1.frame3.button7 \
    -text {Cancel} \
    -command {DestroyWindow.showSaveAsWin}

  # pack widget .showSaveAsWin.frame1.frame3
  pack append .showSaveAsWin.frame1.frame3 \
    .showSaveAsWin.frame1.frame3.button6 {left frame center expand fillx} \
    .showSaveAsWin.frame1.frame3.button7 {left frame center expand fillx}

  # pack widget .showSaveAsWin.frame1
  pack append .showSaveAsWin.frame1 \
    .showSaveAsWin.frame1.frame2 {top frame center padx 99 expand fillx} \
    .showSaveAsWin.frame1.frame3 {top frame center expand fillx}

  # pack widget .showSaveAsWin
  pack append .showSaveAsWin \
    .showSaveAsWin.frame1 {top frame center fillx}

  .showSaveAsWin.frame1.frame2.frame.entry5 insert end {No_Comment}



  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .showSaveAsWin"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.showSaveAsWin {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .showSaveAsWin]" != ""} {
      global xfShowWindow.showSaveAsWin
      set xfShowWindow.showSaveAsWin 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .showSaveAsWin; XFEditSetShowWindows"
    }
  } {
    catch "destroy .showSaveAsWin"
    update
  }
}
# to show save as window

# procedure to show window .showSaveAsPrintWin
proc ShowWindow.showSaveAsPrintWin {args} {# xf ignore me 7

  # build widget .showSaveAsPrintWin
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .showSaveAsPrintWin"
  } {
    catch "destroy .showSaveAsPrintWin"
  }
  toplevel .showSaveAsPrintWin 

  # Window manager configurations
  global tkVersion
  wm positionfrom .showSaveAsPrintWin ""
  wm sizefrom .showSaveAsPrintWin ""
  wm maxsize .showSaveAsPrintWin 1000 1000
  wm minsize .showSaveAsPrintWin 10 10
  wm title .showSaveAsPrintWin {Save File As}


  # build widget .showSaveAsPrintWin.frame1
  frame .showSaveAsPrintWin.frame1 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .showSaveAsPrintWin.frame1.frame2
  frame .showSaveAsPrintWin.frame1.frame2 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .showSaveAsPrintWin.frame1.frame2.frame
  frame .showSaveAsPrintWin.frame1.frame2.frame \
    -relief {raised}

  # build widget .showSaveAsPrintWin.frame1.frame2.frame.label4
  label .showSaveAsPrintWin.frame1.frame2.frame.label4 \
    -padx {2} \
    -relief {raised} \
    -text {File Name}

  # build widget .showSaveAsPrintWin.frame1.frame2.frame.entry5
  entry .showSaveAsPrintWin.frame1.frame2.frame.entry5 \
    -relief {sunken}

  # pack widget .showSaveAsPrintWin.frame1.frame2.frame
  pack append .showSaveAsPrintWin.frame1.frame2.frame \
    .showSaveAsPrintWin.frame1.frame2.frame.label4 {left frame center expand fillx} \
    .showSaveAsPrintWin.frame1.frame2.frame.entry5 {top frame center expand fill}

  # pack widget .showSaveAsPrintWin.frame1.frame2
  pack append .showSaveAsPrintWin.frame1.frame2 \
    .showSaveAsPrintWin.frame1.frame2.frame {top frame center expand fill}

  # build widget .showSaveAsPrintWin.frame1.frame3
  frame .showSaveAsPrintWin.frame1.frame3 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .showSaveAsPrintWin.frame1.frame3.checkbutton4
#  checkbutton .showSaveAsPrintWin.frame1.frame3.checkbutton4 \
#    -text {Save Comment} \
#    -variable {saveComment}

  # build widget .showSaveAsPrintWin.frame1.frame3.button6
  button .showSaveAsPrintWin.frame1.frame3.button6 \
    -text {OK} \
    -command {
      set saveAsFileName [.showSaveAsPrintWin.frame1.frame2.frame.entry5 get]
      set saveBlank 0
      saveAddressDB $saveAsFileName $saveBlank
      addressManagerMessage "$saveAsFileName has been saved" 2
      DestroyWindow.showSaveAsPrintWin
    }

  # build widget .showSaveAsPrintWin.frame1.frame3.button7
  button .showSaveAsPrintWin.frame1.frame3.button7 \
    -text {Cancel} \
    -command {DestroyWindow.showSaveAsPrintWin}

  # pack widget .showSaveAsPrintWin.frame1.frame3
  pack append .showSaveAsPrintWin.frame1.frame3 \
    .showSaveAsPrintWin.frame1.frame3.button6 {left frame center expand fillx} \
    .showSaveAsPrintWin.frame1.frame3.button7 {left frame center expand fillx}

  # pack widget .showSaveAsPrintWin.frame1
  pack append .showSaveAsPrintWin.frame1 \
    .showSaveAsPrintWin.frame1.frame2 {top frame center padx 99 expand fillx} \
    .showSaveAsPrintWin.frame1.frame3 {top frame center expand fillx}

  # pack widget .showSaveAsPrintWin
  pack append .showSaveAsPrintWin \
    .showSaveAsPrintWin.frame1 {top frame center fillx}

  .showSaveAsPrintWin.frame1.frame2.frame.entry5 insert end {No_Comment}



  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .showSaveAsPrintWin"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.showSaveAsPrintWin {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .showSaveAsPrintWin]" != ""} {
      global xfShowWindow.showSaveAsPrintWin
      set xfShowWindow.showSaveAsPrintWin 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .showSaveAsPrintWin; XFEditSetShowWindows"
    }
  } {
    catch "destroy .showSaveAsPrintWin"
    update
  }
}
proc loadFile {addressDB} {

  global databaseSize
  global ID_list Name_list Tel_W_list Tel_H_list Tel_O_list Fax_list \
         Email_list \
         Sex_list DOB_list Title_list Occupation_list Address_list \
         Note_list Comment_list
  global allLists
  global ID_listEntry Name_listEntry Tel_W_listEntry Tel_H_listEntry\
         Tel_O_listEntry Fax_listEntry Email_listEntry Sex_listEntry \
         DOB_listEntry Title_listEntry Occupation_listEntry \
         Address_listEntry Note_listEntry Comment_listEntry

  global allEntryWins textWin


# To load the file, $addressDB

# If there is no such a file, $addressDB, return
  if { ![file exists $addressDB] } {
    return
  } else {
    exec cp $addressDB $addressDB.bak
    # To read database in
#    set databaseSize 0
    set pFile [open $addressDB r]

    while { ![eof $pFile] } {
      set textNo [gets $pFile lineText]
      if { ([string index $lineText 0] != "#") || \
           ( $textNo > 0) || \
           ( [string range $lineText 0 4] != "-----")  } {
      # Then it is a an entry to the database

      # To get the field name
        set tmp [expr [string first : $lineText] -2]
        set fieldName [ string range $lineText 0 $tmp]



    # to get the list name
      set listName [concat $fieldName\_list]

      if { $listName != "Comment_list" } {

    # to get the field content
      set fieldContent [ string range $lineText [expr $tmp +4] end]
      lappend $listName $fieldContent
     } else {
    # we are dealing with comment

    # To get the firstline of the comment
      set comment [ string range $lineText [expr $tmp +4] end]
      if { [string length $comment] > 0 } {
        set comment "$comment\n"
      } else {
        set comment "$comment"
      }
      while { (![eof $pFile]) && \
              ([string range [set lineText [gets $pFile]]  0 4] != "-----") } {
      # still inside comment
        set comment "$comment$lineText\n"
      }

      if { [string length $comment] > 0  } {
      # to delete the empty lines in the end of the comment, if there is any
         set lastCommentIndex [expr [string length $comment] - 1]
         while { [string index $comment $lastCommentIndex] == "\n" } {
           set lastCommentIndex [expr $lastCommentIndex -1]
           set comment [string range $comment 0 $lastCommentIndex]
         }
      }
      lappend $listName $comment
   #Finised reading one persons record
      incr databaseSize

     }

    }

  }

  close $pFile

  # To put the first record of the database into the interface

  foreach crrntlist $allLists {
    set  crrntlistEntry $crrntlist\Entry
    if { $crrntlist == "Comment_list" } {
      # To get the content of the comment
      set cmd [concat $$crrntlist]
      set fieldContent [eval lrange $cmd 0 0]
      # To insert the fieldContent to the field
      set cmd [concat $$crrntlist\Entry]
      eval $cmd insert 0.0 $fieldContent
    } else {
      # To get the fieldContent
      set cmd [concat $$crrntlist]
      set fieldContent [eval lrange $cmd 0 0]
      # To insert the fieldContent to the field
      set crrntlistEntry $crrntlist\Entry
      set cmd [concat $$crrntlistEntry]
      eval $cmd insert 1 $fieldContent
    }
  }
}

# to set focus so that accelerator keys will not lost

  focus .




}
# Procedure: AlertBox
proc AlertBox { {alertBoxMessage "Alert message"} {alertBoxCommand ""} {alertBoxGeometry "350x150"} {alertBoxTitle "Alert box"} args} {
# xf ignore me 5
##########
# Procedure: AlertBox
# Description: show alert box
# Arguments: {alertBoxMessage} - the text to display
#            {alertBoxCommand} - the command to call after ok
#            {alertBoxGeometry} - the geometry for the window
#            {alertBoxTitle} - the title for the window
#            {args} - labels of buttons
# Returns: The number of the selected button, ot nothing
# Sideeffects: none
# Notes: there exist also functions called:
#          AlertBoxFile - to open and read a file automatically
#          AlertBoxFd - to read from an already opened filedescriptor
##########
#
# global alertBox(activeBackground) - active background color
# global alertBox(activeForeground) - active foreground color
# global alertBox(after) - destroy alert box after n seconds
# global alertBox(anchor) - anchor for message box
# global alertBox(background) - background color
# global alertBox(font) - message font
# global alertBox(foreground) - foreground color
# global alertBox(justify) - justify for message box
# global alertBox(toplevelName) - the toplevel name

  global alertBox

  # show alert box
  if {[llength $args] > 0} {
    eval AlertBoxInternal "\{$alertBoxMessage\}" "\{$alertBoxCommand\}" "\{$alertBoxGeometry\}" "\{$alertBoxTitle\}" $args
  } {
    AlertBoxInternal $alertBoxMessage $alertBoxCommand $alertBoxGeometry $alertBoxTitle
  }

  if {[llength $args] > 0} {
    # wait for the box to be destroyed
    update idletask
    grab $alertBox(toplevelName)
    tkwait window $alertBox(toplevelName)

    return $alertBox(button)
  }
}


# Procedure: AlertBoxFd
proc AlertBoxFd { {alertBoxInFile ""} {alertBoxCommand ""} {alertBoxGeometry "350x150"} {alertBoxTitle "Alert box"} args} {
# xf ignore me 5
##########
# Procedure: AlertBoxFd
# Description: show alert box containing a filedescriptor
# Arguments: {alertBoxInFile} - a filedescriptor to read. The descriptor
#                               is closed after reading
#            {alertBoxCommand} - the command to call after ok
#            {alertBoxGeometry} - the geometry for the window
#            {alertBoxTitle} - the title for the window
#            {args} - labels of buttons
# Returns: The number of the selected button, ot nothing
# Sideeffects: none
# Notes: there exist also functions called:
#          AlertBox - to display a passed string
#          AlertBoxFile - to open and read a file automatically
##########
#
# global alertBox(activeBackground) - active background color
# global alertBox(activeForeground) - active foreground color
# global alertBox(after) - destroy alert box after n seconds
# global alertBox(anchor) - anchor for message box
# global alertBox(background) - background color
# global alertBox(font) - message font
# global alertBox(foreground) - foreground color
# global alertBox(justify) - justify for message box
# global alertBox(toplevelName) - the toplevel name

  global alertBox

  # check file existance
  if {"$alertBoxInFile" == ""} {
    puts stderr "No filedescriptor specified"
    return
  }

  set alertBoxMessage [read $alertBoxInFile]
  close $alertBoxInFile

  # show alert box
  if {[llength $args] > 0} {
    eval AlertBoxInternal "\{$alertBoxMessage\}" "\{$alertBoxCommand\}" "\{$alertBoxGeometry\}" "\{$alertBoxTitle\}" $args
  } {
    AlertBoxInternal $alertBoxMessage $alertBoxCommand $alertBoxGeometry $alertBoxTitle
  }

  if {[llength $args] > 0} {
    # wait for the box to be destroyed
    update idletask
    grab $alertBox(toplevelName)
    tkwait window $alertBox(toplevelName)

    return $alertBox(button)
  }
}


# Procedure: AlertBoxFile
proc AlertBoxFile { {alertBoxFile ""} {alertBoxCommand ""} {alertBoxGeometry "350x150"} {alertBoxTitle "Alert box"} args} {
# xf ignore me 5
##########
# Procedure: AlertBoxFile
# Description: show alert box containing a file
# Arguments: {alertBoxFile} - filename to read
#            {alertBoxCommand} - the command to call after ok
#            {alertBoxGeometry} - the geometry for the window
#            {alertBoxTitle} - the title for the window
#            {args} - labels of buttons
# Returns: The number of the selected button, ot nothing
# Sideeffects: none
# Notes: there exist also functions called:
#          AlertBox - to display a passed string
#          AlertBoxFd - to read from an already opened filedescriptor
##########
#
# global alertBox(activeBackground) - active background color
# global alertBox(activeForeground) - active foreground color
# global alertBox(after) - destroy alert box after n seconds
# global alertBox(anchor) - anchor for message box
# global alertBox(background) - background color
# global alertBox(font) - message font
# global alertBox(foreground) - foreground color
# global alertBox(justify) - justify for message box
# global alertBox(toplevelName) - the toplevel name

  global alertBox

  # check file existance
  if {"$alertBoxFile" == ""} {
    puts stderr "No filename specified"
    return
  }

  if {[catch "open $alertBoxFile r" alertBoxInFile]} {
    puts stderr "$alertBoxInFile"
    return
  }

  set alertBoxMessage [read $alertBoxInFile]
  close $alertBoxInFile

  # show alert box
  if {[llength $args] > 0} {
    eval AlertBoxInternal "\{$alertBoxMessage\}" "\{$alertBoxCommand\}" "\{$alertBoxGeometry\}" "\{$alertBoxTitle\}" $args
  } {
    AlertBoxInternal $alertBoxMessage $alertBoxCommand $alertBoxGeometry $alertBoxTitle
  }

  if {[llength $args] > 0} {
    # wait for the box to be destroyed
    update idletask
    grab $alertBox(toplevelName)
    tkwait window $alertBox(toplevelName)

    return $alertBox(button)
  }
}


# Procedure: AlertBoxInternal
proc AlertBoxInternal { alertBoxMessage alertBoxCommand alertBoxGeometry alertBoxTitle args} {
# xf ignore me 6
  global alertBox

  set tmpButtonOpt ""
  set tmpFrameOpt ""
  set tmpMessageOpt ""
  if {"$alertBox(activeBackground)" != ""} {
    append tmpButtonOpt "-activebackground \"$alertBox(activeBackground)\" "
  }
  if {"$alertBox(activeForeground)" != ""} {
    append tmpButtonOpt "-activeforeground \"$alertBox(activeForeground)\" "
  }
  if {"$alertBox(background)" != ""} {
    append tmpButtonOpt "-background \"$alertBox(background)\" "
    append tmpFrameOpt "-background \"$alertBox(background)\" "
    append tmpMessageOpt "-background \"$alertBox(background)\" "
  }
  if {"$alertBox(font)" != ""} {
    append tmpButtonOpt "-font \"$alertBox(font)\" "
    append tmpMessageOpt "-font \"$alertBox(font)\" "
  }
  if {"$alertBox(foreground)" != ""} {
    append tmpButtonOpt "-foreground \"$alertBox(foreground)\" "
    append tmpMessageOpt "-foreground \"$alertBox(foreground)\" "
  }

  # start build of toplevel
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy $alertBox(toplevelName)}
  } {
    catch {destroy $alertBox(toplevelName)}
  }
  toplevel $alertBox(toplevelName)  -borderwidth 0
  catch "$alertBox(toplevelName) config $tmpFrameOpt"
  if {[catch "wm geometry $alertBox(toplevelName) $alertBoxGeometry"]} {
    wm geometry $alertBox(toplevelName) 350x150
  }
  wm title $alertBox(toplevelName) $alertBoxTitle
  wm maxsize $alertBox(toplevelName) 1000 1000
  wm minsize $alertBox(toplevelName) 100 100
  # end build of toplevel

  message $alertBox(toplevelName).message1  -anchor "$alertBox(anchor)"  -justify "$alertBox(justify)"  -relief raised  -text "$alertBoxMessage"
  catch "$alertBox(toplevelName).message1 config $tmpMessageOpt"

  set xfTmpWidth  [string range $alertBoxGeometry 0 [expr [string first x $alertBoxGeometry]-1]]
  if {"$xfTmpWidth" != ""} {
    # set message size
    catch "$alertBox(toplevelName).message1 configure  -width [expr $xfTmpWidth-10]"
  } {
    $alertBox(toplevelName).message1 configure  -aspect 1500
  }

  frame $alertBox(toplevelName).frame1  -borderwidth 0  -relief raised
  catch "$alertBox(toplevelName).frame1 config $tmpFrameOpt"

  set alertBoxCounter 0
  set buttonNum [llength $args]
  if {$buttonNum > 0} {
    while {$alertBoxCounter < $buttonNum} {
      button $alertBox(toplevelName).frame1.button$alertBoxCounter  -text "[lindex $args $alertBoxCounter]"  -command "
          global alertBox
          set alertBox(button) $alertBoxCounter
          if {\"\[info commands XFDestroy\]\" != \"\"} {
            catch {XFDestroy $alertBox(toplevelName)}
          } {
            catch {destroy $alertBox(toplevelName)}
          }"
      catch "$alertBox(toplevelName).frame1.button$alertBoxCounter config $tmpButtonOpt"

      pack append $alertBox(toplevelName).frame1  $alertBox(toplevelName).frame1.button$alertBoxCounter {left fillx expand}

      incr alertBoxCounter
    }
  } {
    button $alertBox(toplevelName).frame1.button0  -text "OK"  -command "
        global alertBox
        set alertBox(button) 0
        if {\"\[info commands XFDestroy\]\" != \"\"} {
          catch {XFDestroy $alertBox(toplevelName)}
        } {
          catch {destroy $alertBox(toplevelName)}
        }
        $alertBoxCommand"
    catch "$alertBox(toplevelName).frame1.button0 config $tmpButtonOpt"

    pack append $alertBox(toplevelName).frame1  $alertBox(toplevelName).frame1.button0 {left fillx expand}
  }

  # packing
  pack append $alertBox(toplevelName)  $alertBox(toplevelName).frame1 {bottom fill}  $alertBox(toplevelName).message1 {top fill expand}

  if {$alertBox(after) != 0} {
    after [expr $alertBox(after)*1000]  "catch \"$alertBox(toplevelName).frame1.button0 invoke\""
  }
}


# Procedure: Alias
if {"[info procs Alias]" == ""} {
proc Alias { args} {
# xf ignore me 7
##########
# Procedure: Alias
# Description: establish an alias for a procedure
# Arguments: args - no argument means that a list of all aliases
#                   is returned. Otherwise the first parameter is
#                   the alias name, and the second parameter is
#                   the procedure that is aliased.
# Returns: nothing, the command that is bound to the alias or a
#          list of all aliases - command pairs. 
# Sideeffects: internalAliasList is updated, and the alias
#              proc is inserted
##########
  global internalAliasList

  if {[llength $args] == 0} {
    return $internalAliasList
  } {
    if {[llength $args] == 1} {
      set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
      if {$xfTmpIndex != -1} {
        return [lindex [lindex $internalAliasList $xfTmpIndex] 1]
      }
    } {
      if {[llength $args] == 2} {
        eval "proc [lindex $args 0] {args} {#xf ignore me 4
return \[eval \"[lindex $args 1] \$args\"\]}"
        set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
        if {$xfTmpIndex != -1} {
          set internalAliasList [lreplace $internalAliasList $xfTmpIndex $xfTmpIndex "[lindex $args 0] [lindex $args 1]"]
        } {
          lappend internalAliasList "[lindex $args 0] [lindex $args 1]"
        }
      } {
        error "Alias: wrong number or args: $args"
      }
    }
  }
}
}


# Procedure: GetSelection
if {"[info procs GetSelection]" == ""} {
proc GetSelection {} {
# xf ignore me 7
##########
# Procedure: GetSelection
# Description: get current selection
# Arguments: none
# Returns: none
# Sideeffects: none
##########

  # the save way
  set xfSelection ""
  catch "selection get" xfSelection
  if {"$xfSelection" == "selection doesn't exist or form \"STRING\" not defined"} {
    return ""
  } {
    return $xfSelection
  }
}
}


# Procedure: MenuPopupAdd
if {"[info procs MenuPopupAdd]" == ""} {
proc MenuPopupAdd { xfW xfButton xfMenu {xfModifier ""} {xfCanvasTag ""}} {
# xf ignore me 7
# the popup menu handling is from (I already gave up with popup handling :-):
#
# Copyright 1991,1992 by James Noble.
# Everyone is granted permission to copy, modify and redistribute.
# This notice must be preserved on all copies or derivates.
#
##########
# Procedure: MenuPopupAdd
# Description: attach a popup menu to widget
# Arguments: xfW - the widget
#            xfButton - the button we use
#            xfMenu - the menu to attach
#            {xfModifier} - a optional modifier
#            {xfCanvasTag} - a canvas tagOrId
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv

  set tk_popupPriv($xfMenu,focus) ""
  set tk_popupPriv($xfMenu,grab) ""
  if {"$xfModifier" != ""} {
    set press "$xfModifier-"
    set motion "$xfModifier-"
    set release "Any-"
  } {
    set press ""
    set motion ""
    set release ""
  }

  bind $xfMenu "<${motion}B${xfButton}-Motion>"  "MenuPopupMotion $xfMenu %W %X %Y"
  bind $xfMenu "<${release}ButtonRelease-${xfButton}>"  "MenuPopupRelease $xfMenu %W"
  if {"$xfCanvasTag" == ""} {
    bind $xfW "<${press}ButtonPress-${xfButton}>"  "MenuPopupPost $xfMenu %X %Y"
    bind $xfW "<${release}ButtonRelease-${xfButton}>"  "MenuPopupRelease $xfMenu %W"
  } {
    $xfW bind $xfCanvasTag "<${press}ButtonPress-${xfButton}>"  "MenuPopupPost $xfMenu %X %Y"
    $xfW bind $xfCanvasTag "<${release}ButtonRelease-${xfButton}>"  "MenuPopupRelease $xfMenu %W"
  }
}
}


# Procedure: MenuPopupMotion
if {"[info procs MenuPopupMotion]" == ""} {
proc MenuPopupMotion { xfMenu xfW xfX xfY} {
# xf ignore me 7
##########
# Procedure: MenuPopupMotion
# Description: handle the popup menu motion
# Arguments: xfMenu - the topmost menu
#            xfW - the menu
#            xfX - the root x coordinate
#            xfY - the root x coordinate
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv

  if {"[info commands $xfW]" != "" && [winfo ismapped $xfW] &&
      "[winfo class $xfW]" == "Menu" &&
      [info exists tk_popupPriv($xfMenu,focus)] &&
      "$tk_popupPriv($xfMenu,focus)" != "" &&
      [info exists tk_popupPriv($xfMenu,grab)] &&
      "$tk_popupPriv($xfMenu,grab)" != ""} {
    set xfPopMinX [winfo rootx $xfW]
    set xfPopMaxX [expr $xfPopMinX+[winfo width $xfW]]
    if {$xfX >= $xfPopMinX && $xfX <= $xfPopMaxX} {
      $xfW activate @[expr $xfY-[winfo rooty $xfW]]
      if {![catch "$xfW entryconfig @[expr $xfY-[winfo rooty $xfW]] -menu" result]} {
        if {"[lindex $result 4]" != ""} {
          foreach binding [bind $xfMenu] {
            bind [lindex $result 4] $binding [bind $xfMenu $binding]
          }
        }
      }
    } {
      $xfW activate none
    }
  }
}
}


# Procedure: MenuPopupPost
if {"[info procs MenuPopupPost]" == ""} {
proc MenuPopupPost { xfMenu xfX xfY} {
# xf ignore me 7
##########
# Procedure: MenuPopupPost
# Description: post the popup menu
# Arguments: xfMenu - the menu
#            xfX - the root x coordinate
#            xfY - the root x coordinate
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv

  if {"[info commands $xfMenu]" != ""} {
    if {![info exists tk_popupPriv($xfMenu,focus)]} {
      set tk_popupPriv($xfMenu,focus) [focus]
    } {
      if {"$tk_popupPriv($xfMenu,focus)" == ""} {
        set tk_popupPriv($xfMenu,focus) [focus]
      }
    }
    set tk_popupPriv($xfMenu,grab) $xfMenu

    catch "$xfMenu activate none"
    catch "$xfMenu post $xfX $xfY"
    catch "focus $xfMenu"
    catch "grab -global $xfMenu"
  }
}
}


# Procedure: MenuPopupRelease
if {"[info procs MenuPopupRelease]" == ""} {
proc MenuPopupRelease { xfMenu xfW} {
# xf ignore me 7
##########
# Procedure: MenuPopupRelease
# Description: remove the popup menu
# Arguments: xfMenu - the topmost menu widget
#            xfW - the menu widget
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv
  global tkVersion

  if {"[info commands $xfW]" != "" && [winfo ismapped $xfW] &&
      "[winfo class $xfW]" == "Menu" &&
      [info exists tk_popupPriv($xfMenu,focus)] &&
      "$tk_popupPriv($xfMenu,focus)" != "" &&
      [info exists tk_popupPriv($xfMenu,grab)] &&
      "$tk_popupPriv($xfMenu,grab)" != ""} {
    if {$tkVersion >= 3.0} {
      catch "grab release $tk_popupPriv($xfMenu,grab)"
    } {
      catch "grab none"
    }
    catch "focus $tk_popupPriv($xfMenu,focus)"
    set tk_popupPriv($xfMenu,focus) ""
    set tk_popupPriv($xfMenu,grab) ""
    if {"[$xfW index active]" != "none"} {
      $xfW invoke active; catch "$xfMenu unpost"
    }
  }
  catch "$xfMenu unpost"
}
}


# Procedure: NoFunction
if {"[info procs NoFunction]" == ""} {
proc NoFunction { args} {
# xf ignore me 7
##########
# Procedure: NoFunction
# Description: do nothing (especially with scales and scrollbars)
# Arguments: args - a number of ignored parameters
# Returns: none
# Sideeffects: none
##########
}
}


# Procedure: SN
if {"[info procs SN]" == ""} {
proc SN { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SN
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  SymbolicName $xfName
}
}


# Procedure: SymbolicName
if {"[info procs SymbolicName]" == ""} {
proc SymbolicName { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SymbolicName
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  global symbolicName

  if {"$xfName" != ""} {
    set xfArrayName ""
    append xfArrayName symbolicName ( $xfName )
    if {![catch "set \"$xfArrayName\"" xfValue]} {
      return $xfValue
    } {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "Unknown symbolic name:\n$xfName"
      } {
        puts stderr "XF error: unknown symbolic name:\n$xfName"
      }
    }
  }
  return ""
}
}


# Procedure: Unalias
if {"[info procs Unalias]" == ""} {
proc Unalias { aliasName} {
# xf ignore me 7
##########
# Procedure: Unalias
# Description: remove an alias for a procedure
# Arguments: aliasName - the alias name to remove
# Returns: none
# Sideeffects: internalAliasList is updated, and the alias
#              proc is removed
##########
  global internalAliasList

  set xfIndex [lsearch $internalAliasList "$aliasName *"]
  if {$xfIndex != -1} {
    rename $aliasName ""
    set internalAliasList [lreplace $internalAliasList $xfIndex $xfIndex]
  }
}
}



# application parsing procedure
proc XFLocalParseAppDefs {xfAppDefFile} {
  global xfAppDefaults

  # basically from: Michael Moore
  if {[file exists $xfAppDefFile] &&
      [file readable $xfAppDefFile] &&
      "[file type $xfAppDefFile]" == "link"} {
    catch "file type $xfAppDefFile" xfType
    while {"$xfType" == "link"} {
      if {[catch "file readlink $xfAppDefFile" xfAppDefFile]} {
        return
      }
      catch "file type $xfAppDefFile" xfType
    }
  }
  if {!("$xfAppDefFile" != "" &&
        [file exists $xfAppDefFile] &&
        [file readable $xfAppDefFile] &&
        "[file type $xfAppDefFile]" == "file")} {
    return
  }
  if {![catch "open $xfAppDefFile r" xfResult]} {
    set xfAppFileContents [read $xfResult]
    close $xfResult
    foreach line [split $xfAppFileContents "\n"] {
      # backup indicates how far to backup.  It applies to the
      # situation where a resource name ends in . and when it
      # ends in *.  In the second case you want to keep the *
      # in the widget name for pattern matching, but you want
      # to get rid of the . if it is the end of the name. 
      set backup -2  
      set line [string trim $line]
      if {[string index $line 0] == "#" || "$line" == ""} {
        # skip comments and empty lines
        continue
      }
      set list [split $line ":"]
      set resource [string trim [lindex $list 0]]
      set i [string last "." $resource]
      set j [string last "*" $resource]
      if {$j > $i} { 
        set i $j
        set backup -1
      }
      incr i
      set name [string range $resource $i end]
      incr i $backup
      set widname [string range $resource 0 $i]
      set value [string trim [lindex $list 1]]
      if {"$widname" != "" && "$widname" != "*"} {
        # insert the widget and resourcename to the application
        # defaults list.
        if {![info exists xfAppDefaults]} {
          set xfAppDefaults ""
        }
        lappend xfAppDefaults [list $widname [string tolower $name] $value]
      }
    }
  }
}

# application loading procedure
proc XFLocalLoadAppDefs {{xfClasses ""} {xfPriority "startupFile"} {xfAppDefFile ""}} {
  global env

  if {"$xfAppDefFile" == ""} {
    set xfFileList ""
    if {[info exists env(XUSERFILESEARCHPATH)]} {
      append xfFileList [split $env(XUSERFILESEARCHPATH) :]
    }
    if {[info exists env(XAPPLRESDIR)]} {
      append xfFileList [split $env(XAPPLRESDIR) :]
    }
    if {[info exists env(XFILESEARCHPATH)]} {
      append xfFileList [split $env(XFILESEARCHPATH) :]
    }
    append xfFileList " /usr/lib/X11/app-defaults"
    append xfFileList " /usr/X11/lib/X11/app-defaults"

    foreach xfCounter1 $xfClasses {
      foreach xfCounter2 $xfFileList {
        set xfPathName $xfCounter2
        if {[regsub -all "%N" "$xfPathName" "$xfCounter1" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%T" "$xfPathName" "app-defaults" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%S" "$xfPathName" "" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%C" "$xfPathName" "" xfResult]} {
          set xfPathName $xfResult
        }
        if {[file exists $xfPathName] &&
            [file readable $xfPathName] &&
            ("[file type $xfPathName]" == "file" ||
             "[file type $xfPathName]" == "link")} {
          catch "option readfile $xfPathName $xfPriority"
          if {"[info commands XFParseAppDefs]" != ""} {
            XFParseAppDefs $xfPathName
          } {
            if {"[info commands XFLocalParseAppDefs]" != ""} {
              XFLocalParseAppDefs $xfPathName
            }
          }
        } {
          if {[file exists $xfCounter2/$xfCounter1] &&
              [file readable $xfCounter2/$xfCounter1] &&
              ("[file type $xfCounter2/$xfCounter1]" == "file" ||
               "[file type $xfCounter2/$xfCounter1]" == "link")} {
            catch "option readfile $xfCounter2/$xfCounter1 $xfPriority"
            if {"[info commands XFParseAppDefs]" != ""} {
              XFParseAppDefs $xfCounter2/$xfCounter1
            } {
              if {"[info commands XFLocalParseAppDefs]" != ""} {
                XFLocalParseAppDefs $xfCounter2/$xfCounter1
              }
            }
          }
        }
      }
    }
  } {
    # load a specific application defaults file
    if {[file exists $xfAppDefFile] &&
        [file readable $xfAppDefFile] &&
        ("[file type $xfAppDefFile]" == "file" ||
         "[file type $xfAppDefFile]" == "link")} {
      catch "option readfile $xfAppDefFile $xfPriority"
      if {"[info commands XFParseAppDefs]" != ""} {
        XFParseAppDefs $xfAppDefFile
      } {
        if {"[info commands XFLocalParseAppDefs]" != ""} {
          XFLocalParseAppDefs $xfAppDefFile
        }
      }
    }
  }
}

# application setting procedure
proc XFLocalSetAppDefs {{xfWidgetPath "."}} {
  global xfAppDefaults

  if {![info exists xfAppDefaults]} {
    return
  }
  foreach xfCounter $xfAppDefaults {
    if {"$xfCounter" == ""} {
      break
    }
    set widname [lindex $xfCounter 0]
    if {[string match $widname ${xfWidgetPath}] ||
        [string match "${xfWidgetPath}*" $widname]} {
      set name [string tolower [lindex $xfCounter 1]]
      set value [lindex $xfCounter 2]
      # Now lets see how many tcl commands match the name
      # pattern specified.
      set widlist [info command $widname]
      if {"$widlist" != ""} {
        foreach widget $widlist {
          # make sure this command is a widget.
          if {![catch "winfo id $widget"] &&
              [string match "${xfWidgetPath}*" $widget]} {
            catch "$widget configure -$name $value" 
          }
        }
      }
    }
  }
}


# initialize global variables
global {alertBox}
set {alertBox(activeBackground)} {}
set {alertBox(activeForeground)} {}
set {alertBox(after)} {0}
set {alertBox(anchor)} {nw}
set {alertBox(background)} {}
set {alertBox(button)} {0}
set {alertBox(font)} {}
set {alertBox(foreground)} {}
set {alertBox(justify)} {center}
set {alertBox(toplevelName)} {.alertBox}

# please don't modify the following
# variables. They are needed by xf.
global {autoLoadList}
set {autoLoadList(main.tcl)} {0}
global {internalAliasList}
set {internalAliasList} {}
global {moduleList}
set {moduleList(main.tcl)} {}
global {preloadList}
set {preloadList(xfInternal)} {}
global {symbolicName}
set {symbolicName(root)} {.}
global {xfWmSetPosition}
set {xfWmSetPosition} {}
global {xfWmSetSize}
set {xfWmSetSize} {}
global {xfAppDefToplevels}
set {xfAppDefToplevels} {}

# display/remove toplevel windows.
#ShowWindow.

# load default bindings.
if {[info exists env(XF_BIND_FILE)] &&
    "[info procs XFShowHelp]" == ""} {
  source $env(XF_BIND_FILE)
}

# parse and apply application defaults.
XFLocalLoadAppDefs Main
XFLocalSetAppDefs

# eof
#

# Procedure: YesNoBox
proc YesNoBox { {yesNoBoxMessage "Yes/no message"} {yesNoBoxGeometry "350x150"}} {
# xf ignore me 5
##########
# Procedure: YesNoBox
# Description: show yesno box
# Arguments: {yesNoBoxMessage} - the text to display
#            {yesNoBoxGeometry} - the geometry for the window
# Returns: none
# Sideeffects: none
##########
#
# global yesNoBox(activeBackground) - active background color
# global yesNoBox(activeForeground) - active foreground color
# global yesNoBox(anchor) - anchor for message box
# global yesNoBox(background) - background color
# global yesNoBox(font) - message font
# global yesNoBox(foreground) - foreground color
# global yesNoBox(justify) - justify for message box
# global yesNoBox(afterNo) - destroy yes-no box after n seconds.
#                            The no button is activated
# global yesNoBox(afterYes) - destroy yes-no box after n seconds.
#                             The yes button is activated

  global yesNoBox

  set tmpButtonOpt ""
  set tmpFrameOpt ""
  set tmpMessageOpt ""
  if {"$yesNoBox(activeBackground)" != ""} {
    append tmpButtonOpt "-activebackground \"$yesNoBox(activeBackground)\" "
  }
  if {"$yesNoBox(activeForeground)" != ""} {
    append tmpButtonOpt "-activeforeground \"$yesNoBox(activeForeground)\" "
  }
  if {"$yesNoBox(background)" != ""} {
    append tmpButtonOpt "-background \"$yesNoBox(background)\" "
    append tmpFrameOpt "-background \"$yesNoBox(background)\" "
    append tmpMessageOpt "-background \"$yesNoBox(background)\" "
  }
  if {"$yesNoBox(font)" != ""} {
    append tmpButtonOpt "-font \"$yesNoBox(font)\" "
    append tmpMessageOpt "-font \"$yesNoBox(font)\" "
  }
  if {"$yesNoBox(foreground)" != ""} {
    append tmpButtonOpt "-foreground \"$yesNoBox(foreground)\" "
    append tmpMessageOpt "-foreground \"$yesNoBox(foreground)\" "
  }

  # start build of toplevel
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy .yesNoBox}
  } {
    catch {destroy .yesNoBox}
  }
  toplevel .yesNoBox  -borderwidth 0
  catch ".yesNoBox config $tmpFrameOpt"
  if {[catch "wm geometry .yesNoBox $yesNoBoxGeometry"]} {
    wm geometry .yesNoBox 350x150
  }
  wm title .yesNoBox {Alert box}
  wm maxsize .yesNoBox 1000 1000
  wm minsize .yesNoBox 100 100
  # end build of toplevel

  message .yesNoBox.message1  -anchor "$yesNoBox(anchor)"  -justify "$yesNoBox(justify)"  -relief raised  -text "$yesNoBoxMessage"
  catch ".yesNoBox.message1 config $tmpMessageOpt"

  set xfTmpWidth  [string range $yesNoBoxGeometry 0 [expr [string first x $yesNoBoxGeometry]-1]]
  if {"$xfTmpWidth" != ""} {
    # set message size
    catch ".yesNoBox.message1 configure  -width [expr $xfTmpWidth-10]"
  } {
    .yesNoBox.message1 configure  -aspect 1500
  }

  frame .yesNoBox.frame1  -borderwidth 0  -relief raised
  catch ".yesNoBox.frame1 config $tmpFrameOpt"

  button .yesNoBox.frame1.button0  -text "Yes"  -command "
      global yesNoBox
      set yesNoBox(button) 1
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .yesNoBox}
      } {
        catch {destroy .yesNoBox}
      }"
  catch ".yesNoBox.frame1.button0 config $tmpButtonOpt"

  button .yesNoBox.frame1.button1  -text "No"  -command "
      global yesNoBox
      set yesNoBox(button) 0
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .yesNoBox}
      } {
        catch {destroy .yesNoBox}
      }"
  catch ".yesNoBox.frame1.button1 config $tmpButtonOpt"

  pack append .yesNoBox.frame1  .yesNoBox.frame1.button0 {left fillx expand}  .yesNoBox.frame1.button1 {left fillx expand}

  # packing
  pack append .yesNoBox  .yesNoBox.frame1 {bottom fill}  .yesNoBox.message1 {top fill expand}

  if {$yesNoBox(afterYes) != 0} {
    after [expr $yesNoBox(afterYes)*1000]  "catch \".yesNoBox.frame1.button0 invoke\""
  }
  if {$yesNoBox(afterNo) != 0} {
    after [expr $yesNoBox(afterNo)*1000]  "catch \".yesNoBox.frame1.button1 invoke\""
  }

  # wait for the box to be destroyed
  update idletask
  grab .yesNoBox
  tkwait window .yesNoBox

  return $yesNoBox(button)
}


# Internal procedures


# Procedure: Alias
if {"[info procs Alias]" == ""} {
proc Alias { args} {
# xf ignore me 7
##########
# Procedure: Alias
# Description: establish an alias for a procedure
# Arguments: args - no argument means that a list of all aliases
#                   is returned. Otherwise the first parameter is
#                   the alias name, and the second parameter is
#                   the procedure that is aliased.
# Returns: nothing, the command that is bound to the alias or a
#          list of all aliases - command pairs. 
# Sideeffects: internalAliasList is updated, and the alias
#              proc is inserted
##########
  global internalAliasList

  if {[llength $args] == 0} {
    return $internalAliasList
  } {
    if {[llength $args] == 1} {
      set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
      if {$xfTmpIndex != -1} {
        return [lindex [lindex $internalAliasList $xfTmpIndex] 1]
      }
    } {
      if {[llength $args] == 2} {
        eval "proc [lindex $args 0] {args} {#xf ignore me 4
return \[eval \"[lindex $args 1] \$args\"\]}"
        set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
        if {$xfTmpIndex != -1} {
          set internalAliasList [lreplace $internalAliasList $xfTmpIndex $xfTmpIndex "[lindex $args 0] [lindex $args 1]"]
        } {
          lappend internalAliasList "[lindex $args 0] [lindex $args 1]"
        }
      } {
        error "Alias: wrong number or args: $args"
      }
    }
  }
}
}


# Procedure: GetSelection
if {"[info procs GetSelection]" == ""} {
proc GetSelection {} {
# xf ignore me 7
##########
# Procedure: GetSelection
# Description: get current selection
# Arguments: none
# Returns: none
# Sideeffects: none
##########

  # the save way
  set xfSelection ""
  catch "selection get" xfSelection
  if {"$xfSelection" == "selection doesn't exist or form \"STRING\" not defined"} {
    return ""
  } {
    return $xfSelection
  }
}
}


# Procedure: MenuPopupAdd
if {"[info procs MenuPopupAdd]" == ""} {
proc MenuPopupAdd { xfW xfButton xfMenu {xfModifier ""} {xfCanvasTag ""}} {
# xf ignore me 7
# the popup menu handling is from (I already gave up with popup handling :-):
#
# Copyright 1991,1992 by James Noble.
# Everyone is granted permission to copy, modify and redistribute.
# This notice must be preserved on all copies or derivates.
#
##########
# Procedure: MenuPopupAdd
# Description: attach a popup menu to widget
# Arguments: xfW - the widget
#            xfButton - the button we use
#            xfMenu - the menu to attach
#            {xfModifier} - a optional modifier
#            {xfCanvasTag} - a canvas tagOrId
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv

  set tk_popupPriv($xfMenu,focus) ""
  set tk_popupPriv($xfMenu,grab) ""
  if {"$xfModifier" != ""} {
    set press "$xfModifier-"
    set motion "$xfModifier-"
    set release "Any-"
  } {
    set press ""
    set motion ""
    set release ""
  }

  bind $xfMenu "<${motion}B${xfButton}-Motion>"  "MenuPopupMotion $xfMenu %W %X %Y"
  bind $xfMenu "<${release}ButtonRelease-${xfButton}>"  "MenuPopupRelease $xfMenu %W"
  if {"$xfCanvasTag" == ""} {
    bind $xfW "<${press}ButtonPress-${xfButton}>"  "MenuPopupPost $xfMenu %X %Y"
    bind $xfW "<${release}ButtonRelease-${xfButton}>"  "MenuPopupRelease $xfMenu %W"
  } {
    $xfW bind $xfCanvasTag "<${press}ButtonPress-${xfButton}>"  "MenuPopupPost $xfMenu %X %Y"
    $xfW bind $xfCanvasTag "<${release}ButtonRelease-${xfButton}>"  "MenuPopupRelease $xfMenu %W"
  }
}
}


# Procedure: MenuPopupMotion
if {"[info procs MenuPopupMotion]" == ""} {
proc MenuPopupMotion { xfMenu xfW xfX xfY} {
# xf ignore me 7
##########
# Procedure: MenuPopupMotion
# Description: handle the popup menu motion
# Arguments: xfMenu - the topmost menu
#            xfW - the menu
#            xfX - the root x coordinate
#            xfY - the root x coordinate
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv

  if {"[info commands $xfW]" != "" && [winfo ismapped $xfW] &&
      "[winfo class $xfW]" == "Menu" &&
      [info exists tk_popupPriv($xfMenu,focus)] &&
      "$tk_popupPriv($xfMenu,focus)" != "" &&
      [info exists tk_popupPriv($xfMenu,grab)] &&
      "$tk_popupPriv($xfMenu,grab)" != ""} {
    set xfPopMinX [winfo rootx $xfW]
    set xfPopMaxX [expr $xfPopMinX+[winfo width $xfW]]
    if {$xfX >= $xfPopMinX && $xfX <= $xfPopMaxX} {
      $xfW activate @[expr $xfY-[winfo rooty $xfW]]
      if {![catch "$xfW entryconfig @[expr $xfY-[winfo rooty $xfW]] -menu" result]} {
        if {"[lindex $result 4]" != ""} {
          foreach binding [bind $xfMenu] {
            bind [lindex $result 4] $binding [bind $xfMenu $binding]
          }
        }
      }
    } {
      $xfW activate none
    }
  }
}
}


# Procedure: MenuPopupPost
if {"[info procs MenuPopupPost]" == ""} {
proc MenuPopupPost { xfMenu xfX xfY} {
# xf ignore me 7
##########
# Procedure: MenuPopupPost
# Description: post the popup menu
# Arguments: xfMenu - the menu
#            xfX - the root x coordinate
#            xfY - the root x coordinate
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv

  if {"[info commands $xfMenu]" != ""} {
    if {![info exists tk_popupPriv($xfMenu,focus)]} {
      set tk_popupPriv($xfMenu,focus) [focus]
    } {
      if {"$tk_popupPriv($xfMenu,focus)" == ""} {
        set tk_popupPriv($xfMenu,focus) [focus]
      }
    }
    set tk_popupPriv($xfMenu,grab) $xfMenu

    catch "$xfMenu activate none"
    catch "$xfMenu post $xfX $xfY"
    catch "focus $xfMenu"
    catch "grab -global $xfMenu"
  }
}
}


# Procedure: MenuPopupRelease
if {"[info procs MenuPopupRelease]" == ""} {
proc MenuPopupRelease { xfMenu xfW} {
# xf ignore me 7
##########
# Procedure: MenuPopupRelease
# Description: remove the popup menu
# Arguments: xfMenu - the topmost menu widget
#            xfW - the menu widget
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv
  global tkVersion

  if {"[info commands $xfW]" != "" && [winfo ismapped $xfW] &&
      "[winfo class $xfW]" == "Menu" &&
      [info exists tk_popupPriv($xfMenu,focus)] &&
      "$tk_popupPriv($xfMenu,focus)" != "" &&
      [info exists tk_popupPriv($xfMenu,grab)] &&
      "$tk_popupPriv($xfMenu,grab)" != ""} {
    if {$tkVersion >= 3.0} {
      catch "grab release $tk_popupPriv($xfMenu,grab)"
    } {
      catch "grab none"
    }
    catch "focus $tk_popupPriv($xfMenu,focus)"
    set tk_popupPriv($xfMenu,focus) ""
    set tk_popupPriv($xfMenu,grab) ""
    if {"[$xfW index active]" != "none"} {
      $xfW invoke active; catch "$xfMenu unpost"
    }
  }
  catch "$xfMenu unpost"
}
}


# Procedure: NoFunction
if {"[info procs NoFunction]" == ""} {
proc NoFunction { args} {
# xf ignore me 7
##########
# Procedure: NoFunction
# Description: do nothing (especially with scales and scrollbars)
# Arguments: args - a number of ignored parameters
# Returns: none
# Sideeffects: none
##########
}
}


# Procedure: SN
if {"[info procs SN]" == ""} {
proc SN { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SN
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  SymbolicName $xfName
}
}


# Procedure: SymbolicName
if {"[info procs SymbolicName]" == ""} {
proc SymbolicName { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SymbolicName
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  global symbolicName

  if {"$xfName" != ""} {
    set xfArrayName ""
    append xfArrayName symbolicName ( $xfName )
    if {![catch "set \"$xfArrayName\"" xfValue]} {
      return $xfValue
    } {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "Unknown symbolic name:\n$xfName"
      } {
        puts stderr "XF error: unknown symbolic name:\n$xfName"
      }
    }
  }
  return ""
}
}


# Procedure: Unalias
if {"[info procs Unalias]" == ""} {
proc Unalias { aliasName} {
# xf ignore me 7
##########
# Procedure: Unalias
# Description: remove an alias for a procedure
# Arguments: aliasName - the alias name to remove
# Returns: none
# Sideeffects: internalAliasList is updated, and the alias
#              proc is removed
##########
  global internalAliasList

  set xfIndex [lsearch $internalAliasList "$aliasName *"]
  if {$xfIndex != -1} {
    rename $aliasName ""
    set internalAliasList [lreplace $internalAliasList $xfIndex $xfIndex]
  }
}
}



# application parsing procedure
proc XFLocalParseAppDefs {xfAppDefFile} {
  global xfAppDefaults

  # basically from: Michael Moore
  if {[file exists $xfAppDefFile] &&
      [file readable $xfAppDefFile] &&
      "[file type $xfAppDefFile]" == "link"} {
    catch "file type $xfAppDefFile" xfType
    while {"$xfType" == "link"} {
      if {[catch "file readlink $xfAppDefFile" xfAppDefFile]} {
        return
      }
      catch "file type $xfAppDefFile" xfType
    }
  }
  if {!("$xfAppDefFile" != "" &&
        [file exists $xfAppDefFile] &&
        [file readable $xfAppDefFile] &&
        "[file type $xfAppDefFile]" == "file")} {
    return
  }
  if {![catch "open $xfAppDefFile r" xfResult]} {
    set xfAppFileContents [read $xfResult]
    close $xfResult
    foreach line [split $xfAppFileContents "\n"] {
      # backup indicates how far to backup.  It applies to the
      # situation where a resource name ends in . and when it
      # ends in *.  In the second case you want to keep the *
      # in the widget name for pattern matching, but you want
      # to get rid of the . if it is the end of the name. 
      set backup -2  
      set line [string trim $line]
      if {[string index $line 0] == "#" || "$line" == ""} {
        # skip comments and empty lines
        continue
      }
      set list [split $line ":"]
      set resource [string trim [lindex $list 0]]
      set i [string last "." $resource]
      set j [string last "*" $resource]
      if {$j > $i} { 
        set i $j
        set backup -1
      }
      incr i
      set name [string range $resource $i end]
      incr i $backup
      set widname [string range $resource 0 $i]
      set value [string trim [lindex $list 1]]
      if {"$widname" != "" && "$widname" != "*"} {
        # insert the widget and resourcename to the application
        # defaults list.
        if {![info exists xfAppDefaults]} {
          set xfAppDefaults ""
        }
        lappend xfAppDefaults [list $widname [string tolower $name] $value]
      }
    }
  }
}

# application loading procedure
proc XFLocalLoadAppDefs {{xfClasses ""} {xfPriority "startupFile"} {xfAppDefFile ""}} {
  global env

  if {"$xfAppDefFile" == ""} {
    set xfFileList ""
    if {[info exists env(XUSERFILESEARCHPATH)]} {
      append xfFileList [split $env(XUSERFILESEARCHPATH) :]
    }
    if {[info exists env(XAPPLRESDIR)]} {
      append xfFileList [split $env(XAPPLRESDIR) :]
    }
    if {[info exists env(XFILESEARCHPATH)]} {
      append xfFileList [split $env(XFILESEARCHPATH) :]
    }
    append xfFileList " /usr/lib/X11/app-defaults"
    append xfFileList " /usr/X11/lib/X11/app-defaults"

    foreach xfCounter1 $xfClasses {
      foreach xfCounter2 $xfFileList {
        set xfPathName $xfCounter2
        if {[regsub -all "%N" "$xfPathName" "$xfCounter1" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%T" "$xfPathName" "app-defaults" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%S" "$xfPathName" "" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%C" "$xfPathName" "" xfResult]} {
          set xfPathName $xfResult
        }
        if {[file exists $xfPathName] &&
            [file readable $xfPathName] &&
            ("[file type $xfPathName]" == "file" ||
             "[file type $xfPathName]" == "link")} {
          catch "option readfile $xfPathName $xfPriority"
          if {"[info commands XFParseAppDefs]" != ""} {
            XFParseAppDefs $xfPathName
          } {
            if {"[info commands XFLocalParseAppDefs]" != ""} {
              XFLocalParseAppDefs $xfPathName
            }
          }
        } {
          if {[file exists $xfCounter2/$xfCounter1] &&
              [file readable $xfCounter2/$xfCounter1] &&
              ("[file type $xfCounter2/$xfCounter1]" == "file" ||
               "[file type $xfCounter2/$xfCounter1]" == "link")} {
            catch "option readfile $xfCounter2/$xfCounter1 $xfPriority"
            if {"[info commands XFParseAppDefs]" != ""} {
              XFParseAppDefs $xfCounter2/$xfCounter1
            } {
              if {"[info commands XFLocalParseAppDefs]" != ""} {
                XFLocalParseAppDefs $xfCounter2/$xfCounter1
              }
            }
          }
        }
      }
    }
  } {
    # load a specific application defaults file
    if {[file exists $xfAppDefFile] &&
        [file readable $xfAppDefFile] &&
        ("[file type $xfAppDefFile]" == "file" ||
         "[file type $xfAppDefFile]" == "link")} {
      catch "option readfile $xfAppDefFile $xfPriority"
      if {"[info commands XFParseAppDefs]" != ""} {
        XFParseAppDefs $xfAppDefFile
      } {
        if {"[info commands XFLocalParseAppDefs]" != ""} {
          XFLocalParseAppDefs $xfAppDefFile
        }
      }
    }
  }
}

# application setting procedure
proc XFLocalSetAppDefs {{xfWidgetPath "."}} {
  global xfAppDefaults

  if {![info exists xfAppDefaults]} {
    return
  }
  foreach xfCounter $xfAppDefaults {
    if {"$xfCounter" == ""} {
      break
    }
    set widname [lindex $xfCounter 0]
    if {[string match $widname ${xfWidgetPath}] ||
        [string match "${xfWidgetPath}*" $widname]} {
      set name [string tolower [lindex $xfCounter 1]]
      set value [lindex $xfCounter 2]
      # Now lets see how many tcl commands match the name
      # pattern specified.
      set widlist [info command $widname]
      if {"$widlist" != ""} {
        foreach widget $widlist {
          # make sure this command is a widget.
          if {![catch "winfo id $widget"] &&
              [string match "${xfWidgetPath}*" $widget]} {
            catch "$widget configure -$name $value" 
          }
        }
      }
    }
  }
}


# prepare auto loading
global auto_path
global tk_library
global xfLoadPath
#foreach xfElement [eval list [split $xfLoadPath :] $auto_path] {
#  if {[file exists $xfElement/tclIndex]} {
#    lappend auto_path $xfElement
#  }
#}
catch "unset auto_index"

catch "unset auto_oldpath"

catch "unset auto_execs"


# initialize global variables
proc InitGlobals {} {
  global {fsBox}
  set {fsBox(activeBackground)} {}
  set {fsBox(activeForeground)} {}
  set {fsBox(all)} {0}
  set {fsBox(background)} {}
  set {fsBox(button)} {0}
  set {fsBox(extensions)} {0}
  set {fsBox(font)} {}
  set {fsBox(foreground)} {}
  set {fsBox(internalPath)} {/data/users/ding/TclTk/Mreg}
  set {fsBox(name)} {}
  set {fsBox(path)} {/data/users/ding/TclTk/Mreg}
  set {fsBox(pattern)} {*}
  set {fsBox(scrollActiveForeground)} {}
  set {fsBox(scrollBackground)} {}
  set {fsBox(scrollForeground)} {}
  set {fsBox(scrollSide)} {left}
  set {fsBox(showPixmap)} {0}
  global {yesNoBox}
  set {yesNoBox(activeBackground)} {}
  set {yesNoBox(activeForeground)} {}
  set {yesNoBox(afterNo)} {0}
  set {yesNoBox(afterYes)} {0}
  set {yesNoBox(anchor)} {n}
  set {yesNoBox(background)} {}
  set {yesNoBox(button)} {0}
  set {yesNoBox(font)} {*times-bold-r-normal*24*}
  set {yesNoBox(foreground)} {}
  set {yesNoBox(justify)} {center}

  # please don't modify the following
  # variables. They are needed by xf.
  global {autoLoadList}
  set {autoLoadList(main.tcl)} {0}
  set {autoLoadList(mreg.tcl)} {0}
  global {internalAliasList}
  set {internalAliasList} {}
  global {moduleList}
  set {moduleList(mreg.tcl)} {}
  global {preloadList}
  set {preloadList(xfInternal)} {}
  global {symbolicName}
  set {symbolicName(root)} {.}
  global {xfWmSetPosition}
  set {xfWmSetPosition} {}
  global {xfWmSetSize}
  set {xfWmSetSize} {}
  global {xfAppDefToplevels}
  set {xfAppDefToplevels} {}
}

# initialize global variables
InitGlobals

# display/remove toplevel windows.
#ShowWindow.

# load default bindings.
if {[info exists env(XF_BIND_FILE)] &&
    "[info procs XFShowHelp]" == ""} {
  source $env(XF_BIND_FILE)
}

# parse and apply application defaults.
XFLocalLoadAppDefs Mreg
XFLocalSetAppDefs

# eof
#
# To clear all the database from the memory

proc clearAllList {} {

  global ID_list Name_list Tel_W_list Tel_H_list Tel_O_list Fax_list \
         Email_list \
         Sex_list DOB_list Title_list Occupation_list Address_list \
         Note_list Comment_list

set ID_list ""
set Name_list ""
set Tel_W_list ""
set Tel_H_list ""
set Tel_O_list ""
set Fax_list ""
set Email_list ""
set Sex_list ""
set DOB_list ""
set Title_list ""
set Occupation_list ""
set Address_list ""
set Note_list ""
set Comment_list ""


}
# Procedure: FSBox
proc FSBox { {fsBoxMessage "Select file:"} {fsBoxFileName ""} {fsBoxActionOk ""} {fsBoxActionCancel ""} } {

# xf ignore me 5
##########
# Procedure: FSBox
# Description: show file selector box
# Arguments: fsBoxMessage - the text to display
#            fsBoxFileName - a file name that should be selected
#            fsBoxActionOk - the action that should be performed on ok
#            fsBoxActionCancel - the action that should be performed on cancel
# Returns: the filename that was selected, or nothing
# Sideeffects: none
##########
# 
# global fsBox(activeBackground) - active background color
# global fsBox(activeForeground) - active foreground color
# global fsBox(background) - background color
# global fsBox(font) - text font
# global fsBox(foreground) - foreground color
# global fsBox(extensions) - scan directory for extensions
# global fsBox(scrollActiveForeground) - scrollbar active background color
# global fsBox(scrollBackground) - scrollbar background color
# global fsBox(scrollForeground) - scrollbar foreground color
# global fsBox(scrollSide) - side where scrollbar is located

  global fsBox

  set tmpButtonOpt ""
  set tmpFrameOpt ""
  set tmpMessageOpt ""
  set tmpScaleOpt ""
  set tmpScrollOpt ""
  if {"$fsBox(activeBackground)" != ""} {
    append tmpButtonOpt "-activebackground \"$fsBox(activeBackground)\" "
  }
  if {"$fsBox(activeForeground)" != ""} {
    append tmpButtonOpt "-activeforeground \"$fsBox(activeForeground)\" "
  }
  if {"$fsBox(background)" != ""} {
    append tmpButtonOpt "-background \"$fsBox(background)\" "
    append tmpFrameOpt "-background \"$fsBox(background)\" "
    append tmpMessageOpt "-background \"$fsBox(background)\" "
  }
  if {"$fsBox(font)" != ""} {
    append tmpButtonOpt "-font \"$fsBox(font)\" "
    append tmpMessageOpt "-font \"$fsBox(font)\" "
  }
  if {"$fsBox(foreground)" != ""} {
    append tmpButtonOpt "-foreground \"$fsBox(foreground)\" "
    append tmpMessageOpt "-foreground \"$fsBox(foreground)\" "
  }
  if {"$fsBox(scrollActiveForeground)" != ""} {
    append tmpScrollOpt "-activeforeground \"$fsBox(scrollActiveForeground)\" "
  }
  if {"$fsBox(scrollBackground)" != ""} {
    append tmpScrollOpt "-background \"$fsBox(scrollBackground)\" "
  }
  if {"$fsBox(scrollForeground)" != ""} {
    append tmpScrollOpt "-foreground \"$fsBox(scrollForeground)\" "
  }

  if {[file exists [file tail $fsBoxFileName]] &&
      [IsAFile [file tail $fsBoxFileName]]} {
    set fsBox(name) [file tail $fsBoxFileName]
  } {
    set fsBox(name) ""
  }
  if {[file exists $fsBoxFileName] && [IsADir $fsBoxFileName]} {
    set fsBox(path) $fsBoxFileName
  } {
    if {"[file rootname $fsBoxFileName]" != "."} {
      set fsBox(path) [file rootname $fsBoxFileName]
    }
  }
  if {$fsBox(showPixmap)} {
    set fsBox(path) [string trimleft $fsBox(path) @]
  }
  if {"$fsBox(path)" != "" && [file exists $fsBox(path)] &&
      [IsADir $fsBox(path)]} {
    set fsBox(internalPath) $fsBox(path)
  } {
    if {"$fsBox(internalPath)" == "" ||
        ![file exists $fsBox(internalPath)]} {
      set fsBox(internalPath) [pwd]
    }
  }
  # build widget structure

  # start build of toplevel
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy .fsBox}
  } {
    catch {destroy .fsBox}
  }
  toplevel .fsBox  -borderwidth 0
  catch ".fsBox config $tmpFrameOpt"
  wm geometry .fsBox 350x300 
  wm title .fsBox {File select box}
  wm maxsize .fsBox 1000 1000
  wm minsize .fsBox 100 100
  # end build of toplevel

  label .fsBox.message1  -anchor c  -relief raised  -text "$fsBoxMessage"
  catch ".fsBox.message1 config $tmpMessageOpt"

  frame .fsBox.frame1  -borderwidth 0  -relief raised
  catch ".fsBox.frame1 config $tmpFrameOpt"

  button .fsBox.frame1.ok  -text "OK"  -command "
      global fsBox
      set fsBox(name) \[.fsBox.file.file get\]
      if {$fsBox(showPixmap)} {
        set fsBox(path) @\[.fsBox.path.path get\]
      } {
        set fsBox(path) \[.fsBox.path.path get\]
      }
      set fsBox(internalPath) \[.fsBox.path.path get\]
      $fsBoxActionOk
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .fsBox}
      } {
        catch {destroy .fsBox}
      }"
  catch ".fsBox.frame1.ok config $tmpButtonOpt"

  button .fsBox.frame1.rescan  -text "Rescan"  -command {
      global fsBox
      FSBoxFSShow [.fsBox.path.path get]  [.fsBox.pattern.pattern get] $fsBox(all)}
  catch ".fsBox.frame1.rescan config $tmpButtonOpt"

  button .fsBox.frame1.cancel  -text "Cancel"  -command "
      global fsBox
      set fsBox(name) {}
      set fsBox(path) {}
      $fsBoxActionCancel
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .fsBox}
      } {
        catch {destroy .fsBox}
      }"
  catch ".fsBox.frame1.cancel config $tmpButtonOpt"

  if {$fsBox(showPixmap)} {
    frame .fsBox.frame2  -borderwidth 0  -relief raised
    catch ".fsBox.frame2 config $tmpFrameOpt"

    scrollbar .fsBox.frame2.scrollbar3  -command {.fsBox.frame2.canvas2 xview}  -orient {horizontal}  -relief {raised}
    catch ".fsBox.frame2.scrollbar3 config $tmpScrollOpt"

    scrollbar .fsBox.frame2.scrollbar1  -command {.fsBox.frame2.canvas2 yview}  -relief {raised}
    catch ".fsBox.frame2.scrollbar1 config $tmpScrollOpt"

    canvas .fsBox.frame2.canvas2  -confine {true}  -relief {raised}  -scrollregion {0c 0c 20c 20c}  -width {100}  -xscrollcommand {.fsBox.frame2.scrollbar3 set}  -yscrollcommand {.fsBox.frame2.scrollbar1 set}
    catch ".fsBox.frame2.canvas2 config $tmpFrameOpt"

    .fsBox.frame2.canvas2 addtag currentBitmap withtag [.fsBox.frame2.canvas2 create bitmap 5 5 -anchor nw]
  }

  frame .fsBox.path  -borderwidth 0  -relief raised
  catch ".fsBox.path config $tmpFrameOpt"

  frame .fsBox.path.paths  -borderwidth 2  -relief raised
  catch ".fsBox.path.paths config $tmpFrameOpt"

  menubutton .fsBox.path.paths.paths  -borderwidth 0  -menu ".fsBox.path.paths.paths.menu"  -relief flat  -text "Pathname:"
  catch ".fsBox.path.paths.paths config $tmpButtonOpt"

  menu .fsBox.path.paths.paths.menu
  catch ".fsBox.path.paths.paths.menu config $tmpButtonOpt"

  .fsBox.path.paths.paths.menu add command  -label "[string trimright $fsBox(internalPath) {/@}]"  -command "
       global fsBox
       FSBoxFSShow \[.fsBox.path.path get\]  \[.fsBox.pattern.pattern get\] \$fsBox(all)
       .fsBox.path.path delete 0 end
       .fsBox.path.path insert 0 [string trimright $fsBox(internalPath) {/@}]"

  entry .fsBox.path.path  -relief raised
  catch ".fsBox.path.path config $tmpMessageOpt"

  if {![IsADir $fsBox(internalPath)]} {
    set $fsBox(internalPath) [pwd]
  }
  .fsBox.path.path insert 0 $fsBox(internalPath)

  frame .fsBox.pattern  -borderwidth 0  -relief raised
  catch ".fsBox.pattern config $tmpFrameOpt"

  frame .fsBox.pattern.patterns  -borderwidth 2  -relief raised
  catch ".fsBox.pattern.patterns config $tmpFrameOpt"

  menubutton .fsBox.pattern.patterns.patterns  -borderwidth 0  -menu ".fsBox.pattern.patterns.patterns.menu"  -relief flat  -text "Selection pattern:"
  catch ".fsBox.pattern.patterns.patterns config $tmpButtonOpt"

  menu .fsBox.pattern.patterns.patterns.menu
  catch ".fsBox.pattern.patterns.patterns.menu config $tmpButtonOpt"

  .fsBox.pattern.patterns.patterns.menu add checkbutton  -label "Scan extensions"  -variable fsBox(extensions)  -command {
      global fsBox
      FSBoxFSShow [.fsBox.path.path get]  [.fsBox.pattern.pattern get] $fsBox(all)}

  entry .fsBox.pattern.pattern  -relief raised
  catch ".fsBox.pattern.pattern config $tmpMessageOpt"

  .fsBox.pattern.pattern insert 0 $fsBox(pattern)
  
  frame .fsBox.files  -borderwidth 0  -relief raised
  catch ".fsBox.files config $tmpFrameOpt"

  scrollbar .fsBox.files.vscroll  -relief raised  -command ".fsBox.files.files yview"
  catch ".fsBox.files.vscroll config $tmpScrollOpt"

  scrollbar .fsBox.files.hscroll  -orient horiz  -relief raised  -command ".fsBox.files.files xview"
  catch ".fsBox.files.hscroll config $tmpScrollOpt"

  listbox .fsBox.files.files  -exportselection false  -relief raised  -xscrollcommand ".fsBox.files.hscroll set"  -yscrollcommand ".fsBox.files.vscroll set"
  catch ".fsBox.files.files config $tmpMessageOpt"

  frame .fsBox.file  -borderwidth 0  -relief raised
  catch ".fsBox.file config $tmpFrameOpt"

  label .fsBox.file.labelfile  -relief raised  -text "Filename:"
  catch ".fsBox.file.labelfile config $tmpMessageOpt"

  entry .fsBox.file.file  -relief raised
  catch ".fsBox.file.file config $tmpMessageOpt"

  .fsBox.file.file delete 0 end
  .fsBox.file.file insert 0 $fsBox(name)
  
  checkbutton .fsBox.pattern.all  -offvalue 0  -onvalue 1  -text "Show all files"  -variable fsBox(all)  -command {
      global fsBox
      FSBoxFSShow [.fsBox.path.path get]  [.fsBox.pattern.pattern get] $fsBox(all)}
  catch ".fsBox.pattern.all config $tmpButtonOpt"

  FSBoxFSShow $fsBox(internalPath) $fsBox(pattern) $fsBox(all)

  # bindings
  bind .fsBox.files.files <Double-Button-1> "
    FSBoxFSFileSelectDouble %W $fsBox(showPixmap) \{$fsBoxActionOk\} %y"
  bind .fsBox.files.files <ButtonPress-1> "
    FSBoxFSFileSelect %W $fsBox(showPixmap) %y"
  bind .fsBox.files.files <Button1-Motion> "
    FSBoxFSFileSelect %W $fsBox(showPixmap) %y"
  bind .fsBox.files.files <Shift-Button1-Motion> "
    FSBoxFSFileSelect %W $fsBox(showPixmap) %y"
  bind .fsBox.files.files <Shift-ButtonPress-1> "
    FSBoxFSFileSelect %W $fsBox(showPixmap) %y"

  bind .fsBox.path.path <Tab> {
    FSBoxFSNameComplete path}
  bind .fsBox.path.path <Return> {
    global tkVersion
    global fsBox
    FSBoxFSShow [.fsBox.path.path get]  [.fsBox.pattern.pattern get] $fsBox(all)
    FSBoxFSInsertPath
    if {$tkVersion >= 3.0} {
      .fsBox.file.file icursor end
    } {
      .fsBox.file.file cursor end
    }
    focus .fsBox.file.file}
  catch "bind .fsBox.path.path <Up> {}"
  bind .fsBox.path.path <Down> {
    global tkVersion
    if {$tkVersion >= 3.0} {
      .fsBox.file.file icursor end
    } {
      .fsBox.file.file cursor end
    }
    focus .fsBox.file.file}

  bind .fsBox.file.file <Tab> {
    FSBoxFSNameComplete file}
  bind .fsBox.file.file <Return> "
    global fsBox
    set fsBox(name) \[.fsBox.file.file get\]
    if {$fsBox(showPixmap)} {
      set fsBox(path) @\[.fsBox.path.path get\]
    } {
      set fsBox(path) \[.fsBox.path.path get\]
    }
    set fsBox(internalPath) \[.fsBox.path.path get\]
    $fsBoxActionOk
    if {\"\[info commands XFDestroy\]\" != \"\"} {
      catch {XFDestroy .fsBox}
    } {
      catch {destroy .fsBox}
    }"
  bind .fsBox.file.file <Up> {
    global tkVersion
    if {$tkVersion >= 3.0} {
      .fsBox.path.path icursor end
    } {
      .fsBox.path.path cursor end
    }
    focus .fsBox.path.path}
  bind .fsBox.file.file <Down> {
    global tkVersion
    if {$tkVersion >= 3.0} {
      .fsBox.pattern.pattern icursor end
    } {
      .fsBox.pattern.pattern cursor end
    }
    focus .fsBox.pattern.pattern}

  bind .fsBox.pattern.pattern <Return> {
    global fsBox
    FSBoxFSShow [.fsBox.path.path get]  [.fsBox.pattern.pattern get] $fsBox(all)}
  bind .fsBox.pattern.pattern <Up> {
    global tkVersion
    if {$tkVersion >= 3.0} {
      .fsBox.file.file icursor end
    } {
      .fsBox.file.file cursor end
    }
    focus .fsBox.file.file}
  catch "bind .fsBox.pattern.pattern <Down> {}"

  # packing
  pack append .fsBox.files  .fsBox.files.vscroll "$fsBox(scrollSide) filly"  .fsBox.files.hscroll {bottom fillx}  .fsBox.files.files {left fill expand}
  pack append .fsBox.file  .fsBox.file.labelfile {left}  .fsBox.file.file {left fill expand}
  pack append .fsBox.frame1  .fsBox.frame1.ok {left fill expand}  .fsBox.frame1.rescan {left fill expand}  .fsBox.frame1.cancel {left fill expand}
  pack append .fsBox.path.paths  .fsBox.path.paths.paths {left}
  pack append .fsBox.pattern.patterns  .fsBox.pattern.patterns.patterns {left}
  pack append .fsBox.path  .fsBox.path.paths {left}  .fsBox.path.path {left fill expand}
  pack append .fsBox.pattern  .fsBox.pattern.patterns {left}  .fsBox.pattern.all {right fill}  .fsBox.pattern.pattern {left fill expand}
  if {$fsBox(showPixmap)} {
    pack append .fsBox.frame2  .fsBox.frame2.scrollbar1 {left filly}  .fsBox.frame2.canvas2 {top expand fill}  .fsBox.frame2.scrollbar3 {top fillx} 

    pack append .fsBox  .fsBox.message1 {top fill}  .fsBox.frame1 {bottom fill}  .fsBox.pattern {bottom fill}  .fsBox.file {bottom fill}  .fsBox.path {bottom fill}  .fsBox.frame2 {right fill}  .fsBox.files {left fill expand}
  } {
    pack append .fsBox  .fsBox.message1 {top fill}  .fsBox.frame1 {bottom fill}  .fsBox.pattern {bottom fill}  .fsBox.file {bottom fill}  .fsBox.path {bottom fill}  .fsBox.files {left fill expand}
  }

  if {"$fsBoxActionOk" == "" && "$fsBoxActionCancel" == ""} {
    # wait for the box to be destroyed
    update idletask
    grab .fsBox
    tkwait window .fsBox

    if {"[string trim $fsBox(path)]" != "" ||
        "[string trim $fsBox(name)]" != ""} {
      if {"[string trimleft [string trim $fsBox(name)] /]" == ""} {
        return [string trimright [string trim $fsBox(path)] /]
      } {
        return [string trimright [string trim $fsBox(path)] /]/[string trimleft [string trim $fsBox(name)] /]
      }
    }
  }
}


# Procedure: FSBoxBindSelectOne
proc FSBoxBindSelectOne { fsBoxW fsBoxY} {
# xf ignore me 6

  set fsBoxNearest [$fsBoxW nearest $fsBoxY]
  if {$fsBoxNearest >= 0} {
    $fsBoxW select from $fsBoxNearest
    $fsBoxW select to $fsBoxNearest
  }
}


# Procedure: FSBoxFSFileSelect
proc FSBoxFSFileSelect { fsBoxW fsBoxShowPixmap fsBoxY} {
# xf ignore me 6
  global fsBox

  FSBoxBindSelectOne $fsBoxW $fsBoxY
  set fsBoxNearest [$fsBoxW nearest $fsBoxY]
  if {$fsBoxNearest >= 0} {
    set fsBoxTmpEntry [$fsBoxW get $fsBoxNearest]
    if {"[string index $fsBoxTmpEntry  [expr [string length $fsBoxTmpEntry]-1]]" == "/" ||
        "[string index $fsBoxTmpEntry  [expr [string length $fsBoxTmpEntry]-1]]" == "@"} {
      set fsBoxFileName [string range $fsBoxTmpEntry 0  [expr [string length $fsBoxTmpEntry]-2]]
      if {![IsADir [string trimright $fsBox(internalPath)/$fsBoxFileName @]] &&
          ![IsASymlink [string trimright $fsBox(internalPath)/$fsBoxFileName @]]} {
        set fsBoxFileName $fsBoxTmpEntry
      }
    } {
      if {"[string index $fsBoxTmpEntry  [expr [string length $fsBoxTmpEntry]-1]]" == "*"} {
        set fsBoxFileName [string range $fsBoxTmpEntry 0  [expr [string length $fsBoxTmpEntry]-2]]
        if {![file executable $fsBox(internalPath)/$fsBoxFileName]} {
          set fsBoxFileName $fsBoxTmpEntry
        }
      } {
        set fsBoxFileName $fsBoxTmpEntry
      }
    }
    if {![IsADir [string trimright $fsBox(internalPath)/$fsBoxFileName @]]} {
      set fsBox(name) $fsBoxFileName
      .fsBox.file.file delete 0 end
      .fsBox.file.file insert 0 $fsBox(name)
      if {$fsBoxShowPixmap} {
        catch ".fsBox.frame2.canvas2 itemconfigure currentBitmap -bitmap \"@$fsBox(internalPath)/$fsBox(name)\""
      }
    }
  }
}


# Procedure: FSBoxFSFileSelectDouble
proc FSBoxFSFileSelectDouble { fsBoxW fsBoxShowPixmap fsBoxAction fsBoxY} {
# xf ignore me 6
  global fsBox

  FSBoxBindSelectOne $fsBoxW $fsBoxY
  set fsBoxNearest [$fsBoxW nearest $fsBoxY]
  if {$fsBoxNearest >= 0} {
    set fsBoxTmpEntry [$fsBoxW get $fsBoxNearest]
    if {"$fsBoxTmpEntry" == "../"} {
      set fsBoxTmpEntry [string trimright [string trim $fsBox(internalPath)] "@/"]
      if {"$fsBoxTmpEntry" == ""} {
        return
      }
      FSBoxFSShow [file dirname $fsBoxTmpEntry]  [.fsBox.pattern.pattern get] $fsBox(all)
      .fsBox.path.path delete 0 end
      .fsBox.path.path insert 0 $fsBox(internalPath)
    } {
      if {"[string index $fsBoxTmpEntry  [expr [string length $fsBoxTmpEntry]-1]]" == "/" ||
          "[string index $fsBoxTmpEntry  [expr [string length $fsBoxTmpEntry]-1]]" == "@"} {
        set fsBoxFileName [string range $fsBoxTmpEntry 0  [expr [string length $fsBoxTmpEntry]-2]]
        if {![IsADir [string trimright $fsBox(internalPath)/$fsBoxFileName @]] &&
            ![IsASymlink [string trimright $fsBox(internalPath)/$fsBoxFileName @]]} {
          set fsBoxFileName $fsBoxTmpEntry
        }
      } {
        if {"[string index $fsBoxTmpEntry  [expr [string length $fsBoxTmpEntry]-1]]" == "*"} {
          set fsBoxFileName [string range $fsBoxTmpEntry 0  [expr [string length $fsBoxTmpEntry]-2]]
          if {![file executable $fsBox(internalPath)/$fsBoxFileName]} {
            set fsBoxFileName $fsBoxTmpEntry
          }
        } {
          set fsBoxFileName $fsBoxTmpEntry
        }
      }
      if {[IsADir [string trimright $fsBox(internalPath)/$fsBoxFileName @]]} {
        set fsBox(internalPath) "[string trimright $fsBox(internalPath) {/@}]/$fsBoxFileName"
        FSBoxFSShow $fsBox(internalPath)  [.fsBox.pattern.pattern get] $fsBox(all)
        .fsBox.path.path delete 0 end
        .fsBox.path.path insert 0 $fsBox(internalPath)
      } {
        set fsBox(name) $fsBoxFileName
        if {$fsBoxShowPixmap} {
          set fsBox(path) @$fsBox(internalPath)
        } {
          set fsBox(path) $fsBox(internalPath)
        }
        if {"$fsBoxAction" != ""} {
          eval "global fsBox; $fsBoxAction"
        }
        if {"[info commands XFDestroy]" != ""} {
          catch {XFDestroy .fsBox}
        } {
          catch {destroy .fsBox}
        }
      }
    }
  }
}


# Procedure: FSBoxFSInsertPath
proc FSBoxFSInsertPath {} {
# xf ignore me 6
  global fsBox

  set fsBoxLast [.fsBox.path.paths.paths.menu index last]
  set fsBoxNewEntry [string trimright [.fsBox.path.path get] "/@"]
  for {set fsBoxCounter 0} {$fsBoxCounter <= $fsBoxLast} {incr fsBoxCounter 1} {
    if {"$fsBoxNewEntry" ==  "[lindex [.fsBox.path.paths.paths.menu entryconfigure  $fsBoxCounter -label] 4]"} {
      return
    }
  }
  if {$fsBoxLast < 9} {
    .fsBox.path.paths.paths.menu add command  -label "$fsBoxNewEntry"  -command "
        global fsBox
        FSBoxFSShow $fsBoxNewEntry  \[.fsBox.pattern.pattern get\] \$fsBox(all)
        .fsBox.path.path delete 0 end
        .fsBox.path.path insert 0 $fsBoxNewEntry"
  } {
    for {set fsBoxCounter 0} {$fsBoxCounter < $fsBoxLast} {incr fsBoxCounter 1} {
      .fsBox.path.paths.paths.menu entryconfigure  $fsBoxCounter -label  [lindex [.fsBox.path.paths.paths.menu entryconfigure  [expr $fsBoxCounter+1] -label] 4]
      .fsBox.path.paths.paths.menu entryconfigure $fsBoxCounter  -command "
          global fsBox
          FSBoxFSShow [lindex [.fsBox.path.paths.paths.menu entryconfigure  [expr $fsBoxCounter+1] -label] 4]  \[.fsBox.pattern.pattern get\] \$fsBox(all)
          .fsBox.path.path delete 0 end
          .fsBox.path.path insert 0 [lindex  [.fsBox.path.paths.paths.menu entryconfigure  [expr $fsBoxCounter+1] -label] 4]"
    }
    .fsBox.path.paths.paths.menu entryconfigure $fsBoxLast  -label "$fsBoxNewEntry"
    .fsBox.path.paths.paths.menu entryconfigure $fsBoxCounter  -command "
        global fsBox
        FSBoxFSShow \[.fsBox.path.path get\]  \[.fsBox.pattern.pattern get\] \$fsBox(all)
        .fsBox.path.path delete 0 end
        .fsBox.path.path insert 0 $fsBoxNewEntry"
  }
}


# Procedure: FSBoxFSNameComplete
proc FSBoxFSNameComplete { fsBoxType} {
# xf ignore me 6
  global tkVersion
  global fsBox

  set fsBoxNewFile ""
  if {"$fsBoxType" == "path"} {
    set fsBoxDirName [file dirname [.fsBox.path.path get]]
    set fsBoxFileName [file tail [.fsBox.path.path get]]
  } {
    set fsBoxDirName [file dirname [.fsBox.path.path get]/]
    set fsBoxFileName [file tail [.fsBox.file.file get]]
  }

  set fsBoxNewFile ""
  if {[IsADir [string trimright $fsBoxDirName @]]} {
    catch "glob -nocomplain $fsBoxDirName/${fsBoxFileName}*" fsBoxResult
    foreach fsBoxCounter $fsBoxResult {
      if {"$fsBoxNewFile" == ""} {
        set fsBoxNewFile [file tail $fsBoxCounter]
      } {
        if {"[string index [file tail $fsBoxCounter] 0]" !=
            "[string index $fsBoxNewFile 0]"} {
          set fsBoxNewFile ""
          break
        }
        set fsBoxCounter1 0
        set fsBoxTmpFile1 $fsBoxNewFile
        set fsBoxTmpFile2 [file tail $fsBoxCounter]
        set fsBoxLength1 [string length $fsBoxTmpFile1]
        set fsBoxLength2 [string length $fsBoxTmpFile2]
        set fsBoxNewFile ""
        if {$fsBoxLength1 > $fsBoxLength2} {
          set fsBoxLength1 $fsBoxLength2
        }
        while {$fsBoxCounter1 < $fsBoxLength1} {
          if {"[string index $fsBoxTmpFile1 $fsBoxCounter1]" ==  "[string index $fsBoxTmpFile2 $fsBoxCounter1]"} {
            append fsBoxNewFile [string index $fsBoxTmpFile1 $fsBoxCounter1]
          } {
            break
          }
          incr fsBoxCounter1 1
        }
      }
    }
  }
  if {"$fsBoxNewFile" != ""} {
    if {[IsADir [string trimright $fsBoxDirName/$fsBoxNewFile @]] ||
        ![IsAFile [string trimright $fsBoxDirName/$fsBoxNewFile @]]} {
      if {[IsADir [string trimright $fsBoxDirName/$fsBoxNewFile @]]} {
        if {"$fsBoxDirName" == "/"} {
          .fsBox.path.path delete 0 end
          .fsBox.path.path insert 0 "/[string trimright [string trim $fsBoxNewFile /] @]/"
        } {
          .fsBox.path.path delete 0 end
          .fsBox.path.path insert 0 "[string trimright $fsBoxDirName /]/[string trimright [string trim $fsBoxNewFile /] @]/"
        }
        FSBoxFSShow [.fsBox.path.path get]  [.fsBox.pattern.pattern get] $fsBox(all)
        FSBoxFSInsertPath
      } {
        .fsBox.path.path delete 0 end
        .fsBox.path.path insert 0 "[string trimright $fsBoxDirName /]/[string trimright [string trim $fsBoxNewFile /] @]"
      }
    } {
      .fsBox.path.path delete 0 end
      .fsBox.path.path insert 0 "[string trimright $fsBoxDirName {@/}]/"
      .fsBox.file.file delete 0 end
      .fsBox.file.file insert 0 $fsBoxNewFile
      if {$tkVersion >= 3.0} {
        .fsBox.file.file icursor end
      } {
        .fsBox.file.file cursor end
      }
      focus .fsBox.file.file
    }
  }
}


# Procedure: FSBoxFSShow
proc FSBoxFSShow { fsBoxPath fsBoxPattern fsBoxAll} {
# xf ignore me 6
  global fsBox

  set tmpButtonOpt ""
  if {"$fsBox(activeBackground)" != ""} {
    append tmpButtonOpt "-activebackground \"$fsBox(activeBackground)\" "
  }
  if {"$fsBox(activeForeground)" != ""} {
    append tmpButtonOpt "-activeforeground \"$fsBox(activeForeground)\" "
  }
  if {"$fsBox(background)" != ""} {
    append tmpButtonOpt "-background \"$fsBox(background)\" "
  }
  if {"$fsBox(font)" != ""} {
    append tmpButtonOpt "-font \"$fsBox(font)\" "
  }
  if {"$fsBox(foreground)" != ""} {
    append tmpButtonOpt "-foreground \"$fsBox(foreground)\" "
  }

  set fsBox(pattern) $fsBoxPattern
  if {[file exists $fsBoxPath] && [file readable $fsBoxPath] &&
      [IsADir $fsBoxPath]} {
    set fsBox(internalPath) $fsBoxPath
  } {
    if {[file exists $fsBoxPath] && [file readable $fsBoxPath] &&
        [IsAFile $fsBoxPath]} {
      set fsBox(internalPath) [file dirname $fsBoxPath]
      .fsBox.file.file delete 0 end
      .fsBox.file.file insert 0 [file tail $fsBoxPath]
      set fsBoxPath $fsBox(internalPath)
    } {
      while {"$fsBoxPath" != "" && "$fsBoxPath" != "/" &&
             ![file isdirectory $fsBoxPath]} {
        set fsBox(internalPath) [file dirname $fsBoxPath]
         set fsBoxPath $fsBox(internalPath)
      }
    }
  }
  if {"$fsBoxPath" == ""} {
    set fsBoxPath "/"
    set fsBox(internalPath) "/"
  }
  .fsBox.path.path delete 0 end
  .fsBox.path.path insert 0 $fsBox(internalPath)

  if {[.fsBox.files.files size] > 0} {
    .fsBox.files.files delete 0 end
  }
  if {$fsBoxAll} {
    if {[catch "exec ls -F -a $fsBoxPath" fsBoxResult]} {
      puts stderr "$fsBoxResult"
    }
  } {
    if {[catch "exec ls -F $fsBoxPath" fsBoxResult]} {
      puts stderr "$fsBoxResult"
    }
  }
  set fsBoxElementList [lsort $fsBoxResult]

  foreach fsBoxCounter [winfo children .fsBox.pattern.patterns.patterns] {
    if {[string length [info commands XFDestroy]] > 0} {
      catch {XFDestroy $fsBoxCounter}
    } {
      catch {destroy $fsBoxCounter}
    }
  }
  menu .fsBox.pattern.patterns.patterns.menu
  catch ".fsBox.pattern.patterns.patterns.menu config $tmpButtonOpt"

  if {$fsBox(extensions)} {
    .fsBox.pattern.patterns.patterns.menu add command  -label "*"  -command {
        global fsBox
        set fsBox(pattern) "*"
        .fsBox.pattern.pattern delete 0 end
        .fsBox.pattern.pattern insert 0 $fsBox(pattern)
        FSBoxFSShow [.fsBox.path.path get] $fsBox(pattern)  $fsBox(all)}
  }

  if {"$fsBoxPath" != "/"} {
    .fsBox.files.files insert end "../"
  }
  foreach fsBoxCounter $fsBoxElementList {
    if {[string match $fsBoxPattern $fsBoxCounter] ||
        [IsADir [string trimright $fsBoxPath/$fsBoxCounter "/@"]]} {
      if {"$fsBoxCounter" != "../" &&
          "$fsBoxCounter" != "./"} {
        .fsBox.files.files insert end $fsBoxCounter
      }
    }

    if {$fsBox(extensions)} {
      catch "file rootname $fsBoxCounter" fsBoxRootName
      catch "file extension $fsBoxCounter" fsBoxExtension
      set fsBoxExtension [string trimright $fsBoxExtension "/*@"]
      if {"$fsBoxExtension" != "" && "$fsBoxRootName" != ""} {
        set fsBoxInsert 1
        set fsBoxLast [.fsBox.pattern.patterns.patterns.menu index last]
        for {set fsBoxCounter1 0} {$fsBoxCounter1 <= $fsBoxLast} {incr fsBoxCounter1 1} {
          if {"*$fsBoxExtension" ==  "[lindex [.fsBox.pattern.patterns.patterns.menu entryconfigure  $fsBoxCounter1 -label] 4]"} {
            set fsBoxInsert 0
          }
        }
	if {$fsBoxInsert} {
          .fsBox.pattern.patterns.patterns.menu add command  -label "*$fsBoxExtension"  -command "
              global fsBox
              set fsBox(pattern) \"*$fsBoxExtension\"
              .fsBox.pattern.pattern delete 0 end
              .fsBox.pattern.pattern insert 0 \$fsBox(pattern)
              FSBoxFSShow \[.fsBox.path.path get\] \$fsBox(pattern)  \$fsBox(all)"
        }
      }
    }
  }
  if {$fsBox(extensions)} {
    .fsBox.pattern.patterns.patterns.menu add separator
  }
  if {$fsBox(extensions) || 
      "[.fsBox.pattern.patterns.patterns.menu index last]" == "none"} {
    .fsBox.pattern.patterns.patterns.menu add checkbutton  -label "Scan extensions"  -variable "fsBox(extensions)"  -command {
        global fsBox
        FSBoxFSShow [.fsBox.path.path get]  [.fsBox.pattern.pattern get] $fsBox(all)}
  }
}


# Procedure: IsADir
proc IsADir { pathName} {
# xf ignore me 5
##########
# Procedure: IsADir
# Description: check if name is a directory (including symbolic links)
# Arguments: pathName - the path to check
# Returns: 1 if its a directory, otherwise 0
# Sideeffects: none
##########

  if {[file isdirectory $pathName]} {
    return 1
  } {
    catch "file type $pathName" fileType
    if {"$fileType" == "link"} {
      if {[catch "file readlink $pathName" linkName]} {
        return 0
      }
      catch "file type $linkName" fileType
      while {"$fileType" == "link"} {
        if {[catch "file readlink $linkName" linkName]} {
          return 0
        }
        catch "file type $linkName" fileType
      }
      return [file isdirectory $linkName]
    }
  }
  return 0
}


# Procedure: IsAFile
proc IsAFile { fileName} {
# xf ignore me 5
##########
# Procedure: IsAFile
# Description: check if filename is a file (including symbolic links)
# Arguments: fileName - the filename to check
# Returns: 1 if its a file, otherwise 0
# Sideeffects: none
##########

  if {[file isfile $fileName]} {
    return 1
  } {
    catch "file type $fileName" fileType
    if {"$fileType" == "link"} {
      if {[catch "file readlink $fileName" linkName]} {
        return 0
      }
      catch "file type $linkName" fileType
      while {"$fileType" == "link"} {
        if {[catch "file readlink $linkName" linkName]} {
          return 0
        }
        catch "file type $linkName" fileType
      }
      return [file isfile $linkName]
    }
  }
  return 0
}


# Procedure: IsASymlink
proc IsASymlink { fileName} {
# xf ignore me 5
##########
# Procedure: IsASymlink
# Description: check if filename is a symbolic link
# Arguments: fileName - the path/filename to check
# Returns: none
# Sideeffects: none
##########

  catch "file type $fileName" fileType
  if {"$fileType" == "link"} {
    return 1
  }
  return 0
}


# Internal procedures


# Procedure: Alias
if {"[info procs Alias]" == ""} {
proc Alias { args} {
# xf ignore me 7
##########
# Procedure: Alias
# Description: establish an alias for a procedure
# Arguments: args - no argument means that a list of all aliases
#                   is returned. Otherwise the first parameter is
#                   the alias name, and the second parameter is
#                   the procedure that is aliased.
# Returns: nothing, the command that is bound to the alias or a
#          list of all aliases - command pairs. 
# Sideeffects: internalAliasList is updated, and the alias
#              proc is inserted
##########
  global internalAliasList

  if {[llength $args] == 0} {
    return $internalAliasList
  } {
    if {[llength $args] == 1} {
      set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
      if {$xfTmpIndex != -1} {
        return [lindex [lindex $internalAliasList $xfTmpIndex] 1]
      }
    } {
      if {[llength $args] == 2} {
        eval "proc [lindex $args 0] {args} {#xf ignore me 4
return \[eval \"[lindex $args 1] \$args\"\]}"
        set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
        if {$xfTmpIndex != -1} {
          set internalAliasList [lreplace $internalAliasList $xfTmpIndex $xfTmpIndex "[lindex $args 0] [lindex $args 1]"]
        } {
          lappend internalAliasList "[lindex $args 0] [lindex $args 1]"
        }
      } {
        error "Alias: wrong number or args: $args"
      }
    }
  }
}
}


# Procedure: GetSelection
if {"[info procs GetSelection]" == ""} {
proc GetSelection {} {
# xf ignore me 7
##########
# Procedure: GetSelection
# Description: get current selection
# Arguments: none
# Returns: none
# Sideeffects: none
##########

  # the save way
  set xfSelection ""
  catch "selection get" xfSelection
  if {"$xfSelection" == "selection doesn't exist or form \"STRING\" not defined"} {
    return ""
  } {
    return $xfSelection
  }
}
}


# Procedure: MenuPopupAdd
if {"[info procs MenuPopupAdd]" == ""} {
proc MenuPopupAdd { xfW xfButton xfMenu {xfModifier ""} {xfCanvasTag ""}} {
# xf ignore me 7
# the popup menu handling is from (I already gave up with popup handling :-):
#
# Copyright 1991,1992 by James Noble.
# Everyone is granted permission to copy, modify and redistribute.
# This notice must be preserved on all copies or derivates.
#
##########
# Procedure: MenuPopupAdd
# Description: attach a popup menu to widget
# Arguments: xfW - the widget
#            xfButton - the button we use
#            xfMenu - the menu to attach
#            {xfModifier} - a optional modifier
#            {xfCanvasTag} - a canvas tagOrId
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv

  set tk_popupPriv($xfMenu,focus) ""
  set tk_popupPriv($xfMenu,grab) ""
  if {"$xfModifier" != ""} {
    set press "$xfModifier-"
    set motion "$xfModifier-"
    set release "Any-"
  } {
    set press ""
    set motion ""
    set release ""
  }

  bind $xfMenu "<${motion}B${xfButton}-Motion>"  "MenuPopupMotion $xfMenu %W %X %Y"
  bind $xfMenu "<${release}ButtonRelease-${xfButton}>"  "MenuPopupRelease $xfMenu %W"
  if {"$xfCanvasTag" == ""} {
    bind $xfW "<${press}ButtonPress-${xfButton}>"  "MenuPopupPost $xfMenu %X %Y"
    bind $xfW "<${release}ButtonRelease-${xfButton}>"  "MenuPopupRelease $xfMenu %W"
  } {
    $xfW bind $xfCanvasTag "<${press}ButtonPress-${xfButton}>"  "MenuPopupPost $xfMenu %X %Y"
    $xfW bind $xfCanvasTag "<${release}ButtonRelease-${xfButton}>"  "MenuPopupRelease $xfMenu %W"
  }
}
}


# Procedure: MenuPopupMotion
if {"[info procs MenuPopupMotion]" == ""} {
proc MenuPopupMotion { xfMenu xfW xfX xfY} {
# xf ignore me 7
##########
# Procedure: MenuPopupMotion
# Description: handle the popup menu motion
# Arguments: xfMenu - the topmost menu
#            xfW - the menu
#            xfX - the root x coordinate
#            xfY - the root x coordinate
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv

  if {"[info commands $xfW]" != "" && [winfo ismapped $xfW] &&
      "[winfo class $xfW]" == "Menu" &&
      [info exists tk_popupPriv($xfMenu,focus)] &&
      "$tk_popupPriv($xfMenu,focus)" != "" &&
      [info exists tk_popupPriv($xfMenu,grab)] &&
      "$tk_popupPriv($xfMenu,grab)" != ""} {
    set xfPopMinX [winfo rootx $xfW]
    set xfPopMaxX [expr $xfPopMinX+[winfo width $xfW]]
    if {$xfX >= $xfPopMinX && $xfX <= $xfPopMaxX} {
      $xfW activate @[expr $xfY-[winfo rooty $xfW]]
      if {![catch "$xfW entryconfig @[expr $xfY-[winfo rooty $xfW]] -menu" result]} {
        if {"[lindex $result 4]" != ""} {
          foreach binding [bind $xfMenu] {
            bind [lindex $result 4] $binding [bind $xfMenu $binding]
          }
        }
      }
    } {
      $xfW activate none
    }
  }
}
}


# Procedure: MenuPopupPost
if {"[info procs MenuPopupPost]" == ""} {
proc MenuPopupPost { xfMenu xfX xfY} {
# xf ignore me 7
##########
# Procedure: MenuPopupPost
# Description: post the popup menu
# Arguments: xfMenu - the menu
#            xfX - the root x coordinate
#            xfY - the root x coordinate
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv

  if {"[info commands $xfMenu]" != ""} {
    if {![info exists tk_popupPriv($xfMenu,focus)]} {
      set tk_popupPriv($xfMenu,focus) [focus]
    } {
      if {"$tk_popupPriv($xfMenu,focus)" == ""} {
        set tk_popupPriv($xfMenu,focus) [focus]
      }
    }
    set tk_popupPriv($xfMenu,grab) $xfMenu

    catch "$xfMenu activate none"
    catch "$xfMenu post $xfX $xfY"
    catch "focus $xfMenu"
    catch "grab -global $xfMenu"
  }
}
}


# Procedure: MenuPopupRelease
if {"[info procs MenuPopupRelease]" == ""} {
proc MenuPopupRelease { xfMenu xfW} {
# xf ignore me 7
##########
# Procedure: MenuPopupRelease
# Description: remove the popup menu
# Arguments: xfMenu - the topmost menu widget
#            xfW - the menu widget
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv
  global tkVersion

  if {"[info commands $xfW]" != "" && [winfo ismapped $xfW] &&
      "[winfo class $xfW]" == "Menu" &&
      [info exists tk_popupPriv($xfMenu,focus)] &&
      "$tk_popupPriv($xfMenu,focus)" != "" &&
      [info exists tk_popupPriv($xfMenu,grab)] &&
      "$tk_popupPriv($xfMenu,grab)" != ""} {
    if {$tkVersion >= 3.0} {
      catch "grab release $tk_popupPriv($xfMenu,grab)"
    } {
      catch "grab none"
    }
    catch "focus $tk_popupPriv($xfMenu,focus)"
    set tk_popupPriv($xfMenu,focus) ""
    set tk_popupPriv($xfMenu,grab) ""
    if {"[$xfW index active]" != "none"} {
      $xfW invoke active; catch "$xfMenu unpost"
    }
  }
  catch "$xfMenu unpost"
}
}


# Procedure: NoFunction
if {"[info procs NoFunction]" == ""} {
proc NoFunction { args} {
# xf ignore me 7
##########
# Procedure: NoFunction
# Description: do nothing (especially with scales and scrollbars)
# Arguments: args - a number of ignored parameters
# Returns: none
# Sideeffects: none
##########
}
}


# Procedure: SN
if {"[info procs SN]" == ""} {
proc SN { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SN
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  SymbolicName $xfName
}
}


# Procedure: SymbolicName
if {"[info procs SymbolicName]" == ""} {
proc SymbolicName { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SymbolicName
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  global symbolicName

  if {"$xfName" != ""} {
    set xfArrayName ""
    append xfArrayName symbolicName ( $xfName )
    if {![catch "set \"$xfArrayName\"" xfValue]} {
      return $xfValue
    } {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "Unknown symbolic name:\n$xfName"
      } {
        puts stderr "XF error: unknown symbolic name:\n$xfName"
      }
    }
  }
  return ""
}
}


# Procedure: Unalias
if {"[info procs Unalias]" == ""} {
proc Unalias { aliasName} {
# xf ignore me 7
##########
# Procedure: Unalias
# Description: remove an alias for a procedure
# Arguments: aliasName - the alias name to remove
# Returns: none
# Sideeffects: internalAliasList is updated, and the alias
#              proc is removed
##########
  global internalAliasList

  set xfIndex [lsearch $internalAliasList "$aliasName *"]
  if {$xfIndex != -1} {
    rename $aliasName ""
    set internalAliasList [lreplace $internalAliasList $xfIndex $xfIndex]
  }
}
}




# module inclusion
global env
global xfLoadPath
global xfLoadInfo
set xfLoadInfo 0
if {[info exists env(XF_LOAD_PATH)]} {
  if {[string first $env(XF_LOAD_PATH) /usr/local/lib/] == -1} {
    set xfLoadPath $env(XF_LOAD_PATH):/usr/local/lib/
  } {
    set xfLoadPath /usr/local/lib/
  }
} {
  set xfLoadPath /usr/local/lib/
}

global argc
global argv
global tkVersion
set tmpArgv ""
for {set counter 0} {$counter < $argc} {incr counter 1} {
  case [string tolower [lindex $argv $counter]] in {
    {-xfloadpath} {
      incr counter 1
      set xfLoadPath "[lindex $argv $counter]:$xfLoadPath"
    }
    {-xfstartup} {
      incr counter 1
      source [lindex $argv $counter]
    }
    {-xfbindfile} {
      incr counter 1
      set env(XF_BIND_FILE) "[lindex $argv $counter]"
    }
    {-xfcolorfile} {
      incr counter 1
      set env(XF_COLOR_FILE) "[lindex $argv $counter]"
    }
    {-xfcursorfile} {
      incr counter 1
      set env(XF_CURSOR_FILE) "[lindex $argv $counter]"
    }
    {-xffontfile} {
      incr counter 1
      set env(XF_FONT_FILE) "[lindex $argv $counter]"
    }
    {-xfmodelmono} {
      if {$tkVersion >= 3.0} {
        tk colormodel . monochrome
      }
    }
    {-xfmodelcolor} {
      if {$tkVersion >= 3.0} {
        tk colormodel . color
      }
    }
    {-xfloading} {
      set xfLoadInfo 1
    }
    {-xfnoloading} {
      set xfLoadInfo 0
    }
    {default} {
      lappend tmpArgv [lindex $argv $counter]
    }
  }
}
set argv $tmpArgv
set argc [llength $tmpArgv]
unset counter
unset tmpArgv



# procedure to show window .
proc ShowWindow. {args} {# xf ignore me 7

  # Window manager configurations
  global tkVersion
  wm positionfrom . user
  wm sizefrom . ""
  wm maxsize . 490 618
  wm minsize . 490 618
  wm title . {Address Manager}
  wm geometry . 489x618

  # bindings
  bind . <Button-3> {MenuPopupPost .frame26.menu28 %X %Y}
  bind . <ButtonRelease-3> {MenuPopupRelease .frame26.menu28 %W}

  # build widget .label0
  label .label0 \
    -relief {flat} \
    -text {Tel (Home)}

  # build widget .entry1
  entry .entry1 \
    -relief {sunken}
  bind .entry1 <Return> {focus .entry4; .entry4  icursor 0}
  bind .entry1 <Tab> {focus .entry4; .entry4  icursor 0}

  # build widget .label3
  label .label3 \
    -relief {flat} \
    -text {Name}

  # build widget .entry4
  entry .entry4 \
    -relief {sunken}
  bind .entry4 <Return> {focus .entry6; .entry6  icursor 0}
  bind .entry4 <Tab> {focus .entry6; .entry6  icursor 0}

  # build widget .label5
  label .label5 \
    -relief {flat} \
    -text {Tel (Work)}

  # build widget .entry6
  entry .entry6 \
    -relief {sunken}
  bind .entry6 <Return> {focus .entry5; .entry5  icursor 0}
  bind .entry6 <Tab> {focus .entry5; .entry5  icursor 0}

  # build widget .label1
  label .label1 \
    -relief {flat} \
    -text { ID}

  # build widget .entry5
  entry .entry5 \
    -relief {sunken}
  bind .entry5 <Return> {focus .entry8; .entry8  icursor 0}
  bind .entry5 <Tab> {focus .entry8; .entry8  icursor 0}

  # build widget .label7
  label .label7 \
    -relief {flat} \
    -text {Tel (Others)}

  # build widget .entry8
  entry .entry8 \
    -relief {sunken}
  bind .entry8 <Return> {focus .entry10; .entry10  icursor 0}
  bind .entry8 <Tab> {focus .entry10; .entry10  icursor 0}

  # build widget .label9
  label .label9 \
    -relief {flat} \
    -text {Fax}

  # build widget .entry10
  entry .entry10 \
    -relief {sunken}
  bind .entry10 <Return> {focus .entry12; .entry12  icursor 0}
  bind .entry10 <Tab> {focus .entry12; .entry12  icursor 0}

  # build widget .label11
  label .label11 \
    -relief {flat} \
    -text {Email}

  # build widget .entry12
  entry .entry12 \
    -relief {sunken}
  bind .entry12 <Return> {focus .entry14; .entry14  icursor 0}
  bind .entry12 <Tab> {focus .entry14; .entry14  icursor 0}

  # build widget .label13
  label .label13 \
    -relief {flat} \
    -text {Sex}

  # build widget .entry14
  entry .entry14 \
    -relief {sunken}
  bind .entry14 <Return> {focus .entry16; .entry16  icursor 0}
  bind .entry14 <Tab> {focus .entry16; .entry16  icursor 0}

  # build widget .label15
  label .label15 \
    -relief {flat} \
    -text {DOB}

  # build widget .entry16
  entry .entry16 \
    -relief {sunken}
  bind .entry16 <Return> {focus .entry18; .entry18  icursor 0}
  bind .entry16 <Tab> {focus .entry18; .entry18  icursor 0}

  # build widget .label17
  label .label17 \
    -relief {flat} \
    -text {Title}

  # build widget .entry18
  entry .entry18 \
    -relief {sunken}
  bind .entry18 <Return> {focus .entry20; .entry20  icursor 0}
  bind .entry18 <Tab> {focus .entry20; .entry20  icursor 0}

  # build widget .label19
  label .label19 \
    -relief {flat} \
    -text {Occupation}

  # build widget .entry20
  entry .entry20 \
    -relief {sunken}
  bind .entry20 <Return> {
    focus .frame21.frame.frame3.entry5
    .frame21.frame.frame3.entry5  icursor 0}
  bind .entry20 <Tab> {
    focus .frame21.frame.frame3.entry5
    .frame21.frame.frame3.entry5  icursor 0}


  # build widget .frame21
  frame .frame21 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .frame21.frame
  frame .frame21.frame

  # build widget .frame21.frame.scrollbar7
  scrollbar .frame21.frame.scrollbar7 \
    -command {.frame21.frame.frame3.entry5 view} \
    -orient {horizontal} \
    -relief {raised} \
    -width {11}

  # build widget .frame21.frame.frame3
  frame .frame21.frame.frame3

  # build widget .frame21.frame.frame3.entry5
  entry .frame21.frame.frame3.entry5 \
    -relief {sunken} \
    -scrollcommand {.frame21.frame.scrollbar7 set}
  bind .frame21.frame.frame3.entry5 <Return> {
     focus .frame25.frame.frame3.entry5
     .frame25.frame.frame3.entry5  icursor 0}
  bind .frame21.frame.frame3.entry5 <Tab> {
     focus .frame25.frame.frame3.entry5
     .frame25.frame.frame3.entry5  icursor 0}


  # build widget .frame21.frame.frame3.label4
  label .frame21.frame.frame3.label4 \
    -padx {2} \
    -relief {flat} \
    -text {Address}

  # pack widget .frame21.frame.frame3
  pack append .frame21.frame.frame3 \
    .frame21.frame.frame3.label4 {left frame center} \
    .frame21.frame.frame3.entry5 {top frame center expand fill}

  # pack widget .frame21.frame
  pack append .frame21.frame \
    .frame21.frame.frame3 {top frame center fillx} \
    .frame21.frame.scrollbar7 {top frame center fillx}

  # pack widget .frame21
  pack append .frame21 \
    .frame21.frame {top frame center fill}

  # build widget .frame23
  frame .frame23 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .frame23.frame
  frame .frame23.frame \
    -relief {raised}

  # build widget .frame23.frame.scrollbar1
  scrollbar .frame23.frame.scrollbar1 \
    -command {.frame23.frame.text2 yview} \
    -relief {raised}

  # build widget .frame23.frame.text2
  text .frame23.frame.text2 \
    -borderwidth {2} \
    -relief {raised} \
    -wrap {none} \
    -yscrollcommand {.frame23.frame.scrollbar1 set}

  # pack widget .frame23.frame
  pack append .frame23.frame \
    .frame23.frame.scrollbar1 {left frame center filly} \
    .frame23.frame.text2 {top frame center expand fill}

  # place
  place .frame23.frame.text2 -x 115 -y 521 -anchor nw


  # pack widget .frame23
  pack append .frame23 \
    .frame23.frame {top frame center fill}

  # build widget .label24
  label .label24 \
    -relief {flat} \
    -text {Comment:}

  # build widget .frame25
  frame .frame25 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .frame25.frame
  frame .frame25.frame

  # build widget .frame25.frame.scrollbar7
  scrollbar .frame25.frame.scrollbar7 \
    -command {.frame25.frame.frame3.entry5 view} \
    -orient {horizontal} \
    -relief {raised} \
    -width {11}

  # build widget .frame25.frame.frame3
  frame .frame25.frame.frame3

  # build widget .frame25.frame.frame3.entry5
  entry .frame25.frame.frame3.entry5 \
    -relief {sunken} \
    -scrollcommand {.frame25.frame.scrollbar7 set}
  bind .frame25.frame.frame3.entry5 <Return> { 
     focus .entry1
     .entry1  icursor 0}
  bind .frame25.frame.frame3.entry5 <Tab> { 
     focus .entry1
     .entry1  icursor 0}


  # build widget .frame25.frame.frame3.label4
  label .frame25.frame.frame3.label4 \
    -padx {2} \
    -relief {flat} \
    -text {Note}

  # pack widget .frame25.frame.frame3
  pack append .frame25.frame.frame3 \
    .frame25.frame.frame3.label4 {left frame center} \
    .frame25.frame.frame3.entry5 {top frame center expand fill}

  # pack widget .frame25.frame
  pack append .frame25.frame \
    .frame25.frame.frame3 {top frame center fillx} \
    .frame25.frame.scrollbar7 {top frame center fillx}

  # pack widget .frame25
  pack append .frame25 \
    .frame25.frame {top frame center fill}

  # build widget .frame26
  frame .frame26 \
    -borderwidth {2} \
    -relief {raised}
  # bindings
  bind .frame26 <Button-1> {MenuPopupPost .frame26.menu0 %X %Y}
  bind .frame26 <Button-2> {MenuPopupPost .frame26.menu29 %X %Y}
  bind .frame26 <Button-3> {MenuPopupPost .frame26.menu30 %X %Y}
#  bind .frame26 <ButtonRelease-1> {MenuPopupRelease .frame26.menu0 %W}
  bind .frame26 <ButtonRelease-2> {MenuPopupRelease .frame26.menu29 %W}
  bind .frame26 <ButtonRelease-3> {MenuPopupRelease .frame26.menu30 %W}

  # build widget .frame26.menubutton0
  menubutton .frame26.menubutton0 \
    -menu {.frame26.menubutton0.m} \
    -text {File} \
    -underline {0}

  # build widget .frame26.menubutton0.m
  global yesNoBox
  menu .frame26.menubutton0.m
  .frame26.menubutton0.m add command \
    -label {Load New Database} \
    -underline {0} \
    -command {global {fsBox(pattern)} {fsBox(name)}
      set {fsBox(pattern)} {*.db}
      if {$databaseSize > 0} {
        YesNoBox "The current database will not be saved automatically \
           to the disk. Do you really want to load in a new database?" \
           "500x200"
      }
      if { $yesNoBox(button) == 1 } {
        clearAllList
        newEntry ; # remove all the contents from all the entries
        set databaseSize 0
        set addressDB [FSBox]
        loadFile $addressDB
      } 
    }
  .frame26.menubutton0.m add command \
    -label {Merge} \
    -underline {0} \
    -command {global {fsBox(pattern)} {fsBox(name)}
      set {fsBox(pattern)} {*.db}
      YesNoBox "You will append a new database to the current one. \
                Do you want to continue?" \
           "500x200"
      if { $yesNoBox(button) == 1 } {
        set addressDB [FSBox]
        loadFile $addressDB
        viewRecord $crrntDBindex
      } 
    }
  .frame26.menubutton0.m add command \
    -label {Save} \
    -underline {0} \
    -command {saveAddressDB $addressDB 1
              addressManagerMessage "File was saved" 2}
  .frame26.menubutton0.m add command \
    -label {Save as New File ...} \
    -underline {1} \
    -command {ShowWindow.showSaveAsWin}
  .frame26.menubutton0.m add command \
    -label {Save as Print File ...} \
    -underline {8} \
    -command {ShowWindow.showSaveAsPrintWin}
  .frame26.menubutton0.m add command \
    -label {Sort} \
    -underline {3} \
    -command {sortDatabase
              if { [winfo exists .topViewAll ]} viewAll}
  .frame26.menubutton0.m add command \
    -label {Quit} \
    -command {ShowWindow.top0; grab .top0 } \
    -underline {0}

  # build widget .frame26.menubutton1
  menubutton .frame26.menubutton1 \
    -menu {.frame26.menubutton1.m} \
    -text {Edit} \
    -underline {0}

  # build widget .frame26.menubutton1.m
  menu .frame26.menubutton1.m
  .frame26.menubutton1.m add command \
    -accelerator {Ctrl+c} \
    -label {Copy} \
    -underline {0} \
    -command {copyEntry}
  .frame26.menubutton1.m add command \
    -accelerator {Ctrl+y} \
    -label {Paste   } \
    -underline {0} \
    -command {pasteEntry}
  .frame26.menubutton1.m add command \
    -accelerator {Ctrl+o} \
    -label {New Entry} \
    -underline {0} \
    -command {newEntry; set crrntDBindex $databaseSize}
  .frame26.menubutton1.m add command \
    -accelerator {Ctrl+s} \
    -label {Save Crrnt Entry } \
    -underline {0} \
    -command {writeNewEntry
              incr databaseSize
              addressManagerMessage "The current entry is saved " 3
              if { [winfo exists .topViewAll ]} viewAll}
  .frame26.menubutton1.m add command \
    -label {Delete Crrnt Entry } \
    -underline {0} \
    -command {deleteCrrntEntry
              addressManagerMessage "The current entry is deleted " 3
              tkwait window .addressManagerMessage
              set databaseSize [expr $databaseSize -1 ]
              set crrntDBindex [expr $crrntDBindex - 1]
              set n $crrntDBindex
              viewRecord $n 
              if { [winfo exists .topViewAll ]} {viewAll}}

  # build widget .frame26.menubutton2
  menubutton .frame26.menubutton2 \
    -menu {.frame26.menubutton2.m} \
    -text {View} \
    -underline {0}

  # build widget .frame26.menubutton2.m
  menu .frame26.menubutton2.m
  .frame26.menubutton2.m add command \
    -label {First  } \
    -accelerator {Escape <} \
    -underline {0} \
    -command { set n 0
        viewRecord $n  }
  .frame26.menubutton2.m add command \
    -label {Last } \
    -accelerator {Escape >} \
    -underline {0} \
    -command { set n [expr $databaseSize -1]
        viewRecord $n  }
  .frame26.menubutton2.m add command \
    -accelerator {Ctrl+p} \
    -label {Previous   } \
    -underline {0} \
    -command { set n [expr $crrntDBindex - 1]
        viewRecord $n  }

  .frame26.menubutton2.m add command \
    -accelerator {Ctrl+n} \
    -label {Next   } \
    -underline {0} \
    -command { set n [expr $crrntDBindex +1]
        viewRecord $n
     }
  .frame26.menubutton2.m add command \
    -label {All } \
    -underline {0} \
    -command {viewAll}

  # build widget .frame26.button3
  button .frame26.button3 \
      -text {Search} \
      -relief {flat} \
      -command { ShowWindow.topSearch }

  # pack widget .frame26
  pack append .frame26 \
    .frame26.menubutton0 {top frame center}

  # place
  place .frame26.button3 -x 129 -y 5 -anchor nw

  # place
  place .frame26.menubutton2 -x 83 -y 5 -anchor nw

  # place
  place .frame26.menubutton1 -x 44 -y 5 -anchor nw

  # place
  place .frame26.menubutton0 -x 3 -y 5 -width 39 -anchor nw


  # place
  place .entry6 -x 87 -y 96 -width 139 -anchor nw

  # place
  place .label5 -x 2 -y 94 -anchor nw

  # place
  place .entry4 -x 154 -y 52 -width 234 -anchor nw

  # place
  place .label3 -x 104 -y 51 -anchor nw

  # place
  place .entry1 -x 30 -y 53 -width 47 -height 24 -anchor nw

  # place
  place .label0 -x 240 -y 95 -anchor nw

  # place
  place .label1 -x 2 -y 52 -anchor nw

  # place
  place .entry5 -x 333 -y 96 -width 152 -anchor nw

  # place
  place .label7 -x 2 -y 126 -anchor nw

  # place
  place .entry8 -x 102 -y 128 -anchor nw

  # place
  place .label9 -x 299 -y 126 -anchor nw

  # place
  place .entry10 -x 332 -y 127 -width 153 -anchor nw

  # place
  place .label11 -x 3 -y 172 -anchor nw

  # place
  place .entry12 -x 50 -y 173 -width 436 -anchor nw

  # place
  place .label13 -x 2 -y 218 -anchor nw

  # place
  place .entry14 -x 38 -y 219 -width 24 -anchor nw

  # place
  place .label15 -x 86 -y 219 -anchor nw

  # place
  place .entry16 -x 127 -y 220 -width 164 -anchor nw

  # place
  place .label17 -x 304 -y 219 -anchor nw

  # place
  place .entry18 -x 343 -y 220 -width 142 -anchor nw

  # place
  place .label19 -x 2 -y 253 -anchor nw

  # place
  place .entry20 -x 96 -y 254 -width 389 -anchor nw

  # place
  place .frame21 -x 1 -y 299 -width 486 -height 43 -anchor nw

  # place
  place .frame23 -x -6 -y 435 -width 494 -height 183 -anchor nw

  # place
  place .label24 -x -2 -y 409 -anchor nw

  # place
  place .frame25 -x 1 -y 360 -width 488 -height 48 -anchor nw

  # place
  place .frame26 -x 1 -y 1 -width 487 -height 37 -anchor nw


  global tkVersion
  if {$tkVersion >= 3.0} {
    tk_menuBar .frame26 .frame26.menubutton0 .frame26.menubutton1 .frame26.menubutton2 
  } {
    tk_menus . .frame26.menubutton0 .frame26.menubutton1 .frame26.menubutton2 }


  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree ."
    after 2 "catch {XFEditSetShowWindows}"
  }
}


# User defined procedures


# Internal procedures


# Procedure: Alias
if {"[info procs Alias]" == ""} {
proc Alias { args} {
# xf ignore me 7
##########
# Procedure: Alias
# Description: establish an alias for a procedure
# Arguments: args - no argument means that a list of all aliases
#                   is returned. Otherwise the first parameter is
#                   the alias name, and the second parameter is
#                   the procedure that is aliased.
# Returns: nothing, the command that is bound to the alias or a
#          list of all aliases - command pairs. 
# Sideeffects: internalAliasList is updated, and the alias
#              proc is inserted
##########
  global internalAliasList

  if {[llength $args] == 0} {
    return $internalAliasList
  } {
    if {[llength $args] == 1} {
      set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
      if {$xfTmpIndex != -1} {
        return [lindex [lindex $internalAliasList $xfTmpIndex] 1]
      }
    } {
      if {[llength $args] == 2} {
        eval "proc [lindex $args 0] {args} {#xf ignore me 4
return \[eval \"[lindex $args 1] \$args\"\]}"
        set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
        if {$xfTmpIndex != -1} {
          set internalAliasList [lreplace $internalAliasList $xfTmpIndex $xfTmpIndex "[lindex $args 0] [lindex $args 1]"]
        } {
          lappend internalAliasList "[lindex $args 0] [lindex $args 1]"
        }
      } {
        error "Alias: wrong number or args: $args"
      }
    }
  }
}
}


# Procedure: GetSelection
if {"[info procs GetSelection]" == ""} {
proc GetSelection {} {
# xf ignore me 7
##########
# Procedure: GetSelection
# Description: get current selection
# Arguments: none
# Returns: none
# Sideeffects: none
##########

  # the save way
  set xfSelection ""
  catch "selection get" xfSelection
  if {"$xfSelection" == "selection doesn't exist or form \"STRING\" not defined"} {
    return ""
  } {
    return $xfSelection
  }
}
}


# Procedure: MenuPopupAdd
if {"[info procs MenuPopupAdd]" == ""} {
proc MenuPopupAdd { xfW xfButton xfMenu {xfModifier ""} {xfCanvasTag ""}} {
# xf ignore me 7
# the popup menu handling is from (I already gave up with popup handling :-):
#
# Copyright 1991,1992 by James Noble.
# Everyone is granted permission to copy, modify and redistribute.
# This notice must be preserved on all copies or derivates.
#
##########
# Procedure: MenuPopupAdd
# Description: attach a popup menu to widget
# Arguments: xfW - the widget
#            xfButton - the button we use
#            xfMenu - the menu to attach
#            {xfModifier} - a optional modifier
#            {xfCanvasTag} - a canvas tagOrId
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv

  set tk_popupPriv($xfMenu,focus) ""
  set tk_popupPriv($xfMenu,grab) ""
  if {"$xfModifier" != ""} {
    set press "$xfModifier-"
    set motion "$xfModifier-"
    set release "Any-"
  } {
    set press ""
    set motion ""
    set release ""
  }

  bind $xfMenu "<${motion}B${xfButton}-Motion>"  "MenuPopupMotion $xfMenu %W %X %Y"
  bind $xfMenu "<${release}ButtonRelease-${xfButton}>"  "MenuPopupRelease $xfMenu %W"
  if {"$xfCanvasTag" == ""} {
    bind $xfW "<${press}ButtonPress-${xfButton}>"  "MenuPopupPost $xfMenu %X %Y"
    bind $xfW "<${release}ButtonRelease-${xfButton}>"  "MenuPopupRelease $xfMenu %W"
  } {
    $xfW bind $xfCanvasTag "<${press}ButtonPress-${xfButton}>"  "MenuPopupPost $xfMenu %X %Y"
    $xfW bind $xfCanvasTag "<${release}ButtonRelease-${xfButton}>"  "MenuPopupRelease $xfMenu %W"
  }
}
}


# Procedure: MenuPopupMotion
if {"[info procs MenuPopupMotion]" == ""} {
proc MenuPopupMotion { xfMenu xfW xfX xfY} {
# xf ignore me 7
##########
# Procedure: MenuPopupMotion
# Description: handle the popup menu motion
# Arguments: xfMenu - the topmost menu
#            xfW - the menu
#            xfX - the root x coordinate
#            xfY - the root x coordinate
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv

  if {"[info commands $xfW]" != "" && [winfo ismapped $xfW] &&
      "[winfo class $xfW]" == "Menu" &&
      [info exists tk_popupPriv($xfMenu,focus)] &&
      "$tk_popupPriv($xfMenu,focus)" != "" &&
      [info exists tk_popupPriv($xfMenu,grab)] &&
      "$tk_popupPriv($xfMenu,grab)" != ""} {
    set xfPopMinX [winfo rootx $xfW]
    set xfPopMaxX [expr $xfPopMinX+[winfo width $xfW]]
    if {$xfX >= $xfPopMinX && $xfX <= $xfPopMaxX} {
      $xfW activate @[expr $xfY-[winfo rooty $xfW]]
      if {![catch "$xfW entryconfig @[expr $xfY-[winfo rooty $xfW]] -menu" result]} {
        if {"[lindex $result 4]" != ""} {
          foreach binding [bind $xfMenu] {
            bind [lindex $result 4] $binding [bind $xfMenu $binding]
          }
        }
      }
    } {
      $xfW activate none
    }
  }
}
}


# Procedure: MenuPopupPost
if {"[info procs MenuPopupPost]" == ""} {
proc MenuPopupPost { xfMenu xfX xfY} {
# xf ignore me 7
##########
# Procedure: MenuPopupPost
# Description: post the popup menu
# Arguments: xfMenu - the menu
#            xfX - the root x coordinate
#            xfY - the root x coordinate
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv

  if {"[info commands $xfMenu]" != ""} {
    if {![info exists tk_popupPriv($xfMenu,focus)]} {
      set tk_popupPriv($xfMenu,focus) [focus]
    } {
      if {"$tk_popupPriv($xfMenu,focus)" == ""} {
        set tk_popupPriv($xfMenu,focus) [focus]
      }
    }
    set tk_popupPriv($xfMenu,grab) $xfMenu

    catch "$xfMenu activate none"
    catch "$xfMenu post $xfX $xfY"
    catch "focus $xfMenu"
    catch "grab -global $xfMenu"
  }
}
}


# Procedure: MenuPopupRelease
if {"[info procs MenuPopupRelease]" == ""} {
proc MenuPopupRelease { xfMenu xfW} {
# xf ignore me 7
##########
# Procedure: MenuPopupRelease
# Description: remove the popup menu
# Arguments: xfMenu - the topmost menu widget
#            xfW - the menu widget
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv
  global tkVersion

  if {"[info commands $xfW]" != "" && [winfo ismapped $xfW] &&
      "[winfo class $xfW]" == "Menu" &&
      [info exists tk_popupPriv($xfMenu,focus)] &&
      "$tk_popupPriv($xfMenu,focus)" != "" &&
      [info exists tk_popupPriv($xfMenu,grab)] &&
      "$tk_popupPriv($xfMenu,grab)" != ""} {
    if {$tkVersion >= 3.0} {
      catch "grab release $tk_popupPriv($xfMenu,grab)"
    } {
      catch "grab none"
    }
    catch "focus $tk_popupPriv($xfMenu,focus)"
    set tk_popupPriv($xfMenu,focus) ""
    set tk_popupPriv($xfMenu,grab) ""
    if {"[$xfW index active]" != "none"} {
      $xfW invoke active; catch "$xfMenu unpost"
    }
  }
  catch "$xfMenu unpost"
}
}


# Procedure: NoFunction
if {"[info procs NoFunction]" == ""} {
proc NoFunction { args} {
# xf ignore me 7
##########
# Procedure: NoFunction
# Description: do nothing (especially with scales and scrollbars)
# Arguments: args - a number of ignored parameters
# Returns: none
# Sideeffects: none
##########
}
}


# Procedure: SN
if {"[info procs SN]" == ""} {
proc SN { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SN
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  SymbolicName $xfName
}
}


# Procedure: SymbolicName
if {"[info procs SymbolicName]" == ""} {
proc SymbolicName { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SymbolicName
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  global symbolicName

  if {"$xfName" != ""} {
    set xfArrayName ""
    append xfArrayName symbolicName ( $xfName )
    if {![catch "set \"$xfArrayName\"" xfValue]} {
      return $xfValue
    } {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "Unknown symbolic name:\n$xfName"
      } {
        puts stderr "XF error: unknown symbolic name:\n$xfName"
      }
    }
  }
  return ""
}
}


# Procedure: Unalias
if {"[info procs Unalias]" == ""} {
proc Unalias { aliasName} {
# xf ignore me 7
##########
# Procedure: Unalias
# Description: remove an alias for a procedure
# Arguments: aliasName - the alias name to remove
# Returns: none
# Sideeffects: internalAliasList is updated, and the alias
#              proc is removed
##########
  global internalAliasList

  set xfIndex [lsearch $internalAliasList "$aliasName *"]
  if {$xfIndex != -1} {
    rename $aliasName ""
    set internalAliasList [lreplace $internalAliasList $xfIndex $xfIndex]
  }
}
}



# application parsing procedure
proc XFLocalParseAppDefs {xfAppDefFile} {
  global xfAppDefaults

  # basically from: Michael Moore
  if {[file exists $xfAppDefFile] &&
      [file readable $xfAppDefFile] &&
      "[file type $xfAppDefFile]" == "link"} {
    catch "file type $xfAppDefFile" xfType
    while {"$xfType" == "link"} {
      if {[catch "file readlink $xfAppDefFile" xfAppDefFile]} {
        return
      }
      catch "file type $xfAppDefFile" xfType
    }
  }
  if {!("$xfAppDefFile" != "" &&
        [file exists $xfAppDefFile] &&
        [file readable $xfAppDefFile] &&
        "[file type $xfAppDefFile]" == "file")} {
    return
  }
  if {![catch "open $xfAppDefFile r" xfResult]} {
    set xfAppFileContents [read $xfResult]
    close $xfResult
    foreach line [split $xfAppFileContents "\n"] {
      # backup indicates how far to backup.  It applies to the
      # situation where a resource name ends in . and when it
      # ends in *.  In the second case you want to keep the *
      # in the widget name for pattern matching, but you want
      # to get rid of the . if it is the end of the name. 
      set backup -2  
      set line [string trim $line]
      if {[string index $line 0] == "#" || "$line" == ""} {
        # skip comments and empty lines
        continue
      }
      set list [split $line ":"]
      set resource [string trim [lindex $list 0]]
      set i [string last "." $resource]
      set j [string last "*" $resource]
      if {$j > $i} { 
        set i $j
        set backup -1
      }
      incr i
      set name [string range $resource $i end]
      incr i $backup
      set widname [string range $resource 0 $i]
      set value [string trim [lindex $list 1]]
      if {"$widname" != "" && "$widname" != "*"} {
        # insert the widget and resourcename to the application
        # defaults list.
        if {![info exists xfAppDefaults]} {
          set xfAppDefaults ""
        }
        lappend xfAppDefaults [list $widname [string tolower $name] $value]
      }
    }
  }
}

# application loading procedure
proc XFLocalLoadAppDefs {{xfClasses ""} {xfPriority "startupFile"} {xfAppDefFile ""}} {
  global env

  if {"$xfAppDefFile" == ""} {
    set xfFileList ""
    if {[info exists env(XUSERFILESEARCHPATH)]} {
      append xfFileList [split $env(XUSERFILESEARCHPATH) :]
    }
    if {[info exists env(XAPPLRESDIR)]} {
      append xfFileList [split $env(XAPPLRESDIR) :]
    }
    if {[info exists env(XFILESEARCHPATH)]} {
      append xfFileList [split $env(XFILESEARCHPATH) :]
    }
    append xfFileList " /usr/lib/X11/app-defaults"
    append xfFileList " /usr/X11/lib/X11/app-defaults"

    foreach xfCounter1 $xfClasses {
      foreach xfCounter2 $xfFileList {
        set xfPathName $xfCounter2
        if {[regsub -all "%N" "$xfPathName" "$xfCounter1" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%T" "$xfPathName" "app-defaults" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%S" "$xfPathName" "" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%C" "$xfPathName" "" xfResult]} {
          set xfPathName $xfResult
        }
        if {[file exists $xfPathName] &&
            [file readable $xfPathName] &&
            ("[file type $xfPathName]" == "file" ||
             "[file type $xfPathName]" == "link")} {
          catch "option readfile $xfPathName $xfPriority"
          if {"[info commands XFParseAppDefs]" != ""} {
            XFParseAppDefs $xfPathName
          } {
            if {"[info commands XFLocalParseAppDefs]" != ""} {
              XFLocalParseAppDefs $xfPathName
            }
          }
        } {
          if {[file exists $xfCounter2/$xfCounter1] &&
              [file readable $xfCounter2/$xfCounter1] &&
              ("[file type $xfCounter2/$xfCounter1]" == "file" ||
               "[file type $xfCounter2/$xfCounter1]" == "link")} {
            catch "option readfile $xfCounter2/$xfCounter1 $xfPriority"
            if {"[info commands XFParseAppDefs]" != ""} {
              XFParseAppDefs $xfCounter2/$xfCounter1
            } {
              if {"[info commands XFLocalParseAppDefs]" != ""} {
                XFLocalParseAppDefs $xfCounter2/$xfCounter1
              }
            }
          }
        }
      }
    }
  } {
    # load a specific application defaults file
    if {[file exists $xfAppDefFile] &&
        [file readable $xfAppDefFile] &&
        ("[file type $xfAppDefFile]" == "file" ||
         "[file type $xfAppDefFile]" == "link")} {
      catch "option readfile $xfAppDefFile $xfPriority"
      if {"[info commands XFParseAppDefs]" != ""} {
        XFParseAppDefs $xfAppDefFile
      } {
        if {"[info commands XFLocalParseAppDefs]" != ""} {
          XFLocalParseAppDefs $xfAppDefFile
        }
      }
    }
  }
}

# application setting procedure
proc XFLocalSetAppDefs {{xfWidgetPath "."}} {
  global xfAppDefaults

  if {![info exists xfAppDefaults]} {
    return
  }
  foreach xfCounter $xfAppDefaults {
    if {"$xfCounter" == ""} {
      break
    }
    set widname [lindex $xfCounter 0]
    if {[string match $widname ${xfWidgetPath}] ||
        [string match "${xfWidgetPath}*" $widname]} {
      set name [string tolower [lindex $xfCounter 1]]
      set value [lindex $xfCounter 2]
      # Now lets see how many tcl commands match the name
      # pattern specified.
      set widlist [info command $widname]
      if {"$widlist" != ""} {
        foreach widget $widlist {
          # make sure this command is a widget.
          if {![catch "winfo id $widget"] &&
              [string match "${xfWidgetPath}*" $widget]} {
            catch "$widget configure -$name $value" 
          }
        }
      }
    }
  }
}


# prepare auto loading
global auto_path
global tk_library
global xfLoadPath
foreach xfElement [eval list [split $xfLoadPath :] $auto_path] {
  if {[file exists $xfElement/tclIndex]} {
    lappend auto_path $xfElement
  }
}
catch "unset auto_index"

catch "unset auto_oldpath"

catch "unset auto_execs"


# initialize global variables
proc InitGlobals {} {

  # please don't modify the following
  # variables. They are needed by xf.
  global {autoLoadList}
  set {autoLoadList(addressManager1.tcl)} {0}
  global {internalAliasList}
  set {internalAliasList} {}
  global {moduleList}
  set {moduleList(addressManager1.tcl)} {}
  global {preloadList}
  set {preloadList(xfInternal)} {}
  global {symbolicName}
  set {symbolicName(root)} {.}
  global {xfWmSetPosition}
  set {xfWmSetPosition} {}
  global {xfWmSetSize}
  set {xfWmSetSize} {}
  global {xfAppDefToplevels}
  set {xfAppDefToplevels} {}
}

# initialize global variables
InitGlobals

# display/remove toplevel windows.
ShowWindow.

# load default bindings.
if {[info exists env(XF_BIND_FILE)] &&
    "[info procs XFShowHelp]" == ""} {
  source $env(XF_BIND_FILE)
}

# parse and apply application defaults.
XFLocalLoadAppDefs AddressManager1
XFLocalSetAppDefs

#source /data/users/ding/TclTk/addressManager/YesNoBox.pro

# To initialize addressManager1
addressManager1Init 


# eof
#

