global num_images images
if {![info exists num_images]} {set num_images 0}
global Menu_string
source  $env(GUI_BUILDER)/common.tcl
source  $env(GUI_BUILDER)/extensions.tcl
set align_list ""
wm withdraw .
global Topgeom Toppos
catch "destroy .colors"
#- TOP LEVEL -----------------------------------------
toplevel .colors -background gray80
wm title .colors {colors}
wm minsize .colors 1 1
set Toppos(.colors) 0
set Topgeom(.colors) 0

set Name .colors
set Parent $Name

set Name $Parent.f14
#------------------------------------------
frame $Name -background gray80 -borderwidth 2 -height 50 -relief raised -width 50
pack $Name -anchor center -expand 0 -fill x -ipadx 0 -ipady 0 -padx 0 -pady 0 -side bottom

set Name $Parent.f14.f26
#------------------------------------------
frame $Name -background gray80 -height 96 -relief raised -width 128
pack $Name -anchor center -expand 0 -fill y -ipadx 0 -ipady 0 -padx 0 -pady 0 -side right

set Name $Parent.f14.f26.b21
#------------------------------------------
radiobutton $Name -anchor w -background gray80 -command apply_color -foreground gray10 -relief raised -text HighlightFG -value highlightcolor -variable color_res -width 12
pack $Name -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 -side bottom

set Name $Parent.f14.f26.b24
#------------------------------------------
radiobutton $Name -anchor w -background gray80 -command apply_color -foreground gray10 -relief raised -text HighlightBG -value highlightbackground -variable color_res -width 12
pack $Name -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 -side bottom

set Name $Parent.f14.f26.b22
#------------------------------------------
radiobutton $Name -anchor w -background gray80 -command apply_color -foreground gray10 -relief raised -text Trough -value troughcolor -variable color_res -width 12
pack $Name -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 -side bottom

set Name $Parent.f14.f26.b43
#------------------------------------------
radiobutton $Name -anchor w -background gray80 -command apply_color -foreground gray10 -relief raised -text SelectBG -value selectbackground -variable color_res -width 12
pack $Name -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 -side bottom

set Name $Parent.f14.f26.b44
#------------------------------------------
radiobutton $Name -anchor w -background gray80 -command apply_color -foreground gray10 -relief raised -text SelectFG -value selectforeground -variable color_res -width 12
pack $Name -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 -side bottom

set Name $Parent.f14.f27
#------------------------------------------
frame $Name -background gray80 -height 50 -relief raised -width 50
pack $Name -anchor center -expand 0 -fill y -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left

set Name $Parent.f14.f27.b17
#------------------------------------------
radiobutton $Name -anchor w -background gray80 -command apply_color -foreground gray10 -relief raised -text Insert -value insertbackground -variable color_res -width 12
pack $Name -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 -side bottom

set Name $Parent.f14.f27.b20
#------------------------------------------
radiobutton $Name -anchor w -background gray80 -command apply_color -foreground gray10 -relief raised -text ActiveBG -value activebackground -variable color_res -width 12
pack $Name -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 -side bottom

set Name $Parent.f14.f27.b19
#------------------------------------------
radiobutton $Name -anchor w -background gray80 -command apply_color -foreground gray10 -relief raised -text ActiveFG -value activeforeground -variable color_res -width 12
pack $Name -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 -side bottom

set Name $Parent.f14.f27.b18
#------------------------------------------
radiobutton $Name -anchor w -background gray80 -command apply_color -foreground gray10 -relief raised -text Background -value background -variable color_res -width 12
pack $Name -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 -side bottom

set Name $Parent.f14.f27.b45
#------------------------------------------
radiobutton $Name -anchor w -background gray80 -command apply_color -foreground gray10 -relief raised -text Foreground -value foreground -variable color_res -width 12
pack $Name -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 -side bottom
global Procs
set Procs($Name) {apply_color}
proc apply_color {} {
  global current color_res
  catch ".colors.f11 config -back \[$current cget -$color_res\]"
  set rgb [winfo rgb . [.colors.f11 cget -back]]
  set r [expr [lindex $rgb 0]/256]
  set g [expr [lindex $rgb 1]/256]
  set b [expr [lindex $rgb 2]/256]
  .colors.f6.s3 set $r
  .colors.f6.s4 set $g
  .colors.f6.s2 set $b
}

set Name $Parent.f14.f47
#------------------------------------------
frame $Name -background gray80 -height 80 -relief raised -width 88
pack $Name -anchor center -expand 1 -fill both -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top

set Name $Parent.f14.f47.b51
#------------------------------------------
button $Name -background gray80 -command make_default -foreground gray10 -text {Make Default}
pack $Name -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top
global Procs
set Procs($Name) {make_default}
proc make_default {} {
  global color_res Defaults
  set Defaults($color_res) [.colors.f11 cget -back]
}

set Name $Parent.f14.f47.b53
#------------------------------------------
button $Name -background gray80 -command {wm withdraw .colors} -foreground gray10 -text Done
pack $Name -anchor center -expand 0 -fill x -ipadx 0 -ipady 0 -padx 0 -pady 0 -side bottom

set Name $Parent.f6
#------------------------------------------
frame $Name -background gray80 -borderwidth 2 -height 50 -relief raised -width 50
pack $Name -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left

set Name $Parent.f6.s3
#------------------------------------------
scale $Name -activebackground yellow -background red2 -command {set_rgb .colors.f11 red} -digits 1 -foreground white -length 200 -orient horizontal -relief sunken -resolution 0.1 -to 255.0 -troughcolor red
pack $Name -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top
global Procs
set Procs($Name) {set_rgb}
proc set_rgb {w col val} {
  global current color_res
  set rgb [winfo rgb . [get_widget_value $w background]]
  set r [format "%x" [expr [lindex $rgb 0]/256]]
  set g [format "%x" [expr [lindex $rgb 1]/256]]
  set b [format "%x" [expr [lindex $rgb 2]/256]]
  set val [format "%x" $val]
  if {[string length $val]==1} {set val 0$val}
  if {[string length $r]==1} {set r 0$r}
  if {[string length $g]==1} {set g 0$g}
  if {[string length $b]==1} {set b 0$b}
  if {$col == "red"} {
    set rgb #$val$g$b
  } elseif {$col == "green"} {
    set rgb #$r$val$b
  } elseif {$col == "blue"} {
    set rgb #$r$g$val
  }
  $w config -back $rgb
  catch "$current config -$color_res $rgb"
}

set Name $Parent.f6.s4
#------------------------------------------
scale $Name -activebackground yellow -background #00ff00 -command {set_rgb .colors.f11 green} -digits 1 -foreground white -length 200 -orient horizontal -relief sunken -resolution 0.1 -to 255.0 -troughcolor green
pack $Name -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top

set Name $Parent.f6.s2
#------------------------------------------
scale $Name -activebackground yellow -background blue -command {set_rgb .colors.f11 blue} -digits 1 -foreground white -length 200 -orient horizontal -relief sunken -resolution 0.1 -to 255.0 -troughcolor blue
pack $Name -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top

set Name $Parent.f11
#------------------------------------------
frame $Name -background #000000 -borderwidth 2 -height 96 -relief raised -width 136
pack $Name -anchor center -expand 1 -fill both -ipadx 0 -ipady 0 -padx 0 -pady 0 -side right
