#==============================================================================
#                                  vwfs.tcl
#------------------------------------------------------------------------------
# Defines the VW front side panel surface.
#
# Copyright (c) Evans & Sutherland - ok to distribute if copyright appears.
#------------------------------------------------------------------------------
# $Id: vwfs.tcl,v 4.0 1993/11/27 21:25:37 markd Rel $
#==============================================================================

proc SippVWFrontSide {side shader} {

    set pnt(1)  {17.875  -53.500   31.375}
    set pnt(2)  {21.250  -43.250   31.375}
    set pnt(3)  {20.250  -44.250   33.500}
    set pnt(4)  {20.500  -44.500   32.500}
    set pnt(5)  {21.000  -39.250   34.000}
    set pnt(6)  {21.750  -40.500   33.000}
    set pnt(7)  {22.500  -38.750   29.375}
    set pnt(8)  {23.500  -33.000   33.500}
    set pnt(9)  {23.000  -28.500   36.500}
    set pnt(10) {24.250  -29.500   33.500}
    set pnt(11) {24.500  -30.500   28.000}
    set pnt(12) {23.750  -24.500   35.500}
    set pnt(13) {25.500  -24.650   34.000}
    set pnt(14) {25.000  -24.750   28.000}
    set pnt(15) {24.750  -24.400   19.750}
    set pnt(16) {24.500  -28.250   17.375}
    set pnt(17) {24.250  -24.500   11.500}
    set pnt(18) {23.500  -34.625   26.250}
    set pnt(19) {24.125  -30.750   22.250}
    set pnt(20) {22.500  -30.000   35.750}
    set pnt(21) {24.750  -26.750   12.750}
    set pnt(22) {24.375  -26.125   10.750}

    SippVW:DefPoly $side pnt { 4  1  2}
    SippVW:DefPoly $side pnt {12  9 10 13}
    SippVW:DefPoly $side pnt {13 10 11 14}
    SippVW:DefPoly $side pnt {14 11 19 15}
    SippVW:DefPoly $side pnt {15 19 16}
    SippVW:DefPoly $side pnt {15 16 21 22 17}
    SippVW:DefPoly $side pnt { 9 20  8 10}
    SippVW:DefPoly $side pnt {20  5  6  8}
    SippVW:DefPoly $side pnt { 5  3  4  6}
    SippVW:DefPoly $side pnt { 3  1  4}
    SippVW:DefPoly $side pnt {10  8 18 11}
    SippVW:DefPoly $side pnt {11 18 19}
    SippVW:DefPoly $side pnt { 8  7 18}
    SippVW:DefPoly $side pnt { 8  6  4  7}
    SippVW:DefPoly $side pnt { 7  4  2}

    SippSurfaceCreate $shader
}
