'\"
'\" Copyright 1992 The Australian National University.
'\"
'\" Permission to use, copy, modify, and distribute this documentation
'\" is hereby granted, provided that the above copyright
'\" notice appears in all copies.  This software is provided without any
'\" warranty, express or implied. The Australian National University
'\" makes no representations about the suitability of this software for
'\" any purpose.
'\"
'\" Author: Paul Mackerras (paulus@cs.anu.edu.au)
'\"
'\" $Header: /u/markd/graphics/sipp/tclsipp/man/RCS/photo.n,v 4.0 1993/11/27 21:28:13 markd Rel $
'\"
.\" The definitions below are for supplemental macros used in Tcl/Tk
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'       .TH \\$1 1 \\*(^3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\*(^3 \\$4
.if '\\$2'tcl'        .TH \\$1 n \\*(^3 Tcl "Tcl Built-In Commands"
.if '\\$2'tk'         .TH \\$1 n \\*(^3 Tk "Tk Commands"
.if '\\$2'tclc'        .TH \\$1 3 \\*(^3 Tcl "Tcl Library Procedures"
.if '\\$2'tkc'         .TH \\$1 3 \\*(^3 Tk "Tk Library Procedures"
.if '\\$2'tclcmds'         .TH \\$1 1 \\*(^3 Tk "Tcl Applications"
.if '\\$2'tkcmds'         .TH \\$1 1 \\*(^3 Tk "Tk Applications"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS photo tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
'
'\"@help: tsipp/tk/photo
'\"@brief: Create and manipulate photo widgets.
.SH NAME
photo \- Create and manipulate photo widgets
.SH SYNOPSIS
\fBphoto\fI \fIpathName \fR?\fB-visual \fIvisual\fR? ?\fIoptions\fR?
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBcursor	\fBpadx\fR	\fBxScrollCommand\fR
\fBgeometry\fR	\fBpady\fR	\fByScrollCommand\fR

.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c
.LP
.nf
Name:	\fBblank\fR
Class:	\fBBlank\fR
Command-Line Switch:	\fB\-blank\fR
.fi
.IP
Specifies the color for blank areas of the image (those which have not
had image data written to them).  Defaults to black.
.LP
.nf
Name:	\fBditherLevel\fR
Class:	\fBDitherLevel\fR
Command-Line Switch:	\fB\-ditherlevel\fR
.fi
.IP
Specifies how and when the image is to be dithered for display.  Its
value is an integer between 0 and 2; 0 specifies no dithering, 1
allows dithering on request, and 2 specifies that each block of the
image should be dithered as it is displayed.  Default is 0 for TrueColor
and DirectColor displays and 2 for other types.
.LP
.nf
Name:	\fBimageSize\fR
Class:	\fBGeometry\fR
Command-Line Switch:	\fB\-imagesize\fR
.fi
.IP
Specifies how much pixel area to allocate for the complete image, as a
string in the form \fIwidth\fBx\fIheight\fR.  This may be larger than
the size of the photo widget window.
.LP
.nf
Name:	\fBgamma\fR
Class:	\fBGamma\fR
Command-Line Switch:	\fB\-gamma\fR
.fi
.IP
Specifies that the photo widget should correct for a non-linear
display with the given gamma value.  (The intensity produced by most
CRT displays is a power function of the input value (to a good
approximation); gamma is the exponent and is typically around 2).  The
default value is 1.
.LP
.nf
Name:	\fBpalette\fR
Class:	\fBPalette\fR
Command-Line Switch:	\fB\-palette\fR
.fi
.IP
Specifies how many colors to allocate for the photo widget window.
The value of this option is either a single number \fIngray\fR or
three numbers separated by slashes in the form
\fInred\fB/\fIngreen\fB/\fInblue\fR.  The first form specifies
monochrome display of the image using \fIngray\fR shades of gray.  The
second form specifies color display using \fInred\fR shades of red,
\fIngreen\fR shades of green, and \fInblue\fR shades of blue.  The
default depends on the visual chosen for the window (see below).
.LP
.nf
Name:	\fBscanSpeed\fR
Class:	\fBscanSpeed\fR
Command-Line Switch:	\fB\-scanspeed\fR
.fi
.IP
Specifies how fast the image is moved when scanning (see the \fBscan
mark\fR and \fBscan dragto\fR commands).  The mouse motion is
multiplied by the value of this option to get the image motion.  The
default value is 10, but lower values are often appropriate.
.BE

.SH DESCRIPTION
.PP
The \fBphoto\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a photo widget.
Additional options, described above, may be specified on the
command line or in the option database
to configure aspects of the photo.  The \fBphoto\fR command returns its
\fIpathName\fR argument.  At the time this command is invoked,
there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
A photo is a widget that displays an image.  The image is supplied to
the photo widget in 24 bits per pixel format; the photo widget takes
care of the details of displaying the image on whatever kind of
display is available.  The photo widget's window may be smaller than
the image, in which case the image may be scrolled around within the window.
The photo widget has the necessary hooks for communicating with two
scrollbars, one each for the X and Y dimensions of the image; in
addition, the mouse can be used to scan by dragging the image around
within the window.
.PP
Usually, an X server will make several X visuals (i.e., ways of
representing and displaying color) available on each screen.
Normally, the photo widget chooses the best visual for image display
from those which the X server provides for the screen which the
photo's window is on.  In addition to the standard options listed
above, a \fB-visual\fR option may be specified on the command line.
If it is specified, it restricts the set of visuals from which
the photo widget will choose.  The option value may be the name of an
X visual class (e.g. DirectColor), the word \fBdefault\fR (indicating
the default visual for the screen), or a numeric X visual ID
specifying one particular X visual.
.PP
The photo widget allocates a set of colors as specified by the
\fB-palette\fR configuration option.  For color display, these colors
form a cube in RGB
color space, with the colors spaced at equal intervals along each axis
from zero intensity to full intensity.  The actual color values
requested depend on the value of \fIgamma\fR (if any) specified with
the \fB\-gamma\fR option; the requested values are chosen so as to be
equally spaced in intensity on a display with the given \fIgamma\fR
exponent.
.PP
The image to be displayed may
be quantized (where each pixel is displayed using the nearest
available color to the pixel's color), or optionally dithered.
Dithering trades off some spatial resolution for improved color
resolution, giving a considerable improvement in the visual
appearance of most images on 8-bit color and 1-bit
monochrome workstations.
.PP
The default palette for a widget attempts to make reasonably
good use of the workstation's capabilities.  The default palette is
chosen based on the X visual used for the photo's window, as follows.
For DirectColor and TrueColor visuals, the
default palette has as many shades of each color as the visual
supports.  For PseudoColor and StaticColor visual, the default
palette is chosen based on the depth (7/7/4 for 8 bits/pixel).
The default for GrayScale and StaticGray visuals has
as many shades of gray as the visual supports.
.PP
An alternative palette can be specified if desired, as long as the
palette does not exceed the visual's capabilities.  For example,
a monochrome palette can be used on a color visual, but not
vice-versa.  The default palette for 8-bit PseudoColor visuals
leaves around 60 colors free for other windows; in many circumstances,
this means that the widget's colors can be allocated in the default
colormap.  The user may alternatively specify an 8/8/4 palette for
example, which provides (slightly) better color resolution at the
expense of requiring a private colormap for the window.
.PP
The palette and gamma values may be changed at any time.  This may
change the widget's colormap, but does not change the displayed pixel
values.  Thus the displayed image may be incorrect until the image is
dithered or until a new image is displayed.
.PP
The photo widget attempts to use the same colormap for as many photo
windows as possible, in order to save on colormap resources and on the
time taken to allocate colors.  Two photo windows will use the same
colormap if they are on the same screen of the same display, use the
same visual, and have the same values (if any) specified for the
\fB\-palette\fR and \fB-gamma\fR options.
The photo widget will attempt to allocate the colors it
requires from the default colormap; if that fails, it will allocate a
private colormap and allocate the colors within that.  The window
manager will then be informed that this window has a non-default colormap;
when its colormap is installed depends on the window manager's colormap
focus policy, and on the application's colormap focus preference (set
with the \fBcolorfocus\fR command).
.PP
The photo widget has an interface which allows C code to supply
rectangular blocks of image data to be displayed.  These blocks may be
any size (up to the total image size) and supplied in any order.
Image data can also be supplied using the \fBput\fR widget command,
but this is recommended only for very small blocks because of the
inefficiency of converting pixel values to and from a string
representation.
If the widget's palette specifies monochrome display, the color image
is converted to monochrome as it is supplied using the formula
\fII\fR = (11\fIR\fR + 16\fIG\fR + 5\fIB\fR) / 32.
.PP
Image blocks may optionally be dithered as
they are supplied (\fIditherLevel\fR = 2), or they may be
quantized for immediate display and then optionally dithered at a
later time (\fIditherLevel\fR = 1).  With either of these options, the
widget will allocate storage to store the undithered image and error
information, which amounts to 6 bytes/pixel for color display, or 2
bytes/pixel for monochrome display.  Using \fIditherLevel\fR = 0
disables dithering (images are merely quantized) and decreases the
memory requirements.  The default \fIditherLevel\fR is 0 for
DirectColor and TrueColor visuals and 2 for other types.
(Note that dithering with a 256/256/256 palette will leave the
image unchanged.)
.PP
Because the dithering algorithm propagates errors from each pixel to
its neighbours to the right and below, image blocks dithered at the time
that they are supplied may not be quite correct if the image blocks
are supplied out of order.  The photo widget keeps track of which
part of the image has been correctly dithered, and will redither the
remainder on request.
.PP
The user may specify an image size using the \fB\-imagesize\fR option
or by calling the \fBPhotoSetSize\fR procedure from C code.  If this
is done, the photo widget will clip all image blocks supplied to the
specified image size, and allocate a pixmap in the X server of this
size.  Otherwise the widget will allocate a pixmap of a default size
initially and expand it as it receives image blocks which would fall
outside of the current dimensions of the pixmap; the pixmap size is
taken to be the image size when the user has not specified an explicit
image size.  The initial default
size of the pixmap in this case is the window size, which is initially
256x256 pixels unless a size has been specified with the
\fB\-geometry\fR option.  Giving an empty string as the
argument to the \fB\-imagesize\fR option cancels the user-specified
image size.  Note that the image can only be smaller than the window
if both the image size and window size are specified by the user; in
this case the size of the pixmap is taken as the larger of the two in
each dimension.
.PP
The size of the photo window is ultimately under the control of the
packer.  The photo widget requests a window size which is determined
as follows: if a size for the window is specified with the
\fB\-geometry\fR option, that size is requested.  Otherwise, the
image size is used as the requested window size, which is initially
256x256 pixels unless the user has specified an explicit image size.

.SH "WIDGET COMMAND"
.PP
The \fBphoto\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the command.
.PP
The following commands are possible for photo widgets:
.TP
\fIpathName \fBblank\fR
Set the whole image to the blank color (default black; specified with
the \fB\-blank\fR option).
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBphoto\fR
command.
.TP
\fIpathName \fBdither\fR ?\fIx y width height\fR?
Dither all or part of the image.  If \fIx, y, width\fR and
\fIheight\fR are given, they specify a rectangular region of the image
to be dithered, which must be contained in the image (\fIwidth\fR and
\fIheight\fR must be positive).  Otherwise the whole image is
dithered.  This command will fail if the \fIditherLevel\fR is zero.
.TP
\fIpathName \fBput \fIx y width height data_width data_height color_list\fR
Sets the pixel values for a rectangular region of the image,
\fIwidth\fR pixels wide and \fIheight\fR pixels high, with
its top-left corner at coordinates (\fIx, y\fr).  \fIColor_list\fR
specifies the colors of the pixels in a block \fIdata_width\fR pixels
wide and \fIdata_height\fR pixels high, which is replicated in a tiled
fashion (if necessary) to fill the rectangular region of the image.
Each color value in \fIcolor_list\fR can be specified either as an
absolute color (e.g. #2376af) or by name (e.g. red).  This command is
recommended only in cases where \fIcolor_list\fR is short; the
FindPhoto interface from C code is much more efficient (see FindPhoto (3)).
.TP
\fIpathName \fBredither\fR
Redither the part (if any) of the image which is not correctly
dithered.  If the image was supplied in scan-line order, or if
\fIditherLevel\fR is zero, this command does nothing.
.TP
\fIpathName \fBscan \fIoption args\fR
This option is used to implement scanning on photo widgets.  It has
two forms, depending on \fIoption\fR:
.RS
.TP
\fIpathName \fBscan mark \fIx y\fR
Records \fIx\fR and \fIy\fR and the current view in the photo window;
used in conjuction with later \fBscan dragto\fR commands.  Typically
this command is associated with a mouse button pres in the widget.  It
returns an empty string.
.TP
\fIpathName \fBscan dragto \fIx y\fR
This command computes the difference between its \fIx\fR and \fIy\fR
arguments and the \fIx\fR and \fIy\fR arguments to the last \fBscan
mark\fR command for the widget.  It then adjusts the view by
\fIscanspeed\fR times the difference in coordinates (where
\fIscanspeed\fR is specified using the \fB-scanspeed\fR configuration
option; the default is 10).  This command is typically associated with
mouse motion events in the widget, to produce the effect of dragging
the image around within the window.  The return value is an empty
string.
.RE
.TP
\fIpathName \fBxview \fR?\fIleft-x\fR?
If \fIleft-x\fR is given, this command
scrolls the window so that the pixels with X coordinate \fIleft-x\fR
are displayed at the left edge of the window.  The value of
\fIleft-x\fR is clipped to the range for which the window is contained
in the image.  This form of the command also invokes the command, if
any, specified with the \fB\-xScrollCommand\fR option.  If the
\fIleft-x\fR argument is not given, this command returns the X
coordinate of the pixels at the left edge of the window.
.TP
\fIpathName \fByview \fR?\fItop-y\fR?
If \fItop-y\fR is given, this command
scrolls the window so that the pixels with Y coordinate \fItop-y\fR
are displayed at the top edge of the window (note that Y coordinates
increase downwards).  The value of
\fItop-y\fR is clipped to the range for which the window is contained
in the image.  This form of the command also invokes the command, if
any, specified with the \fB\-yScrollCommand\fR option.  If the
\fItop-y\fR argument is not given, this command returns the Y
coordinate of the pixels at the top edge of the window.

.SH BINDINGS
.PP
When a new photo is created, it has no default bindings.
Normally, class bindings should be established which bind button 2
presses to the \fBscan mark\fR command and motion with button 2
depressed to the \fBscan dragto\fR command.  This will allow the image
to be scanned using the mouse (when the window is smaller than the
image).
.PP
If a photo is using a non-default visual or colormap, it may be
necessary with some window managers to bind some appropriate events
(such as <Enter> and <Leave> on the photo) to the \fBcolorfocus\fR
command so that the photo's colormap gets installed at the appropriate
times.

.SH C INTERFACE
.PP

An application using the photo widget creates a photo window via Tcl,
but then supplies image data via a C-language procedure call interface
to the photo widget.  This interface is documented in detail elsewhere
(see FindPhoto (3)), and defined in the header file tkPhoto.h.
Since there may be several photo windows in an application, the
interface procedures take an opaque handle (of type
\fBPhotoHandle\fR) as a parameter to identify the window to be
affected.  This handle is obtained from the window's path name using
the \fBFindPhoto\fR procedure.  The C-language interface also includes
procedures to query and set the size of the image and to blank the image.

.SH KEYWORDS
photo, image, widget, visual, colormap
'\"@endhelp
