#==============================================================================
#                                  wood.tcl
#------------------------------------------------------------------------------
# A port of SIPP demo program woodtest.c to Tcl-SIPP.
#------------------------------------------------------------------------------
# $Id: wood.tcl,v 4.0 1993/11/27 21:26:00 markd Rel $
#------------------------------------------------------------------------------

if {[info commands DoRendering] == ""} {
    if [file exists ./demoutil.tlib] {
        loadlibindex ./demoutil.tlib
    } else {
        set demoutil [searchpath $auto_path demos/demoutil.tlib]
        if [lempty $demoutil] {
            error "Can't find \"demos/demoutil.tlib\" on auto_path"
        }
        loadlibindex $demoutil
    }
}
ParseDemoArgs 3

set wood_surf [SippShaderWood 0.5 0.0 0.99 10.0 {0.770 0.568 0.405} \
                              {0.468 0.296 0.156} {1.0 1.0 1.0}]

SippLightSourceCreate {1.0 1.0 1.0} {0.9 0.9 0.9} DIRECTION

SippObjectAddSubobj WORLD [SippBlock {4.0 3.0 3.0} $wood_surf WORLD]

SippCameraParams STDCAMERA {10.0 10.0 20.0} {0.0 0.0 0.0} {0.0 1.0 0.0} 0.125

DoRendering "wood"
