#==============================================================================
#                               planet.tcl
#------------------------------------------------------------------------------
# A port of SIPP demo program planettest.c to Tcl-SIPP.
#------------------------------------------------------------------------------
# $Id: planet.tcl,v 4.0 1993/11/27 21:25:50 markd Rel $
#------------------------------------------------------------------------------

if {[info commands DoRendering] == ""} {
    if [file exists ./demoutil.tlib] {
        loadlibindex ./demoutil.tlib
    } else {
        set demoutil [searchpath $auto_path demos/demoutil.tlib]
        if [lempty $demoutil] {
            error "Can't find \"demos/demoutil.tlib\" on auto_path"
        }
        loadlibindex $demoutil
    }
}
ParseDemoArgs 3

set SUBDIVS 50

set shader [SippShaderPlanet 0.4 0.0 0.5]

SippLightSourceCreate {1.0 1.0 1.0} {1.0 1.0 1.0} DIRECTION

SippObjectAddSubobj WORLD [SippSphere 1.0 $SUBDIVS $shader WORLD]
SippObjectRotateZ WORLD -1.2
SippObjectRotateX WORLD  0.2

SippCameraParams STDCAMERA {0.0 2.0 0.0} {0.0 0.0 0.0} {0.0 0.0 1.0} 0.75

DoRendering "planet"
