#==============================================================================
#                                  cone.tcl
#------------------------------------------------------------------------------
# A port of SIPP demo program conetest.c to Tcl-SIPP.
#------------------------------------------------------------------------------
# $Id: cone.tcl,v 4.0 1993/11/27 21:25:48 markd Rel $
#------------------------------------------------------------------------------

if {[info commands DoRendering] == ""} {
    if [file exists ./demoutil.tlib] {
        loadlibindex ./demoutil.tlib
    } else {
        set demoutil [searchpath $auto_path demos/demoutil.tlib]
        if [lempty $demoutil] {
            error "Can't find \"demos/demoutil.tlib\" on auto_path"
        }
        loadlibindex $demoutil
    }
}
ParseDemoArgs

set RESOLUTION 20

SippLightSourceCreate { 1.0  1.0 1.0} {0.9 0.9 0.9} DIRECTION
SippLightSourceCreate {-1.0 -1.0 0.5} {0.4 0.4 0.4} DIRECTION

#
# light salmon
#
set shader [SippShaderBasic 0.5 0.6 0.2 {1.0000 0.6275 0.4784}]

#
# The ordinary cone
#
set cone [SippCone 1.0 0.0 4.0 $RESOLUTION $shader WORLD]

SippObjectMove $cone {-3.0 0.0 0.0}
SippObjectAddSubobj WORLD $cone

#
# The truncated cone
#
set trunc_cone [SippCone 1.0 0.4 5.0 $RESOLUTION $shader WORLD]
SippObjectMove $trunc_cone {3.0 0.0 0.0}
SippObjectAddSubobj WORLD $trunc_cone

#
# The cylinder (a trucated cone with equal top and bottom radii
#
set cylinder [SippCylinder 1.0 3.0 $RESOLUTION $shader WORLD]
SippObjectAddSubobj WORLD $cylinder

SippCameraParams STDCAMERA {5.0 -10.0 6.0} {0.0 0.0 0.0} {0.0 0.0 1.0} 0.4

DoRendering "cone"
