/*
 * Copyright 1992 by the National Optical Astronomy Observatories(*)
 *
 * Permission to use, copy, and distribute
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * This software is provided "as is" without any express or implied warranty.
 *
 * (*) Operated by the Association of Universities for Research in
 *     Astronomy, Inc. (AURA) under cooperative agreement with the
 *     National Science Foundation.
 *
 * SCCS INFO
 *      @(#)tclipcP.h	1.1 9/11/92
 */
/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
/* File: tclipcP.h
 *      This is the private library interface in the tcl ipc library.
 *      Should be used only by library code and special programs (PortManager).
 *
 * Created: K. Gillies 26 June 1992
 *
 * SCCS INFO
 *      @(#)tclipcP.h	1.1 9/11/92
 */
#ifndef _tclipcP_h
#define _tclipcP_h

#define IPCHLENGTH 10     /* The storage for a copy of the handle */

/* Sender and Receiver are opaque.  Here are their actual contents. */
typedef struct _Receiver {
  Port receivePort;              /* Receive messages on which port and socket*/
  int receiveSocket;
  SVCXPRT *transport;
  Tcl_Interp *interp;            /* Used to match received messages */
                                 /* to the correct interpreter */
  char handleName[IPCHLENGTH];   /* Copy of handle for this receiver */
} ReceiverR, *Receiver;

typedef struct _Sender {
  CLIENT *clientPtr;             /* RPC CLIENT */
  int clientSocket;              /* The socket value */
  int portNumber;                /* Which port should be used */
  Tcl_Interp *interp;            /* The interpreter used with this Sender */
  Receiver localReceiver;        /* This will be non-null if its alocal send */
  char handleName[IPCHLENGTH];   /* Copy of handle for this sender */
} SenderR, *Sender;

/* Public functions */
/* Create a new Sender on *Port */
EXTERN Sender NewSender _ANSI_ARGS_((Tcl_Interp*, Port*));

/* Destroy a Sender */
EXTERN void DestroySender _ANSI_ARGS_((Sender));

/* Check to see if an application on the end of a Sender is alive */
EXTERN int SenderAppCheck _ANSI_ARGS_((Port* senderPort));

/* Create a new Receiver */
EXTERN Receiver NewReceiver _ANSI_ARGS_((Sender portMgrSender, 
				  char *appName, 
				  int receivingPort));
/* Destroy a Receiver */
EXTERN void DestroyReceiver _ANSI_ARGS_((Sender portMgrSender, 
				  Receiver receiver));

/* Signal handler function for polling for incoming commands. */
EXTERN void receiverAlarmTimeout _ANSI_ARGS_((int));

/* The contents of the dispatch table type */
typedef struct _DispatchTable {
  evalcmd_res *(*cmdRecvPtr)_ANSI_ARGS_((Tcl_Interp*, cmdText));
  void (*listenFunctionPtr)_ANSI_ARGS_((void));
  void (*connectFunctionPtr)_ANSI_ARGS_((int));
  void (*destroyConnectFunctionPtr)_ANSI_ARGS_((int));
} DispatchTable;

/* Register functions to override the standard versions */
EXTERN void BuildDispatchTable _ANSI_ARGS_((DispatchTable* table));

/* Set the receive timeout--private hack */
EXTERN void setReceiveTimeout _ANSI_ARGS_((long secs, long usecs));

/* Return the interpreter associated with the port "portIn" */
EXTERN int ipcGetInterp _ANSI_ARGS_((int portIn, 
				       Tcl_Interp **interp));

/* Check to see if a connection is local */
EXTERN Receiver ipcCheckForLocal _ANSI_ARGS_((Port *));

/* This function can be called to trigger the new connection function */
EXTERN void ipcCheckIncomingConnections _ANSI_ARGS_((int newfd));

/* Called when a connection goes away */
EXTERN void ipcDestroyConnections _ANSI_ARGS_((int dyingfd));

#endif
