.TH "portManager" TCL "" "TCL"
.ad b
.SH NAME
pmConnectWithPortMgr, pmIsPortUnique, pmDisconnectFromPortMgr, pmGetOpenApps, pmGetPortFromName, pmGetPortFromResult, pmDestroyResult - an interface to the tclIPC PortManager
.SH SYNOPSIS
.PP
.nf
.ft CW
#include <tclipc.h>

int
pmConnectWithPortMgr(Sender sender,
                     Port *receivingPort);

int
pmIsPortUnique(Sender sender
               Port *receivingPort);

int
pmDisconnectFromPortMgr(Sender sender,
                        Port *apport);

int
pmGetOpenApps(Sender sender,
              PortMgrResult *openAppsReturn);

int
pmGetPortFromName(Sender sender,
                  Port *appNameAndHost,
                  PortMgrResult *matchingPortsReturn);

int
pmGetPortFromResult(Tcl_Interp *interp,
                    int whichone,
                    PortMgrResult pmresult,
                    Port *appPortReturn);

int
pmDestroyResult(PortMgrResult pmresult);
.ft R
.fi
'
.SH DESCRIPTION
.PP
These convenience functions allow the C programmer to easily use 
the \fBtclIPC\fR PortManagers.
'
.SS pmConnectWithPortMgr
.PP
Makes a connection to the PortManager indicated by sender and registers the
application, host, and port number in receivingPort with that PortManager.
.PP
Parameters:
.RS 2
\fBo \fIsender\fR - A valid sender to a PortManager application.
.br
.PP
\fBo \fIreceivingPort\fR - This Port structure should be set up to contain
the application name, its host, and the port number where this application
will be listening for commands.
.br
.RE
.PP
Returns:
.RS 2
Returns the TCL error value and string from the remote "connect" command
that executed on the specified PortManager.
.RE
'
.SS ipcIsPortUnique
.PP
Contact a PortManager and check to see if there is already an application
registered with the same host and label in receivingPort.
.PP
Parameters:
.RS 2
\fBo \fIsender\fR - A valid sender to a PortManager application.
.br
.PP
\fBo \fIreceivingPort\fR - This Port structure should be set up to contain
the application name and host name that should be checked for uniqueness.
.br
.RE
.PP
Returns:
.RS 2
Returns the TCL error value and string from the remote "isunique" command
that executed on the specified PortManager.
.RE
'
.SS pmGetOpenApps
.PP
Contacts a specified PortManager and returns a TCL list of all the
applications currently registered on that PortManager.  The caller
must free the PortMgrResult when he/she is finished with the result.  The 
pmGetPortFromResult function can be used to access the members of
a PortMgrResult string.
.PP
Parameters:
.RS 2
\fBo \fIsender\fR - A valid sender to a PortManager application.
.br
.PP
\fBo \fIopenAppsReturn\fR - A pointer to a PortMgrResult which is a TCL
list of Port descriptions.  The list is of the following form:
.RE
.PP
.nf
.ft CW
.RS 4
{pmgr radish 6601} {prog1 radish 3255} {prog2 ursa 2333}
.RE
.ft R
.fi
'
.PP
Returns:
.RS 2
Returns the TCL error value and string from the remote "openapps" command
that executed on the specified PortManager.  The result will be the
list or an error message if TCL_ERROR was returned.
.RE
'
.SS pmDisconnectFromPortMgr
.PP
Contacts a specified PortManager and removes the application name and
host specified in appPort.
.PP
Parameters:
.RS 2
\fBo \fIsender\fR - A valid sender to a PortManager application.
.br
.PP
\fBo \fIappPort\fR - This Port structure should be set up to contain
the application name and host name that should be removed from the
PortManager registry.
.RE
.PP
Returns:
.RS 2
Returns the TCL error value and string from the remote "disconnect" command
that executed on the specified PortManager.  
.RE
'
.SS pmGetPortFromName
.PP
Contacts a specified PortManager with an application label and possibly
a host and returns a PortMgrResult list of matching applications.
.PP
Parameters:
.RS 2
\fBo \fIsender\fR - A valid sender to a PortManager application.
.br
.PP
\fBo \fIappNameAndHost\fR - This Port structure should be set up to contain
the application name and optionally a host name for a desired destination
receiver.  If the host doesn't matter, the host name should be set to 
"AnyHost".  If a host name other than "AnyHost" is given, the PortManager
will only return entries that match both the host machine and the 
application name.
.RE
.PP
Returns:
.RS 2
Returns the TCL error value and string from the remote "portfromname" command
that executed on the specified PortManager.  
.RE
'
.SS pmGetPortFromResult
.PP
Given a PortMgrResult list, this function will fill in a Port structure with
the data from one member of the PortMgrResult string.
.PP
Parameters:
.RS 2
\fBo \fIinterp\fR - An errors generated during the command will be returned
in this interpreters result string.
.br
.PP
\fBo \fIwhichone\fR - An integer index indicating which member of the
PortMgrResult should be used to fill in the Port structure.  The index
should start at 0.  The function checks for appropriate index values and
returns the closest list member.
.br
.PP
\fBo \fIpmresult\fR - This is a PortMgrResult as returned by pmGetOpenApps
or pmGetPortFromName.
.PP
\fBo \fIappPortReturn\fR - This Port will be filled in with the data
from the indicated list member.
.br
.RE
.PP
Returns:
.RS 2
Returns TCL_ERROR if there was a problem during the list evaluation.  The
result string of the interpreter will be set to the cause of the problem.
.RE
'
.SS pmDestroyResult
.PP
Free the memory associated with a PortMgrResult.
.PP
Parameters:
.RS 2
\fBo \fIpmresult\fR - This is the PortMgrResult that will be freed.
.br
.PP
Returns:
.RS 2
Always returns TCL_OK.
.RE
'
