.TH "ipcInit" TCL "" "TCL"
.ad b
.SH NAME
ipcInterpInit, ipcSendInit
.SH SYNOPSIS
.PP
.nf
.ft CW
#include <tclipc.h>

void
ipcInterpInit(Tcl_Interp *interp);

void
ipcSendInit(long timeoutsecs,
            long timeoutusecs,
            long receivesecs,
            long receiveusecs,
            evalfunction evaluator,
            listenfunction listener,
            connectfunction connect,
            connectfunction destroyer);

.ft R
.fi
'
.SH DESCRIPTION
.PP
These calls must be used to initialize the \fBtclIPC\fR library and interpreters that need to have access to the \fBtclIPC\fR TCL commands.
'
.SS ipcInterpInit
.PP
This function adds the tclIPC user commands: sender, receiver, isend, srdump, and pmdump to the interpreter passed as an argument in the function.  This function can be called for each interpreter in your program that needs to send commands.
.PP
Parameters:
.RS 2
\fBo \fIinterp\fR - The interpreter that will have the tclIPC commands added.
.br
.RE
.PP
Returns:
.RS 2
void
.RE
'
.SS ipcSendInit
.PP
Initialize the TCL message library.  Timeouts can be set for the command-line program alarm timeout and the amount of time the alarm timeout function waits for incoming messages when it is called.  The programmer can override some functions used by the tclIPC library.  The \fIevalfunc\fR is called when an incoming messages arrives.  The \fIlistener\fR is called periodically and is expected to check for incoming messages on RPC sockets.  The \fIconnector\fR is called when new connections are accepted by the library.  The \fIdestroyer\fR is called when connections are closed.  This function should only be called once within a program.
.PP
Parameters:
.RS 2
\fBo \fItimeoutsecs, timeoutusecs\fR - These two values are used to set the period between checks for incoming messages.  These values set the period for the alarm signal handler.  The first value, timeoutsecs, is in seconds, and the second, timeoutusecs, is in microseconds.  Setting both these values to 0 will keep the alarm from being used.  This is appropriate with a GUI window program that uses its own methods for checking for messages.
.br
.PP
\fBo \fIreceivesecs, receiveusecs\fR - The standard command-line message receiving function calls the select system call.  With these two values, the programmer can set the timeout value for the select call.  If you pass the constant "WAITFOREVER", the select will block indefinitely until something arrives.  This might be appropriate for a non-interactive server application.  These values are ignored unless timeoutsecs and timeoutusecs are also non-zero.
.br
.PP
\fBo \fIevalfunc\fR - The library user can substitute his own function that will be called when an incoming message arrives.  Pass (evalfunc *)NULL to use the standard message evaluating function, which is appropriate in most cases.  The prototype for the evalfunc is:
.RE
.RS 4
.PP
.ft CW
evalcmd_res *function(Tcl_Interp *interp, cmdText cmd);
.ft R
'
.PP
Parameters:
.RS 2
\fBo \fIinterp\fR - This interpreter should be used to execute the command.  It is the interpreter that executed the ipcNewReceiver or receiver new in a TCL script.
.br
.PP
\fBo \fIcmd\fR - This is a pointer to the character string that is the command to be executed.
.RE
.PP
Returns:
.RS 2
The evalfunc returns a pointer to an evalcmd_res structure (which must be static).  The two members of the structure are errno and text.  The structure member errno should be set to the Tcl_Eval result value, and structure value text should be set to the interpreter result.
.RE
.RE
'
.PP
.RS 2
.br
\fBo \fIlistener\fR - The alarm timeout calls a message listener function.  
The programmer can substitute another message listener function that will be 
called by the alarm timeout function rather than the built-in function.  
The PortManager uses this feature.  Passing (listener *)NULL for this
argument means the library should use the standard function.  
The function takes no arguments and returns nothing, but it is responsible
for checking the RPC sockets for incoming messages.
See the examples and RPC documentation if you need to override this function.
.br
.PP
\fBo \fIconnector, destroyer\fR - GUI programs typically call library-specific
functions that allow them to receive data on file descriptors; the libraries 
can then deal with these kinds of inputs as events.  
The functions defined to register these events vary from one toolkit to 
another.  \fBtclIPC\fR will call a user-defined function when a client 
(a receiver of a message) receives a connection open request and when a 
client connection is closed.  To use this feature, the programmer should pass a non-NULL function pointer for the connector and destroyer arguments.  Here is the prototype for a connectfunction.
.RE
.RS 4
.PP
.ft CW
void function(int fd);
.ft R
'
.PP
Parameters:
.RS 2
\fBo \fIfd\fR - This value is the file descriptor for the new connection or the file descriptor of the connection that is closing.
.br
.RE
.PP
Returns:
.RS 2
void
.RE
'
