
# $Id: 7segC.tcl,v 1.1 1993/06/08 05:59:10 david Exp $
# 7segC.tcl - `Seven segment' display within a canvas widget.
#
# AUTHOR: David Herron <david@davids.mmdf.com (home)>
#
# Copyright 1993 David Herron.
# Permission to use, copy, modify and distribute this software
# and its documentation for any purpose and without fee is
# hereby granted, provided that the above copyright notice
# appear in all copies.  David Herron makes no representations
# about the suitability of this software for any purpose save
# printing it out and using the paper as bird cage lining.
#
# $Log: 7segC.tcl,v $
# Revision 1.1  1993/06/08  05:59:10  david
# Initial revision.  Demo programs for 7-segment-LED digit.
#

Define_Module 7SegmentClass {
InterpBase -import 7SegmentClass InterpBase [InterpBase -get EXPORTS]
-chain MainInterp [InterpBase -get TkChain]

set EXPORTS { new setval getval geometry }
-export EXPORTS

Method new {canvas X Y WIDTH HEIGHT FORE} {
	set name [gen_interp_name "7seg"]
	interp new $name

	-import $name InterpBase [InterpBase -get EXPORTS]
	-import $name 7SegmentClass [7SegmentClass -get EXPORTS]
	$name -exec [list -chain MainInterp [InterpBase -get TkChain]]
	$name -exec "-chain MainInterp $canvas"

	$name -exec "set canvas $canvas"
	$name -exec "set X      $X"
	$name -exec "set Y      $Y"
	$name -exec "set WIDTH  $WIDTH"
	$name -exec "set HEIGHT $HEIGHT"
	$name -exec "set FORE   $FORE"

	$name -exec {
		set backg [lindex [$canvas configure -background] 4]
		set this [interp this]
		$canvas create line 0 0 0 0	-fill $backg \
						-tags [list $this l0:$this]
		$canvas create line 0 0 0 0  	-fill $backg \
						-tags [list $this l1:$this]
		$canvas create line 0 0 0 0	-fill $backg \
						-tags [list $this l2:$this]
		$canvas create line 0 0 0 0	-fill $backg \
						-tags [list $this l3:$this]
		$canvas create line 0 0 0 0	-fill $backg \
						-tags [list $this l4:$this]
		$canvas create line 0 0 0 0	-fill $backg \
						-tags [list $this l5:$this]
		$canvas create line 0 0 0 0	-fill $backg \
						-tags [list $this l6:$this]
		$canvas create line 0 0 0 0	-fill $backg \
						-tags [list $this l7:$this]
		$canvas create line 0 0 0 0	-fill $backg \
						-tags [list $this l8:$this]
		setval blank
		geometry $X $Y $WIDTH $HEIGHT

		-AllowExec False
	}

	return $name
}

Method setval newval {
	global curval this canvas backg FORE
	set foreg $FORE
	case $newval {
	0	{
		$canvas itemconfigure l0:$this -fill $foreg
		$canvas itemconfigure l1:$this -fill $foreg
		$canvas itemconfigure l2:$this -fill $foreg
		$canvas itemconfigure l3:$this -fill $backg
		$canvas itemconfigure l4:$this -fill $backg
		$canvas itemconfigure l5:$this -fill $foreg
		$canvas itemconfigure l6:$this -fill $foreg
		$canvas itemconfigure l7:$this -fill $backg
		$canvas itemconfigure l8:$this -fill $foreg
	}
	1	{
		$canvas itemconfigure l0:$this -fill $backg
		$canvas itemconfigure l1:$this -fill $foreg
		$canvas itemconfigure l2:$this -fill $backg
		$canvas itemconfigure l3:$this -fill $backg
		$canvas itemconfigure l4:$this -fill $backg
		$canvas itemconfigure l5:$this -fill $foreg
		$canvas itemconfigure l6:$this -fill $backg
		$canvas itemconfigure l7:$this -fill $backg
		$canvas itemconfigure l8:$this -fill $backg
	}
	2	{
		$canvas itemconfigure l0:$this -fill $foreg
		$canvas itemconfigure l1:$this -fill $foreg
		$canvas itemconfigure l2:$this -fill $backg
		$canvas itemconfigure l3:$this -fill $backg
		$canvas itemconfigure l4:$this -fill $foreg
		$canvas itemconfigure l5:$this -fill $backg
		$canvas itemconfigure l6:$this -fill $foreg
		$canvas itemconfigure l7:$this -fill $backg
		$canvas itemconfigure l8:$this -fill $foreg
	}
	3	{
		$canvas itemconfigure l0:$this -fill $foreg
		$canvas itemconfigure l1:$this -fill $foreg
		$canvas itemconfigure l2:$this -fill $backg
		$canvas itemconfigure l3:$this -fill $backg
		$canvas itemconfigure l4:$this -fill $foreg
		$canvas itemconfigure l5:$this -fill $foreg
		$canvas itemconfigure l6:$this -fill $backg
		$canvas itemconfigure l7:$this -fill $backg
		$canvas itemconfigure l8:$this -fill $foreg
	}
	4	{
		$canvas itemconfigure l0:$this -fill $backg
		$canvas itemconfigure l1:$this -fill $foreg
		$canvas itemconfigure l2:$this -fill $foreg
		$canvas itemconfigure l3:$this -fill $backg
		$canvas itemconfigure l4:$this -fill $foreg
		$canvas itemconfigure l5:$this -fill $foreg
		$canvas itemconfigure l6:$this -fill $backg
		$canvas itemconfigure l7:$this -fill $backg
		$canvas itemconfigure l8:$this -fill $backg
	}
	5	{
		$canvas itemconfigure l0:$this -fill $foreg
		$canvas itemconfigure l1:$this -fill $backg
		$canvas itemconfigure l2:$this -fill $foreg
		$canvas itemconfigure l3:$this -fill $backg
		$canvas itemconfigure l4:$this -fill $foreg
		$canvas itemconfigure l5:$this -fill $foreg
		$canvas itemconfigure l6:$this -fill $backg
		$canvas itemconfigure l7:$this -fill $backg
		$canvas itemconfigure l8:$this -fill $foreg
	}
	6	{
		$canvas itemconfigure l0:$this -fill $backg
		$canvas itemconfigure l1:$this -fill $backg
		$canvas itemconfigure l2:$this -fill $foreg
		$canvas itemconfigure l3:$this -fill $backg
		$canvas itemconfigure l4:$this -fill $foreg
		$canvas itemconfigure l5:$this -fill $foreg
		$canvas itemconfigure l6:$this -fill $foreg
		$canvas itemconfigure l7:$this -fill $backg
		$canvas itemconfigure l8:$this -fill $foreg
	}
	7	{
		$canvas itemconfigure l0:$this -fill $foreg
		$canvas itemconfigure l1:$this -fill $foreg
		$canvas itemconfigure l2:$this -fill $backg
		$canvas itemconfigure l3:$this -fill $backg
		$canvas itemconfigure l4:$this -fill $backg
		$canvas itemconfigure l5:$this -fill $foreg
		$canvas itemconfigure l6:$this -fill $backg
		$canvas itemconfigure l7:$this -fill $backg
		$canvas itemconfigure l8:$this -fill $backg
	}
	8	{
		$canvas itemconfigure l0:$this -fill $foreg
		$canvas itemconfigure l1:$this -fill $foreg
		$canvas itemconfigure l2:$this -fill $foreg
		$canvas itemconfigure l3:$this -fill $backg
		$canvas itemconfigure l4:$this -fill $foreg
		$canvas itemconfigure l5:$this -fill $foreg
		$canvas itemconfigure l6:$this -fill $foreg
		$canvas itemconfigure l7:$this -fill $backg
		$canvas itemconfigure l8:$this -fill $foreg
	}
	9	{
		$canvas itemconfigure l0:$this -fill $foreg
		$canvas itemconfigure l1:$this -fill $foreg
		$canvas itemconfigure l2:$this -fill $foreg
		$canvas itemconfigure l3:$this -fill $backg
		$canvas itemconfigure l4:$this -fill $foreg
		$canvas itemconfigure l5:$this -fill $foreg
		$canvas itemconfigure l6:$this -fill $backg
		$canvas itemconfigure l7:$this -fill $backg
		$canvas itemconfigure l8:$this -fill $backg
	}
	10	{
		$canvas itemconfigure l0:$this -fill $foreg
		$canvas itemconfigure l1:$this -fill $foreg
		$canvas itemconfigure l2:$this -fill $foreg
		$canvas itemconfigure l3:$this -fill $backg
		$canvas itemconfigure l4:$this -fill $foreg
		$canvas itemconfigure l5:$this -fill $foreg
		$canvas itemconfigure l6:$this -fill $foreg
		$canvas itemconfigure l7:$this -fill $backg
		$canvas itemconfigure l8:$this -fill $backg
	}
	11	{
		$canvas itemconfigure l0:$this -fill $backg
		$canvas itemconfigure l1:$this -fill $backg
		$canvas itemconfigure l2:$this -fill $foreg
		$canvas itemconfigure l3:$this -fill $foreg
		$canvas itemconfigure l4:$this -fill $foreg
		$canvas itemconfigure l5:$this -fill $backg
		$canvas itemconfigure l6:$this -fill $foreg
		$canvas itemconfigure l7:$this -fill $foreg
		$canvas itemconfigure l8:$this -fill $backg
	}
	12	{
		$canvas itemconfigure l0:$this -fill $foreg
		$canvas itemconfigure l1:$this -fill $backg
		$canvas itemconfigure l2:$this -fill $foreg
		$canvas itemconfigure l3:$this -fill $backg
		$canvas itemconfigure l4:$this -fill $backg
		$canvas itemconfigure l5:$this -fill $backg
		$canvas itemconfigure l6:$this -fill $foreg
		$canvas itemconfigure l7:$this -fill $backg
		$canvas itemconfigure l8:$this -fill $foreg
	}
	13	{
		$canvas itemconfigure l0:$this -fill $backg
		$canvas itemconfigure l1:$this -fill $backg
		$canvas itemconfigure l2:$this -fill $foreg
		$canvas itemconfigure l3:$this -fill $foreg
		$canvas itemconfigure l4:$this -fill $backg
		$canvas itemconfigure l5:$this -fill $backg
		$canvas itemconfigure l6:$this -fill $foreg
		$canvas itemconfigure l7:$this -fill $foreg
		$canvas itemconfigure l8:$this -fill $backg
	}
	14	{
		$canvas itemconfigure l0:$this -fill $foreg
		$canvas itemconfigure l1:$this -fill $backg
		$canvas itemconfigure l2:$this -fill $foreg
		$canvas itemconfigure l3:$this -fill $backg
		$canvas itemconfigure l4:$this -fill $foreg
		$canvas itemconfigure l5:$this -fill $backg
		$canvas itemconfigure l6:$this -fill $foreg
		$canvas itemconfigure l7:$this -fill $backg
		$canvas itemconfigure l8:$this -fill $foreg
	}
	15	{
		$canvas itemconfigure l0:$this -fill $foreg
		$canvas itemconfigure l1:$this -fill $backg
		$canvas itemconfigure l2:$this -fill $foreg
		$canvas itemconfigure l3:$this -fill $backg
		$canvas itemconfigure l4:$this -fill $foreg
		$canvas itemconfigure l5:$this -fill $backg
		$canvas itemconfigure l6:$this -fill $foreg
		$canvas itemconfigure l7:$this -fill $backg
		$canvas itemconfigure l8:$this -fill $backg
	}
	blank	{
		$canvas itemconfigure l0:$this -fill $backg
		$canvas itemconfigure l1:$this -fill $backg
		$canvas itemconfigure l2:$this -fill $backg
		$canvas itemconfigure l3:$this -fill $backg
		$canvas itemconfigure l4:$this -fill $backg
		$canvas itemconfigure l5:$this -fill $backg
		$canvas itemconfigure l6:$this -fill $backg
		$canvas itemconfigure l7:$this -fill $backg
		$canvas itemconfigure l8:$this -fill $backg
	}
	}
	set curval $newval
}

Method getval {} { global curval; return $curval }

Method geometry {X Y WIDTH HEIGHT} {
	global canvas this
	set left [expr $X+$WIDTH]
	set midl [expr $Y+($HEIGHT/2)]
	set botm [expr $Y+$HEIGHT]
	$canvas coords l0:$this $X    $Y    $left $Y
	$canvas coords l1:$this $left $Y    $left $midl
	$canvas coords l2:$this $X    $Y    $X    $midl
	$canvas coords l3:$this $X    $Y    $left $midl
	$canvas coords l4:$this $X    $midl $left $midl
	$canvas coords l5:$this $left $midl $left $botm
	$canvas coords l6:$this $X    $midl $X    $botm
	$canvas coords l7:$this $X    $botm $left $midl
	$canvas coords l8:$this $X    $botm $left $botm
}

}
