#!/usr/prac/se/hush/bin/hush -f
# ----------------------------------------------------------------------
#  PURPOSE:  color palette (demo for drag&drop facilities)
#
#   AUTHOR:  Michael J. McLennan       Phone: (215)770-2842
#            AT&T Bell Laboratories   E-mail: alux2!mmc@att.com
#
#     SCCS:  %W% (%G%)
# ----------------------------------------------------------------------
#            Copyright (c) 1992  AT&T  All Rights Reserved
# ======================================================================

# ----------------------------------------------------------------------
# Mapping numbers to colors...
# ----------------------------------------------------------------------
set dec_to_hex_map(0) 0
set dec_to_hex_map(1) 1
set dec_to_hex_map(2) 2
set dec_to_hex_map(3) 3
set dec_to_hex_map(4) 4
set dec_to_hex_map(5) 5
set dec_to_hex_map(6) 6
set dec_to_hex_map(7) 7
set dec_to_hex_map(8) 8
set dec_to_hex_map(9) 9
set dec_to_hex_map(10) a
set dec_to_hex_map(11) b
set dec_to_hex_map(12) c
set dec_to_hex_map(13) d
set dec_to_hex_map(14) e
set dec_to_hex_map(15) f

proc dec_to_hex {val} {
	global dec_to_hex_map

	if {$val < 0} {set val 0}
	if {$val > 255} {set val 255}

	set dig1 [expr $val/16]
	set dig2 [expr $val-$dig1*16]
	return $dec_to_hex_map($dig1)$dec_to_hex_map($dig2)
}

# ----------------------------------------------------------------------
# Receiving data from remote applications...
# ----------------------------------------------------------------------
proc receive_number {num} {
	global Number
	expr $num*1
	set Number $num
}

proc receive_rgb {r g b} {
	global NewR NewG NewB
	set NewR $r
	set NewG $g
	set NewB $b
}

proc set_color {} {
	global NewR NewG NewB
	set_red   $NewR
	set_green $NewG
	set_blue  $NewB
}

proc bg_color {win} {
	global NewR NewG NewB
	set ActR [expr $NewR-20]
	set ActG [expr $NewG-20]
	set ActB [expr $NewB-20]
	set ncolor #[dec_to_hex $NewR][dec_to_hex $NewG][dec_to_hex $NewB]
	set acolor #[dec_to_hex $ActR][dec_to_hex $ActG][dec_to_hex $ActB]

	if {![string match *sample* $win]} {
		catch "$win config -background $ncolor"
		catch "$win config -activebackground $acolor"
	}
	foreach child [winfo children $win] {
		bg_color $child
	}
}

proc fg_color {win} {
	global NewR NewG NewB

	set ActR [expr $NewR-20]
	set ActG [expr $NewG-20]
	set ActB [expr $NewB-20]
	set ncolor #[dec_to_hex $NewR][dec_to_hex $NewG][dec_to_hex $NewB]
	set acolor #[dec_to_hex $ActR][dec_to_hex $ActG][dec_to_hex $ActB]

	if {![string match *sample* $win]} {
		catch "$win config -foreground $ncolor"
		catch "$win config -activeforeground $acolor"
	}
	foreach child [winfo children $win] {
		fg_color $child
	}
}

# ----------------------------------------------------------------------
# Sending data to remote applications...
# ----------------------------------------------------------------------
proc package_number {num win} {
	if {[winfo children $win] == ""} {
		label $win.label -text ""
		pack append $win $win.label top
	}
	expr $num*1
	$win.label config -text "Number: $num"
	return $num
}

proc send_number {interp ddwin tokenval} {
	send $interp "receive_number $tokenval"
	send $interp "drag&drop target $ddwin handle number"
}

proc package_rgb {r g b win} {
	if {[winfo children $win] == ""} {
		label $win.label -text "Color"
		pack append $win $win.label top
	}
	set color #[dec_to_hex $r][dec_to_hex $g][dec_to_hex $b]

	if {[expr $r+$g+$b] > 384} {
		$win.label config -background $color -foreground black
	} else {
		$win.label config -background $color -foreground white
	}
	return [list $r $g $b]
}

proc send_rgb {interp ddwin tokenval} {
	send $interp "receive_rgb $tokenval"
	send $interp "drag&drop target $ddwin handle rgb"
}

# ----------------------------------------------------------------------
# Setting color samples...
# ----------------------------------------------------------------------
set Red 0
set Green 0
set Blue 0

