#ifndef XYGRAPH_H
#define XYGRAPH_H

class xygraph : public widget {
public:
char* type() { return "xygraph"; }

xygraph(char* p, char* options = "", int fl=1 ) : widget(p) { if(fl) init(options); }
xygraph(widget* w, char* p, char* options = "", int fl=1 ) : widget(w,p) { if(fl) init(options); }

void install(action& ac, char* args = "") { 
	bind("<Any-ButtonPress>",ac, args);
	bind("<Any-ButtonRelease>",ac, args);
	bind("<Any-Motion>",ac, args);
	}

void insert(char* s, char* options = "") {
	sprintf(buf,"%s insert %s %s",path(),s,options);
	tk->eval( buf );
	}

void add(char* s, float x, float y, char* options = "") {
	sprintf(buf,"%s lineconfigure %s -xdata %f -ydata %f %s",path(),s,x,y,options);
	tk->eval( buf );
	}

/*
char* bar(int x, int y) {
	sprintf(buf,"whichbar %s %d %d",path(),x,y);
	return tk->evaluate(buf);
	}
*/

float y(int ex, int ey) {
	sprintf(buf,"lindex [%s locate %d %d] 1",path(),ex,ey);
	float f = 0; sscanf(tk->evaluate(buf),"%f",&f);
	return f;
	};

void lineconfigure(char* line, char* options="") {
	sprintf(buf,"%s lineconfigure %s %s",path(),line,options);
	tk->eval( buf );
	}

private:

};

#endif
