#ifndef MENU_H
#define MENU_H

class menu : public widget {
public:

char* type() { return "menu"; }

menu(char* p, char* options = "", int fl=1) : widget(p) {
if(fl) init(options); dvstring s =""; name_ = s; args_ = "";
}
menu(widget* w, char* p, char* options = "", int fl=1) : widget(w,p) {
if(fl) init(options); dvstring s =""; name_ = s; args_ = "";
}

menu* add(char* s, char* options = "") {
	sprintf(buf,"%s add %s %s", path(),s,options);
	tk->eval( buf );
	return this;
	}

menu* entry(char* s, action& ac, char* args ="", char* options = "") {
	sprintf(buf,"%s add command -label \"%s\" -command \"catch {%s {%s} %s}\" -state active %s",
		path(),s,ac.name(),s,args,options);
	tk->eval( buf );
	return this;
	}

menu* entry(char* s, char* args ="", char* options = "") {
	sprintf(buf,"%s add command -label \"%s\" -command \"catch {%s {%s} %s %s}\" -state active %s",
		path(),s,name(),s,args, args_,options);
	tk->eval( buf );
	return this;
	}

menu* cascade(char* s, char* m, char* options = "") {
	sprintf(buf,"%s add cascade -label \"%s\" -menu %s %s",
		path(),s,m,options);
	tk->eval( buf );
	return this;
	}

menu* cascade(char* s, menu* m, char* options = "") {
	sprintf(buf,"%s add cascade -label \"%s\" -menu %s -state active %s",
		path(),s,m->path(),options);
	tk->eval( buf );
	return this;
	}

char* entryconfigure(int i, char* options) {
	sprintf(buf,"%s entryconfigure %d %s",path(),i,options);
	return tk->evaluate( buf );
	}

int index(char *s) {
	sprintf(buf,"%s index %s",path(),s);
	int n = -1; sscanf(tk->evaluate( buf ),"%d",&n);
	return n;
	}

int active() { return index("active"); }


void del(int i) { sprintf(buf,"%s delete @%d",path(),i); tk->eval( buf ); }
void del(char* s) { sprintf(buf,"%s delete %s",path(),s); tk->eval( buf ); }

char* invoke(int i) { sprintf(buf,"%s invoke @%d",path(),i); return tk->evaluate( buf ); }
char* invoke(char *s ) { sprintf(buf,"%s invoke %s",path(),s); return tk->evaluate( buf ); }

void post(int x = 500, int y = 500) {
	sprintf(buf,"%s post %d %d",path(),x,y);
	tk->eval( buf );
	}

void unpost() {
	sprintf(buf,"%s unpost",path());
	tk->eval( buf );
	}

protected:
char* name() { return (char*) name_; }
dvstring name_;
char* args_;

void install(action& ac, char* args) {
	dvstring s = ac.name(); name_ = s;
	args_ = args;
	}
};


#endif
