#include <hush/hush.h>

int kit::n = 0;
int widget::widgetno = 0;

static widget rootwidget(".");

widget* theroot() // { return &rootwidget; }
  { return new widget("."); }


class handler;
class client;
struct callback;
extern struct callback* lastcallback();

extern Tcl_Interp* tk_mainInterp;
#ifndef HCLONLY
extern Tk_Window MainWindow;
#endif

extern int hush_main(kit*,int,char**,char*,int);
extern void init_hush(kit*);
class session;

class widget;


kit::~kit() { ;}

void kit::startup(int  argc, char **argv, char* name, int flags) { 
		     hush_main(this, argc, argv, name, flags);
		     }
int kit::eval(char* cmd) {
	if (traceon>0) cout << "eval: " << cmd << endl;
	return Eval(cmd); 
	}

char* kit::evaluate(char* cmd) { eval(cmd); return result(); }

char* kit::result() { return Result(); }
void kit::result(char* s) { SetResult(s); }

int kit::source(char* f)  {
    sprintf(buf,"source %s",f);
    return eval(buf);
}

void kit::after(int n, char* cmd) {
sprintf(buf,"after %d %s",n,cmd);
eval(buf);
}

char* kit::send(char* it, char* cmd) {
sprintf(buf,"send %s %s",it,cmd);
return evaluate(buf);
}

char* kit::selection(char* options) {
	sprintf(buf,"selection get %s", options);
	return evaluate( buf );
	}

void kit::update(char* options) { 
	sprintf(buf,"update %s", options);
	eval( buf );
	}

void kit::quit() { eval("destroy ."); }

void kit::trace(int i) { traceon = i; }
void kit::notrace() { traceon = 0; }


event kit::event() {
#ifndef HCLONLY
	class xevent* e = new xevent(last);
	e->cb = lastcallback();
	class event E(e);
#else
	class event E;
#endif
	return E;
	}

#ifndef HCLONLY
Tk_Window kit::tkwin() { return MainWindow; }
#endif


void kit::event(XEvent* p) {
#ifndef HCLONLY
	last = p;
	if (traceon>2) {
	   class xevent e(last);
	   e.trace();
	}
#endif
}


int kit::init() { 
	int r = source(session_->init_);
	init_hush(this);
	return r;
	}

void kit::install(kit* tk, int argc, char** argv) { 
if (session_->install_) session_->install_(tk, argc, argv);
}

void kit::program(kit* tk, int argc, char** argv) {
session_->main(tk,argc, argv);
}

char* kit::initfile() {
return session_->init_;
}


kit::kit(session* s) { 
	if (n++ == 0) tk_mainInterp = itp_;
	traceon = 0;
	root_ = theroot();
	session_ = s;
	/*
init_ = INITFILE;    // see Makefile 
install_ = (installproc*) 0; 
program_ = (installproc*) 0;
	*/
	}

widget* kit::root() { return theroot(); }
widget* kit::pack(widget* w, char* options) {
	return root()->pack(w,options);
	}
widget* kit::pack(char* w, char* options) {
	return root()->pack(w,options);
	}

action& kit::action(char* name) {
	if (traceon>0) cout << "action: " << name << endl;
	class action* ac = new tclaction(this,name);
	return *ac;
	}

class action& kit::action(char* name, class handler* h) {
	if (traceon>0) cout << "action(handler): " << name << endl;
	class action* ac = new tclaction(this,name,h);
	return *ac;
	}

class action& kit::action(char* name, int proc (client*, kit*, int, char**), client* data) {
	if (traceon>0) cout << "action: " << name << endl;
	class action* ac = new tclaction(this,name,proc,data);
	return *ac;
	}

class action& kit::action(char* name, int proc( clientdata, tclinterp, int , char** ), clientdata data ) {
	if (traceon>0) cout << "tclcommand: " << name << endl;
	CreateCommand(name,proc,data,(void (*)(clientdata)) NULL);
	class action* ac = new tclaction(this,name);
	return *ac;
	}
