#ifndef TCLSTRING_H
#define TCLSTRING_H

#include <iostream.h>
#include "strings.h"


class tclstringrep {
friend class tclstring;
private:
tclstringrep() {
	ds = &buffer;
	Tcl_DStringInit(ds);
	count = 1;
	}
~tclstringrep() {
	Tcl_DStringFree(ds);
	}
int count;
Tcl_DString* ds;
Tcl_DString buffer;
};


class tclstring {
public:

tclstring() { init(); } 
tclstring(char* s) { init(); concat(s); }
tclstring(tclstring& a) { rep = a.rep; rep->count++; } 

~tclstring() { if ( --rep->count <= 0 ) delete rep; }

tclstring& operator=( char* s ) { 
	   if (--rep->count <= 0 ) delete rep;
	   init(); append(s);
	   return *this;
	   }

tclstring& operator=( tclstring& a ) { 
	   a.rep->count++;
	   if (--rep->count <= 0 ) delete rep;
	   rep = a.rep;
	   return *this;
	   }

tclstring& start() {
	   Tcl_DStringStartSublist(rep->ds);
	   return *this;
	   }

tclstring& end() {
	   Tcl_DStringEndSublist(rep->ds);
	   return *this;
	   }

tclstring& trunc(int n) {
	   Tcl_DStringTrunc(rep->ds,n);
	   return* this;
	   }

tclstring& concat( char* s) {
           Tcl_DStringAppend(rep->ds,s,strlen(s));
	   return *this;
	   }

tclstring& concat( tclstring& a ) {
	   Tcl_DStringAppendElement(rep->ds, a.value());
	   return *this;
	   }

tclstring& append( char* s ) {
           Tcl_DStringAppendElement(rep->ds,s);
	   return *this;
	   }

tclstring& append( tclstring& a ) {
	   Tcl_DStringAppendElement(rep->ds, a.value());
	   return *this;
	   }

int length() { return Tcl_DStringLength(rep->ds) + 1; } 

char* value() { return Tcl_DStringValue(rep->ds); }

int match(char* s) {
	return Tcl_StringMatch(value(),s);
	}
	
int regmatch(char* s) {
	return Tcl_RegExpMatch(tk->interp(),value(),s);
	}

char* tilde() {
	Tcl_DString x; char* p;
	return p = Tcl_TildeSubst(tk->interp(), value(), &x );
	}

char* lindex(int n);
char* lindex(char* id);

int llength();

operator char*() { return value(); }

Tcl_DString* ds() { return rep->ds; }

private:
void init() { rep = new tclstringrep(); tk = thekit(); }
tclstringrep* rep;
kit* tk;
};

#endif
