#ifndef TABLE_H
#define TABLE_H

//static char* table_info = "abstract table";
// extern "C" { //#include <tclHash.h> }

#include <adt/iter.h>
#include <adt/DummyHashEntry.h>



template<class T>
class table {
public:
table() {
	tbl = &htbl;
	Tcl_InitHashTable(tbl,TCL_STRING_KEYS);
	}

~table() {
	Tcl_DeleteHashTable(tbl);
	}


void entry(char* k, T* v) {
	int n;
	Tcl_HashEntry* p;
	do {
		p = Tcl_CreateHashEntry(tbl,k, &n);
	} while( !n );
	Tcl_SetHashValue(p, (ClientData) v);
	}

T* find(char* k) {
	Tcl_HashEntry* p;
	p = Tcl_FindHashEntry(tbl,k);
	if (!p)  cerr << "error finding " << k << endl;
	return (T*) Tcl_GetHashValue(p);
	}

T* del(char* k) {
	Tcl_HashEntry* p;
	p = Tcl_FindHashEntry(tbl,k);
	if (!p)  cerr << "error finding " << k << endl;
	T* v = (T*) Tcl_GetHashValue(p);
	Tcl_DeleteHashEntry( p );
	return v;
	}

inline iter<T> search();

char* stats() {
	return Tcl_HashStats( tbl );
	}
	
T& operator()(char* k) { return *find(k); }

DummyHashEntry<T>& operator[](char* k) {  /// trick to allow assignment
	int n;
	Tcl_HashEntry* p;
	do {
		p = Tcl_CreateHashEntry(tbl,k, &n);
	} while( !n );
	return * new DummyHashEntry<T>( p );
	}
	
protected:
//friend T* operator=(Tcl_HashEntry*, T* );
//friend class tableiter<T>;
Tcl_HashTable htbl;
Tcl_HashTable* tbl;
};


template<class T> 
class tableiter : public iter<T> {
public:
tableiter(Tcl_HashTable* tbl_) : iter<T>(this) {
	tbl = tbl_; sp = &s;
	p = Tcl_FirstHashEntry(tbl,sp);
	//if (p) cout << "oke"; else cout << "wrong"; cout << endl;
	}

void dummy(T*) { }

T* operator()() {
	//if (p) cout << "oke"; else cout << "wrong"; cout << endl;
	T* v = p ? (T*) Tcl_GetHashValue(p) : 0;
	p = Tcl_NextHashEntry(sp);
	return v;
	}
	
private:
Tcl_HashSearch* sp;
Tcl_HashTable* tbl;
Tcl_HashSearch s;
Tcl_HashEntry* p;
};

template<class T>
inline iter<T> table<T>::search() { return * new tableiter<T>(tbl); }

#endif
