/*
 *-----------------------------------------------------------------------------
 *  Copyright (c) 1993-1995 European Synchrotron Radiation Facility
 *
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the "Terms and Conditions of Distribution", given in the documentation
 *  to this software, are applicable and the above copyright message appears
 *  in each copy.
 *
 *-----------------------------------------------------------------------------
 *
 *
 *  This file contains the application specific callback functions of
 *  the sample application for demonstrating the use of the CTAXT interface
 *
 *  13.12.1993   hp      1st version
 *  07.01.1994   hp      corrected the error message "Couldn't get Interp..."
 */


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "ctaxt.h"




/*
 *  centreRectangle ---
 *
 *  This function is the callback for the pushbutton to center the rectangle
 *  in the toplevel window.
 *
 *  Arguments:
 *
 *    none
 *
 *  Result:
 *
 *    0 means ok, otherwise error
 *
 *  Side effects:
 *
 *    The rectangle in the toplevel window will get centred
 */

int 
centreRectangle (display,tkParent3)
  Display *display;
  Window tkParent3;
{
  static Tcl_Interp *interp = NULL;


  if (interp == NULL) {
    
    /*  initialize the function  */


    if ((interp = CTAXT_GetInterpreter (tkParent3,display)) != NULL) {
      Tcl_Eval (interp,"source centrerect.tcl");
      if (*(interp->result)) {
	fprintf (stderr,"\n%s\n",interp->result);
      }
    } else {
        fprintf (stderr,"\nCould not get the Tcl interpreter for the "
		        "Top-level Window!\n");
	return (1);
      }
  }

  /*  evaluate the Tcl script to centre the rectangle  */

  Tcl_Eval (interp,"centreRectangle .canvas rectangle");
  if (*(interp->result)) {
    fprintf (stderr,"\n%s\n",interp->result);
  }
  return (0);
}
