source ../library/tkEmacs.tcl

set type "emacs18"
if {$argc == 1} {
  set type [lindex $argv 0]
}

case $type {
  {emacs18} {
    if {$tkVersion >= 3.3} {
      button .q -text Quit -command {exit 0}
    } {
      button .q -text Quit -command {catch "destroy ."; catch "exit 0"}
    }
    tkemacs .f -command {TkEmacs -i -rn TKEMACS -geometry $geometry -l $lispfile -tkwidget $pathName.xfl localhost $port} -name TKEMACS* -xscrollcommand {.s2 set} -yscrollcommand {.s1 set} -useadvise 1
    scrollbar .s1 -command {.f yview}
    scrollbar .s2 -orient horizontal -command {.f xview}
    pack append . .q {bottom} .s1 {right fill} .s2 {bottom fill} .f {top fill expand}
  }
  {emacs19} {
    if {$tkVersion >= 3.3} {
      button .q -text Quit -command {exit 0}
    } {
      button .q -text Quit -command {catch "destroy ."; catch "exit 0"}
    }
    tkemacs .f -command {emacs-19.15 -i -geometry $geometry -l $lispfile -tkwidget $pathName.xfl localhost $port} -xscrollcommand {.s2 set} -yscrollcommand {.s1 set} -useadvise 1
    scrollbar .s1 -command {.f yview}
    scrollbar .s2 -orient horizontal -command {.f xview}
    pack append . .q {bottom} .s1 {right fill} .s2 {bottom fill} .f {top fill expand}
  }
  {lemacs} {
    if {$tkVersion >= 3.3} {
      button .q -text Quit -command {exit 0}
    } {
      button .q -text Quit -command {catch "destroy ."; catch "exit 0"}
    }
    tkemacs .f -command {lemacs -title TKEMACS -eval (iconify-emacs) -geometry $geometry -l $lispfile -tkwidget $pathName.xfl localhost $port} -xscrollcommand {.s2 set} -yscrollcommand {.s1 set} -useadvise 1 -name TKEMACS
    scrollbar .s1 -command {.f yview}
    scrollbar .s2 -orient horizontal -command {.f xview}
    pack append . .q {bottom} .s1 {right fill} .s2 {bottom fill} .f {top fill expand}
  }
  {noreparent} {
    if {$tkVersion >= 3.3} {
      button .q -text Quit -command {.f stopemacs; exit 0}
    } {
      button .q -text Quit -command {.f stopemacs; catch "destroy ."; catch "exit 0"}
    }
    tkemacs .f -reparent 0 -command {TkEmacs -rn TKEMACS -geometry 20x20+10+10 -l $lispfile -tkwidget $pathName.xfl localhost $port} -name TKEMACS*
    pack append . .q {bottom}
  }
  {default} {
    if {$tkVersion >= 3.3} {
      button .q -text Quit -command {exit 0}
    } {
      button .q -text Quit -command {catch "destroy ."; catch "exit 0"}
    }
    tkemacs .f -command {TkEmacs -i -rn TKEMACS -geometry $geometry -l $lispfile -tkwidget $pathName.xfl localhost $port} -name TKEMACS* -xscrollcommand {.s2 set} -yscrollcommand {.s1 set} -useadvise 1
    scrollbar .s1 -command {.f yview}
    scrollbar .s2 -orient horizontal -command {.f xview}
    pack append . .q {bottom} .s1 {right fill} .s2 {bottom fill} .f {top fill expand}
  }
}

wm maxsize . 1000 1000

# eof

