# call of the printer driver dvips with the file $main_file,
#                                                    output into $prt_file
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen

proc prt_dvips {f austext} {

  upvar 1 $austext a

  global vv main_file prtoptions pg_start pg_end prmsel prt_file opsep printcops

  writescr $f ""
  set a ""

  writescr $f "[datime] $vv(dta1) \"dvips\" $vv(dta2)\n"

  set opt1 "[lindex [split $prtoptions $opsep] 1] -c $printcops"
  set opt2 "[lindex [split $prtoptions $opsep] 2]"

  set opt_seiten ""  
  if { $pg_start=="$vv(dmstart)" } {set start 1}   else {set start $pg_start}
  if { $pg_end=="$vv(dmend)" }    {set ende 9999} else {set ende  $pg_end}

  if { $start>$ende } { set a "\n***$vv(dterr)  $start>$ende\n\n"; bell; return 1 }

  if { ($prmsel == "rel") || ($prmsel == "abs") } {# von ... bis ... alle Seiten 

    if { $prmsel == "rel" }        { set ar "=" } else { set ar "" }
    if { $pg_start != "$vv(dmstart)" }  { set opt_seiten "$opt_seiten -p $ar$start" }
    if { $pg_end != "$vv(dmend)" }     { set opt_seiten "$opt_seiten -l $ar$ende"  }
    eval mkCmd_wait $f dvips [list "$opt1 $opt2 $opt_seiten -o $prt_file $main_file"]

  } elseif { ($prmsel == "u_abs") || ($prmsel == "g_abs") } {# nur gerade bzw. ungerade

    if { $pg_start != "$vv(dmstart)" } {
      if { $prmsel == "u_abs" }  { set start [expr "(($start/2)*2)+1"] }
      if { $prmsel == "g_abs" }  { set start [expr "(($start+1)/2)*2"] }
      set opt_seiten "$opt_seiten -p $start"
    }
    if { $pg_end != "$vv(dmend)" } {
      if { $prmsel == "u_abs" }  { set ende  [expr "((($ende+1)/2)*2)-1"] }
      if { $prmsel == "g_abs" }  { set ende  [expr "($ende/2)*2"] }
      set opt_seiten "$opt_seiten -l $ende"
    }
    if { $prmsel == "u_abs" }  { set opt_seiten "$opt_seiten -A" }
    if { $prmsel == "g_abs" }  { set opt_seiten "$opt_seiten -B" }
    if { $start>$ende } { set a "${a}$serr $start>$ende\n\n"; bell; return 1 }

    eval mkCmd_wait $f dvips [list "$opt1 $opt2 $opt_seiten -o $prt_file $main_file"]

  } elseif { ($prmsel == "a5buchvorder") } {

    eval mkCmd_wait $f dvidvi [list "-m \"4:-1,2(148mm,0mm)\" $main_file tmp.dvi"]
    eval mkCmd_wait $f dvips  [list "$opt1 $opt2 -t landscape -o $prt_file tmp.dvi"]
    unlink -nocomplain tmp.dvi

  } elseif { ($prmsel == "a5buchrueck") } {

    eval mkCmd_wait $f dvidvi [list "-m \"4:-3,0(148mm,0mm)\" $main_file tmp.dvi"]
    eval mkCmd_wait $f dvips  [list "$opt1 $opt2 -t landscape -o $prt_file tmp.dvi"]
    unlink -nocomplain tmp.dvi

  } elseif { ($prmsel == "verkleinern2") } {

    eval mkCmd_wait $f dvidvi [list "-f $start -l $ende $main_file tmp.1.dvi"]
    eval mkCmd_wait $f dvidvi [list "-m \"2:0,1(210mm,0mm)\" tmp.1.dvi tmp.dvi"]
    unlink -nocomplain tmp.1.dvi
    eval mkCmd_wait $f dvips  [list "$opt1 $opt2 -x 707 -t landscape -o $prt_file tmp.dvi"]
    unlink -nocomplain tmp.dvi

  } elseif { ($prmsel == "verkleinern4") } {

    eval mkCmd_wait $f dvidvi [list "-f $start -l $ende $main_file tmp.1.dvi"]
    eval mkCmd_wait $f dvidvi [list "-m \
      \"4:0(-25mm,-25mm),1(185mm,-25mm),2(-25mm,267mm),3(185mm,267mm)\" \
      tmp.1.dvi tmp.dvi"]
    unlink -nocomplain tmp.1.dvi
    eval mkCmd_wait $f dvips  [list "$opt1 $opt2 -x 500 -o $prt_file tmp.dvi"]
    unlink -nocomplain tmp.dvi

  } else {       # error: unexpected value of $prmsel 

    set a "${a}*** $vv(pra1) (prt_dvips.tcl): $vv(dt1) \"$prmsel\"\n"
    set a "${a}    $vv(pra2)\n\n"
    bell; return 1
    set opt_seiten "$opt_seiten -p =$start"
    set opt_seiten "$opt_seiten -l =$ende"
    eval mkCmd_wait $f dvips [list "$opt1 $opt2 $opt_seiten -o $prt_file $main_file"]

  }

  return 0

}
