# Aufrumen   
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen

proc akanzeigen {s1} {
  global vv aufmax aufsuff auftoggle
  writescr0 .ak.d.tt "$s1\n\n" \
                    " $vv(ak2)  $aufmax\n" \
                    " $vv(ak3)  $aufsuff\n" \
                    " $vv(ak4)  $auftoggle\n\n"
  .ak.d.tt yview 0
}


proc clear {f} {

global  vv hlp_dir  auftoggle aufsuff sub
global  h delsuff nmax deldat dd dmax dmaxmax daus aufmax df df1 df2
   

toplevel .ak
wm title .ak "$vv(akvor)"
wm minsize .ak 0 0


set tyh 18
set dir [pwd]

writescr0 $f ""


# Bereich a fuer erste Buttons

frame .ak.a -relief raised -borderwidth 1
pack configure .ak.a -in .ak -pady 10 -anchor w
 
button .ak.a.e -text "$vv(ae)"
bind   .ak.a.e <Button-3> {cat_file0 "${hlp_dir}rm_quit.hlp" .ak.d.tt}
button .ak.a.h -text "$vv(ah)" 
bind   .ak.a.h <Any-Button> {cat_file0 "${hlp_dir}rm_h.hlp" .ak.d.tt}
button .ak.a.l -text "$vv(al)" -command {clearscr .ak.d.tt}
bind   .ak.a.l <Button-3> {cat_file0 "${hlp_dir}z_loeschetf.hlp" .ak.d.tt}
button .ak.a.g -text "$vv(ag)" -command {
  set foid [open_vst default.vst]
  while { [getscl $foid ein] > 0 } {
    mtest $ein 19 aufmax
    mtest $ein 19 aufsuff
    mtest $ein 19 auftoggle
  }
  close $foid
  destroy .ak
  clear .d.tt     
  akanzeigen "$vv(ausg1)"
  bind .ak.a.e <Button-1> {+ destroy .ak; unlock_list}
}
bind   .ak.a.g <Button-3> {cat_file0 "${hlp_dir}rm_grund.hlp" .ak.d.tt}
pack configure .ak.a.e .ak.a.h .ak.a.l .ak.a.g -in .ak.a -side left -padx 3 -pady 3


# Bereich b fuer Anzeigen   

frame .ak.b
bind  .ak.b <Button-3> {cat_file0 "${hlp_dir}rm_anzeig.hlp" .ak.d.tt}
pack configure .ak.b -in .ak -pady 13 -anchor w

label .ak.b.dv -text "$vv(bdv)  $dir" -width 90 -anchor w
bind  .ak.b.dv <Button-3> {cat_file0 "${hlp_dir}rm_anzeig.hlp" .ak.d.tt}
pack configure .ak.b.dv -in .ak.b


# Bereich c fuer Suffix- und Datei-Listen    

frame .ak.c
pack configure .ak.c -in .ak -anchor w

frame .ak.c.1
frame .ak.c.2
  
pack configure .ak.c.1  -in .ak.c -side left -fill x -ipadx 20
pack configure .ak.c.2 -in .ak.c -side right -fill x -ipadx 120


# Bereich c1 fuer Suffix-Liste     

label .ak.c.1.g -text "$vv(akc1g)" -anchor n
bind  .ak.c.1.g <Button-3> {cat_file0 "${hlp_dir}rm_suffix.hlp" .ak.d.tt}
frame .ak.c.1.fr 
pack configure .ak.c.1.g -in .ak.c.1 -anchor n 
pack configure  .ak.c.1.fr -in .ak.c.1 -anchor n 

set nmax [llength $aufsuff]
set n 0

while { $n < $nmax } {
  checkbutton .ak.c.1.fr.cb$n -borderwidth 1 -variable v(.ak.c.1.fr.cb$n) \
      -text "  [lindex $aufsuff $n] " -width 10 -anchor w
  pack configure  .ak.c.1.fr.cb$n -in .ak.c.1.fr 
  bind .ak.c.1.fr.cb$n <Button-3> {cat_file0 "${hlp_dir}rm_suffix.hlp" .ak.d.tt}
  set delsuff(.ak.c.1.fr.cb$n) [lindex $aufsuff $n]
  set h(.ak.c.1.fr.cb$n) [lindex $auftoggle $n]
  if {  $h(.ak.c.1.fr.cb$n) == 1 } {
    .ak.c.1.fr.cb$n select 
  } else {
    .ak.c.1.fr.cb$n deselect
  }
  incr n 1 
}

set daus 0
set n 0
while { $n < $nmax } {
  bind .ak.c.1.fr.cb$n <Button-1> {
     tk_butDown %W
    if { $h(%W) == 1 } {
      set h(%W) 0
    } else {
      set h(%W) 1
    }
    set dmax 0
    while { $dmax < $dmaxmax } {
      if { [string match "$delsuff(%W)" $deldat($dmax)] } {
        if { ($dd($dmax) == 0) || ($dd($dmax) == 1) } {
          set dd($dmax) $h(%W)
        }
      }
      incr dmax 1
    }
    .ak.c.2.fr.li delete 0 end 
    set daus 0
    set dmax 0
    set df1 -1
    set df2 -1
    while { $dmax < $dmaxmax } {  
      if { $dd($dmax) == 1 } {
        if { $df1 == -1 } {set df1 $dmax}
        if { $daus < $aufmax } {
          .ak.c.2.fr.li insert end $deldat($dmax)
          incr daus 1
          set df2 $dmax
        } 
      }
      incr dmax 1
    }
  }
  incr n 1
}


# Bereich c2 fuer Datei-Anzeige

button .ak.c.2.ad -width 39 -text "$vv(akc2ad)" 
bind   .ak.c.2.ad <Button-3> {cat_file0 "${hlp_dir}rm_files.hlp" .ak.d.tt}
frame  .ak.c.2.fr -borderwidth 2 
pack configure .ak.c.2.ad .ak.c.2.fr -in .ak.c.2

listbox .ak.c.2.fr.li -relief raised -geometry 35x$aufmax
bind    .ak.c.2.fr.li <Button-3> {cat_file0 "${hlp_dir}rm_files.hlp" .ak.d.tt}
pack configure .ak.c.2.fr.li -in .ak.c.2.fr -side left


# Bereich d fuer Hilfe-Ausgaben

frame .ak.d -relief raised -borderwidth 2
pack configure .ak.d -in .ak -anchor sw -pady 6

scrollbar .ak.d.sb -command ".ak.d.tt yview"
bind      .ak.d.sb <Button-3> {+ cat_file0 "${hlp_dir}z_textfeld.hlp" .ak.d.tt}
text      .ak.d.tt -yscroll ".ak.d.sb set" -height $tyh 
bind      .ak.d.tt <Button-3> {+ cat_file0 "${hlp_dir}z_textfeld.hlp" .ak.d.tt}
pack configure .ak.d.sb .ak.d.tt -in .ak.d -side right -fill y
.ak.d.tt configure -state disabled


# Erstellen Dateiliste fr Lschen

set dmax 0

# Datei "core" als Lschkandidat
set dirliste [lsort [glob -nocomplain -- *]]
foreach i $dirliste {
  if { [file isfile $i] && [string match "core" $i] } {
    set deldat($dmax) $i
    set dd($dmax) 1
    incr dmax 1
  } 
}

# Dateien mit allen gesetzten Suffixen der Liste als Lschkandidaten
set n 0
while { $n < $nmax } {
  foreach i $dirliste {
    if [file isdirectory $i] {
    } elseif { [string match "$delsuff(.ak.c.1.fr.cb$n)" $i] } {
      set deldat($dmax) $i
      if { $h(.ak.c.1.fr.cb$n) == 1 } {
        set dd($dmax) 1
      } else {set dd($dmax) 0}
      incr dmax 1
    } 
  }
  incr n 1
}
set dmaxmax $dmax


# Ausgabe der zum Loeschen vorgesehenen Dateien

.ak.c.2.fr.li delete 0 end 
set daus 0
set dmax 0
set df1 -1
set df2 -1
while { $dmax < $dmaxmax } {  
  if { $dd($dmax) == 1 } {
    if { $df1 == -1 } {set df1 $dmax}
    if { $daus < $aufmax } {
      .ak.c.2.fr.li insert end $deldat($dmax)
      incr daus 1
      set df2 $dmax
    }
  }
  incr dmax 1
}


#Bind fuer Datei-Selektion

focus .ak.c.2.fr.li
bind  .ak.c.2.fr.li <Triple-Button-1> { }
bind  .ak.c.2.fr.li <Double-Button-1> {
  set ii [catch {selection get} i]
  selection clear %W
  if {$ii == 0} { 
    set df $df1
    while { $df <= $df2 } {
      if { [string match "$deldat($df)" $i] } {
        set dd($df) -1
      }
      incr df 1
    }
    .ak.c.2.fr.li delete 0 end
    set df $df1
    while { $df <= $df2 } {
      if { $dd($df) == 1 } {
       .ak.c.2.fr.li insert end $deldat($df)
      }
      incr df 1
    }
  }
}


# bind fuer Datei-Lschen

bind .ak.c.2.ad <Button-1> {+
  if { $df1 < 0 } {
    writescr .ak.d.tt "$vv(ak5)\n"
  } else {
    set df $df1 
    writescr0 .ak.d.tt "$vv(ak6)"  
    while { $df <= $df2 } {
      if { $dd($df) == 1 } {
        writescr .ak.d.tt "\n $deldat($df)"
        if { [file writable $deldat($df)] == 1 } {
          unlink -nocomplain $deldat($df)
        } else {
          writescr .ak.d.tt "  $vv(ak7)"
        }
        set dd($df) -2  
      }
      incr df 1
    }
    writescr .ak.d.tt "\n"
    .ak.c.2.fr.li delete 0 end 
    set dmax $df2
    set daus 0
    set df1 -1
    set df2 -1
    while { $dmax < $dmaxmax } {  
      if { $dd($dmax) == 1 } {
        if { $df1 == -1 } {set df1 $dmax}
        if { $daus < $aufmax } {
          .ak.c.2.fr.li insert end $deldat($dmax)
          incr daus 1
          set df2 $dmax
        }
      }
      incr dmax 1
    }
  }
}

bind .ak.a.e <Button-1> {+
  set auftoggle ""
  set n 0
  while { $n < $nmax } {
   lappend auftoggle  $v(.ak.c.1.fr.cb$n)
   incr n 1
  }
}

}
