' $Id$
.TH pie tk
.BS
.SH NAME
pie \- pie with slices class
.SH SYNOPSIS
\fBnew pie \fIparentPathName width height ?thickness? ?topColor? ?edgeColor? ?highlightMode?\fR
.in
\fBdelete pie \fIpieId\fR
.SH DESCRIPTION
.PP
A pie object is used to visualize a set of values, usually as shares of a total. Each value is represented by a colored slice, which may have a 2 dimensional or 3 dimensional look with a thick edge. Each slice is associated with a label containing text describing the meaning of the value, next to a numerical field showing the percentage taken by the slice. The labels are arranged in 2 columns below the pie graphics. Each label color matches its related slice.
.PP
The \fBpie\fR constructor creates a frame widget, which contains a canvas for displaying the pie itself and its slices, and one colored label widget per slice. The frame widget has \fIparentPathName\fR argument as parent widget The \fBnew pie\fR instruction returns a unique object identifier, later used for creating slices, resizing them and ultimately deleting the pie object itself, using the \fBdelete pie\fR instruction. At the time the pie is created, the \fIparentPathName\fR widget must exist.
.PP
When deleted, the pie frame, canvas and all related Tk widgets are destroyed.
.SH CREATION PARAMETERS
.PP
The constructor takes several arguments: the parent window, the pie sizes, some color options and the slice highlighting mode.
.PP
The parent window pathname is used when creating all the child widgets that the pie object manages, such as a frame that itself contains a canvas and label widgets.
.PP
The graphical part of the pie is defined using the size parameters. The width and height parameters define the elliptical shape of the pie. The thickness is optional and set to 0 by default, giving the pie a simple 2D shape, faster to display. A positive thickness value will give the pie a 3D look with matched darker colors for the slices edges. These values may be specified in any of the forms described in the SIZES section below.
.PP
Slices may or may not fill up the 100% of the pie. The unoccupied part of the pie is by default transparent, taking the pie frame color as background color. The unoccupied part top and edge (when 3D) colors may be set by the user using color names as in the \fB-background\fR standard option (see the \fBoptions\fR man page for more details). Transparent colors are handled by passing an empty string as the color parameter.
.PP
Slices colors are automatically generated by the pie object. When a 3D look is used, the slice edge is darker than its top and uses the same color tone. However, if the number of slices is too big, identical colors will be used for some of the slices. In this case and by default, automatic pointer highlighting is used to help the user figure which slice is related to what label and its value. Moving the pointer on any visible part of a slice with highlight the slice and its corresponding label with a black border. This behaviour may be disabled by passing \fB0\fR, \fBoff\fR, \fBfalse\fR or \fBno\fR as the \fIhighlightMode\fR parameter. Passing \fB1\fR, \fBon\fR, \fBtrue\fR or \fByes\fR permanently enables the highlighting mode. Passing \fBauto\fR is the default mode.
.SH GEOMETRY MANAGEMENT
.PP
The geometry manager (packer, placer, ...) can access the pie object frame member, as in:
.PP
\fBpack\fR \fB$pie(\fI$pieId\fB,frame)\fR
.PP
where \fIpieID\fR was returned by a previous \fBnew pie\fR instruction.
.SH SLICE CREATION
.PP
Slices are created using:
.PP
\fBpie::newSlice \fIpieId ?labelText?\fR
.PP
The slice color is automatically allocated and the slice label and its current slice size in % is placed within one of the 2 labels columns below the pie graphics. The slice itself is placed after (clockwise) the existing slices. A unique slice integer object identifier is returned: it will be used for sizing and resizing the slice.
.PP
If the label text is not specified, it will be set to "slice n", n being the number of the slice in the order of creation (first slice is number 1).
.SH SLICE RESIZING
.PP
Slices are sized and resized using:
.PP
\fBpie::sizeSlice \fIpieId sliceId perCent\fR
.PP
The slice is then automatically recalculated so it occupies the proper percentage of the whole pie. The slice size value next to the slice label is also updated. The \fIperCent\fR parameter is a floating point number expressed in percent of the whole pie. The following slices (clockwise) are moved to accomodate the new slice size.
.SH SIZES
.PP
All sizes related to pies are stored as floating-point numbers. The \fIwidth\fR, \fIheight\fR and \fIthickness\fR constructor parameters are specified in screen units, which are floating-point numbers optionally followed by one of several letters as specified in the \fBcanvas\fR COORDINATES man section.
.SH LIMITATIONS
There is no way to delete a slice.
.in
Pie resizing is not implemented (maybe when and if \fBcanvas\fR coordinate system scaling is implemented).
.in
Slice highighting is slow.
.PP
.SH KEYWORDS
.PP
pie, slice, new, delete
