# ============================================================================
# mainwin.tcl
# build up main widgets except canvas window.
# ============================================================================
# 

# mainwin:create --
# Args -
#  maped - global data structure
#  w - toplevel widget name (default is nil)
# SideEfects -
#  (1) set up default resources for main frames.
#  (2) create and pack main frames.
#  (3) call create procs for any widgets.
proc mainwin:create {maped {w {}}} {
    upvar #0 $maped data
    if {$w == {}} {set w {}}
    # Default Resources.
    option add *[string trimleft $w.Frame.relief .] raised widgetDefault
    option add *[string trimleft $w.Frame.borderWidth .] 2 widgetDefault
    option add *[string trimleft $w.body.borderWidth .] 0 widgetDefault
    option add *[string trimleft $w.body.highlightThickness .] 0 widgetDefault
    option add *[string trimleft $w.body.relief .] flat widgetDefault
    option add *[string trimleft $w.body.borderWidth .] 0 widgetDefault

    # create main frames...
    frame $w.mbar 
    frame $w.body
    frame $w.url
    frame $w.alt
    frame $w.text

    # and pack them.
    pack $w.mbar $w.url $w.alt -side top -fill x
    pack $w.body -side top -fill both -expand true
    pack $w.text -side bottom -fill x

    # create each windows under main frames.
    mbar:create $maped $w.mbar;  # create menu bar
    canvas:create $maped $w.body; # create canvas windows
    lineed:create $w.url url; # create URL edit windows
    lineed:create $w.alt alt; # create ALT edit windows
    message:create $maped $w.text;  # create message windows
}



