#!/bin/sh
# ###############################################
# anicon.tcl : animation icon library ver 0.2
# Usage:
# anicon:setup t w icons delay ?args?
# t - top level widget which iconified.
# w - widget name
# icons - list of image
# delay - delay [msec]
# args - option(s) for $w.lable widget
# Side Efect:
# add binding to . for <Unmap> and <Map> event.
# ############################################### \
	exec wish4.1 -f $0 ${1+"$@"}
# ###############################################
# Global variables 
# ###############################################
# setup proc. see header.
proc anicon:setup {t w icons delay args} {
    global $t:counter;    # flame no.
    global $t:flag;       # control flag.

    set $t:flag stop
    set $t:counter 0

    toplevel $w ;             # cleate top level widget for display icon
    eval label $w.label $args \
	    -image [lindex $icons 0]; # create icon widget, and set 1st flame.
    pack $w.label;            # packing icon widgget
    wm iconwindow $t $w;      # setup icon widget
    set anicon:counter 1;     # Next flame.
    bind $w.label <Enter> +[list anicon:start \
	    $t $w.label $icons $delay]
    bind $w.label <Leave> +[list anicon:stop $t]
    bind $w.label <Unmap> +[list anicon:stop $t]; # if deiconify then set stop flag.
}
# start animation
proc anicon:start {t w icons delay} {
    global $t:flag;       # control flag.
    set $t:flag start;    # start animation
    anicon:animate $t $w $icons $delay
}

# back ground task proc.
proc anicon:animate {t w icons delay} {
    global $t:counter;    # flame no.
    global $t:flag;       # control flag.
    if {[set $t:flag] != "start" } {
	return;                       # if stop flag is true then stop.
    }
    if {[set $t:counter] >= [llength $icons]} {
	set $t:counter 0
    }
    after $delay;                  # wait
    $w configure -image [lindex $icons \
	    [set $t:counter]];    # display next flame.
    incr $t:counter
    update;                        # update windows
    after idle [list anicon:animate $t $w $icons $delay]; # recursive call;-)
}

proc anicon:stop {t} {
    global $t:flag ;            # control flag.
    set $t:flag stop
}

# test proc
proc anicon:test {} {
    # set rsource *iconFileList. it's a list of icons. 
    option add "*iconFileList" {
	./earth0.ppm ./earth1.ppm ./earth2.ppm ./earth3.ppm 
	./earth4.ppm ./earth5.ppm ./earth6.ppm ./earth7.ppm
	./earth8.ppm ./earth9.ppm ./earthA.ppm ./earthB.ppm
    }

    set imgList {}
    foreach i [option get . iconFileList {}] {
	lappend imgList [image create photo -file $i]
    }

    anicon:setup . .icon $imgList 500 -highlightthickness 0

    button .b -text "Exit" -command exit
    pack .b
}
# if you want test this file, uncomment next line, and execute this file.
# anicon:test	    
