#!@WISHPATH@ -f
# Copyright (c) 1994 Takeshi Taguchi (taguchi@aic.co.jp).
# All rights reserved.
# Permission is hereby granted, without written agreement and without
# license or royalty fees, to use, copy, modify, and distribute this
# software and its documentation for any purpose, provided that the
# above copyright notice and the following two paragraphs appear in
# all copies of this software.

# ǥեȤΥե
set iconBitmapFile {./tkmapedit.xbm}
set selectPixmap {./arrow.xpm}
set defPixmap {./def.xpm}
set circlePixmap {./circle.xpm}
set rectanglePixmap {./box.xpm}
set polygonPixmap {./polygon.xpm}

# ============================================================================
# ꥽Ϣ饤֥
# ============================================================================
# envVal envValName
#   Ķѿ envValName դ֤ͤ¸ߤʤ
#   {} ֤
proc envVal {envValName} {
  global env
  if [info exists env($envValName)] {return $env($envValName)} {return {}}
}

# loadAppDefaults classNameList ?priority?
#   Searches for the app-default files corresponding to classNames in
#   the order specified by X Toolkit Intrinsics (R5), and loads them with
#   the priority specified (default: startupFile).
proc loadAppDefaults {classNameList {priority startupFile}} {
    set filepath "\
	    /usr/X11R6/lib/X11/app-defaults \
	    [split [envVal XFILESEARCHPATH] :] \
	    [split [envVal XAPPLRESDIR] :] \
	    [split [envVal XUSERFILESEARCHPATH] :] \
	    [envVal HOME]/app-defaults \
	    "
    foreach i $classNameList {
	foreach j $filepath {
	    if {[file exists $j/$i]} {
		option readfile $j/$i $priority;
	    }
	}
    }   
}
# loadXDefaults classNameList ?priority? ?defaultsFile?
#   ~/.Xdefaults  className ˴ؤ꥽ɤ߹ࡥ
proc loadXDefaults {classNameList {priority userDefault} \
	{defaultsFile ".Xdefaults"}} {
    set xdefaults "[envVal HOME]/$defaultsFile"
    if {[file exists $xdefaults]} {
	set pattern "^[lindex $classNameList 0]"
	foreach i [lrange $classNameList 1 end] {
	    set pattern "$pattern|^$i"
	}
	set fp [open $xdefaults]
	while {[gets $fp line] >= 0} {
	    if {[regexp $pattern $line]} {
		regsub $pattern $line {} line
		if {[regsub {\\$} $line {} line]} {
		    while {[gets $fp next] >= 0 && \
			    ![regsub {\\$} $next {} next]} {
			regsub "^\[\t \]*" $next {} next
			set line "$line$next"
		    }
		}
		if {[regexp {(.*):(.*)} $line line resName resValue]} {
		    regsub -all "^\[\t\ \]*" $resValue {} resValue
		    option add [winfo name .] $resValue $priority
		}
	    }
	}
    }
}

# --------------------------------------------------------------------
# Resource ɤ߹
# --------------------------------------------------------------------
# Read resource definition.
set ClassName [winfo name .]
option clear
loadAppDefaults "$ClassName TkMapedit"
loadXDefaults "$ClassName TkMapedit"

# =====================================================================
# ǽ꥽
# tkmapedit Ѥ꥽ϡʲ̤:
# ꥽̾                  |ǥե         |  
# ----------------------------+---------------------+----------------------- 
# *tkLibDir                   |/usr/X11R6/lib/tk    | ե饤֥̾
# *htmlDocumentURL            |./doc/tkmapedit.html | ɥURL 
# *viewer                     |Mosaic               | ѤW3Client
# *iconBitmap                 |./tkmapedit.xbm      | ե
# *select.bitmap              |./arrow.xpm          | selectܥbitmap
# *default.bitmap             |./def.xpm            | defaultܥbitmap
# *circle.bitmap              |./circle.xpm         | circleܥbitmap
# *rectangle.bitmap           |./box.xpm            | rectangleܥbitmap
# *polygon.bitmap             |./polygon.xpm        | polygonܥbitmap
# *editPlane.selectForeground |blue                 | ֥ɽ
# *editPlane.handleForeground |green                | ϥɥɽ
# *editPlane.selectWidth      |3                    | 
# *editPlane.itemWidth        |1                    | ɸ
# *editPlane.itemForeground   |blue                 | ɸɽ
# =====================================================================

# --------------------------------------------------------------------
# fileΥեɤ߹
# ǥեȤǤϡgarfield@cs.tu-berlin.de (Sven Delmas)  FSBox
# <URL:ftp://ftp.aud.alcatel.com/tcl/code/FSBox.tar.gz> б
# --------------------------------------------------------------------
option add $ClassName*tkLibDir "/usr/X11R6/lib/tk" widgetDefault
if {[envVal TK_LIBRARY] != {}} {
    source [envVal TK_LIBRARY]/FSBox.t
} elseif {[file exists [option get . tkLibDir Text]/FSBox.t]} { 
    source [option get . tkLibDir Text]/FSBox.t
}

# --------------------------------------------------------------------
# ɥޥ͡
# --------------------------------------------------------------------
option add $ClassName*version "1.3" widgetDefault
option add $ClassName*iconBitmap $iconBitmapFile widgetDefault
wm title . "$argv0 [option get . version Text]"
wm minsize . 0 0
wm iconbitmap . "[option get . iconBitmap Text]"

# --------------------------------------------------------------------
# ¾
# --------------------------------------------------------------------
option add $ClassName*viewer "Mosaic" widgetDefault
option add $ClassName*htmlDocumentURL "./doc/tkmapedit.html" widgetDefault

# Window structures.
# 1) Top level.
# +-----------------------------------+
# |frame .mbar                        | <- .  (topLevel)
# +-----------------------------------+
# |frame .body                        |
# |                                   |
# +-----------------------------------+
# |frame .url                         |
# +-----------------------------------+  
# |frame .text                        |
# +-----------------------------------+
option add $ClassName*mbar.borderWidth 2 widgetDefault
option add $ClassName*mbar.relief raised widgetDefault
option add $ClassName*url.borderWidth 2 widgetDefault
option add $ClassName*url.relief raised widgetDefault
option add $ClassName*text.borderWidth 2 widgetDefault
option add $ClassName*text.relief raised widgetDefault
frame .mbar
frame .body 
frame .url
frame .text
pack .mbar -side top -fill x
pack .body -side top -fill both -expand yes
pack .url .text -side top -fill x

# 2) frame .mbar 
# +---------------------------------------+
# |File  Edit                    Test Help|
# +---------------------------------------+ 
#   |      |               |           |
#   |      V               V           |
#   V .mbar.edit.menu .mbar.test.menu  V
# .mbar.file.menu            .mbar.help.menu
option add $ClassName*mbar.file.text "File" widgetDefault 
option add $ClassName*mbar.edit.text "Edit" widgetDefault 
option add $ClassName*mbar.test.text "Test" widgetDefault 
option add $ClassName*mbar.help.text "Help" widgetDefault 
option add $ClassName*mbar*underline 0 widgetDefault 
menubutton .mbar.file -menu .mbar.file.menu
menubutton .mbar.edit -menu .mbar.edit.menu
menubutton .mbar.test -menu .mbar.test.menu
menubutton .mbar.help -menu .mbar.help.menu
pack .mbar.file .mbar.edit -side left
pack .mbar.help .mbar.test -side right

# 2-1) File Menu definition.
# +----------+
# |New       |
# |LoadConfig| 
# |LoadImage |
# |Save      |
# |Save As   |
# |Print     |
# |----------|
# |Exit      |
# +----------+
set curConfigFile {}
set curImageFile {}
menu .mbar.file.menu
.mbar.file.menu add command -label "New" -command {new .editPlane} -underline 0
.mbar.file.menu add command -label "Load Config" -underline 5 \
	-command {set curConfigFile [FSBox]; \
	loadConfig .editPlane $curConfigFile} 
.mbar.file.menu add command -label "Load Image" -underline 5 \
	-command {set curImageFile [FSBox]; \
	loadImage .editPlane $curImageFile}
.mbar.file.menu add command -label "Save" -underline 0 \
	-command {set curConfigFile [save .editPlane $curConfigFile]}
.mbar.file.menu add command -label "Save As" -underline 5 \
	-command {set curConfigFile [save .editPlane]}
.mbar.file.menu add separator
.mbar.file.menu add command -label "Exit" -command exit  -underline 1

# 2-2) Edit Menu definition.
# +----------+
# |Delete    |
# |Cut       |
# |COpy      |
# |Paste     |
# +----------+
menu .mbar.edit.menu
.mbar.edit.menu add command -label "Delete" \
	-command {deleteObj .editPlane} -underline 0
.mbar.edit.menu add command -label "Cut" \
	-command {cutObj .editPlane} -underline 0
.mbar.edit.menu add command -label "Copy" \
	-command {copyObj .editPlane}  -underline 1
.mbar.edit.menu add command -label "Paste" \
	-command {pasteObj .editPlane}  -underline 0

# 2-3) Test ˥塼
# +--------+
# |Test  |
# +--------+
menu .mbar.test.menu
.mbar.test.menu add checkbutton -label "Test" -variable "_test_" \
	-command {setUpTestMode .editPlane $_test_} -underline 0
set _test_ 0

# 2-4) Help Menu definition.
# +--------+
# |Help    |
# +--------+
menu .mbar.help.menu
.mbar.help.menu add command -label "Help" -underline 0 \
	-command {help [option get . viewer Text] [option get . htmlDocumentURL Text]} 

# 2-5) Buid up menu bar
tk_menuBar .mbar .mbar.file .mbar.edit .mbar.help

# 3) Body parts
# +-----+-----------------------------+
# |.bbar|.canvas                      |
# |     |                             |
# +-----+-----------------------------+
# .bbar  : Խоѥܥե졼
# .canvas: Хե졼 
option add $ClassName*bbar.borderWidth 2 widgetDefault
option add $ClassName*bbar.relief raised  widgetDefault
frame .bbar
frame .canvas
pack .bbar -side left -in .body -fill y 
pack .canvas -side right -fill both -expand yes -in .body

# 3-1) Խоѥܥե졼
option add $ClassName*select.bitmap "@$selectPixmap" widgetDefault 
option add $ClassName*default.bitmap "@$defPixmap" widgetDefault 
option add $ClassName*circle.bitmap "@$circlePixmap" widgetDefault 
option add $ClassName*rectangle.bitmap "@$rectanglePixmap" widgetDefault 
option add $ClassName*polygon.bitmap "@$polygonPixmap" widgetDefault 
option add $ClassName*bbar*Radiobutton.anchor "w" widgetDefault
radiobutton .select -variable mode(Item) -value {none} \
	-command {selectButtonProc .editPlane}
radiobutton .default -variable mode(Item) -value {default} \
	-command {defaultButtonProc .editPlane}
radiobutton .circle -variable mode(Item) -value {circle} \
	-command {circleButtonProc .editPlane}
radiobutton .rectangle -variable mode(Item) -value {rectangle} \
	-command {rectangleButtonProc .editPlane}
radiobutton .polygon -variable mode(Item) -value {polygon} \
	-command {polygonButtonProc .editPlane}
pack .select .default .circle .rectangle .polygon -side top -in .bbar
set mode(CMD) {none}
set mode(Item) {none}

# 3-2) Х
option add $ClassName*editPlane.relief raised widgetDefault
option add $ClassName*editPlane.borderWidth 2 widgetDefault
option add $ClassName*editPlane.selectForeground blue widgetDefault
option add $ClassName*editPlane.handleForeground green widgetDefault
option add $ClassName*editPlane.selectWidth 3 widgetDefault
option add $ClassName*editPlane.itemWidth 1 widgetDefault
option add $ClassName*editPlane.itemForeground blue widgetDefault
canvas .editPlane -xscrollcommand ".xscroll set" \
	-yscrollcommand ".yscroll set"
scrollbar .xscroll -orient horizontal -command ".editPlane xview"
scrollbar .yscroll -orient vertical -command ".editPlane yview"
pack .xscroll -in .canvas -side bottom -fill x
pack .yscroll -in .canvas -side right -fill y
pack .editPlane  -in .canvas -expand yes -fill both -side top
set selectForeground [option get .editPlane selectForeground Background]
set handleForeground [option get .editPlane handleForeground Background]
set selectWidth [option get .editPlane selectWidth BorderWidth]
set itemForeground [option get .editPlane itemForeground Background]
set itemWidth [option get .editPlane itemWidth BorderWidth] 

# 4) url part
option add $ClassName*label.text {URL:} widgetDefault
option add $ClassName*entry.relief flat widgetDefault
option add $ClassName*entry.borderWidth 2 widgetDefault
label .label
entry .entry -state disabled
pack .label -side left -in .url
pack .entry -side right -fill x -expand yes -in .url

# 5) å
option add $ClassName*bitmap.bitmap "" widgetDefault
option add $ClassName*bitmap.text "" widgetDefault
option add $ClassName*bitmap.borderWidth 2 widgetDefault
option add $ClassName*bitmap.relief flat widgetDefault
option add $ClassName*message.borderWidth 2 widgetDefault
option add $ClassName*message.relief flat widgetDefault
option add $ClassName*message.state disabled widgetDefault
option add $ClassName*message.height 2 widgetDefault
label .bitmap
text .message
pack .bitmap -side left -in .text -fill y
pack .message -side right -fill x -expand yes -in .text

# ====================================================================
# ϵǽ
# ====================================================================
# -------------------------------------------------------------------
# new {w} : ХõƤ֤˥åȤ
# -------------------------------------------------------------------
proc new {w} {
    global mode curConfigFile curImageFile _id_ _test_
    $w delete all
    set _id_ 0
    set _test_ 0
    set mode(CMD) {none}
    set mode(Item) {none}
    set curConfigFile ""
    set curImageFile ""
}

# -------------------------------------------------------------------
# postMessage {{text ""} {bitmap ""}} : text.messageɽ
# -------------------------------------------------------------------
proc postMessage {{text ""} {bitmap ""}} {
    if {$bitmap != ""} {
	catch ".bitmap configure -bitmap $bitmap"
    }
    if {$text != ""} {
	.message configure -state normal
	.message delete 1.0 end
	.message insert end $text
	.message configure -state disabled
    }
}
proc unPostMessage {} {
    .bitmap configure -bitmap ""
    .message configure -state normal
    .message delete 1.0 end
    .message configure -state disabled
}

# -------------------------------------------------------------------
# loadImage {w imageFile} : ᡼ǡɤ߹
# :w         : Хå̾ 
#      imageFile : ɤ߹।᡼ե̾
# : image֥ȤCanvas ID
# -------------------------------------------------------------------
proc loadImage {w imageFile} {
    set msg {}
    if {$imageFile != {}} {
	# ¸Υ᡼
	catch ".editPlane delete {image}"
	# ᡼ɤ߹ߡɽ
	if {[catch ".editPlane create bitmap 0 0 \
		-anchor nw -tags {image} -bitmap @$imageFile" msg]} {
	    postMessage "$msg" {error}
	    return {}
	}
	$w lower image
	$w configure -scrollregion [$w bbox all]
    }
    return $msg
}

# -------------------------------------------------------------------
# loadConfig {w confFile} : ¸mapեɤ߹
# -------------------------------------------------------------------
proc loadConfig {w confFile} {
    global URLs
    set ret 0
    if {$confFile != {}} {
	if {[catch "open $confFile" fp]} {
	    postMessage "$fp" {error}
	} else {
	    while {[gets $fp line]>=0} {
		set URL {}
		if {[regexp {default (.*)} $line line URL]} {
		    set URLs(default) $URL
		    incr ret
		} elseif {[regexp {circle \(([0-9]*),([0-9]*)\) ([0-9]*) (.*)} $line line x1 y1 r URL] || \
			[regexp {circle \(([0-9]*),([0-9]*)\) ([0-9]*) } $line line x1 y1 r]} {
		    eval createCircle $w $x1 $y1 $r $URL
		    incr ret
		} elseif {[regexp {rectangle \(([0-9]*),([0-9]*)\) \(([0-9]*),([0-9]*)\) (.*)} $line line x1 y1 x2 y2 URL] || \
			[regexp {rectangle \(([0-9]*),([0-9]*)\) \(([0-9]*),([0-9]*)\)} $line line x1 y1 x2 y2]} {
		    eval createRectangle $w $x1 $y1 $x2 $y2 $URL
		    incr ret
		} elseif {[regexp {polygon (\(.*\)*) (.*)} $line line coords URL] || \
			[regexp {polygon (\(.*\)*)} $line line coords]} {
		    regsub {\(\,\)} $coords { } coords
		    eval createPolygon $w $coords $URL
		    incr ret
		}
	    }
	    close $fp
	}
	$w configure -scrollregion [$w bbox all]
    }
    return $ret
}

# -------------------------------------------------------------------
# save {{confFile ""}} : ߤΥХƤmapե¸
# -------------------------------------------------------------------
proc save {w {confFile ""}} {
    global URLs
    while {$confFile == {}} {
	set confFile [FSBox]
    }
    if {[catch "open $confFile w" fp]} {
	postMessage "$fp" {error}
    } else {
	if {[info exist URLs(default)]} {
	    puts $fp "default $URLs(default)"
	}
	foreach i [$w find withtag {graphic}] {
	    if {[regexp {ID[0-9]*} [$w gettags $i] ID]} {
		set type [$w type $i]
		set coords [$w coords $i]
		if {[info exists URLs($ID)]} {set URL $URLs($ID)} else {set URL {}}
		if {$type == {oval}} {
		    set x1 [expr ([lindex $coords 0]+[lindex $coords 2])/2]
		    set y1 [expr ([lindex $coords 1]+[lindex $coords 3])/2]
		    set r  [expr ([lindex $coords 2]-[lindex $coords 0])/2]
		    puts $fp "circle ($x1,$y1) $r $URL"
		} elseif {$type == {rectangle}} {
		    set x1 [lindex $coords 0]
		    set y1 [lindex $coords 1]
		    set x2 [lindex $coords 2]
		    set y2 [lindex $coords 3]
		    puts $fp "rectangle ($x1,$y1) ($x2,$y2) $URL"
		} elseif {$type == {line}} {
		    set newCoords {}
		    for {set j 0} {$j < [expr [llength $coords]-2]} {incr j 2} {
			set newCoords "$newCoords ([lindex $coords $j],[lindex $coords [expr $j+1]])"
		    }
		    puts $fp "polygon $newCoords $URL"
		}
	    }
	}
	close $fp
    }
    return $confFile
}
	    
# ====================================================================
# ϵǽ
# ====================================================================
# --------------------------------------------------------------------
# ԽоܥΥХå
# --------------------------------------------------------------------
proc selectButtonProc {w} {
    global mode
    unSelectObj $w
    unPostMessage 
    set mode(CMD) none
}

proc defaultButtonProc {w} {
    global mode
    unSelectObj $w
    postMessage "<1> : start \t <D-1> : finish"  "info"
    set mode(CMD) create
}

proc circleButtonProc {w} {
    global mode
    unSelectObj $w
    postMessage "<1> : center \t <D-1> : cancel"  "info"
    set mode(CMD) create
}

proc rectangleButtonProc {w} {
    global mode
    unSelectObj $w
    postMessage "<1> : upper-left corner \t <D-1> : cancel"  "info"
    set mode(CMD) create
}

proc polygonButtonProc {w} {
    global mode
    unSelectObj $w
    postMessage "<1> : start \t <D-1> : cancel"  "info"
    set mode(CMD) create
}
# --------------------------------------------------------------------
# å«
# --------------------------------------------------------------------
bind .editPlane <ButtonPress-1> {buttonPress1 %W %x %y}
bind .editPlane <B1-Motion> {b1Motion %W %x %y}
bind .editPlane <ButtonRelease-1> {buttonRelease1 %W %x %y}
bind .editPlane <Double-1> {double1 %W %x %y}
bind .editPlane <ButtonPress-2> {buttonPress2 %W %x %y}
bind .editPlane <Motion> {motion %W %x %y}
bind .entry <Return> {buttonPress2 .editPlane %x %y}
bind .entry <ButtonPress-2> {+ getSelection %W}
bind .entry <ButtonPress-3> {+ getCurrentURLfromTkWWW %W}

# --------------------------------------------------------------------
# newID {} : Ϣ֤IDֹ֤
# --------------------------------------------------------------------
set _id_ 0
proc newID {} {
    global _id_
    return "ID[incr _id_]"
}

# --------------------------------------------------------------------
# buttonPress1 {w x y} : <1> ΥХå
# --------------------------------------------------------------------
set curPos(x) 0
set curPos(y) 0
proc buttonPress1 {w x y} {
    global mode curPos copyBuffer cutBuffer URLs
    set x [$w canvasx $x]
    set y [$w canvasy $y]
    switch $mode(CMD) {
	{create} {buttonPress1Create $w $x $y}
	{drawing} {
	    if {$mode(Item) == {polygon}} {addPointPolygon $w $x $y}
	}
	{modify} {buttonPress1Modify $w $x $y}
	{none} {buttonPress1None $w $x $y}
	{copy} {doCopyPasteObj $w $x $y copyBuffer}
	{paste} {doCopyPasteObj $w $x $y cutBuffer}
	{test} {doURLTest $w $x $y}
    }
    return $mode(CMD)
}

# --------------------------------------------------------------------
# buttonPress1Create {w x y} : <1> ΥХå (create )
# --------------------------------------------------------------------
proc buttonPress1Create {w x y} {
    global mode URLs
    set x [$w canvasx $x]
    set y [$w canvasy $y]
    switch $mode(Item) {
	{circle} {
	    $w addtag {drawing} withtag [createCircle $w $x $y 0] 
	    postMessage "<2> : finish.\t <D-1> : cancel." {info}
	    focus $w
	    set mode(CMD) {drawing}
	}
	{rectangle} {
	    $w addtag {drawing} withtag [createRectangle $w $x $y $x $y]
	    postMessage "<2> : finish.\t <D-1> : cancel." {info}
	    focus $w
	    set mode(CMD) {drawing}
	}		    
	{polygon} {
	    $w addtag {drawing} withtag [drawPolygon $w $x $y]
	    postMessage "<1> : add point.\t<2> : finish.\t<D-1> : cancel." {info}
	    focus $w
	    set mode(CMD) {drawing}
	}
	{default} {
	    .entry configure -state normal -relief sunken
	    .entry delete 0 end
	    if {[info exists URLs(default)]} {
		.entry insert 0 $URLs(default)
	    }
	    focus .entry
	    postMessage "<2>,<Return> : finish.\t<D-1> : cancel." {info}
	    set mode(CMD) {drawing}
	}
    }
    return $mode(CMD)
}

# --------------------------------------------------------------------
# buttonPress1Modify {w x y} : <1> ΥХå (modify )
# --------------------------------------------------------------------
proc buttonPress1Modify {w x y} {
    global mode curPos 
    set x [$w canvasx $x]
    set y [$w canvasy $y]
    set curtag [$w gettags [$w find withtag current]]
    switch -regexp $curtag {
	{moveHandle} {
	    # å줿ΤmoveHandle
	    set curPos(x) $x
	    set curPos(y) $y
	    postMessage "<M-1> : move object." {info}
	    set mode(CMD) move
	}
	{resizeHandle} {
	    # å줿ΤresizeHandle
	    postMessage "<M-1> : resize/reshape object." {info}
	    set mode(CMD) resize
	}
    }
    return $mode(CMD)
}

# --------------------------------------------------------------------
# buttonPress1None {w x y} : <1> ΥХå (none - ֥)
# --------------------------------------------------------------------
proc buttonPress1None {w x y} {
    global mode
    set x [$w canvasx $x]
    set y [$w canvasy $y]
    if {[regexp {ID[0-9]*} \
	    [$w gettags [$w find withtag current]] ID]} {
	# å줿֥Ȥtype롥
	set type [$w type current]
	switch $type {
	    {oval} {
		selectCirRec $w $ID
		set mode(Item) {circle}
	    }
	    {rectangle} {
		selectCirRec $w $ID
		set mode(Item) {rectangle}
	    }
	    {line} {
		selectPolygon $w $ID
		set mode(Item) {polygon}
	    }
	}
	postMessage "<2>,<Return> : finish." {info}
	set mode(CMD) {modify}
    }
    return $mode(CMD)
}
# --------------------------------------------------------------------
# motion {w x y} : <Motion> ΥХå
# --------------------------------------------------------------------
proc motion {w x y} {
    global mode 
    set x [$w canvasx $x]
    set y [$w canvasy $y]
    if {$mode(CMD) == {drawing}} {
	switch $mode(Item) {
	    {circle} {drawCircle $w $x $y}
	    {rectangle} {drawRectangle $w $x $y}
	    {polygon} {drawingPolygon $w $x $y}
	}
    }
    return $mode(CMD)
}

# --------------------------------------------------------------------
# b1Motion {w x y} : <Button1-Motion> ΥХå
# --------------------------------------------------------------------
proc b1Motion {w x y} {
    global mode curPos
    set x [$w canvasx $x]
    set y [$w canvasy $y]
    switch $mode(CMD) {
	{move} {
	    # ư륪֥ȤID
	    if {[regexp {ID[0-9]*} \
		    [$w gettags [lindex [$w find withtag {modify}] 0]] ID]} {
		#tagIDƤΥ֥Ȥư
		$w move $ID [expr $x-$curPos(x)] [expr $y-$curPos(y)]
		# ȤΥ֥Ȱ֤򹹿
		set curPos(x) $x
		set curPos(y) $y
	    }
	}
	{resize} {
	    switch $mode(Item) {
		{circle} -
		{rectangle} {resizeCirRec $w $x $y}
		{polygon} {resizePolygon $w $x $y}
	    }
	}
    }
    return $mode(CMD)
}

# --------------------------------------------------------------------
# buttonRelease1 {w x y} : <ButtonRelease-1> ΥХå
# --------------------------------------------------------------------
proc buttonRelease1 {w x y} {
    global mode
    set x [$w canvasx $x]
    set y [$w canvasy $y]
    if {($mode(CMD) == {move}) || ($mode(CMD) == {resize})} {
	postMessage "<2>,<return> : finish." {info}
	set mode(CMD) {modify}
    } 
}

# --------------------------------------------------------------------
# double1 {w x y} : <Double-1> ΥХå
# --------------------------------------------------------------------
proc double1 {w x y} {
    global mode
    set x [$w canvasx $x]
    set y [$w canvasy $y]
    if {$mode(CMD) == {modify}} {
	unSelectObj $w
	unPostMessage
	set mode(CMD) {none}
	set mode(Item) {none}
    } elseif {$mode(CMD) == {drawing}} {
	$w delete drawing
	resetURLentry .entry
	switch $mode(Item) {
	    {circle} {postMessage "<1> : center \t <D-1> : cancel"  "info"}
	    {rectangle} {postMessage "<1> : upper-left corner \t <D-1> : cancel"  "info"}
	    {polygon} -
	    {default} {postMessage "<1> : start \t <D-1> : cancel"  "info"}
	}
	set mode(CMD) {create}
    }
    
}

# --------------------------------------------------------------------
# buttonPress2 {w x y} : <2> ΥХå
# --------------------------------------------------------------------
proc buttonPress2 {w x y} {
    global mode
    set x [$w canvasx $x]
    set y [$w canvasy $y]
    if {$mode(CMD) == {drawing}} {
	switch $mode(Item) {
	    {polygon} {
		#Polygon֥ȤID
		if {[regexp {ID[0-9]*} [$w gettags [$w find withtag {drawing}]] ID]} {
		    #Υ֥Ȥκɸꤷ
		    if {[fixPolygon $w $x $y $ID] != {}} {
			# 楿򳰤
			$w dtag $ID {drawing}
			# Ĵɽˤ
			selectPolygon $w $ID
			# ѹ楿Ĥ
			$w addtag {modify} withtag $ID
			# ֤
			set mode(CMD) {modify}
		    }
		}
	    }
	    {circle} -
	    {rectangle} {
		#α/ͳѥ֥ȤID
		if {[regexp {ID[0-9]*} [$w gettags [$w find withtag {drawing}]] ID]} {
		    # 楿򳰤
		    $w dtag $ID {drawing}
		    # Ĵɽˤ
		    selectCirRec $w $ID
		    # ѹ楿Ĥ
		    $w addtag {modify} withtag $ID
		    # ֤
		    set mode(CMD) {modify}
		}
	    }
	    {default} {
		# URL
		setURLinfo .entry
		resetURLentry .entry
		# ֤
		set mode(CMD) {none}
		set mode(Item) {none}
	    }
	}
	postMessage "<2>,<Return> : finish." {info}
    } elseif {$mode(CMD) == {modify}} {
	unSelectObj $w
	if {$mode(Item) == {default}} {
	    setURLinfo .entry
	    resetURLentry .entry
	}	
	unPostMessage
	set mode(CMD) {none}
	set mode(Item) {none}
    }
    return $mode(CMD)
}

# --------------------------------------------------------------------
# createCircle {w x y r {URL {}}} : ѥ᡼Ǳߥ֥
# : w   ; Хɥ̾
#       x   ; 濴xɸ
#       y   ; 濴yɸ
#       r   ; Ⱦ
#       URL ; URL
# : ߥ֥ȤID
# --------------------------------------------------------------------
proc createCircle {w x y r {URL {}}} {
    global URLs itemForeground itemWidth
    set ID [newID]
    set URLs($ID) $URL
    $w create oval [expr $x-$r] [expr $y-$r] \
	    [expr $x+$r] [expr $y+$r] -tags "$ID graphic" \
	    -outline $itemForeground -width $itemWidth
    return $ID
}

# --------------------------------------------------------------------
# createRectangle {w x1 y1 x2 y2 {URL {}}} 
#          : ѥ᡼ǻͳѥ֥
# : w  ; Хɥ̾
#       x1 ; xɸ
#       y1 ; yɸ
#       x2 ; xɸ
#       y2 ; yɸ
#       URL; URL
# : ֥ȤID
# --------------------------------------------------------------------
proc createRectangle {w x1 y1 x2 y2 {URL {}}} {
    global URLs itemForeground itemWidth
    set ID [newID]
    set URLs($ID) $URL
    $w create rectangle $x1 $y1 $x2 $y2 -tags "$ID graphic" \
	    -outline $itemForeground -width $itemWidth	    
    return $ID
}

# --------------------------------------------------------------------
# createPolygon {w args} 
#          : ѥ᡼ǥݥꥴ󥪥֥
# : w  ; Хɥ̾
#       args ; ɸ( URL)
# : ֥ȤID
# --------------------------------------------------------------------
proc createPolygon {w args} {
    global URLs itemForeground itemWidth
    set ID [newID]
    # args ĤǤä硤ǸURL.ĤɸȤ롥
    set URL {}
    if {[expr [set arglen [llength $args]]%2]} {
	set URL [lindex $args [incr arglen -1]]
	set args [lrange $args 0 [incr arglen -1]]
    }
    set URLs($ID) $URL
    # args ϥꥹȤʤΤŪ˥ФäƤ롥
    eval $w create line $args -tags "$ID graphic" \
	    	    -fill $itemForeground -width $itemWidth	    
    return $ID
}

# --------------------------------------------------------------------
# drawPolygon {w x y} 
#          : ѥ᡼ǥݥꥴ󥪥֥ȤԤ
# : w  ; Хɥ̾
#       x  ; ޥxɸ
#       y  ; ޥyɸ
# --------------------------------------------------------------------
proc drawPolygon {w x y} {
    global itemForeground itemWidth
    set ID [newID]
    $w create line $x $y $x $y -tags "$ID graphic" \
	    -fill $itemForeground -width $itemWidth	    
    return $ID
}

# --------------------------------------------------------------------
# drawingPolygon {w x y} 
#          : ѥ᡼ǥݥꥴüԤ
# : w  ; Хɥ̾
#       x  ; ޥxɸ
#       y  ; ޥyɸ
# --------------------------------------------------------------------
proc drawingPolygon {w x y} {
    if {[set current [$w find withtag {drawing}]] != {}} {
	set coords [$w coords $current]
	set coords [lrange $coords 0 [expr [llength $coords]-3]] 
	eval $w coords $current $coords $x $y
    }
}

# --------------------------------------------------------------------
# addPointPolygon {w x y}
#           : ѥ᡼ΰ֤ˡޤɲ
# : w  ; Хɥ̾
#       x  ; ޥxɸ
#       y  ; ޥyɸ
# --------------------------------------------------------------------
proc addPointPolygon {w x y} {
    if {[set current [$w find withtag {drawing}]] != {}} {
	set coords [$w coords $current]
	eval $w coords $current $coords $x $y 
    }
}

# --------------------------------------------------------------------
# fixPolygon {w x y ID} : ID Ǽ񤭳ݤPolygonfix
# : w  ; Хɥ̾
#       ID ; fix륪֥ȤID
# --------------------------------------------------------------------
proc fixPolygon {w x y ID} {
    set ret {}
    set coords [$w coords $ID]
    # ֤äƤɸ
    set newcoords {}
    for {set i 0} {$i < [llength $coords]} {incr i 2} {
	if {!([lindex $coords $i] == [lindex $coords [expr $i+2]] && \
		[lindex $coords [expr $i+1]] == [lindex $coords [expr $i+3]])} {
	    set newcoords "$newcoords [lindex $coords $i] [lindex $coords [expr $i+1]]"
	}
    }
    set coords $newcoords
    if {[llength $coords] > 4} { 
	eval $w coords $ID $coords [lindex $coords 0] [lindex $coords 1]
	set ret $ID
    } else {
	$w delete $ID
    }
    return $ID
}

# --------------------------------------------------------------------
# selectPolygon {w ID} : IDPolygon֥ȤĴɽ
# : w  ; Хɥ̾
#       ID ; Ĵɽ륪֥ȤID
# --------------------------------------------------------------------
proc selectPolygon {w ID} {
    global selectForeground handleForeground selectWidth URLs
    # ֥Τcanvas item id 
    set obj {}
    foreach i [$w find withtag $ID] {
	if {[regexp {graphic} [$w gettags $i]]} {
	    set obj $i
	    break
	}
    }
    if {$obj == {}} {
	# IDĥ֥Ȥ¸ߤƤʤ
	puts stderr "internal error: illigal ID: $ID in selectPolygon"
    } else {
	# κɸ
	set coords [$w coords $obj]
	# moveHandle
	set x1 [lindex $coords 0]
	set y1 [lindex $coords 1]
	$w create line \
		[expr $x1-5]  [expr $y1-5] \
		[expr $x1+5]  [expr $y1+5] -tags "$ID moveHandle" \
		-fill $handleForeground -width $selectWidth 
	$w create line \
		[expr $x1-5]  [expr $y1+5] \
		[expr $x1+5]  [expr $y1-5] -tags "$ID moveHandle" \
		-fill $handleForeground -width $selectWidth 
	# ʳresizeHandle
	set p 0
	for {set i 2} {$i < [expr [llength $coords]-2]} {incr i 2} {
	    set x [lindex $coords $i]
	    set y [lindex $coords [expr $i+1]] 
	    $w create rectangle \
		    [expr $x-3] [expr $y-3] [expr $x+3] [expr $y+3] \
		    -tags "$ID resizeHandle P[incr p]" \
		    -outline $handleForeground -width $selectWidth \
		    -fill $handleForeground 
	}
	# Ĵɽ
	$w itemconfigure $obj -fill $selectForeground -width $selectWidth 
	$w addtag {modify} withtag $ID
	#URLϰ 
	.entry configure -state normal -relief sunken
	.entry delete 0 end
	if {[info exists URLs($ID)]} {
	    .entry insert 0 $URLs($ID)
	}
	postMessage "<D-1>,<Return> : finish." {info}
	focus .entry
    }
    return $obj
}

# --------------------------------------------------------------------
# selectCirRec {w ID} : IDα/ͳѷϥ֥ȤĴɽ
# : w  ; Хɥ̾
#       ID ; Ĵɽ륪֥ȤID
# --------------------------------------------------------------------
proc selectCirRec {w ID} {
    global selectForeground handleForeground selectWidth URLs
    # ֥Τcanvas item id 
    set obj {}
    foreach i [$w find withtag $ID] {
	if {[regexp {graphic} [$w gettags $i]]} {
	    set obj $i
	    break
	}
    }
    if {$obj == {}} {
	# IDĥ֥Ȥ¸ߤƤʤ
	puts stderr "internal error: illigal ID: $ID in selectCirRec"
    } else {
	# ꥵϥɥ뤬Ƥʤʤ
	if {[$w find withtag {resizeHandle}] == {}} {
	    set coords [$w coords $obj]
	    $w create rectangle \
		    [expr [lindex $coords 2]-3] [expr [lindex $coords 3]-3] \
		    [expr [lindex $coords 2]+3] [expr [lindex $coords 3]+3] \
		    -tags "$ID resizeHandle" \
		    -outline $handleForeground -width $selectWidth \
		    -fill $handleForeground
	}
	#ưϥɥ뤬̤ʤ
	if {[$w find withtag {moveHandle}] == {}} {
	    set coords [$w coords $obj]
	    set x1 [expr ([lindex $coords 0]+[lindex $coords 2])/2]
	    set y1 [expr ([lindex $coords 1]+[lindex $coords 3])/2]
	    $w create line \
		    [expr $x1-5]  [expr $y1-5] \
		    [expr $x1+5]  [expr $y1+5] -tags "$ID moveHandle" \
		    -fill $handleForeground -width $selectWidth 
	    $w create line \
		    [expr $x1-5]  [expr $y1+5] \
		    [expr $x1+5]  [expr $y1-5] -tags "$ID moveHandle" \
		    -fill $handleForeground -width $selectWidth 
	}
	# Ĵɽ
	$w itemconfigure $obj -outline $selectForeground -width $selectWidth 
	$w addtag {modify} withtag $ID
	#URLϰ 
	.entry configure -state normal -relief sunken
	.entry delete 0 end
	if {[info exists URLs($ID)]} {
	    .entry insert 0 $URLs($ID)
	}
	postMessage "<D-1>,<Return> : finish." {info}
	focus .entry
    }
    return $obj
}

# --------------------------------------------------------------------
# unSelectObj {w} : ХζĴɽ֥֥Ȥꥻå
# : w  ; Хɥ̾
# --------------------------------------------------------------------
proc unSelectObj {w} {
    global mode itemForeground itemWidth
    set ID {}
    #ѹΥ֥Ȥ
    if {[set current [$w find withtag {modify}]] != {}} {
	if {[regexp {ID[0-9]*} \
		[$w gettags [lindex $current 0]] ID]} {
	    #ԽURL¸
	    setURLinfo .entry
	    #ϥɥõ
	    $w delete withtag moveHandle resizeHandle
	    #֥Ȥꥻå
	    if {[$w type $ID] == {line}} {
		$w itemconfigure $ID -width $itemWidth -fill $itemForeground
	    } else {
		$w itemconfigure $ID -width $itemWidth -outline $itemForeground
	    }
	    $w dtag $ID {modify} 
	}
	#URLȥꥻå
	resetURLentry .entry
    } 
    unPostMessage
    return $ID
}


# --------------------------------------------------------------------
# drawCircle {w x y} : ߥ֥Ȥ
# : w  ; Хɥ̾
#       x  ; ޥxɸ
#       y  ; ޥyɸ
# --------------------------------------------------------------------
proc drawCircle {w x y} {
    #楪֥Ȥ򸫤Ĥɸ
    set coords [$w coords [set current [$w find withtag {drawing}]]]
    set x1 [expr ([lindex $coords 0]+[lindex $coords 2])/2]
    set y1 [expr ([lindex $coords 1]+[lindex $coords 3])/2]
    #ߤΥޥ֤Ⱦ¤
    set r [expr [expr abs($x-$x1) < abs($y-$y1)] ? \
	    [expr abs($x-$x1)] : [expr abs($y-$y1)]]
    #ߥ֥Ȥκɸѹ
    return [$w coords $current \
	    [expr $x1-$r] [expr $y1-$r] [expr $x1+$r] [expr $y1+$r]]
}

# --------------------------------------------------------------------
# drawRectangle {w x y} : ͳѥ֥Ȥ
# : w  ; Хɥ̾
#       x  ; ޥxɸ
#       y  ; ޥyɸ
# --------------------------------------------------------------------
proc drawRectangle {w x y} {
    set coords [$w coords [set current [$w find withtag {drawing}]]]
    return [$w coords $current \
	    [lindex $coords 0] [lindex $coords 1] $x $y]
}

# --------------------------------------------------------------------
# resizeCirRec {w x y} : /ͳѤΥꥵ
# : w  ; Хɥ̾
#       x  ; ޥxɸ
#       y  ; ޥyɸ
# --------------------------------------------------------------------
proc resizeCirRec {w x y} {
    global mode
    set coords {}
    # 礭ѹ֥ȤID
    if {[regexp {ID[0-9]*} \
	    [set curtag [$w gettags [$w find withtag current]]] ID]} {
	#IDΥեå
	set obj {}
	foreach i [$w find withtag $ID] {
	    if {[regexp {graphic} [$w gettags $i]]} {
		set obj $i
		break
	    }
	}
	if {$obj != {}} {
	    #ꥵκɸ
	    set coords [$w coords $obj]
	    # եåꥵ
	    if {$mode(Item) == {circle}} {
		set x1 [expr ([lindex $coords 0]+[lindex $coords 2])/2]
		set y1 [expr ([lindex $coords 1]+[lindex $coords 3])/2]
		set r [expr [expr abs($x-$x1) < abs($y-$y1)] ? \
			[expr abs($x-$x1)] : [expr abs($y-$y1)]]
		$w coords $obj \
			[expr $x1-$r] [expr $y1-$r] \
			[expr $x1+$r] [expr $y1+$r]
	    } else {
		$w coords $obj \
			[lindex $coords 0] [lindex $coords 1] $x $y
	    }
	    #ꥵκɸ
	    set coords [$w coords $obj]
	    #resizeHandleΰĴ
	    $w coords current \
		    [expr [lindex $coords 2]-3] \
		    [expr [lindex $coords 3]-3] \
		    [expr [lindex $coords 2]+3] \
		    [expr [lindex $coords 3]+3] 
	    #moveHandleΰĴ
	    set moveHandle [$w find withtag {moveHandle}]
	    set x1 [expr ([lindex $coords 0]+[lindex $coords 2])/2]
	    set y1 [expr ([lindex $coords 1]+[lindex $coords 3])/2]
	    $w coords [lindex $moveHandle 0] \
		    [expr $x1-5]  [expr $y1-5] \
		    [expr $x1+5]  [expr $y1+5] 
	    $w coords [lindex $moveHandle 1] \
		    [expr $x1-5]  [expr $y1+5] \
		    [expr $x1+5]  [expr $y1-5]
	}
    }
    return $coords
}

# --------------------------------------------------------------------
# resizePolygon {w x y} : ݥꥴΥꥵ
# : w  ; Хɥ̾
#       x  ; ޥxɸ
#       y  ; ޥyɸ
# --------------------------------------------------------------------
proc resizePolygon {w x y} {
    global mode curPos
    # : ѹκɸ
    set coords {}
    # ȤresizeHandle
    set currentHandle [$w find withtag current]
    # 礭ѹ֥ȤID
    if {[regexp {ID[0-9]*} \
	    [set curtag [$w gettags $currentHandle]] ID]} {
	#IDΥեå
	set obj {}
	foreach i [$w find withtag $ID] {
	    if {[regexp {graphic} [$w gettags $i]]} {
		set obj $i
		break
	    }
	}
	if {$obj != {}} {
	    # ݥꥴѹ٤ɸ
	    if {[regexp {P[0-9]*} $curtag PID]} {
		regsub {P} $PID {} PID
		set PID [expr 2*$PID]
		set coords [lreplace [$w coords $obj] $PID [incr PID] $x $y]
		eval $w coords $obj $coords
		#currentresizeHandleư
		$w coords $currentHandle [expr $x-3] [expr $y-3] [expr $x+3] [expr $y+3]
	    }
	}
    }
    return $coords
}

# --------------------------------------------------------------------
# setURLinfo {w} : modify֤Υ֥ȤСURL
# : w  ; ȥꥦɥ̾
# --------------------------------------------------------------------
proc setURLinfo {w} {
    global mode URLs
    # ret: ͡ǥեȤ϶
    set ret {}
    # modifyΩäƤ륪֥Ȥ¸ߤʤ 
    if {[set current [.editPlane find withtag {modify}]] != {}} {
	# Υ֥Ȥ1ĤIDʤ 
	if {[regexp {ID[0-9]*} \
		[.editPlane gettags [lindex $current 0]] ID]} {
	    # ȥƤ򤽤IDURLȤ
	    set ret [set URLs($ID) [$w get]]
	}
    } elseif {$mode(Item) == {default}} {
	set ret [set URLs(default) [$w get]]
    }
    focus .mbar
    return $ret
}

# --------------------------------------------------------------------
# rsetURLentry {w} : URLϥեɤdisabled֤
# : w  ; ȥꥦɥ̾
# --------------------------------------------------------------------
proc resetURLentry {w} {
    $w delete 0 end
    return [$w configure -state disabled \
	    -relief [lindex [.entry configure -relief] 3]] 
}

# --------------------------------------------------------------------
# deleteObj {w} : ХwǶĴɽ֤ˤ륪֥Ȥ
# : w  ; Хɥ̾
# --------------------------------------------------------------------
proc deleteObj {w} {
    global URLs mode
    # (֥ȤID)
    set ID {}
    # Ĵɽ֤ˤ륪֥ȤID
    if {$mode(CMD) == {modify} && \
	    [regexp {ID[0-9]*} [$w gettags [lindex [$w find withtag {modify}] 0]] ID]} {
	unSelectObj $w 
	$w delete $ID
	unset URLs($ID)
	set mode(CMD) {none}
	set mode(Item) {none}
    }
    unPostMessage
    return $ID
}

# --------------------------------------------------------------------
# cutObj {w} :ХwǶĴɽ֤ˤ륪֥Ȥ򥫥å
# : w  ; Хɥ̾
# --------------------------------------------------------------------
set cutBuffer(coords) {}
set cutBuffer(URL) {}
proc cutObj {w} {
    global mode cutBuffer
    # (cut֥ȤID)
    set ID {}
    # ߶Ĵɽˤ륪֥(cut륪֥)ID򸫤Ĥ
    if {$mode(CMD) == {modify} && \
	    [regexp {ID[0-9]*} [$w gettags [lindex [$w find withtag {modify}] 0]] ID]} {
	# cut֥Ȥgraphic򸫤Ĥ
	set obj {}
	foreach i [$w find withtag $ID] {
	    if {[regexp {graphic} [$w gettags $i]]} {
		set obj $i
		break
	    }
	}
	if {$obj != {}} {
	    # cut֥Ȥɽ֤
	    unSelectObj $w
	    # cutХåեcut֥ȤǼ
	    set coords [$w coords $obj]
	    set x1 [lindex $coords 0]
	    set y1 [lindex $coords 1]
	    set newCoords {}
	    for {set i 0} {$i < [llength $coords]} {incr i} {
		if {[expr $i%2] == 0} {
		    set newCoords "$newCoords [expr [lindex $coords $i]-$x1]"
		} else {
		    set newCoords "$newCoords [expr [lindex $coords $i]-$y1]"
		}
	    }
	    set cutBuffer(coords) [concat [$w type $obj] $newCoords]
	    if {[info exists URLs($ID)]} {
		set cutBuffer(URLs) URLs($ID)
		unset URLs($ID)
	    }
	    # cut֥Ȥõ
	    $w delete $obj
	    # ֤᤹
	    unPostMessage
	    set mode(CMD) {none}
	    set mode(Item) {none}
	}
    }
    return $ID
}

# --------------------------------------------------------------------
# copyObj {w} : ХwǶĴɽ֤ˤ륪֥Ȥʣ
# : w  ; Хɥ̾
# --------------------------------------------------------------------
set copyBuffer(coords) {}
set copyBuffer(URLs) {}
proc copyObj {w} {
    global mode copyBuffer
    # (copy֥ȤID)
    set ID {}
    # ߶Ĵɽˤ륪֥(copy륪֥)ID򸫤Ĥ
    if {$mode(CMD) == {modify} && \
	    [regexp {ID[0-9]*} [$w gettags [lindex [$w find withtag {modify}] 0]] ID]} {
	# copy֥Ȥgraphic򸫤Ĥ
	set obj {}
	foreach i [$w find withtag $ID] {
	    if {[regexp {graphic} [$w gettags $i]]} {
		set obj $i
		break
	    }
	}
	if {$obj != {}} {
	    # ֥Ȥξ
	    set coords [$w coords $obj]
	    set newCoords {}
	    for {set i 0} {$i < [llength $coords]} {incr i} {
		if {[expr $i%2] == 0} {
		    set newCoords \
			    "$newCoords [expr [lindex $coords $i]-[lindex $coords 0]]"
		} else {
		    set newCoords \
			    "$newCoords [expr [lindex $coords $i]-[lindex $coords 1]]"
		}
	    }
	    # copyBuffer ˾
	    set copyBuffer(coords) [concat [$w type $obj] $newCoords]
	    if {[info exists URLs($ID)]} {
		set copyBuffer(URLs) URLs($ID)
	    }
	    postMessage "<1> : copy object. \t<M-1> : drag object." {info}
	    set mode(CMD) {copy}
	    set mode(Item) {disabled}
	}
    }
    return $ID
}

# --------------------------------------------------------------------
# pasteObj {w} : paste֤ܤ
# : w  ; Хɥ̾
# --------------------------------------------------------------------
proc pasteObj {w} {
    global mode cutBuffer
    # ߶Ĵɽˤ륪֥(copy륪֥)ID򸫤Ĥ
    if {$mode(CMD) == {modify} && \
	    [regexp {ID[0-9]*} [$w gettags [lindex [$w find withtag {modify}] 0]] ID]} {
	unSelectObj $w 
	set mode(CMD) {none}
	set mode(Item) {none}
    }
    if {$cutBuffer(coords) != {}} {
	postMessage "<1> : paste object. \t<M-1> : drag object." {info}
	set mode(CMD) {paste}
	set mode(Item) {disabled}
    }
}

# --------------------------------------------------------------------
# doCopyPasteObj {w x y} : ХåեƤ򡤻ɸʣ
# --------------------------------------------------------------------
proc doCopyPasteObj {w x y buffer} {
    global mode URLs curPos 
    upvar $buffer buf
    set NID {}
    if {$buf(coords) != {}} {
	set NID [newID]
	set curPos(x) $x
	set curPos(y) $y
	set newCoords {}
	for {set i 1} {$i < [llength $buf(coords)]} {incr i} {
	    if {[expr $i%2]} {
		if {[lindex $buf(coords) 0] == {oval} || \
			[lindex $buf(coords) 0] == {rectangle}} {
		    set newCoords "$newCoords [expr [lindex $buf(coords) $i]+$x-[lindex $buf(coords) 3]/2]"
		} else {
		    set newCoords "$newCoords [expr [lindex $buf(coords) $i]+$x]"
		}
	    } else {
		if {[lindex $buf(coords) 0] == {oval} || \
			[lindex $buf(coords) 0] == {rectangle}} {
		    set newCoords "$newCoords [expr [lindex $buf(coords) $i]+$y-[lindex $buf(coords) 4]/2]"
		} else {
		    set newCoords "$newCoords [expr [lindex $buf(coords) $i]+$y]"
		}
	    }
	}
	eval "$w create [lindex $buf(coords) 0] $newCoords \
		-tags \[list $NID graphic\]"
	set URLs($NID) $buf(URL)
	if {[lindex $buf(coords) 0] == {oval}} {
	    selectCirRec $w $NID
	    set mode(CMD) {move}
	    set mode(Item) {circle}
	} elseif {[lindex $buf(coords) 0] == {rectangle}} {
	    selectCirRec $w $NID
	    set mode(CMD) {move}
	    set mode(Item) {rectangle}
	} else {
	    selectPolygon $w $NID
	    set mode(CMD) {move}
	    set mode(Item) {polygon}
	}
	postMessage "<2>,<Return> : finish." {info}
    }
    return $NID
}

# --------------------------------------------------------------------
# getSelection {w} :selectionƤ롥
# : w  ; ȥꥦɥ̾
# --------------------------------------------------------------------
proc getSelection {w} {
    catch {$w insert insert [selection get]}
}

# --------------------------------------------------------------------
# getCurrentURLfromTkWWW {w}: tkWWW顤߳ƤURL
# : w  ; ȥꥦɥ̾
# --------------------------------------------------------------------
proc getCurrentURLfromTkWWW {w} {
    if {[set viewer [option get . viewer Text]] == {tkwww} && \
	    [set interp [findTkWWW]] != {}} {
	catch {$w insert insert [send $interp ".titles.address_entry get"]}
    }
}

# ====================================================================
# ϵǽ
# ====================================================================
# --------------------------------------------------------------------
# setUpTestMode {w test} : URL⡼ɤꡤԤ
# --------------------------------------------------------------------
proc setUpTestMode {w test} {
    global mode
    if {$test == 1} {
	# ⡼ɤ	
	# Ѥ˥ХΥ֥Ȥ°ѹ
	unSelectObj $w
	foreach i [$w find withtag {graphic}] {
	    if {[set type [$w type $i]] == {oval} || $type == {rectangle}} {
		$w itemconfigure $i -fill {black} -stipple {gray25}
	    } elseif {$type == {line}} {
		eval $w create polygon [$w coords $i] \
			-tags \[concat \[$w gettags $i\] testObj \] \
			-fill {black} -stipple {gray25}
	    }
	}
	postMessage "<1> : select test object." {info}
	set mode(CMD) {test}
	set mode(Item) {disabled}
    } else {
	# ⡼ɤβ
	# polygon֥Ȥκ
	$w delete {testObj}
	# /ͳѷ֥Ȥѹ
	foreach i [$w find withtag {graphic}] {
	    if {[set type [$w type $i]] == {oval} || $type == {rectangle}} {
		$w itemconfigure $i -fill {} -stipple {}
	    }
	}
	unPostMessage
	set mode(CMD) {none}
	set mode(Item) {none}
    }	
    return $mode(CMD)
}

# --------------------------------------------------------------------
# doURLTest {w x y} : URLԤ
# --------------------------------------------------------------------
proc doURLTest {w x y} {
    global URLs
    set ret {}
    set obj [$w find closest $x $y]
    if {[set viewer [option get . viewer Text]] != {} && $obj != {}} {
	if {$viewer == {tkwww} && [findTkWWW] =={}} {
	    exec tkwww &
	}
	set ID {}
	if {[set type [$w type $obj]] == {bitmap}} {
	    set ID {default}
	} elseif {$type == {oval} || $type == {rectangle} || $type == {line} || $type == {polygon}} {
	    regexp {ID[0-9]*} [$w gettags $obj] ID
	}
	if {$ID != {} && [info exists URLs($ID)]} {
	    if {$viewer == {tkwww}} {
		send [findTkWWW] "tkW3NavigateGoto $URLs($ID)"
	    } else {
		eval "exec $viewer $URLs($ID) &"
	    }
	    postMessage "Go to $URLs($ID)..." {info}
	    set ret $URLs($ID)
	} else {
	    postMessage "Can not find URL definition!" {error}
	}
    }
    return $ret
}

# --------------------------------------------------------------------
# findTkWWW {} : tkWWW Υ󥿥ץ꥿̾򸫤Ĥ
# --------------------------------------------------------------------
proc findTkWWW {} {
    set ret {}
    foreach i [winfo interp] {
	if {[string match {tkWWW*} $i]} {
	    set ret $i
	    break
	}
    }
    return $ret
}

# ====================================================================
# Helpϵǽ
# ====================================================================
# --------------------------------------------------------------------
# help {viewer url} : HelpåȤurlviewerɽ
# --------------------------------------------------------------------
proc help {viewer url} {
    postMessage "Go to $url ..." {info}
    eval "exec $viewer $url &"
    return $url
}

