# localfile.tcl
#----------------------------------------------------------------------------
# Copyright 1994 Siemens KWU Erlangen
# Permission to use, copy, modify, and distribute this documentation
# is hereby granted, provided that this copyright notice appears
# in all copies. This software is provided without any warranty, express
# or implied. Siemens KWU Erlangen makes no representations about the
# suitability of this software for any purpose.
#
# Author: Johan Lindbladh (tet90jl@tintin.hik.se)
#----------------------------------------------------------------------------
# This script generates a window with the  possibility to include a reference
# to a file stored local
#----------------------------------------------------------------------------

#----------------------------------------------------------------------------
#### proc includelocal ####
# Include a file stored in a local directory and updates the mainwindow
#----------------------------------------------------------------------------
proc includelocal {localname contentname} {
global breakpoint
global currenttext
global winnumber
global includenum
global sumofwin
global currentwidgetnumber
global widgetname
global contenttype
global body
global description
global bg1 bg2 actbg bheight

set sumofwin [expr $sumofwin+1]
set includenum [expr $includenum+1]
set currentframe [split $currenttext .]
set part2 [lindex $currentframe 2]
set currentframe .[lindex $currentframe 1]
## Checks if cursor doesn't stand in an textfield, then the input will be first
if {$part2 !="text"} {
   set currenttext $widgetname(1)
   set currentframe [split $currenttext .]
   set currentframe .[lindex $currentframe 1]
   set breakpoint 1.0
   }
frame .f$includenum -background $bg1

#### if first position in the current textwidget

if {$breakpoint=="1.0"} {
   pack .f$includenum -fill both -side top -before $currentframe
   canvas .f$includenum.canvas -background $bg1 -relief raised -height 20
   pack .f$includenum.canvas -fill x
   updatesendlist $currentwidgetnumber($currenttext) $sumofwin
   set currentwidgetnumber(.f$includenum.canvas) \
        [expr $currentwidgetnumber($currenttext)-1]
   set widgetname($currentwidgetnumber(.f$includenum.canvas)) .f$includenum.canvas
   set contenttype($currentwidgetnumber(.f$includenum.canvas)) \
        "\[SafeTcl_makebody \"message/external-body\" "
   set body($currentwidgetnumber(.f$includenum.canvas)) \
	"-parameter \"\\n access-type=\\\"local-file\\\"\" \
 -parameter \"\\n name=\\\"$localname\\\"\" \
\"Content-type:  $contentname\" \] "
   set description($currentwidgetnumber(.f$includenum.canvas)) \
        "localfile : $localname, $contentname"
   # # # # #
} else {
   pack .f$includenum -fill both -side top -after $currentframe
   text .f$includenum.text -relief raised -bd 2 -background $bg2 \
        -yscrollcommand ".f$includenum.scroll set" -height $bheight
   scrollbar .f$includenum.scroll  -relief flat  -background $bg2 -foreground \
        $bg2 -activeforeground $actbg -command ".f$includenum.text yview"
   pack .f$includenum.scroll -side right -fill y
   pack .f$includenum.text -expand yes -fill both
   .f$includenum.text insert 1.0 [ $currenttext get insert end]
   $currenttext delete insert end
   updatesendlist [expr $currentwidgetnumber($currenttext)+1] $sumofwin

   set currentwidgetnumber(.f$includenum.text) \
        [expr $currentwidgetnumber($currenttext)+1]
   set widgetname($currentwidgetnumber(.f$includenum.text)) .f$includenum.text
   set contenttype($currentwidgetnumber(.f$includenum.text)) \
        "\[SafeTcl_makebody \"text/plain\" "
   set body($currentwidgetnumber(.f$includenum.text)) \
        "\[.f$includenum.text get 1.0 end\]\] "
   set description($currentwidgetnumber(.f$includenum.text)) \
        "textfield"
   set sumofwin [expr $sumofwin+1]
   set includenum [expr $includenum+1]
   frame .f$includenum -background $bg1
   pack .f$includenum -fill both -side top -after $currentframe
   canvas .f$includenum.canvas -background $bg1 -relief raised -height 20
   pack .f$includenum.canvas -fill x

   set currentwidgetnumber(.f$includenum.canvas) [expr \
        $currentwidgetnumber($currenttext)+1]
   updatesendlist [expr $currentwidgetnumber($currenttext)+1] $sumofwin
   set widgetname($currentwidgetnumber(.f$includenum.canvas)) \
	.f$includenum.canvas
   set contenttype($currentwidgetnumber(.f$includenum.canvas)) \
        "\[SafeTcl_makebody \"message/external-body\" "
   set body($currentwidgetnumber(.f$includenum.canvas)) \
        "-parameter \"\\n access-type=\\\"local-file\\\"\" \
 -parameter \"\\n name=\\\"$localname\\\"\" \
 -parameter \"\\nContent-type:  $contentname\" \] "
   set description($currentwidgetnumber(.f$includenum.canvas)) \
        "localfile : $localname, $contentname"
   }

.f$includenum.canvas create text 1 10 -text "localfile : $localname, \
	$contentname" -anchor w
destroy .local
.butt.label configure -text "Including a local file... done" -foreground #000000
}

#----------------------------------------------------------------------------
#### localmenu ####
# shows what file you have selected and let you specify the Contenttype
#----------------------------------------------------------------------------
proc localmenu {} {
global type
global numberoftype
global localname
global contentname
global bg1 bg2 actbg

toplevel .local
wm title .local "A local file"
wm iconname .local "local"

label .local.header1 -text "A local file" -background $bg1 \
        -font "-*-helvetica-*-r-*-*-*-240-*-*-*-*-*-*" -foreground red
label .local.header2 -text "Please give the following options" -background $bg1
pack .local.header1 -side top -fill x
pack .local.header2 -side top -fill x

frame .local.f0 -background $bg2
pack .local.f0 -fill both
label .local.f0.file -width 12 -text "File               :" -background $bg1
label .local.f0.localname -width 60  -background $bg1 -text $localname -anchor w
pack .local.f0.file -side left -anchor w
pack .local.f0.localname -side left

#----------------------------------------------------------------------------
# Pack the menu and entry for the Content
#----------------------------------------------------------------------------
frame .local.f3 -background $bg2
pack .local.f3 -fill both
menubutton .local.f3.content -width 12 -text "Contenttype :" -background $bg1 \
        -activebackground $actbg -relief raised -anchor w \
	-menu .local.f3.content.m

menu .local.f3.content.m -background $bg1 -activebackground $actbg
for {set i 1} {$i <= $numberoftype} {incr i 1} {
  .local.f3.content.m add command -label $type($i) -command \
        ".local.f3.contentname delete 0 end; .local.f3.contentname \
        insert 0 $type($i); grab .local" \
	-background $bg1 -activebackground $actbg
  }
entry .local.f3.contentname -width 60 -relief sunken \
        -background $bg2 -textvariable contentname
pack .local.f3.content -side left -anchor w
pack .local.f3.contentname -side left

#----------------------------------------------------------------------------
# Button actions
#----------------------------------------------------------------------------
frame .local.f2 -background $bg1
pack .local.f2 -fill both
button .local.f2.include -text Include -command {includelocal $localname \
        $contentname} -background $bg1 -activebackground $actbg
button .local.f2.quit -text Cancel -command "destroy .local; .butt.label \
	configure -text \"Including a local file...cancelled\" -foreground \
	#000000" -background $bg1 -activebackground $actbg
button .local.f2.listdir -text "New FSBox" -command {destroy .local;local} \
        -background $bg1 -activebackground $actbg

pack .local.f2.include .local.f2.quit .local.f2.listdir -side left \
	-expand yes -pady 5
catch {grab .local}
}

#---------------------------------------------------------------------------
#### local ####
# Creates a FSBox with the label Select a local file
#---------------------------------------------------------------------------
proc local {} {
global fsBoxMessage
global localname

.butt.label configure -text "Including a local file..." -foreground #3d55ff
set fsBoxMessage "Select a local file"
set localname [FSBox]
if [file isfile $localname] {
   localmenu
   }
}
