# WWW browser launching Client Tcl code for tkgoodstuff
# Mark Crimmins (markcrim@umich.edu)

setifunset WWW_browser $TKG_browser
setifunset WWW_nolabel 1

# much of this is stolen from Brent Welch's exmh
proc WWW-goto {} {
    global WWW_browser WWW_launch_command
    set selection [string trim [selection get]]
    switch $WWW_browser {
	netscape {
	    if [ catch { exec netscape -remote openURL($selection) } tmp ] {
		if { [ string first "not running on" $tmp ] != -1 } {
		    exec netscape $selection &
		}
	    }  
	} hippo {
	    if [catch {send hippo [list Remote $xuri [winfo name .]]} err] { 
		tkerror $err
	    }
	} lynx {
	    exec xterm -T lynx -e lynx $selection &
	} default { WWW_launch_command $selection & }
    }
}

proc create-WWW-window {} {
    global WWW_imagefile WWW-params WWW_browser WWW_launch_command
    global WWW_nolabel WWW_text images
    global WWW_foreground WWW_background
    global WWW_activeforeground WWW_activebackground
    global TKG_defformat

    uplevel {
	setifunset WWW_foreground $TKGbuttonforeground
	setifunset WWW_activeforeground $WWW_foreground
	setifunset WWW_background $TKGbuttonbackground
	setifunset WWW_activebackground $TKGactivebackground
    }
    switch $WWW_browser {
	hippo {
	    setifunset WWW_launch_command hippo
	    setifunset WWW_text "Hippo"
	    setifunset WWW_imagefile $images/www.$TKG_defformat
	}
	lynx {
	    setifunset WWW_launch_command "xterm -T lynx -e lynx"
	    setifunset WWW_text "Lynx"
	    setifunset WWW_imagefile $images/www.$TKG_defformat
	}
	netscape {
	    setifunset WWW_launch_command "netscape"
	    setifunset WWW_text "Netscape"
	    setifunset WWW_imagefile $images/netscape.$TKG_defformat
	}
	default {
	    setifunset WWW_launch_command $WWW_browser
	    setifunset WWW_text "WWW"
	    setifunset WWW_imagefile $images/www.$TKG_defformat
	    
	}
    }

    SetImage WWW_image $WWW_imagefile

    if !$WWW_nolabel {
	TKGButton WWW -text $WWW_text 
    }
    TKGButton WWW \
        -image WWW_image \
	-text $WWW_text \
        -unixcmd $WWW_launch_command \
        -foreground(normal) $WWW_foreground \
        -background(normal) $WWW_background \
        -activeforeground(normal) $WWW_activeforeground \
        -activebackground(normal) $WWW_activebackground

    RecursiveBind [set WWW-params(window)] <3> {WWW-goto}
}

DEBUG "Loaded WWW.tcl"

