# Ical-fetch.tcl  Invoke with:
#        ical -f Ical-fetch.tcl
# makes ical output a tcl script that sets a list of today's alarm information
#
# Part of TkGoodStuff by Mark Crimmins

calendar maincal $env(HOME)/.calendar 

set today [date today]

set default_alarms { 0 5 10 15 }
catch { eval "set default_alarms \{ [maincal option DefaultAlarms ]\}"}

maincal query $today $today item date {
  if [$item is appt] {
      set alarmlist [expr [catch {$item alarms} outtext ] == 0 ? {$outtext} : [list $default_alarms] ]
      puts "lappend Ical_itemlist \{ [$item starttime] [list $alarmlist] [list [$item text]] \}"
    }
}

exit
