return
	-code -errorinfo -errorcode
	$string

-code returnCode
The 
^B^-code
 option may be used to pass one of several 
^S^returnCode
 values, which indicate to the calling procedure or code the precise 
"type" of 
^B^return
 which is being executed, and in some cased cause the calling code to 
react to the return differently than they normally would. The possible 
values for 
^S^returnCode
 (and their meanings) are as follows:
^P^
^B^ok
 : A normal return; exactly as if the 
^B^-code
 option had not been used.
^P^
^B^error
 : The return was done as part of an error. This causes action similar 
to what would occur if an 
^B^error
 command had been issued instead of the 
^B^return
, but handling of information passed back through the 
^B^-errorinfo
 and 
^B^-errorcode
 options is done somewhat differently than using the equivalent flags 
in the 
^B^error
 command.
^P^
^B^return
 : The current procedure will return with a completion code of 
^B^TCL_RETURN
, which means that 
^I^the procedure which called the one containing 
^B^return
^I^ will also return.
^P^
^B^break
 : The current procedure will return with a completion code of 
^B^TCL_BREAK
, which will terminate the innermost nested loop in the code that invoked 
the current procedure. This option could be used when writing a 
custom command that performs similarly to 
^B^break
.
^P^
^B^continue
 : The current procedure will return with a completion code of 
^B^TCL_CONTINUE
, which will terminate the current iteration of the innermost 
nested loop in the code that invoked the current procedure. This option 
could be used when writing a custom command which performs similarly to 
^B^continue
.
^S^num
 : If the argument to 
^B^-code
 is an integer, it will be returned as a completion code to the calling 
procedure. This permits completion codes other than those mentioned 
above to be issued by the 
^B^return
 command.

-errorinfo stackTrace
This option may be used only when the 
^B^-code
 option is used with a value of 
^B^error. In such a case, 
^S^stackTrace
 specifies an initial stack trace for 
the 
^B^errorInfo
 global variable; if the 
^B^-errorinfo
 option is not specified, then the 
stack trace left in 
^S^errorInfo
 will include the call to the 
procedure and higher levels on the stack but it will not 
include any information about the context of the error 
within the procedure. Typically the 
^S^stackTrace
 value is supplied from the value left in 
^B^errorInfo
 after a 
^B^catch
 command trapped an error within the procedure. If this doesn't make 
sense, don't worry--by the time you need to use this option, you will 
understand what is going on.

-errorcode errorCode
This option may be used only when the 
^B^-code
 options is used with a value of 
^B^error
. If it is specified then 
^S^errorCode
 provides a 
value for the global 
^B^errorCode
 variable. If the option is not specified then 
^B^errorCode
 will default to 
^B^NONE
.


