^TI^'
^TITW^proc 
^TIS^name argNames body
^TI^'Command
^P^
The proc command creates a new Tcl procedure named 
^S^name
, 
replacing any existing command or procedure there may have 
been by that name. Whenever the new command is invoked, 
the contents of 
^S^body
 will be executed by the Tcl interpreter. 
^S^argNames
 specifies the formal arguments to the procedure. It consists 
of a list, possibly empty, each of 
whose elements specifies one argument. Each argument 
specifier is also a list with either one or two fields. 
If there is only a single field in the specifier then it 
is the name of the argument; if there are two fields, then 
the first is the argument name and the second is its 
default value. 
^P^
When 
^S^name
 is invoked a local variable will be created for 
each of the formal arguments to the procedure; its value 
will be the value of the corresponding argument in the invoking 
command, or the argument's default value if an explicit value was not 
given for that argument in the invoking command, and the argument has a 
defined default value. Arguments 
with default values need not be specified in a procedure 
invocation. However, there must be enough actual arguments 
for all the formal arguments that don't have 
defaults, and there must not be any extra actual arguments. 
There is one special case to permit procedures 
with variable numbers of arguments. 
^I^If the last formal argument has the name 
'
^B^args
', then a call to the procedure 
may contain more actual arguments than the procedure has 
formals. In this case, all of the actual arguments starting 
at the one that would be assigned to 
^B^args
 are combined 
into a list (as if the 
^B^list
 command had been used); this 
combined value is assigned to the local variable 
^B^args
. 
^P^
When 
^S^body
 is being executed, variable names normally refer 
to 
^I^local variables
, which are created automatically when 
referenced and deleted when the procedure returns. One 
local variable is automatically created for each of the 
procedure's arguments. 
^I^Global variables
 can only be 
accessed by invoking the 
^B^global
 command or the 
^B^upvar
 command. 
^P^
The 
^B^proc
 command returns an empty string. When a procedure 
is invoked, the procedure's return value is the value 
specified in a 
^B^return
 command. If the procedure doesn't 
execute an explicit return, then its return value is the 
value of the last command executed in the procedure's 
body. If an error occurs while executing the procedure 
body, then the procedure-as-a-whole will return that same 
error. 

