^TI^Tcl Global Variables
^P^
The following global variables are created and managed 
automatically by the Tcl library. Except where noted 
below, these variables should normally be treated as read-only 
by application-specific code and by users.
^P^
^B^env
 : This variable is maintained by Tcl as an array 
whose elements are the environment variables for 
the process. Reading an element will return the 
value of the corresponding environment variable. 
Setting an element of the array will modify the 
corresponding environment variable or create a new 
one if it doesn't already exist. Unsetting an element of 
^B^env
 will remove the corresponding environment variable. Changes to the 
^B^env
 array will affect the environment passed to children by commands like 
^B^exec
. If the entire 
^B^env
 array is unset then Tcl will stop monitoring 
^B^env
 accesses and will not update environment variables.
^P^
^B^errorCode
 : After an error has occurred, this variable will be 
set to hold additional information about the error 
in a form that is easy to process with programs. 
^B^errorCode
 consists of a Tcl list with one or more 
elements. For details on the formats stored in this variable, see 
the later section of this document titled '
^B^Formats for the 'errorCode' Variable
'. To set 
^B^errorCode
, applications should use library procedures such as 
^B^Tcl_SetErrorCode
 and 
^B^Tcl_PosixError
, or they may invoke the 
^B^error
 command. If one of these methods hasn't been used, then the Tcl interpreter 
will reset the variable to 
^B^NONE
 after the next error.
^P^
^B^errorInfo
 : After an error has occurred, this string will contain 
one or more lines identifying the Tcl commands 
and procedures that were being executed when the 
most recent error occurred. Its contents take the 
form of a stack trace showing the various nested 
Tcl commands that had been invoked at the time of 
the error.
^P^
^B^tcl_library : When an interpreter is created, Tcl initializes 
this variable to hold the name of a directory containing 
the system library of Tcl scripts, such as 
those used for auto-loading. See the 
^B^library
 manual entry for details of the facilities provided by 
the Tcl script library. Normally each application 
will have its own application-specific script 
library in addition to the Tcl script library; each 
application should set a global variable with a 
name like 
^B^app_library
 (where app is the application's name) to hold the location of that 
application's library directory. The initial value of 
^B^tcl_library
 is set from the 
^B^TCL_LIBRARY
 environment variable if one exists, or from a compiled-in value 
otherwise. A Tcl application may change this variable to use a different 
library directory. The value of this variable is returned by the 
^B^info library
 command.
^P^
^B^tcl_patchLevel
 : When an interpreter is created Tcl initializes this 
variable to hold a string giving the current patch 
level for Tcl, such as 7.3p2 for Tcl 7.3 with the 
first two official patches, or 7.4b4 for the fourth 
beta release of Tcl 7.4. The value of this variable is returned by the 
^B^info patchlevel
 command. 
^P^
^B^tcl_precision
 : If this variable is set, it must contain a decimal 
number giving the number of significant digits to 
include when converting floating-point values to 
strings. If this variable is not set then 6 digits 
are included. 17 digits is ``perfect'' for IEEE 
floating-point in that it allows double-precision 
values to be converted to strings and back to 
binary with no loss of precision.
^P^
^B^tcl_version
 : When an interpreter is created Tcl initializes this 
variable to hold the version number for this version of Tcl in 
the form 
^I^x.y
. Changes to 
^I^x
 represent major changes with probable incompatibilities 
and changes to 
^I^y
 represent small enhancements and bug fixes that retain backward 
compatibility. The value of this variable is returned by the 
^B^info tclversion
 command.
^P^
^TI^Formats for the 'errorCode' Variable
^P^
The value stored in the 
^B^errorCode
 variable can be in one of various formats, depending on the 
precise type of error. Defined formats are as follows (applications may 
define additional formats):
^P^
^B^ARITH 
^S^code msg
 : This format is used when an arithmetic error 
occurs (e.g. an attempt to divide by zero in 
the expr command). 
^S^code identifies the precise error and 
^S^msg
 provides a human-readable description of the error. 
^S^code
 will be either 
^B^DIVZERO
 (for an attempt to divide by zero), 
^B^DOMAIN
 (if an argument is outside the domain of a function, such as 
^B^acos(-3)
), 
^B^IOVERFLOW
 (for integer overflow), 
^B^OVERFLOW
 (for a floating-point overflow), or 
^B^UNKNOWN
 (if the cause of the error cannot be determined).
^P^
^B^CHILDKILLED 
^S^pid sigName msg
 : This format is used when a child process has 
been killed because of a signal. The second 
element of 
^B^errorCode
 will be the process's 
identifier (in decimal). The third element 
will be the symbolic name of the signal that 
caused the process to terminate; it will be 
one of the names from the include file 
^B^signal.h
, such as 
^B^SIGPIPE
. The fourth element will be a short human-readable message 
describing the signal, such as "write on pipe with no readers" for 
^B^SIGPIPE
.
^P^
^B^CHILDSTATUS 
^S^pid code
 : This format is used when a child process has 
exited with a non-zero exit status. The 
second element of 
^B^errorCode
 will be the process's identifier (in decimal) and the third 
element will be the exit code returned by 
the process (also in decimal).

CHILDSUSP pid sigName msg
This format is used when a child process has 
been suspended because of a signal. The 
second element of errorCode will be the process's identifier, 
in decimal. The third element will be the symbolic name of the 
signal that caused the process to suspend; 
this will be one of the names from the 
include file 
^B^signal.h
, such as 
^B^SIGTTIN
. The fourth element will be a short human-readable 
message describing the signal, such 
as "background tty read" for 
^B^SIGTTIN
.
^P^
^B^NONE
 : This format is used for errors where no 
additional information is available for an 
error besides the message returned with the 
error. In these cases 
^B^errorCode
 will consist of a list containing a single element 
whose contents are NONE.
^P^
^B^POSIX 
^S^errName msg
 : If the first element of 
^B^errorCode
 is 
^B^POSIX, then the error occurred during a POSIX kernel call. 
The second element of the list 
will contain the symbolic name of the error 
that occurred, such as 
^B^ENOENT
; this will be 
one of the values defined in the include 
file 
^B^errno.h
. The third element of the list will be a human-readable message 
corresponding to 
^B^errName
, such as "no such file or directory for the 
^B^ENOENT
 case.
^P^



















