# utils.tcl,v 1.1 1995/11/17 00:42:15 steve Exp
#
# Define some general, utility functions
#

if {[info commands infox] == {}} {
    # TclX is missing.  Do what we can do replace
    # its functions with Tcl (slower) equivalents

    puts stderr "

	WARNING!!! Extended Tcl not installed

Some functionality may not be available

"

    proc lassign {list args} {
	foreach l $list {
	    if {$args == {}} break;
	    upvar [lindex $args 0] var
	    set var $l
	    set args [lrange $args 1 end]
	}
    }

    proc min {a b} {
	if {$a < $b} {return $a} else {return $b}
    }

    proc max {a b} {
	if {$a > $b} {return $a} else {return $b}
    }
    
    proc read_file {f} {
	set fd [open $f]
	if {[catch {read -nonewline $fd} data]} {
	    close $fd
	    error $data
	}
	close $fd
	return $data
    }
}
