#
# Simple Tcl applet.  Slowly eats the contents of the page, starting from the last
# letter.  Will continue until "stop eating" button is activated.
#

catch {applet level hyperwindow} err

# The eating function

proc eatAchar {} {
    global ms id
#   [applet embedwindow] configure -state normal
    [applet embedwindow] delete {end - 2 chars}
#   [applet embedwindow] configure -state disabled
    after $ms eatAchar
}

set ms 1000

proc ChangeSpeed {new} {
    global ms
    set ms $new
}

# Start the eating function

set id [after $ms eatAchar]

# Create the "stop eating" button

wm title . {Eat Hyperdocument}
scale .speed -label "Speed" -orient horiz \
	-from 500 -to 5000 -length 100 -show no -resolution 10 \
	-command ChangeSpeed
pack .speed -side right
button .quit -text "Stop eating" \
	-command {destroy .}
pack .quit -side right
