# Animate a wall clock

wm withdraw .
set win [applet embedwindow]

proc strip_lead_zeroes {x} {
    regsub {^0+} $x {} x
    if {$x == {}} {return 0} else {return $x}
}

# Get the current time
if {[catch {fmtclock [getclock] {%I %M %S}} currTime]} {
    # Don't have TclX installed, so can't display current time
    set currTime {01 01 01}
}
set hour [strip_lead_zeroes [lindex $currTime 0]]
set mins [strip_lead_zeroes [lindex $currTime 1]]
set sec  [strip_lead_zeroes [lindex $currTime 2]]

set c [canvas $win.wallclock -width 120 -height 120]
# Draw the clock background
$c create oval 5 5 110 110 -fill white -outline black -width 5
# Draw the hour points
set pi 3.14156
for {set i 1} {$i < 13} {incr i} {
    set x [expr 57 - 45 * cos(($i / 6.0) * $pi)]
    set y [expr 57 - 45 * sin(($i / 6.0) * $pi)]
    $c create oval [expr $x - 2] [expr $y - 2] [expr $x + 2] [expr $y + 2] \
	-fill black
}
$win window create [applet embedindex] -window $c -align center

# Setup a function to animate the digital clock

proc update_clocks {} {
    global c clockid pi hour mins sec

    # Clear the old hands
    $c delete hourhand
    $c delete minhand
    $c delete sechand

    # Update the time.  This method will suffer clock drift
    incr sec
    if {$sec == 60} {
	set sec 0
	incr mins
	if {$mins == 60} {
	    set mins 0
	    incr hour
	    if {$hour == 13} {
		set hour 1
	    }
	}
    }

    # Draw the wall clock's hands
    $c create line 57 57 \
	[expr 57 - 40 * cos((75.0 + $sec) * $pi / 30.0)] \
	[expr 57 - 40 * sin((75.0 + $sec) * $pi / 30.0)] \
	-fill black -tag sechand
    $c create line 57 57 \
	[expr 57 - 40 * cos((75.0 + $mins) * $pi / 30.0)] \
	[expr 57 - 40 * sin((75.0 + $mins) * $pi / 30.0)] \
	-fill black -tag minhand -width 3
    $c create line 57 57 \
	[expr 57 - 20 * cos((15.0 + ($hour + $mins / 60.0)) * $pi / 6.0)] \
	[expr 57 - 20 * sin((15.0 + ($hour + $mins / 60.0)) * $pi / 6.0)] \
	-fill black -tag hourhand -width 3

    set clockid [after 1000 update_clocks]
}
# Start clock update function
set clockid [after 1000 update_clocks]

# Remove all functions when another page is loaded
proc terminate {} {
    global clockid
    after cancel $clockid
}
