# Animate a digital alarm clock

wm withdraw .
set win [applet embedwindow]

proc strip_lead_zeroes {x} {
    regsub {^0+} $x {} x
    if {$x == {}} {return 0} else {return $x}
}

# Get the current time
if {[catch {fmtclock [getclock] {%I %M %S}} currTime]} {
    # Don't have TclX installed, so can't display current time
    set currTime {01 01 01}
}
set hour [strip_lead_zeroes [lindex $currTime 0]]
set mins [strip_lead_zeroes [lindex $currTime 1]]
set sec  [strip_lead_zeroes [lindex $currTime 2]]

set d [canvas $win.digital -width 100 -height 75]
# Draw the clock background
$d create rectangle 5 5 90 60 -fill black -outline white -width 5
$d create text 17 35 -tag hourtext -fill white -text $hour \
	-font "-*-lucida sans-*-r-*-*-18-*-*-*-*-*-*-*"
$d create text 45 35 -tag mintext -fill white -text $mins \
	-font "-*-lucida sans-*-r-*-*-18-*-*-*-*-*-*-*"
$d create text 75 35 -tag sectext -fill white -text $sec \
	-font "-*-lucida sans-*-r-*-*-18-*-*-*-*-*-*-*"
$win window create [applet embedindex] -window $d -align center

# Setup a function to animate the wall clock

proc update_clocks {} {
    global d clockid pi hour mins sec

    # Update the time.  This method will suffer clock drift
    incr sec
    if {$sec == 60} {
	set sec 0
	incr mins
	if {$mins == 60} {
	    set mins 0
	    incr hour
	    if {$hour == 13} {
		set hour 1
	    }
	    $d dchars hourtext 0 end
	    if {$hour < 10} {
		$d insert hourtext end 0
	    }
	    $d insert hourtext end $hour
	}
	$d dchars mintext 0 end
	if {$mins < 10} {
	    $d insert mintext end 0
	}
	$d insert mintext end $mins
    }
    $d dchars sectext 0 end
    if {$sec < 10} {
	$d insert sectext end 0
    }
    $d insert sectext end $sec

    set clockid [after 1000 update_clocks]
}
# Start clock update function
set clockid [after 1000 update_clocks]

# Remove all functions when another page is loaded
proc terminate {} {
    global clockid
    after cancel $clockid
}
