# global stuff
umask 002
set daynames {Sunday Monday Tuesday Wednesday Thursday Friday Saturday}
set machines {}
set mc_height 60
set armed_host ""
set armed_host_change 0
#
# colors
#
set disarmed_host_color_bg deepskyblue2
set armed_host_color_bg deeppink1
set disarmed_host_color_ab #eed5b7
set armed_host_color_ab deeppink3
set reserved_host_color pink
set free_host_color darkorange3
set week_end_color black
set selectbox_color yellow
#
#set work_dir "/ossc/users1/urban/tcl"
#set work_dir "/usr/local/users/urban/tcl"
set log_file "${work_dir}/reserve.log"
set rob_log "$work_dir/rob.log"
set username [exec whoami]
set cell_binding {}
set data_file_extension "WB_DATA"
set lock_file_extension "WB_LOCK"
set num_cells 0
set rev_cell_binding() ""
set num_halfcells 0
set ignore_request 0
set dialog_button -1
set addchange_tablist {}
set resconf_tablist {}
set add_change() ""
set add_change_button ""
set resconf_button ""
set resconf_user ""
set change_host_selection ""
set host_info() ""
set host_mtime() ""
set host_reservations() ""
set virgin_biglist {}
set select_start_half 0
set alarm_minutes 2
set scan_interval 15;	# seconds

# initial sanity check
if {([catch {file stat $work_dir sc_tmp}]) || ($sc_tmp(type) != "directory")} {
  puts "$work_dir doesn't exist or isn't a directory"
  exit
}
#(31,28,31,30,31,30,31,31,30,31,30,31);
proc MonthDays {month year} {
  set m_l "31 28 31 30 31 30 31 31 30 31 30 31"
  if {($month == 2) && ([expr $year / 4] == [expr ${year}.0 / 4.0])} {
    return 29
  }
  return [lindex $m_l [expr $month - 1]]
}
# now the names...
set month_name(1) January
set month_name(2) February
set month_name(3) March
set month_name(4) April
set month_name(5) May
set month_name(6) June
set month_name(7) July
set month_name(8) August
set month_name(9) September
set month_name(10) October
set month_name(11) November
set month_name(12) December
#
set month_names {spacer January February March April May June July August September October November December}


proc SetDateVars {} {
  global week_num weekday_num monthday_num month_num year_num today
  global month_names
  set week_num [string trimleft [fmtclock [getclock] %W] 0]
  set weekday_num [fmtclock [getclock] %w]
  set monthday_num [string trimleft [fmtclock [getclock] %d] 0]
  set month_num [string trimleft [fmtclock [getclock] %m] 0]
  set year_num [fmtclock [getclock] %y]
  set today "${monthday_num}-[string toupper [string range\
    [lindex $month_names $month_num] 0 2]]-${year_num}"
}

SetDateVars

proc Truncate {foo} {
  regsub {\..*} "$foo" {} tmp
  return "$tmp"
}

proc RequestLock {host} {
  global work_dir username lock_file_extension
  set lock_name "${work_dir}/${host}.$lock_file_extension"
  if {[file exist $lock_name]} {
    set fh [open $lock_name]

    set fink [gets $fh]
    close $fh
    Dialog .dialog {Host Locked} \
      "Sorry, \"$fink\" is currently reserving machine $host. Try again later."\
      error -1 OK
    return 0
  } else {
    set fh [open $lock_name "w" 0640]
    puts $fh "$username"
    close $fh
    return 1
  }
}

proc Mail {user message} {
  set fileid [open "|mail -s \"your reservation was deleted\" $user" w]
  puts $fileid "$message"
  close $fileid
}

proc ZeroHostBits {host start end} {
  global biglist num_halfcells
  for {set i $start} {($i <= $end)&&($i < $num_halfcells)} {incr i} {
    set biglist($host) [lreplace $biglist($host) $i $i 0]
  }
}

proc Convert {code halfcell} {
  global cell_binding weekday_num daynames month_names daynames year_num
#  puts "Convert: halfcell=$halfcell"
  set cell [expr $halfcell / 2]
  set binding [lindex $cell_binding $cell]
  set half [expr "[odd ${halfcell}] ? {afternoon} : {morning}"]
  set dayofmonth [lindex $binding 0]
  set monthnum [lindex $binding 1]
  set year [lindex $binding 2]
#  set month $month_name($monthnum)
  set month [lindex $month_names $monthnum]
  set vmsmonth [string toupper [string range $month 0 2]]
  set dayofweeknum [expr ($weekday_num + $dayofmonth) % 7]
  set dayname [lindex $daynames $dayofweeknum]
  switch $code {
    monthnum     {set answer $monthnum}
    month        {set answer $month}
    dayofmonth   {set answer $dayofmonth}
    halfnum      {set answer [odd $halfcell]}
    halfword     {set answer $half}
    dayofweeknum {set answer $dayofweeknum}
    dayname      {set answer $dayname}
    nicedate     {set answer "${month} $dayofmonth, $half"}
    date1        {set answer [format "%d/%d/%d" $dayofmonth $monthnum \
                  $year_num]}
    file_format  {set answer [format "%d/%d/%d/%d" $dayofmonth $monthnum \
                  $year_num [odd $halfcell]]}
    vmsdate	 {set answer "${dayofmonth}-${vmsmonth}-${year}"}
  }
  return $answer
}

proc ReserveBits {host start end user cust sonst} {
  global num_cells host_reservations biglist num_halfcells
  set real_end [expr "{$end} > {$num_halfcells} ? {$num_cells} : {$end}"]
  set tag [GetFreeTag $host]
  set count $start
  while {$count <= $real_end} {
    set biglist($host) [lreplace $biglist($host) $count $count $tag]
    incr count
  }
  lappend host_reservations($host) "{$tag} {$start} {$end} {$user} {$cust}\
    {$sonst}"
}

proc GetFreeTag {host} {
  global host_reservations
  set alltags {}
  if {[catch {set host_reservations($host)}]} {
    return 1
  }
  foreach ent $host_reservations($host) {
    lappend alltags [lindex $ent 0]
  }
  set found 0
  set trytag 1
  while {!$found} {
    if {[lsearch $alltags $trytag] < 0} {
      set found 1
      break
    }
    incr trytag
  }
  return $trytag
}

proc CellBind {} {
  global cell_binding month_num monthday_num year_num
  global num_cells num_halfcells rev_cell_binding
  set num_halfcells [expr $num_cells * 2]
  set count 0
  set cell_binding ""
  set year $year_num
  set curr_month $month_num
  set curr_day_of_month $monthday_num
  set tmp [expr $num_cells * 4]
  while {$count < $tmp} {
    lappend cell_binding "$curr_day_of_month $curr_month $year"
    set rev_cell_binding(${curr_day_of_month}_${curr_month}_$year) $count
    incr curr_day_of_month
    if {$curr_day_of_month > [MonthDays $curr_month $year]} {
      if {$curr_month == 12} {
        set curr_month 1
        incr year
      } else {
        incr curr_month
      }
      set curr_day_of_month 1
    }
    incr count
  }
}

proc FindHosts {} {
  global work_dir data_file_extension machines host_mtime
  set machines ""
  cd $work_dir
  set list {}
  catch {set list [glob *.$data_file_extension]}
  foreach tmp $list {
    regsub {\..*$} $tmp {} machine
    lappend machines $machine
    file stat $tmp stat_var
    set host_mtime($machine) $stat_var(mtime)
  }
  set machines [lsort $machines]
}

proc CheckDate {} {
  global weekday_num
  set tmp [fmtclock [convertclock now] %w]
  if {$tmp != $weekday_num} {
    SetDateVars
    Init
    return 1
  }
  return 0
}
proc UpdateIfChanged {host} {
  global machines host_mtime data_file_extension work_dir
  cd $work_dir
  file stat "${host}.$data_file_extension" stat_info
  if {[catch {set host_mtime($host)}]} {set host_mtime($host) 0}
  if {$stat_info(mtime) != $host_mtime($host)} {
    set host_mtime($host) $stat_info(mtime)
    ReadHostFile $host
    UpdateHostList $host
    UpdateHostDisplay $host
  }
}

proc RobLog {msg} {
  global rob_log username
  set date [fmtclock [convertclock now] "%a, %b %d, %H:%M:%S"]
  set file_id [open "$rob_log" "a+"]
  puts $file_id "\[$username\]: $date, $msg"
  close $file_id
}

proc ScanForChanges {} {
  global machines host_mtime data_file_extension work_dir scan_interval
  global weekday_num armed_host quickie_var cell_binding
#  RobLog "entered ScanForChanges"
  if {$armed_host != ""} {
    after [expr $scan_interval * 1000] ScanForChanges
    return
  }
  if {[catch {cd $work_dir}]} {
    puts "$work_dir not available"
    puts "ScanForChanges: $work_dir not available"
    after [expr $scan_interval * 1000] ScanForChanges
    return
  }
  set tmp {}
  set complete_init 0
  catch {set tmp [glob *.$data_file_extension]}
  regsub -all {\..[^ ]*} $tmp {} list
  if {([lsort $list] == [lsort $machines])&&([exec date +%w] == $weekday_num)} {
    foreach host $machines {
      UpdateIfChanged $host
    }
  } else {
#    puts "Initing again..."
#    RobLog "cur_weekday=[fmtclock [convertclock now] %w], weekday_num=$weekday_num"
#    RobLog "cell_binding(0)=[lindex $cell_binding 0]"
    Quickie {Have Patience...} 2
    SetDateVars
    Init
    set quickie_var foo
  }
  after [expr $scan_interval * 1000] ScanForChanges
}

proc ZeroHostLists {} {
  global machines virgin_biglist biglist
  foreach machine $machines {
    set biglist($machine) "$virgin_biglist"
  }
}

proc odd {int} {
  if {[expr $int % 2]} {
    return 1
  }
  return 0
}

proc ChangeHost {} {
  global machines change_host_selection host_info add_change armed_host
  global armed_host_change
  if {$armed_host == ""} {
    Dialog .dialog {Sorry, pal} "You have not requested a lock for any machine.\
      To do this select the machine by pressing MB1 on the button for the \
      machine to the left." {error} -1 OK
    return
  }

#  puts "machine=$armed_host"
  set list $host_info($armed_host)
  set add_change(hostname) [lindex $list 0]
  set add_change(hardware) [lindex $list 1]
  set add_change(memory) [lindex $list 2]
  set add_change(disks) [lindex $list 3]
  set add_change(remarks) [lindex $list 4]
  if {[AddChangeHost change] > 0} {
    set host_info($armed_host) "{$add_change(hostname)} {$add_change(hardware)}\
      {$add_change(memory)} {$add_change(disks)} {$add_change(remarks)}"
    set armed_host_change 1
    LogIt "{$armed_host changed Stammdaten, New values:}\
           {hardware: $add_change(hardware)} {memory: $add_change(memory)}\
           {disks: $add_change(disks)} {remarks: $add_change(remarks)}"
  }
}

proc ReadAllHosts {} {
  global machines
  foreach host $machines {
    ReadHostFile $host
  }
}

proc ReadHostFile {host} {
  global host_reservations host_info data_file_extension
  set hardware ""
  set memory ""
  set disks ""
  set remarks ""
  set host_reservations($host) ""
  set filename "${host}.${data_file_extension}"
  set file_id [open $filename "r"]
  while {[gets $file_id line] != -1} {
    set label [lindex $line 0]
    set contents [lindex $line 1]
    switch $label {
      hostname   {
        if {$host != $contents} {
          puts "hostname in data file doesn't match filename for host $host"
          puts "bailing..."
          exit
        }
      }
      hardware {set hardware $contents}
      memory   {set memory $contents}
      disks    {set disks $contents}
      remarks  {set remarks $contents}
      res      {
        set tmp "[ConvertFromFileRes $contents]"
        if {$tmp != ""} {
          lappend host_reservations($host) "$tmp"
        }
      }
      default  {puts "junk in data file: $contents"}
    }
  }
  close $file_id
  set host_info($host) "{$host} {$hardware} {$memory} {$disks} {$remarks}"
}

proc ConvertFromFileRes {list} {
  set tag [lindex $list 0]
  set start_date [lindex $list 1]
  set end_date [lindex $list 2]
  set reserver [lindex $list 3]
  set cust [lindex $list 4]
  set sonst [lindex $list 5]
  set start_halfcell [ConvertFromFileDate $start_date]
  set end_halfcell [ConvertFromFileDate $end_date]
  if {($end_halfcell ==  -1)||($start_halfcell == -1)||($end_halfcell == {})} {
    return {}
  }
  if {$start_halfcell == ""} {
    set start_halfcell 0
  }
  return "{$tag} {$start_halfcell} {$end_halfcell} {$reserver} {$cust} {$sonst}"
}

proc ConvertFromFileDate {file_date} {
#  puts "ConvertFromFileDate: $file_date"
  global month_num year_num monthday_num cell_binding num_cells year_num
  global rev_cell_binding log_file
  if {[scan $file_date "%d/%d/%d/%d" day month year half] != 4} {
    puts "error trying to convert $file_date to internal format"
    LogErr "ConvertFromFileDate: error converting $file_date to internal format"
    return {-1}
  }
  if {$year < $year_num} {return {}}
  if {($year == $year_num)&&(($month < $month_num) ||
      (($month == $month_num) && ($day < $monthday_num)))} {
    return {}
  }
  if {[catch {set cell [set rev_cell_binding(${day}_${month}_$year)]}]} {
    LogErr "ConvertFromFileDate: file_date=$file_date (rev_cell_binding)"
    puts "Error, see $log_file"
    return {-1}
  } else {
    return [expr ($cell * 2) + $half]
  }
}

proc LogErr {message} {
  global username today log_file
  set fileid [open $log_file a]
  puts $fileid "ERROR: \[$today\] $username $message"
  close $fileid
}
  

proc ConvertFromFileDateOrig {file_date} {
  global month_num year_num monthday_num cell_binding num_cells year_num
  if {[scan $file_date "%d/%d/%d/%d" day month year half] != 4} {
    puts "error trying to convert $file_date to internal format"
  }
  if {$year < $year_num} {return {}}
  if {($year == $year_num)&&(($month < $month_num) ||
      (($month == $month_num) && ($day < $monthday_num)))} {
    return {}
  }
  set count 0
  while {$count < $num_cells * 4} {
    set tmp [lindex $cell_binding $count]
    set d [lindex $tmp 0]
    set m [lindex $tmp 1]
    set y [lindex $tmp 2]
    if {($m == $month)&&($d == $day)&&($year == $y)} {
      return [expr ($count * 2) + $half]
    }
    incr count
  }
}

proc WriteHostFile {host chgrp} {
  global host_info host_reservations data_file_extension 
#  puts "-- WriteHostFile --"
  set filename "${host}.${data_file_extension}"
  set file_id [open $filename w 0660]
  puts $file_id "hostname {$host}"
  puts $file_id "hardware {[lindex $host_info($host) 1]}"
  puts $file_id "memory {[lindex $host_info($host) 2]}"
  puts $file_id "disks {[lindex $host_info($host) 3]}"
  puts $file_id "remarks {[lindex $host_info($host) 4]}"
  catch {
    foreach ent $host_reservations($host) {
      puts $file_id "res {[ConvertToFileRes $ent]}"
    }
  }
  close $file_id
  if {$chgrp == "chgrp"} {chgrp staff $filename}
}

proc ConvertToFileRes {list} {
#  puts "ConvertToFileRes: list=$list"
  set tag [lindex $list 0]
  set start_date [Convert file_format [lindex $list 1]]
  set end_date   [Convert file_format [lindex $list 2]]
  set reserver   [lindex $list 3]
  set cust       [lindex $list 4]
  set sonst      [lindex $list 5]
  return "{$tag} {$start_date} {$end_date} {$reserver} {$cust} {$sonst}"
}

proc UpdateLists {} {
  global machines
  foreach host $machines {
    UpdateHostList $host
  }
}

proc UpdateHostList {host} {
  global host_reservations biglist virgin_biglist num_halfcells
  set biglist($host) "$virgin_biglist"
  foreach entry $host_reservations($host) {
    set tag [lindex $entry 0]
    set start [lindex $entry 1]
    set end [lindex $entry 2]
    set count $start
    while {($count < $num_halfcells)&&($count <= $end)} {
      set biglist($host) [lreplace $biglist($host) $count $count $tag]
      incr count
    }
  }
}
  

  
proc InitVirginBiglist {} {
  global virgin_biglist num_cells
  set count 0
  while {$count < [expr $num_cells * 2]} {
    lappend virgin_biglist 0
    incr count
  }
}

proc LogIt {message} {
  global username today log_file
#  puts " -- LogIt --"
  set fileid [open $log_file a]
  puts -nonewline $fileid "\[$today\] $username"
  foreach line $message {
    puts $fileid "	$line"
  }
  puts $fileid ""
  close $fileid
}
