
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <tcl.h>
#include "ReplayXt.h"

extern Tcl_Interp *interp;

void
QuitCB(w, client_data, call_data)
    Widget w;
    XtPointer client_data, call_data;
{
    exit(0);
}

void
PressedCB(w, client_data, call_data)
    Widget w;
    XtPointer client_data, call_data;
{
    printf("action was: %s\n", (char *) client_data);
}

int
main(argc, argv)
    int argc;
    char **argv;
{
    Widget rowcol;
    Widget button;
    XtAppContext app;
    Widget toplevel;

    toplevel = XtAppInitialize(&app, "XmSend", NULL, 0, &argc, argv,
				NULL, NULL, 0);

    rowcol = XmCreateRowColumn(toplevel, "rowcol", NULL, 0);
    XtManageChild(rowcol);

    button = XmCreatePushButton(rowcol, "top_button", NULL, 0);
    XtAddCallback(button, XmNarmCallback, PressedCB, "arm");
    XtAddCallback(button, XmNactivateCallback, PressedCB, "activate");
    XtAddCallback(button, XmNdisarmCallback, PressedCB, "disarm");
    XtManageChild(button);

    button = XmCreatePushButton(rowcol, "Quit", NULL, 0);
    XtManageChild(button);
    XtAddCallback(button, XmNactivateCallback, QuitCB, NULL);

    RXt_RegisterPlayer(toplevel, "replay.rules", "replay.data", True);

    XtRealizeWidget(toplevel);

    XtAppMainLoop(app);
}
