#include <stdio.h>
#include "./evap.h"
#include "../pdt/sample_pdt_out"

int main(int argc,
	 char *argv[]);

int main (int argc, char *argv[])

/* evap - a typical example, type-converted values, types, lists */

{
  int i;
  evap_List_Value *lve;		/* list value entry */

  evap ( &argc, &argv, pdt, NULL, pvt ); /* evaluate parameters */
  printf( "\nProgram name:\n  %s\n\n", pvt[P_HELP].unconverted_value );

  if ( pvt[P_verbose].specified ) {
    printf( "verbose = %d\n", pvt[P_verbose].value.switch_value );
  }
  printf( "command = \"%s\"\n", pvt[P_command].value.string_value );
  printf( "scale_factor = %f\n", pvt[P_scale_factor].value.real_value );
  printf( "millisecond_update_interval = %d\n",
	 pvt[P_millisecond_update_interval].value.integer_value );
  printf( "ignore_output_file_column_one = %d\n",
	 pvt[P_ignore_output_file_column_one].value.boolean_value );
  printf( "output = %s\n", pvt[P_output].value.file_value );
  printf( "queue = %s\n", pvt[P_queue].value.key_value );
  printf( "destination = %s\n", pvt[P_destination].value.application_value );

  printf( "'list of' tty = " );
  lve = pvt[P_tty].list;
  while ( lve->unconverted_value != NULL ) {
    printf( "\"%s\"", lve->value.name_value );
    lve++;			/* next list value entry */
    printf( "%s", lve->unconverted_value !=NULL ? ", " : "" );
  } /* whilend */
  printf( "\n" );

  if (argc > 1) {
    printf("\nFile names:\n  ");
    for(i=1; i < argc; i++)
      printf("%s%s", argv[i], (i < argc-1) ? " " : "");
    printf("\n");
  }

  exit( 0 );

} /* end main */
