#--------dv--------------------Postscript/Druckerausgabe----------------------

#-----------------------------------------------------------------------------
# filloutputbuffers {} Routine, die Variablen des diagoutputmenues in
#                     zugehoerige Puffervariablen schreibt
#                     dp : widgetpfad des auszugebenden Diagramms
#-----------------------------------------------------------------------------
#
proc filloutputbuffers {dp} {

   # Diagramm und Statusvariablen sichtbar machen
   #
   global status diagdata

   # Variablen in zugehoerige Puffer schreiben
   #
   set status($dp.rotatebuffer)        $diagdata($dp.rotate)
   set status($dp.outputcolorbuffer)   $diagdata($dp.outputcolor)
   set status($dp.outputmediumbuffer)  $diagdata($dp.outputmedium)
   set status($dp.printcmdbuffer)      $diagdata($dp.printcmd)
   set status($dp.outputscalebuffer)   $diagdata($dp.outputscale)
   set status($dp.outputheightbuffer)  $diagdata($dp.outputheight)
   set status($dp.outputwidthbuffer)   $diagdata($dp.outputwidth) 
   set status($dp.outputfnamebuffer)   $diagdata($dp.outputfname)
   set status($dp.outputfpathbuffer)   $diagdata($dp.outputfpath)
}

#-----------------------------------------------------------------------------
# diagbuildlegend {} Legende eines Diagramms als Grafikfenster aufbauen
#                    dp      : Widgetpfad des aktuellen Diagramms
#                    l       : Widgetpfad des Clones
#                    xlegend : Breite der Legende in Pixeln
#                    ylegend : Hoehe der Legende in Pixeln
#-----------------------------------------------------------------------------
#
proc diagbuildlegend {dp l xlegend ylegend} {

  # Diagrammvariablen sichtbar machen
  #
  global diagdata

  # Canvas-widget fuer Grafik-legende erzeugen
  #
  canvas $l -width $xlegend -height $ylegend
  place $l -x 0 -y 0 

  # Mitte der Grafiklegende bzgl. der Breite berechnen
  #
  set lmx [expr $xlegend/2]

  # y Position+border (aeusserer Freiraum) des Legendentitels ermitteln
  #
  set lty  [winfo y $dp.report.legend.headline]
  incr lty [lindex [$dp.report.legend.headline config -border] 4]
 
  # Legendentitel in Grafikfenster
  #
  $l create text $lmx $lty\
     -text [lindex [$dp.report.legend.headline config -text ] 4]\
     -font [lindex [$dp.report.legend.headline config -font ] 4]\
     -fill [lindex [$dp.report.legend.headline config -foreground ] 4]\
     -anchor n

  # alle label der Legende erfragen
  #
  set labels [winfo children $dp.report.legend.titles]

  # y Position+Border(aeusserer Widgetfreiraum) des titelRahmens erfragen
  #
  set lfy  [winfo y $dp.report.legend.titles]
  incr lfy [lindex [$dp.report.legend.titles config -border] 4]

  # alle label in Grafik-Legende
  #
  foreach label $labels {
     # y Position der label erfragen
     #
     set lly [winfo y $label] 
     $l create text $lmx [expr $lly+$lfy]\
        -text [lindex [$label config -text ] 4]\
        -font [lindex [$label config -font ] 4]\
        -fill [lindex [$label config -foreground ] 4]\
        -anchor n
  }
update
}

#-----------------------------------------------------------------------------
# diagpostscriptfile {} realisiert die Postscriptfilegenerierung eines 
#                       Diagramms (EPS3);
#                       es werden drei Postscriptfiles zusammen gebaut und in
#                       einen String geschrieben
#                       dp        : widgetpfad des auszugebenden Diagramms
#-----------------------------------------------------------------------------
#
proc diagpostscriptfile {dp} {

  # Diagrammvariablen und Umgebungsvariablen sichtbar machen
  #
  global diagdata status env

  # Groesse der Diagrammfenster in Pixel ermitteln
  #
  set xtotal  $diagdata($dp.winsizex) ; # Hoehe Hauptfenster
  set ytotal  $diagdata($dp.sizey)    ; # Breite Hauptfenster ohne Knopfleiste
  set xreport $diagdata($dp.sizex)    ; # Hoehe Grafikfenster
  set yreport $diagdata($dp.sizey)    ; # Breite Grafikfenster
  set xclip   [expr $diagdata($dp.xaxis)-$diagdata($dp.originx)];# Clipboxlaenge
  set yclip   [expr $diagdata($dp.originy)-$diagdata($dp.yaxis)];# Clipboxhoehe
  set xborder [lindex [$dp.report.legend config -border] 4]
  set xlegend [expr [winfo width $dp.report.legend]-$xborder] ;# Legendenbreite
  set ylegend $yreport                ; # Hoehe Legende (stimmt nur, falls alle
                                        # Titel in die Legende passen) 

   # Druckparameter zusammenbauen---------------------------------------------

   # Druckparameterwerte initialisieren
   #
   set xreportpara ""
   set xclippara   ""
   set xlegendpara "" 
   set yreportpara ""
   set yclippara   ""
   set ylegendpara "" 

   # DruckParameter initialisieren
   #
   set printpara "-colormode $diagdata($dp.outputcolor) "
 
   set osc $diagdata($dp.outputscale)
   if {$osc == "height" && $diagdata($dp.outputheight) != ""} {
      # Laengenskalierung eingeschaltet und Laengenmasszahl nicht leer=>

      # Druckparameter fuer alle Teilfenster erstellen
      #  
      append printpara "-pageheight $diagdata($dp.outputheight) "

      # Hoehenmasszahl fuer Fenster ermitteln
      #
      regexp {([0-9 .]*)([c i m p]?)} $diagdata($dp.outputheight)\
              all number suf

      # Y-Groessen fuer Fenster berechnen
      #
      set yreportscale "[expr double($number)*$yreport/$ytotal]"
      set yclipscale   "[expr double($number)*$yclip  /$ytotal]"
      set ylegendscale "[expr double($number)*$ylegend/$ytotal]" 

      # Y-Groessen-Printparameter erstellen
      #
      # keine Einheit angegeben=> Printers Point (1/72 Zoll) setzen 
      if {$suf ==""} {set suf p} 
      set yreportpara "-pageheight $yreportscale$suf "
      set yclippara   "-pageheight $yclipscale$suf "
      set ylegendpara "-pageheight $ylegendscale$suf "
   }

   if {$osc == "width" && $diagdata($dp.outputwidth) != ""} { 
      # Breitenskalierung eingeschaltet und Breitenmasszahl nicht leer=>

      # allgemeine Druckparameter erstellen
      #
      append printpara "-pagewidth $diagdata($dp.outputwidth) "

      # Breitenmasszahl fuer Fenster ermitteln
      #
      regexp {([0-9 .]*)([c i m p]?)} $diagdata($dp.outputwidth)\
              all number suf

      # X-Groessen fuer Fenster berechnen
      #
      set xreportscale [expr double($number)*$xreport/$xtotal]
      set xclipscale   [expr double($number)*$xclip  /$xtotal]
      set xlegendscale [expr double($number)*$xlegend/$xtotal] 

      # X-Groessen-Printparameter erstellen
      #
      # keine Einheit angegeben=> Printers Point (1/72 Zoll) setzen 
      if {$suf == ""} {set suf p}
      set xreportpara "-pagewidth $xreportscale$suf "
      set xclippara   "-pagewidth $xclipscale$suf "
      set xlegendpara "-pagewidth $xlegendscale$suf "
  }
   
  # Postscriptfiles generieren------------------------------------------------ 

  # Legende als Grafikfenster aufbauen
  #
  set l $dp.report.legend.clone
  diagbuildlegend $dp $l $xlegend $ylegend

  # Zeichenflaeche,Clipbox und Legende als Postscriptdatei speichern 
  #
  eval $dp.report.surface postscript $printpara\
       $xreportpara $yreportpara -file $env(HOME)/dvps1.tmp 
  eval $dp.report.surface.clipbox postscript $printpara\
       $xclippara $yclippara -file $env(HOME)/dvps2.tmp 
  eval $dp.report.legend.clone  postscript $printpara\
       $xlegendpara $ylegendpara -file $env(HOME)/dvps3.tmp

  # Postscriptfile der Grafikflaeche in String einlesen
  #
  set f [open $env(HOME)/dvps1.tmp  r]
      
      while {[gets $f line] >= 0} {
             append report $line \n
      }
  close $f

  # Postscriptfile der Clipping-Box in String einlesen
  #
  set f [open $env(HOME)/dvps2.tmp r]
      while {[gets $f line] >= 0} {
             append clipbox $line \n
      }
  close $f

  # Postscriptfile der Legende in String einlesen
  #
  set f [open $env(HOME)/dvps3.tmp r]
      while {[gets $f line] >= 0} {
            append legend $line \n
      }
  close $f

  # ermittle Bounding Box-Koordinaten fuer Eps3-Kommentar und Verschub
  # Bounding Box des Grafikwidgets erfragen
  # 
  set reportlist [split $report \n]
  set index [lsearch $reportlist "%%BoundingBox:*"]
  set line [lindex $reportlist $index]
  set xreportb1 [lindex $line 1]
  set yreportb1 [lindex $line 2]
  set xreportb2 [lindex $line 3]
  set yreportb2 [lindex $line 4]

  # Bounding Box des Legendenclones erfragen
  #
  set legendlist [split $legend \n]
  set index [lsearch $legendlist "%%BoundingBox:*"]
  set line [lindex $legendlist $index]
  set xlegendb1 [lindex $line 1]
  set ylegendb1 [lindex $line 2]
  set xlegendb2 [lindex $line 3]
  set ylegendb2 [lindex $line 4]

  # Bounding-Box der Gesamtausgabe ermitteln
  #
  set xb1 [expr $xreportb1-($xlegendb2-$xlegendb1)/2]
  set yb1 $yreportb1
  set xb2 [expr $xreportb2+($xlegendb2-$xlegendb1)/2]
  set yb2 $yreportb2

  # Mittelpunkt der Gesamtausgabe ermitteln
  #
  set xmiddle [expr ($xb1+$xb2)/2]
  set ymiddle [expr ($yb1+$yb2)/2]

  # Verschub fuer die Diagrammfenster/Legende berechnen
  #
  set xreportmove [expr -($xlegendb2-$xlegendb1)/2]
  set xlegendmove\
      [expr ($xreportb2-$xreportb1)/2-$xreportmove] ; # bzgl. xreportmove
   

  # X-coordinate fuer Trennstrich Legende/Diagramm berechnen
  #
  set cutline [expr $xreportb2+$xreportmove]

  # Postscriptprogramm  fuer Drehung der Zeichnung erzeugen
  #
  if {$diagdata($dp.rotate)} {
     set    rotatediag "%rotate diagramm\n"
     append rotatediag "$xmiddle $ymiddle translate\n"
     append rotatediag "90 rotate\n"
     append rotatediag "-$xmiddle -$ymiddle translate\n"
  } {
     set rotatediag ""                    
  }

  # Dateien so zusammenbauen, dass sie auf eine Seite gedruckt werden
  # Rahmen fuer GesamtDiagramm und Legende anfuegen
  # (shopage-Kommando unterdruecken)         
  #
  set status($dp.output) ""
  append status($dp.output) "%!PS-Adobe-3.0 EPSF-3.0\n"
  append status($dp.output) "%%Creator: DataVision\n"
  append status($dp.output) "%%For: [id user]\n"
  append status($dp.output) "%%Title: $dp\n"
  append status($dp.output) "%%CreationDate: [fmtclock [getclock]]\n"
  append status($dp.output) "%%BoundingBox $xb1 $yb1 $xb2 $yb2\n"
  append status($dp.output) "%%Pages 1\n"
  append status($dp.output) "%%EndComments\n"
  append status($dp.output) \n
  append status($dp.output) "/beginexecute { %def\n"
  append status($dp.output) "   /level0 save def\n"
  append status($dp.output) "   /showpage {} def\n"
  append status($dp.output) "} bind def\n"
  append status($dp.output) "/endexecute { %def\n"
  append status($dp.output) "   level0 restore\n"
  append status($dp.output) "} bind def\n"
  append status($dp.output) \n
  append status($dp.output) "beginexecute\n"
  append status($dp.output) "% build DataVision-Frame\n"
  append status($dp.output) "$rotatediag"
  append status($dp.output) "2 setlinewidth\n"
  append status($dp.output) "$xb1 $yb1 moveto\n"
  append status($dp.output) "$xb1 $yb2 lineto $xb2 $yb2 lineto\n"
  append status($dp.output) "$xb2 $yb1 lineto [expr $xb1-1] $yb1 lineto\n"
  append status($dp.output) "$cutline $yreportb1 moveto\n"
  append status($dp.output) "$cutline $yreportb2 lineto\n"
  append status($dp.output) "stroke\n"
  append status($dp.output) "$xreportmove 0 translate\n" ;# Verschub
  append status($dp.output) \n
  append status($dp.output) "$report\n"
  append status($dp.output) "$clipbox\n"
  append status($dp.output) "$xlegendmove 0 translate\n" ;# Verschub
  append status($dp.output) "$legend\n"
  append status($dp.output) "endexecute\n"
  append status($dp.output) "showpage\n" 

  # Temporaere Dateien loeschen
  #
  exec rm $env(HOME)/dvps1.tmp
  exec rm $env(HOME)/dvps2.tmp
  exec rm $env(HOME)/dvps3.tmp

  # geclontes LegendenFenster zerstoeren
  #
  destroy $l
}
   
#-----------------------------------------------------------------------------
# diagoutputok {} wird von diagoutput angesprungen, wenn der ok-Knopf  oder der
#                 update Knopf gedrueckt wird. Prueft die Eingabewerte, 
#                 schreibt die Einstellungen in den Diagrammdatensatz, 
#                 realisiert die Ausgabe gemaess den Einstellungen des
#                 diagoutputmenues
#                 path: Pfad des Menues
#                 dp  : widgetpfad des zugehoerigen Diagramms
#-----------------------------------------------------------------------------
#
proc diagoutputok {path dp} { 

   # Diagramm, Status und Fileselectionboxvariablen sichtbar machen
   #
   global diagdata status fsBox

   # Skalierungseingaben pruefen und eventuell festschreiben----------------
   #
   # (Vor- oder Nachkommastelle sind nicht leer und werden, falls beide
   # belegt, durch einen Punkt getrennt; die Zahl kann mit c,i,m,p enden. 
   # 
   set correct [regexp {([0-9]*)\.?([0-9]*)([c i m p]?$)} \
               $status($dp.outputheightbuffer) all int real suf]
          
   if {$correct && ($int != "" || $real != "") || 
       $status($dp.outputheightbuffer) == ""} {
      # Es wurde eine sinnvolle Eingabe gemacht => Wert zurueckschreiben
      #
      set diagdata($dp.outputheight) $status($dp.outputheightbuffer)
   } {
      # fehlerhafte Eingabe => focus auf dieses Feld
      #	
      focus $path.scale.entry.height
 
      # Fehlermeldung erzeugen
      #
      error {The input-field "Diagramheight" must contain a\
             number followed by c,i,m,p. The letters stands for\
             centimeters, inches, millimeters and printer's points\
             (1/72 inch).}
      # Anmerkung: hierhin wird nicht zurueckverzweigt
 
   } ; # if correct

    set correct [regexp {([0-9]+)\.?([0-9]*)([c i m p]?$)} \
                $status($dp.outputwidthbuffer) all int real suf]
   
    if {$correct && ($int != "" || $real != "") ||
        $status($dp.outputwidthbuffer) == ""} {
       # Es wurde eine sinnvolle Eingabe gemacht => Wert zurueckschreiben
       #
       set diagdata($dp.outputwidth) $status($dp.outputwidthbuffer)
    } {
       # Fehlerhafte Eingabe gemacht => focus auf dieses Feld
       #
       focus $path.scale.entry.width
   
       # Fehlermeldung erzeugen
       #
       error {The input-field "Diagramwidth" must contain a\
              number followed by c,i,m,p. The letters stands for\
              centimeters, inches, millimeters and printer's points\
              (1/72 inch).}
       # Anmerkung: hierhin wird nicht zurueckverzweigt

    } ; # if correct

   # restlichen Variablen zurueckschreiben
   #
   set diagdata($dp.rotate)       $status($dp.rotatebuffer)
   set diagdata($dp.outputcolor)  $status($dp.outputcolorbuffer)
   set diagdata($dp.outputmedium) $status($dp.outputmediumbuffer)
   set diagdata($dp.printcmd)     $status($dp.printcmdbuffer)
   set diagdata($dp.outputscale)  $status($dp.outputscalebuffer)
   set diagdata($dp.outputfname)  $status($dp.outputfnamebuffer)
   set diagdata($dp.outputfpath)  $status($dp.outputfpathbuffer)

   # Ausgabe realisieren--------------------------------------------
   #
   busy {diagpostscriptfile $dp}
 
   if {$diagdata($dp.outputmedium) == "postscript"} {

       # Postscriptausgabe realisieren  =>
       # Voreinstellungen  fuer  AusgabePfad kopieren
       #
       set fsBox(path) $diagdata($dp.outputfpath)
 
       # Fileselectionbox aufrufen
       #
       FSBox {Save as Postscriptfile: Select Filename }\
              $diagdata($dp.outputfname) {}
       
       if {$fsBox(name) != ""} {
          # Es wurde ein Filename angegeben =>
          #
          append file [string trimright $fsBox(path) /] / $fsBox(name)

          if {[file exists $file]} {
             # ausgewahlter Filename existiert bereits =>
             # Sicherheitsabfrage stellen
             #
             if {[tk_dialog .confirmation "Warning"\
                 "Warning: File \"$fsBox(name)\" already exists"\
                  warning 1 Overwrite Cancel] == 1} {
                # "Cancel" wurde gewaehlt => Speichervorgang abbrechen
                #
                return
             } ; # "Overwrite" gedrueckt
          } ; # file existiert bereits

          # aktuellen Filepfad/namen kopieren
          #
          set diagdata($dp.outputfpath) $fsBox(path)
          set diagdata($dp.outputfname) $fsBox(name) 

          # Dateiausgabe -----------------------------------
          # 
          busy {
             set file ""
             append file $diagdata($dp.outputfpath) / $diagdata($dp.outputfname)
             set f [open $file w]
             puts $f $status($dp.output)
             close $f 
          }

       } ; # Filename ausgewahlt
   } {
       # Ausgabe auf Drucker---------------------------------
       #
       busy {
          set f [open |$diagdata($dp.printcmd) w]
          puts $f $status($dp.output)
          close $f
       }
   }
}

#-----------------------------------------------------------------------------
# diagoutputmenu {} Erzeugt ein Menue, mit dem Druckoptionen eingestellt
#                 und Postscriptfiles generiert werden koennen, sowie 
#                 Diagramme gedruckt werden
#                 path : Pfad des diagoutputmenues
#                 dp   : widgetpfad des auszugebenden Diagramms
#-----------------------------------------------------------------------------
#
proc diagoutputmenu {path dp} {

  # Fensteraufbau
  #
  # +--------diagoutput---------+
  # |         medium            |
  # +---------------------------+
  # |  +------scale---------+   |
  # |  | buttons | entry    |   |
  # |  +--------------------+   |
  # |                           | 
  # |  +------contain-------+   |  
  # |  | format  | color    |   |
  # |  +--------------------+   |
  # +---------------------------+
  # |         buttons           |
  # +---------------------------+

  # falls toplevel schon existiert, Fenster hervorheben
  #
  if {[winfo exist $path]} {
      myraise $path
      return
  }

  # Diagramm und Statusvariablen sichtbar machen
  #
  global diagdata status

  # erzeuge toplevel
  #
  toplevel $path

  # benenne Toplevel
  #
  wm title $path "[string toupper $diagdata($dp.frametitle)] Output menu"

  # Bitmap fuer icon setzen
  #
  global env
  wm iconbitmap $path @$env(DV_HOME)/bitmaps/statist.xbm
  wm iconname   $path Output

  # Focus merken und focus auf dieses Toplevel
  #
  savefocus
  set focus $path 
  
  # erzeuge Rahmen fuer Ausgabemediumwahl
  #
  frame $path.medium -relief raised -bd 1
  pack $path.medium  -expand true -fill x -padx 10 -pady 10 -ipady 5

    # erzeuge Ueberschrift fuer Mediummenue
    #
    label $path.medium.title -text "Medium Options"
    pack $path.medium.title

    # erzeuge Radiobutton fuer Postscriptausgabe
    #
    radiobutton $path.medium.postscript -text "Save as Postscriptfile (EPS3)" \
       -variable status($dp.outputmediumbuffer) \
       -value postscript -anchor w 
    pack $path.medium.postscript -fill x -padx 10

    # erzeuge Radiobutton fuer Druckerausgabe
    #
    radiobutton $path.medium.printer -text "Send to Printer" \
       -variable status($dp.outputmediumbuffer) \
       -value printer -anchor w
    pack $path.medium.printer -fill x -padx 10
  
    # Erzeuge Label fuer Druckerbefehl
    #
    label $path.medium.heading -text Printercommand:
    pack $path.medium.heading -padx 5 
  
    # Erzeuge Eingabefeld fuer Druckerbefehl
    #
    entry $path.medium.printcmd -text status($dp.printcmdbuffer) \
          -relief sunken
    pack $path.medium.printcmd -fill x -padx 10

  # erzeuge Rahmen fuer Skalierungsoptionen
  #
  frame $path.scale -relief raised -bd 1
  pack $path.scale -expand true -fill x -padx 10 -pady 10 

    # erzeuge Ueberschrift fuer Skalierungsoptionen
    #
    label $path.scale.title -text "Scale Options"
    pack $path.scale.title -fill x 

    # erzeuge Rahmen fuer Radiobuttons
    #
    frame $path.scale.buttons
    pack $path.scale.buttons -expand true -fill x -side left -padx 10 -ipady 5

      # erzeuge Radiobutton fuer die Hoeheneinstellung
      #
      radiobutton $path.scale.buttons.height -text Diagramheight: -anchor w \
           -variable status($dp.outputscalebuffer) -value height
      pack $path.scale.buttons.height -fill x

      # erzeuge Radiobutton fuer die Breiteneinstellung
      #
      radiobutton $path.scale.buttons.width -text Diagramwidth: -anchor w \
           -variable status($dp.outputscalebuffer) -value width
      pack $path.scale.buttons.width  -fill x

    # erzeuge Rahmen fuer Eingabefelder
    #
    frame $path.scale.entry
    pack $path.scale.entry -expand true -fill x -side left -padx 10 -ipady 5

      # erzeuge Entry fuer Hoeheneinstellung
      #
      entry $path.scale.entry.height -text status($dp.outputheightbuffer) \
            -relief sunken
      pack $path.scale.entry.height -fill x 

      # erzeuge Entry fuer Breiteneinstellung
      #
      entry $path.scale.entry.width -text status($dp.outputwidthbuffer) \
            -relief sunken
      pack $path.scale.entry.width -fill x 
  
  # erzeuge Rahmen fuer Orientierung und Farboptionen
  #
  frame $path.contain 
  pack $path.contain -fill x -expand true -pady 10

     # erzeuge Rahmen fuer Orientierungs-Menue
     #
     frame $path.contain.format -relief raised -bd 1
     pack $path.contain.format -side left \
         -fill x -expand true -padx 10 -ipady 5
   
       # erzeuge Ueberschrift "Orientation"
       #
       label $path.contain.format.heading -text Orientation
       pack $path.contain.format.heading
   
       # erzeuge Radiobutton fuer Portrait Einstellung
       #
       radiobutton $path.contain.format.portrait -text Portrait \
             -variable status($dp.rotatebuffer) -value false \
             -anchor w
       pack $path.contain.format.portrait -fill x -padx 10 
   
       # erzeuge Radiobutton fuer Landscape Einstellung
       #
       radiobutton $path.contain.format.landscape -text Landscape \
             -variable status($dp.rotatebuffer) -value true \
             -anchor w
       pack $path.contain.format.landscape -fill x -padx 10
   
     # erzeuge Rahmen fuer Farboptionen
     #
     frame $path.contain.color -relief raised -bd 1
     pack $path.contain.color -fill x -expand true -side left\
           -padx 10 -ipady 5
   
       # erzeuge Ueberschrift "Farbe"
       #
       label $path.contain.color.heading -text "Color Options"
       pack $path.contain.color.heading
      
       # erzeuge Radiobutton fuer Farbausgabe
       # 
       radiobutton $path.contain.color.full -text Color \
             -variable status($dp.outputcolorbuffer) -value color -anchor w
       pack $path.contain.color.full -fill x -padx 10
      
       # erzeuge Radiobutton fuer Schwarz-Weiss Ausgabe
       #
       radiobutton $path.contain.color.grayscale -text Grayscale \
             -variable status($dp.outputcolorbuffer) -value gray \
             -anchor w
       pack $path.contain.color.grayscale -fill x -padx 10 

  # erzeuge Frame fuer Ok und Cancel-Button
  #
  frame $path.buttons
  pack $path.buttons -fill x -expand true -pady 10

    # erzeuge Ok-Button (Eingaben pruefen und ausgeben gemaess Einstellung)
    #
    button $path.buttons.ok -text " OK "\
           -command "diagoutputok $path $dp; destroy $path; setoldfocus"
    pack $path.buttons.ok -padx 5 -ipady 5 -fill x -expand true -side left

    # erzeuge update-Button
    #
    button $path.buttons.update -text "update" -command "diagoutputok $path $dp"
    pack $path.buttons.update -padx 5 -ipady 5 -fill x -expand true -side left

    # erzeuge Cancel-Button (Aktivierung zerstoert Menue)
    #
    button $path.buttons.cancel -text Cancel -command "destroy $path"
    pack $path.buttons.cancel -padx 5 -ipady 5 -fill x -expand true -side left

  # Return Bindungen realisieren
  #
  lvarcat list [findentries $path] $path 
  bindreturn $list "$path.buttons.ok invoke"

    # definiere Refreshprozedur
    #
    proc $path.refresh {path dp} {

      # Variablen des diagoutput-menues in Puffer laden
      #
      filloutputbuffers $dp
    } 

   # zum Initialisieren Refresh einmal aufrufen
   #
   eval $path.refresh $path $dp
}
