#-------dv-main---------------------------------------------------------------
#
# *** DataVision ***
# Dieses Programm ermoeglicht es, Tabellen graphisch darzustellen 
#
#-----------------------------------------------------------------------------
#
# Routinen einladen
#
source $env(DV_HOME)/tools/tools.tcl
source $env(DV_HOME)/init/init.tcl
source $env(DV_HOME)/tools/disjoint.tcl
source $env(DV_HOME)/tools/dialog.tcl
source $env(DV_HOME)/tools/tkerror.tcl
source $env(DV_HOME)/fileop/fileop.tcl
source $env(DV_HOME)/fileop/tools.tcl
source $env(DV_HOME)/fileop/FSBox.tcl
source $env(DV_HOME)/import/wosqlcom.tcl
source $env(DV_HOME)/option/choosewincolors.tcl
source $env(DV_HOME)/domain/domain.tcl
source $env(DV_HOME)/data/data.tcl
source $env(DV_HOME)/data/setundefval.tcl
source $env(DV_HOME)/layout/layout.tcl
source $env(DV_HOME)/layout/othersize.tcl
source $env(DV_HOME)/layout/choosescales.tcl
source $env(DV_HOME)/layout/choosecolors.tcl
source $env(DV_HOME)/viewer/diagrams.tcl
source $env(DV_HOME)/viewer/tools.tcl
source $env(DV_HOME)/postscript/output.tcl
source $env(DV_HOME)/help/about.tcl
source $env(DV_HOME)/help/tclhelp.tcl
source $env(DV_HOME)/help/help.tcl

#-----------------------------------------------------------------------------
# globale Variablen
#-----------------------------------------------------------------------------
# diagdata              : [array]  enthaelt Daten zu Diagrammen
#                                  (siehe diagdatainit {}) 
# configbuffer          : [array]  enthaelt Daten zu Diagrammen; wird als
#                                  Puffer beim Konfigurationsladen benutzt
# fsBox                 : [array]  enthaelt Daten zur FileSelectionBox
# dlb                   : [array]   wird von der disjoint-library benutzt
#
# status                : [array]  enthaelt Zustands Daten des Programms :
#  (version)            : [string] enthaelt Versionsbezeichnung von dv
#  (busybuffer)         : [string] (wird von busy in ./diagtools/tools erzeugt)
#  (oldfocus)           : [string]  Liste gespeicherter Focusse
#  (zoomx1)             : X-Koordinate des ersten Punktes des Zoomrahmens
#  (zoomy1)             : Y-Koordinate des ersten Punktes des Zoomrahmens
#  (zoomx2)             : X-Koordinate des zweiten Punktes des Zoomrahmens
#  (zoomy2)             : Y-Koordinate des zweiten Punktes des Zoomrahmens
 
    # ($dp steht fuer den widget-Pfad des aktuellen Diagramms):
#  ($dp.arraytolist[0-9]+)  : [integer] Feld von Referenzindizees im
#                                       diagcolschoosemenu
#  ($dp.listtoarray[0-9]+)  : [integer] Feld von Referenzindizees im
#                                       diagcolschoosemenu
#  ($dp.aslisttoarray[0-9]+): [integer] Feld von Referenzindizees im
#                                       diagcolsassignmenu	
#  ($dp.asarraytolist[0-9]+): [integer] Feld von Referenzindizees im
#                                       diagcolsassignmenu
#  ($dp.cmd)                : [string]  Kommandostring, der auf OK bzw. UPDATE
#                                       im diagcolsassign/diagcolschoosemenue
#                                       ausgefuehrt wird
#  ($dp.assignstatus)       : [integer] Eingabestatus im diagcolsassigmenu
#  ($dp.assignreport)       : [string]  Eingabeanzeige im diagcolsassignmenu
#  ($dp.assignlastind)      : [integer] Index der letzten gewaehlten Spalte im
#  ($dp.poscurvechoose)     : [string]  Position des Kurvenauswahlmenues auf
#                                       dem Bildschirm
#  ($dp.output)             : [string]  Postscriptausgabestring aus diagoutput
#  ($dp*buffer)             :           Puffervariablen verschiedener Menues 
#  ($dp.curvebuffer)        :           wird von diagcolassignmenu  benutzt


#-------------------------------Hauptmenues-----------------------------------

#-----------------------------------------------------------------------------
# mainmenu {} realisiert die Hauptmenueleiste des Programms
#             path : Pfad, in den die Menueleiste eingehaengt wird
#-----------------------------------------------------------------------------
#
proc mainmenu {path} {

  global diagdata

  # Diagrammkennung des aktuellen Diagramms setzen
  #
  set dp $diagdata(diagram)

  # Menueleistenrahmen erstellen
  #
  frame $path.menu -relief raised -bd 1
  pack $path.menu -fill x 

  # Diagrammvariablen sichtbar machen
  #
  global diagdata

  # Menueleisteneintraege realisieren-------------------------------
  #
  menubutton $path.menu.file -text "File" -underline 0\
             -menu $path.menu.file.pdown
  menu $path.menu.file.pdown

  menubutton $path.menu.import -text "Import" -underline 0\
             -menu $path.menu.import.pdown
  menu $path.menu.import.pdown

  menubutton $path.menu.option -text "Option" -underline 0\
             -menu $path.menu.option.pdown
  menu $path.menu.option.pdown

  menubutton $path.menu.domain -text "Domain" -underline 0\
             -menu $path.menu.domain.pdown
  menu $path.menu.domain.pdown

  menubutton $path.menu.data -text "Data" -underline 1\
             -menu $path.menu.data.pdown
  menu $path.menu.data.pdown 

  menubutton $path.menu.diagram -text "Diagram" -underline 3\
             -menu $path.menu.diagram.pdown
  menu $path.menu.diagram.pdown

  menubutton $path.menu.help -text "Help" -underline 0\
             -menu $path.menu.help.pdown
  menu $path.menu.help.pdown

  pack $path.menu.file $path.menu.import $path.menu.option $path.menu.domain\
       $path.menu.data $path.menu.diagram -padx 10 -side left 

  pack $path.menu.help -side right -padx 10
  
  # autopost/unpost sowie Tastenaufruf realisieren
  #   
  tk_menuBar $path.menu $path.menu.file $path.menu.import $path.menu.option\
             $path.menu.domain $path.menu.data $path.menu.diagram\
             $path.menu.help

  # Refreshprozedur definieren------------------------------------------------
  #
  proc $path.menu.refresh {path dp} {

   # Diagrammvariablen sichtbar machen
   #
   global diagdata

   # aktuellen Datenpuffer
   #
   set db $diagdata($dp.diagrambuf)

   # Menue File setzen--------------------------------------------
   #
   catch {$path.file.pdown delete 0 last}

   $path.file.pdown add command -label "load data..."\
     -underline 5\
     -command "selectdata $dp $diagdata($dp.filepath) $diagdata($dp.filename)"

   $path.file.pdown add command -label "concat data..."\
     -underline 0\
     -command "concatdata $dp $diagdata($dp.filepath) $diagdata($dp.filename)"

   $path.file.pdown add separator

   $path.file.pdown add command -label "load configuration..."\
     -underline 0\
     -command "selectconfig $dp;\
               busy {setwindowcolors $dp .}"

   $path.file.pdown add command -label "save configuration..."\
     -underline 1\
     -command "saveconfig $dp"

   $path.file.pdown add command -label "save startconfig" -underline 2\
     -command savestartconfig

   $path.file.pdown add command -label "delete startconfig" -underline 3\
     -command deletestartconfig

   $path.file.pdown add separator

   $path.file.pdown add command -label "reset"\
     -underline 0\
     -command "busy \"resetconfig $dp;\
               setwindowcolors $dp .\""

   $path.file.pdown add command -label "quit" \
     -underline 0\
     -command "quitprog"

   # Menu Import setzen-------------------------------------------
   #
   catch {$path.import.pdown delete 0 last}

   $path.import.pdown add command -label "get data from WOSQL"\
     -underline 0 \
     -command "loadfromwosql $dp"

   $path.import.pdown add command -label "concat data from WOSQL"\
     -underline 0 \
     -command "concatfromwosql $dp"

   # Menue Option setzen-------------------------------------------
   #
   catch {$path.option.pdown delete 0 last}
   
   $path.option.pdown add command -label "set window colors..."\
     -underline 0\
     -command "busy {choosewindowcolors $dp\_wincolor $dp}"

   $path.option.pdown add separator

   $path.option.pdown add checkbutton -label "show table"\
     -underline 5\
     -variable diagdata($dp.showtable)\
     -onvalue on\
     -offvalue off\
     -command "busy {toggletable $dp}"

   # Menue domain setzen-------------------------------------------
   #
   catch {$path.domain.pdown delete 0 last}
   $path.domain.pdown add radiobutton -label "index"\
     -underline 0 \
     -variable diagdata($dp.domain)\
     -value index \
     -command "busy \"setdomainindex $dp\""

   $path.domain.pdown add separator

   $path.domain.pdown add radiobutton -label "real"\
     -underline 0 \
     -variable diagdata($dp.domain) \
     -value real\
     -command "busy \"setdomainreal $dp\""

   $path.domain.pdown add radiobutton -label "date \"YYMMDD\""\
     -underline 0\
     -variable diagdata($dp.domain)\
     -value date\
     -command "busy \"setdomaindate $dp\""

   $path.domain.pdown add radiobutton -label "time \"HHMM\""\
     -underline 0\
     -variable diagdata($dp.domain)\
     -value time\
     -command "busy \"setdomaintime $dp\""

   # Menue Data setzen---------------------------------------------
   #
   catch {$path.data.pdown delete 0 last}
   $path.data.pdown add command -label "select curves..."\
     -underline 0 \
     -command "curvechoose $dp"

   $path.data.pdown add separator

   $path.data.pdown add checkbutton\
     -label "$diagdata($dp.undefval) means undefined"\
     -underline [expr [clength $diagdata($dp.undefval)]+1]\
     -onvalue  "partitionon"\
     -offvalue "partitionoff"\
     -variable diagdata($dp.partition)\
     -command "busy \"refreshwindows $dp .\""

   $path.data.pdown add command\
     -label "set undefined value..."\
     -underline 1\
     -command "diagsetundefval $dp\_setundefval $dp"

  # Menue Diagram setzen--------------------------------------------
  #
  catch {$path.diagram.pdown delete 0 last} 
  $path.diagram.pdown add command -label "diagram layout..."\
     -command "diagprefacemenu $dp\_layout $dp"\
     -underline 0

  $path.diagram.pdown add command -label "show diagram..."\
     -underline 0\
     -command "busy \"showdiagram $dp\""

  # Menue Help setzen-----------------------------------------------
  #
  catch {$path.help.pdown delete 0 last}
  $path.help.pdown add command -label "about..."\
     -underline 0\
     -command "dvabout .about $dp"

  $path.help.pdown add command -label "help..."\
     -underline 0\
     -command {dvhelp .help}
 
  } ; # Refreshproc 

  # Hauptfenster fuer Tastentraverse vorbereiten
  #
  tk_bindForTraversal .

  # Zum initialisieren Refresh durchfuehren
  #
  refreshwindows $dp .

  # alten Focus Speichern und Focus auf die Menueleiste
  #
  savefocus ; focus $path.menu
} 

#-----------------------------------------------------------------------------
# showstatus {} erzeugt das Statusfenster der Hauptkonsole
#               path :  Pfadname des Statusfensters
#-----------------------------------------------------------------------------
#
proc showstatus {path} {

  global diagdata

  # Diagrammkennung des akutellen Diagramms setzen
  #
  set dp $diagdata(diagram)

  # Fenster aufbauen
  #
  frame $path
  pack $path -padx 5 -fill x
  frame $path.frame -relief ridge
  pack $path.frame -pady 10  -fill x

  frame $path.frame.left 
  frame $path.frame.left.label
  frame $path.frame.left.view
  frame $path.frame.right 
  frame $path.frame.right.label
  frame $path.frame.right.view 

  pack $path.frame.left $path.frame.right \
       -side left -padx 10 
  pack $path.frame.left.label $path.frame.left.view\
       $path.frame.right.label $path.frame.right.view\
       -side left -padx 10

  label $path.frame.left.label.status  -text "status of dataset:"
  label $path.frame.left.label.dataset -text "current dataset: "
  label $path.frame.left.label.undef   -text "undefined value:"
  pack $path.frame.left.label.status\
       $path.frame.left.label.dataset\
       $path.frame.left.label.undef\
       -anchor w

  label $path.frame.left.view.status 
  label $path.frame.left.view.dataset
  label $path.frame.left.view.undef
  pack $path.frame.left.view.status\
       $path.frame.left.view.dataset\
       $path.frame.left.view.undef\
       -anchor w

  label $path.frame.right.label.domain  -text "current domain:"
  label $path.frame.right.label.columns -text "#columns of dataset:"
  label $path.frame.right.label.rows    -text "#rows of dataset:"
  pack $path.frame.right.label.domain\
       $path.frame.right.label.columns\
       $path.frame.right.label.rows\
       -anchor w

  label $path.frame.right.view.domain 
  label $path.frame.right.view.columns
  label $path.frame.right.view.rows
  pack  $path.frame.right.view.domain\
       $path.frame.right.view.columns\
       $path.frame.right.view.rows\
       -anchor w

  label $path.head -text "STATUS" ;# Ueberschrift setzen
  place $path.head -relx 0.5 -rely 0.0 -anchor n
 
  # refreshprozedur definieren ---------------------------------------------
  #
  proc $path.refresh {path dp} { 

    # Diagrammvariablen sichtbar machen
    #
    global diagdata

    # aktuelle Werte in Statusanzeigefelder setzen
    #
    $path.frame.left.view.status   config -text $diagdata($dp.status)
    $path.frame.left.view.dataset  config -text $diagdata(diagram)
    $path.frame.right.view.rows    config -text $diagdata($dp.rownum)
    $path.frame.right.view.domain  config -text $diagdata($dp.domain)
    $path.frame.right.view.columns config -text $diagdata($dp.colnum)

    if {$diagdata($dp.partition) == "partitionon"} {
       # undefinierte Werte werden beruecksichtigt
       #
       $path.frame.left.view.undef config -text $diagdata($dp.undefval)
    } {
       # undefinierte Werte werden nicht beruecksichtigt
       #
       $path.frame.left.view.undef config -text "****"
    }
  } ; # refreshproc

  # zum initialisieren refresh einmal aufrufen
  #
  $path.refresh $path $dp

} ; # showstatus 
   
#-----------------------------------------------------------------------------
# toggletable {} Hilfsprozedur, die je nach Einstellung der Variablen 
#                diagdata($dp.showtable) das Tabellenanzeigefenster im
#                Hauptfenster installiert bzw. deinstalliert
#                dp : aktueller Diagrammwidgetpfad
#----------------------------------------------------------------------------
#
proc toggletable {dp} {
 
  # Diagrammvariablen sichtbar machen
  #
  global diagdata 

  if {$diagdata($dp.showtable) == "on"} {

     # Tabelle soll gezeigt werden =>
     
     if {![winfo exists $dp\_main.pos]} {
        # zugehoerige minimale Groesse und Geometry setzen
        #
        wm minsize $dp\_main  535 280
        wm geometry $dp\_main 535x380

        # Tabellenwidget einbauen
        #
        frame $dp\_main.pos -bd 0
        pack  $dp\_main.pos -after $dp\_main.status -expand true -fill both
        showtable $dp\_main.pos.table
     }
  } {
     # Tabelle soll nicht gezeigt werden =>
     # zugehoerige minimale Groesse und Geometry setzen 
     #
     wm minsize $dp\_main  "" ""
     wm geometry $dp\_main 535x180
    
     # Tabellenwidget zerstoeren
     #
     catch {destroy $dp\_main.pos}
  } ; # if 
}

#-----------------------------------------------------------------------------
# showtable {} zeigt die geladene Tabelle textuell
#              path: Pfadname des Tabellenfensters
#-----------------------------------------------------------------------------
#
proc showtable {path} {

  global diagdata

  # Diagrammkennung des akutellen Diagramms setzen
  #
  set dp $diagdata(diagram)

  # Rahmen aufbauen
  #
  frame $path
  pack $path -padx 5 -expand true -fill both 
  frame $path.frame -relief ridge
  pack $path.frame -pady 10 -expand true -fill both

  # Anzeigefenster aufbauen
  #
  scrollbar $path.frame.vert -command "$path.frame.view yview"
  pack $path.frame.vert -side left -fill y 
  scrollbar $path.frame.hor -command "$path.frame.view xview"\
                            -orient horizontal
  pack $path.frame.hor -side bottom -fill x 
  listbox $path.frame.view -yscroll "$path.frame.vert set"\
                           -xscroll "$path.frame.hor set"\
                           -geometry 1x1\
                           -font -*-courier-*-r-*-*-14-*-*-*-*-*-*-*
  pack $path.frame.view -expand true -fill both -pady 5 

  # Titel setzen
  #
  label $path.head -text "TABLE"
  place $path.head -relx 0.5 -rely 0.0 -anchor n

  # refreshproc definieren ---------------------------------------
  #
  proc $path.refresh {path dp} {

      # Diagrammvariablen sichtbar machen
      #
      global diagdata

      # Anzeigefenster loeschen
      #
      $path.frame.view delete 0 end
   
      # Tabelle darstellen und Index hinzufuegen; dabei Format beibehalten 
      # 
      set maxi [expr $diagdata($dp.rownum)-3] ;# maximaler Index
      set maxl [clength $maxi]                ;# Breite des maxindex
      set maxa [expr $maxl+3]                 ;# Gesamtbreite der Indexspalte

      # die ersten Zwei Zeilen eintragen
      #
      set table $diagdata($dp.table)
      set index [format "%$maxa\s" ""]               ;# Index formatieren
      set line [lvarpop table]
      $path.frame.view insert end "$index $line"     ;# erste Zeile eintragen
      set index [format "%$maxa\s" ""]               ;# Index formatieren
      set line [lvarpop table] 
      $path.frame.view insert end "$index $line"     ;# zweite Zeile eintragen
                   
      # restlichen Zeilen eintragen
      # 
      set i 0
      foreach line $table {
         set index [format "%$maxa\s" "\[$i\]"]     ;# Index formatieren 
         $path.frame.view insert end "$index $line" ;# Zeile eintragen 
         incr i
      }
  } ;# refreshproc

  # zum Initialisieren Refreshproc aufrufen
  #
  $path.refresh $path $dp
}


#-----------------------------------------------------------------------------
# quickmenu {} realisiert die SchnellAuswahlknoepfe 
#              path: Variable, die den Pfadnamen des Schnellmenues enthaelt
#-----------------------------------------------------------------------------
#
proc quickmenu {path} {

  global diagdata

  # Diagrammkennung des aktuellen Diagramms setzen
  #
  set dp $diagdata(diagram)

  # Name des zugehoerigen Datenpuffers
  #
  set db $diagdata($dp.diagrambuf)

  # Knopfleiste erstellen
  #
  frame $path 
  pack $path -side bottom -fill both

  button $path.dataselect -text "load data..."\
     -command "selectdata $dp $diagdata($dp.filepath) $diagdata($dp.filename)"\
     -width 15
  button $path.prefacebut -text "diagram layout..." \
     -command "diagprefacemenu $dp\_layout $dp" -width 15
  button $path.showdiag -text "show diagram"\
     -command "busy \"showdiagram $dp\"" -width 15
  button $path.exit -text "quit" -command "quitprog" -width 15

  pack $path.dataselect $path.prefacebut $path.showdiag $path.exit\
       -padx 5 -pady 5 -ipadx 5 -ipady 5 -side left -expand true -fill x
}

#-----------------------------------------------------------------------------
# mainwindow {} erzeugt das Hauptfenster
#-----------------------------------------------------------------------------
#
proc mainwindow {} {

  # Diagrammvariablen sichtbar machen
  #
  global diagdata

  # Diagrammkennung des aktuellen Diagramms setzen
  #
  set dp $diagdata(diagram)

  # . fenster erzeugen
  #
  toplevel $dp\_main 

  # . fenster verstecken
  #
  wm withdraw $dp\_main

  # Bitmap fuer icon setzen
  #
  global env
  wm iconbitmap $dp\_main @$env(DV_HOME)/bitmaps/statist.xbm
  wm iconname   $dp\_main Main

  # Name fuer Hauptfenster erzeugen
  #
  wm title $dp\_main "DataVision"

  # Hauptmenueleiste einbauen
  #
  mainmenu $dp\_main

  # Leerrahmen
  #
  frame $dp\_main.empty
  pack $dp\_main.empty

  # StatusFenster setzen
  #
  showstatus $dp\_main.status

  # Schnellauswahlknoepfe
  #
  quickmenu $dp\_main.quick

  # Fensterfarben setzen
  #
  setwindowcolors $dp . 

  # refreshprozedur erzeugen -------------------------------------------------
  #
  proc $dp\_main.refresh {path dp} {

    # Tabellenfenster je nach Einstellung von showtable oeffnen/schliessen 
    #
    toggletable $dp

  } ;# refreshproc        

  # zum initialisieren refresh aufrufen
  #
  $dp\_main.refresh $dp\_main $dp 

  # Fenster sichtbar machen
  #
  wm deiconify $dp\_main
}

#-------------------------------main------------------------------------------


# Hauptfenster verstecken
#
wm withdraw .

# Programminitialisierung
#
init {.diagram}

# Diagrammdatensatz initialisieren
#
diagdatainit {.diagram}

# Hauptfenster initialisieren
#
mainwindow
