### Copyright (C) 1995 Jesper K. Pedersen
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#
# funktion to parse input file.
#
proc parseFile {} {
  global subPath progList saveInfo argv argv0 pathProgsNames \
      files menu2funk loaded

  set progList {}
  lappend files main.template
  foreach fileName $files {
    set IN [open [lindex $argv 1]/$fileName]
    set funktion 0
    
    while {![eof $IN]} {
      gets $IN line
      if {$funktion} {
	# read the info line
	if {![regexp {^ *\#(.*)$} $line all line]} {
	  puts "Error in template file \"$fileName\", near funktion $funkName"
	  puts "Type path must be the first line in the funktion"
	  exit -1
	}
	set lastPath "/"
	while {[regexp {^([^/]*)/(.*)$} $line all elm line]} {
	  set elm [string trim $elm]
	  uniqAppend subPath($lastPath) $elm
	  append lastPath "$elm/"
	}
	set line [string trim $line]
	if {$line == ""} {
	  set line $funkName
	}
	set pathProgsNames($funkName) "$lastPath$line"
	uniqAppend subPath($lastPath) $line
	set menu2funk($lastPath$line) $funkName
	set funktion 0
      } elseif {[regexp {^proc ([^\{]+) \{} $line all funk]} {
	set funkName $funk
	if {[lsearch -exact $progList $funk] != -1} {
	  error "function \"$funk\" found more than once."
	}
	lappend progList $funk
	set saveInfo($funk) 0
	set loaded($funk) 0
	set funktion 1
	set lastPath "/"
      }
    }
    close $IN
  }
}
