### Copyright (C) 1995 Jesper K. Pedersen
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


proc writeText {} {
  upvar text text
  if {$text != ""} {
    puts ".help.text insert insert \"$text\""
    set text ""
  }
}

############################################################
#         reading and parsing the help file
#         and writing it to a script
############################################################
if {$argv != ""} {
  set IN [open $argv]
} else {
  set IN [open help.data]
}

set i 0; set slash 0; set quotation 0; set newLine 0
set text ""

while {[gets $IN line] != -1} {
  if {[regexp {^\[(.*)\]$} $line all title]} {
    writeText
    puts "set index \[.help.text index insert\]"
    puts ".help.text insert insert \"$title\\n\""
    puts {.help.text tag add header $index insert}
    puts ".help.lbox insert end \"$title\""
    puts "set generalHelpIndex(\$header) \$index"
    puts "lappend textIndexes {$title}"
    puts "incr header"
  } else {
    set length [string length $line]
    if {$length == 0} {
      append text {\n\n}
    }
    for {set j 0} {$j<$length} {incr j} {
      set char [string range $line $j $j]
      if {$char == "\\"} {
	if {$slash} {
	  append text {\\}
	}
	set slash [expr ($slash+1)%2]

      } elseif {$char == "\""} {
	if {$slash} {
	  append text {\"}
	  set slash 0
	} else {
	  if {$quotation} {
	    # end of quotation
	    writeText
	    puts {.help.text tag add italic $index insert}
	  } else {
	    # beginning of quotation
	    writeText
	    puts {set index [.help.text index insert]}
	  }
	  set quotation [expr ($quotation+1)%2]
	}

      } elseif {$char == "<"} {
	if {$slash} {
	  append text "<"
	  set slash 0
	} else {
	  # start of boldface
	  writeText
	  puts {set index [.help.text index insert]}
	}

      } elseif {$char == ">"} {
	if {$slash} {
	  append text ">"
	  set slash 0
	} else {
	  # end of boldface
	  writeText
	  puts {.help.text tag add bold $index insert}
	}
      } else {
	if {$slash} {
	  append text "\\$char"
	  set newLine 1
	  set slash 0
	} else {
	  append text $char
	  set newLine 0
	}
      }
    }
    if {$length != 0 && !$newLine} {
      append text " "
    }
  }
}
close $IN
writeText
