# create pager widget from a listbox. if widget exists already all 
# lines in it are deleted and the title is reset
#
# return 1 if a new window was made 
#        0 otherwise
#
proc pagerCreate {w type {title ""}} {
    global ListFont
    set exists [catch { 
	$type $w
	if {$type=="toplevel"} {
	    wm geometry $w 600x350
	    wm minsize $w 300 300
	    wm maxsize $w \
		[expr [winfo screenwidth .]-64] \
		[expr [winfo screenheight .]-64]
	    if {$title == ""} {
		set title $w
	    }
	}
    }]

    if {$exists} {
	listBoxClear $w.list.box
	return 0
    }

    # make and pack scrolling area
    frame 	$w.list -relief raised -borderwidth 2
    scrollbar	$w.list.bar -relief sunken -command "$w.list.box view"
    listbox	$w.list.box -font $ListFont -scroll "$w.list.bar set"
    pack append  $w.list \
    	$w.list.bar {left filly frame w} \
	$w.list.box {right expand fill frame e}

    # pack toplevel
    pack append $w $w.list {bottom expand fill}
    return 1
}

