# global stuff
#umask 002
set daynames {Sunday Monday Tuesday Wednesday Thursday Friday Saturday}
set people {}
set holi_list ""
set mc_height 60
set armed_person ""
set armed_person_change 0
set hostname [exec /bin/hostname]
#
#if {[regexp {.*abwesenheit} $argv0]} {}
if {$language == "german"} {
  set color_file "$env(HOME)/.abwesenheit_colors";	# personal color file
} else {
  set color_file "$env(HOME)/.absence_colors";	# personal color file
}
set username [exec whoami]
set cell_binding {}
set num_halfcells 0
set ignore_request 0
set dialog_button -1
set addchange_tablist {}
set resconf_tablist {}
set add_change() ""
set add_change_button ""
set resconf_button ""
set resconf_user ""
set change_person_selection ""
set person_info() ""
set person_mtime() ""
set person_reservations() ""
set virgin_biglist {}
set select_start_half 0
set alarm_minutes 2
set scan_interval 15;	# seconds
set prop_font	"-Adobe-times-medium-r-normal--*-180*"

#(31,28,31,30,31,30,31,31,30,31,30,31);
proc MonthDays {month year} {
  set m_l "31 28 31 30 31 30 31 31 30 31 30 31"
  if {($month == 2) && ([expr $year / 4] == [expr ${year}.0 / 4.0])} {
    return 29
  }
  return [lindex $m_l [expr $month - 1]]
}
# now the names...
#
set month_names {spacer January February March April May June July August September October November December}

proc SetDateVars {} {
  global week_num weekday_num monthday_num month_num year_num today
  global month_names
  set week_num [string trimleft [exec date +%U] 0]
  set weekday_num [exec date +%w]
  set monthday_num [string trimleft [exec date +%d] 0]
  set month_num [string trimleft [exec date +%m] 0]
  set year_num [exec date +%y]
  set today "${monthday_num}-[string toupper\
    [string range [lindex $month_names $month_num] 0 2]]-${year_num}"
}

proc Truncate {foo} {
  regsub {\..*} "$foo" {} tmp
  return "$tmp"
}

proc GetRealName {username} {
  global hostname
  if {$username == "jmh"} {
    return "Holzer"
  }
  if {$hostname == "doofus"} {
    set pwline [exec grep $username /etc/passwd]
  } else {
    set pwline [exec ypcat passwd | grep $username]
  }
  set gecos [lindex [split $pwline {:}] 4]
  set fullname [lindex [split $gecos {,}] 0]
  return [lindex $fullname [expr [llength $fullname] - 1]]
}

proc ClientRequestLock {person} {
  global signon lock_file_extension server
  set ret [ExecRPC RequestLock $person $signon]
  set arg0 [lindex $ret 0]
  if {$arg0 == "failure"} {
    set fink [lindex $ret 1]
    Dialog .dialog {Person Locked} \
      "Sorry, \"$fink\" is currently reserving person $person.\
       Try again later." error -1 OK
    return 0
  } elseif {$arg0 == "error"} {
    Dialog .dialog {error} "$ret" error -1 OK
    return 0
  } else {
    return 1
  }
}

proc ZeroPersonBits {person start end} {
  global biglist num_halfcells
  for {set i $start} {($i <= $end)&&($i < $num_halfcells)} {incr i} {
    set biglist($person) [lreplace $biglist($person) $i $i 0]
  }
}

proc Convert {code halfcell} {
  global cell_binding weekday_num daynames month_names daynames
  global debug
  #if {$debug} {puts "Convert: halfcell=$halfcell"}
  set cell [expr $halfcell / 2]
  #if {$debug} {puts "Convert: cell=$cell"}
  set binding [lindex $cell_binding $cell]
  #if {$debug} {puts "Convert: binding=$binding"}
  set half [expr "[odd ${halfcell}] ? {afternoon} : {morning}"]
  set halfgerm [expr "[odd ${halfcell}] ? {Nachmittag} : {Vormittag}"]
  set dayofmonth [lindex $binding 0]
  set monthnum [lindex $binding 1]
  set year [lindex $binding 2]
  #if {$debug} {puts "day=$dayofmonth, monthnum=$monthnum, year=$year"}
  set month [lindex $month_names $monthnum]
  set vmsmonth [string toupper [string range $month 0 2]]
  set dayofweeknum [expr ($weekday_num + $dayofmonth) % 7]
  set dayname [lindex $daynames $dayofweeknum]
  switch $code {
    monthnum     {set answer $monthnum}
    month        {set answer $month}
    dayofmonth   {set answer $dayofmonth}
    halfnum      {set answer [odd $halfcell]}
    halfword     {set answer $half}
    dayofweeknum {set answer $dayofweeknum}
    dayname      {set answer $dayname}
    nicedate     {set answer "${month} $dayofmonth, $half"}
    secdate      {set answer [format "%d/%d/%d %s" $dayofmonth $monthnum \
                  $year $halfgerm]}
    file_format  {set answer [format "%d/%d/%d/%d" $dayofmonth $monthnum \
                  $year [odd $halfcell]]}
    vmsdate	 {set answer "${dayofmonth}-${vmsmonth}-${year}"}
  }
  return $answer
}

proc ReserveBits {person start end cust sonst fone busy} {
  global num_cells person_reservations biglist num_halfcells
  set real_end [expr "{$end} > {$num_halfcells} ? {$num_cells} : {$end}"]
  set tag [GetFreeTag $person $busy]
  set count $start
  while {$count <= $real_end} {
    set biglist($person) [lreplace $biglist($person) $count $count $tag]
    incr count
  }
  lappend person_reservations($person) "{$tag} {$start} {$end} {$cust}\
    {$sonst} {$fone}"
}

proc GetFreeTag {person busy} {
  global person_reservations
  set alltags {}
  if {[catch {set person_reservations($person)}]} {
    return 1
  }
  foreach ent $person_reservations($person) {
    lappend alltags [lindex $ent 0]
  }
  set found 0
  if {$busy} {
    set trytag 1000
  } else {
    set trytag 1
  }
  while {!$found} {
    if {[lsearch $alltags $trytag] < 0} {
      set found 1
      break
    }
    incr trytag
  }
  return $trytag
}


proc CheckDate {} {
  global weekday_num
  #set tmp [fmtclock [convertclock now] %w]
  set tmp [exec date +%w]
  if {$tmp != $weekday_num} {
    SetDateVars
    Init
    return 1
  }
  return 0
}
proc UpdateIfChanged {person} {
  global people person_mtime server person_reservations

  set mtime [ExecRPC GetModTime $person]
  if {[catch {set person_mtime($person)}]} {set person_mtime($person) 0}
  if {$mtime != $person_mtime($person)} {
    set person_mtime($person) $mtime
    #ReadPersonFile $person
    set person_reservations($person)\
      [ExecRPC set person_reservations($person)]
    UpdatePersonList $person
    UpdatePersonDisplay $person
  }
}

proc ZeroPersonLists {} {
  global people virgin_biglist biglist
  foreach person $people {
    set biglist($person) "$virgin_biglist"
  }
}

proc odd {int} {
  if {[expr $int % 2]} {
    return 1
  }
  return 0
}

proc ChangePerson {} {
  global people change_person_selection person_info add_change armed_person
  global armed_person_change username server

  if {$armed_person == ""} {
    Dialog .dialog {Sorry, pal} "You have not requested a lock for any person.\
      To do this select the person by pressing MB1 on the button for the \
      person to the left." {error} -1 OK
    return
  }

#  puts "person=$armed_person"
  set list $person_info($armed_person)
  set add_change(person) [lindex $list 0]
  #puts "ChangePerson: setting add_change(person) = $add_change(person)"
  set add_change(phone) [lindex $list 1]
  set add_change(address) [lindex $list 2]
  if {[AddChangePerson change] > 0} {
    set person_info($armed_person) "{$add_change(person)} {$add_change(phone)}\
      {$add_change(address)}"
    set armed_person_change 1
    ExecRPC LogIt "{$username changed Stammdaten for $armed_person}"
  }
}

proc UpdateLists {} {
  global people
  foreach person $people {
    UpdatePersonList $person
  }
}

proc UpdatePersonList {person} {
  global person_reservations biglist virgin_biglist num_halfcells
  set biglist($person) "$virgin_biglist"
  foreach entry $person_reservations($person) {
    set tag [lindex $entry 0]
    set start [lindex $entry 1]
    set end [lindex $entry 2]
    set count $start
    while {($count < $num_halfcells)&&($count <= $end)} {
      set biglist($person) [lreplace $biglist($person) $count $count $tag]
      incr count
    }
  }
}
  

  
proc InitVirginBiglist {} {
  global virgin_biglist num_cells
  set count 0
  while {$count < [expr $num_cells * 2]} {
    lappend virgin_biglist 0
    incr count
  }
}

proc GetMesse {cell} {
  global messen cell_binding
  set binding [lindex $cell_binding $cell]
  foreach messe $messen {
    if {([lindex $binding 0] == [lindex $messe 0])&&\
        ([lindex $binding 1] == [lindex $messe 1])&&\
        ([lindex $binding 2] == [lindex $messe 2])} {
        return [lindex $messe 3]
    }
  }
  puts "ERROR: GetMesse: cell=$cell, messen=$messen, messe_list=$messe_list"
}

proc IsHoliday {cell} {
  global cell_binding holidays holiday_list
  foreach holiday $holidays {
#    puts "IsHoliday: cell=$cell, holiday=$holiday"
#    puts "c0=\[[lindex $cell 0]\], h0=\[[lindex $holiday 0]\]"
#    puts "c1=\[[lindex $cell 1]\], h1=\[[lindex $holiday 1]\]"
#    puts "c2=\[[lindex $cell 2]\], h2=\[[lindex $holiday 2]\]"
    if {([lindex $cell 0] == [lindex $holiday 0])&&\
        ([lindex $cell 1] == [lindex $holiday 1])&&\
        ([lindex $cell 2] == [lindex $holiday 2])} {
#      lappend holiday_list "_${num}_"
      return 1
    }
  }
  return 0
}
proc IsMesse {cell} {
  global cell_binding messen messe_list
  foreach messe $messen {
#    puts "IsMesse: cell=$cell, messe=$messe"
#    puts "c0=\[[lindex $cell 0]\], h0=\[[lindex $messe 0]\]"
#    puts "c1=\[[lindex $cell 1]\], h1=\[[lindex $messe 1]\]"
#    puts "c2=\[[lindex $cell 2]\], h2=\[[lindex $messe 2]\]"
    if {([lindex $cell 0] == [lindex $messe 0])&&\
        ([lindex $cell 1] == [lindex $messe 1])&&\
        ([lindex $cell 2] == [lindex $messe 2])} {
#      lappend messe_list "_${num}_"
      return 1
    }
  }
  return 0
}

proc NotifyQuery {op person start_hc end_hc} {
  global weekday_num dialog_button resconf_cust mail_cmd server

  if {[expr $start_hc/2 < (6 - $weekday_num)]} {
    Dialog .dialog {Send Mail?} "Send mail to Waltraud? (Instead of\
      going to her office and entering into timesheet)"\
      question -1 Yes No
    if {$dialog_button == 0} {
      set my_days {Montag Dienstag Mittwoch Donnerstag Freitag}
      set real_user [GetRealName $person]
      set start_secdate [Convert secdate $start_hc]
      set end_secdate [Convert secdate $end_hc]
      set start_half    [expr "[odd $start_hc] ? {Nachmittag} : {Vormittag}"]
      set end_half      [expr "[odd $end_hc] ? {Nachmittag} : {Vormittag}"]
      set start_str "[lindex $my_days [expr ($start_hc / 2) + $weekday_num - 1]\
                     ] $start_half [lindex $start_secdate 0]"
      set end_str   "$end_half [lindex $end_secdate 0]"
      if {$op == "confirm"} {
        set subject "$real_user Abwesenheit"
        set line1 "$real_user wird von $start_str bis $end_str abwesend sein"
        set line2 "Firma/Grund: $resconf_cust"
      } else {
        set line1 "$real_user hat Termin/Abwesenheit GELOESCHT! (nicht mehr gueltig)"
        set line2 "Firma/Grund WAR: $resconf_cust"
        set subject "$real_user: Abwesenheit Eintrag STORNIERT"
      }
      ExecRPC Mail abwesenheit "$subject" "{$line1} {$line2}"
      #dp_RPC $server Mail abwesenheit "$subject" "{$line1} {$line2}"
      #set fid [open "|$mail_cmd -s \"$subject\" abwesenheit" w]
      #puts $fid "$line1"
      #puts $fid "$line2"
      #close $fid
    }
  }
}

proc getkw {day month year} {
  global week_num weekday_num monthday_num month_num year_num today

  if {$year > 1900} {set year [expr $year - 1900]}
  set m_l "0 31 28 31 30 31 30 31 31 30 31 30 31"
  set year_day 0
  for {set m 1} {$m < $month} {incr m} {
    set year_day [expr $year_day + [lindex $m_l $m]]
  }
  set year_day [expr $year_day + $day]
  if {[expr $year / 4] == [expr ${year}.0 / 4.0]} {
    incr year_day;	# leapyear
  }
  set pre_total_days 0
  if {$year > 94} {
    for {set tmp 94} {$tmp < $year} {incr tmp} {
      if {[expr $tmp / 4] == [expr ${tmp}.0 / 4.0]} {
        set pre_total_days [expr $pre_total_days + 366]
      } else {
        set pre_total_days [expr $pre_total_days + 365]
      }
    }
  }
  set total_days [expr $pre_total_days + $year_day]
  #
  # the magic value is 2 because jan 1, 1994 is a saturday
  # d_of_w is day_of_week
  set d_of_w [expr ($total_days - 2) % 7]
  # the calculation is really: (pre_total_days + 1 - 2) % 7
  # yb_d_of_w is year_begin_day_of_week
  set yb_d_of_w [expr ($pre_total_days - 1) % 7]
  #puts "year_day = $year_day, day_of_week = $d_of_w, yb_dow=$yb_d_of_w"
  #puts "fmtclock d_of_w: [fmtclock [convertclock "$month/$day/$year"] %w]"
  # now for the fun stuff...
  #set offset [expr (( $year_day - $weekday_num) % 7) - 1]
  #set offset [expr 8 - $yb_d_of_w]
  set monday [expr ((8 - $yb_d_of_w) % 7) + 1]
  set kw [expr (($year_day - $monday) / 7) + 1]
  #puts "offset = $offset, kw=$kw"
  #puts "fmtclock kw: [fmtclock [convertclock "$month/$day/$year"] %U]"
  return $kw
}

proc ReadAllPeople {} {
  global server people person_reservations person_info
  foreach person $people {
    set person_reservations($person)\
      [ExecRPC set person_reservations($person)]
    set person_info($person) [ExecRPC set person_info($person)]
  }
}

proc TestExecRPC {command args} {
  global server debug errorCode armed_person signon username

  return [eval dp_RPC $server $command $args]
}

proc ExecRPC {command args} {
  global server debug errorCode armed_person signon username

  if {[catch {set ret [eval dp_RPC $server $command $args]}]} {
    #puts "ret=$ret"
    if {$debug} {puts "errorCode=$errorCode"}
    if {[catch {dp_RPC $server expr 2 + 2}]} {
      if {[Dialog .d1 {Connection Broken} "During the command: \"$command\
          $args\" your connection to the server broke"\
          error -1 {Exit Program} {Try to reconnect}] == 0} {
        exit
      } else {
        set try 1
        while {$try} {
          # try to reconnect...
          exec sleep 10
          if {[Connect]} {
	    set try 0
            Quickie "Success!" 2
            set armed_person ""
            set signon [dp_RPC $server SignOn $username]
            Init
            return
          } else {
            if {[Dialog .dg {again} {Try again?} question -1 {YES} {NO}]} {
              set try 0
            }
          }
        }
      }
    } else {
      # connection not broke, but command failed
      if {[Dialog .d2 {error} "During the command: \"$command\
          $args\" there was an error." error -1 {Exit Program} {Continue}]} {
        return
      } else {
        SignOff force
      }
    }
    return
  }
  return "$ret"
}

proc QuitApp {arg} {
  global armed_person armed_person_change dialog_button server signon

  if {$arg != "force"} {
    if {($armed_person != "")&&($armed_person_change != 0)} {
      Dialog .dialog {Save Changes?} "You haven't save your modifications to\
        person $armed_person. Do you want to?" warning -1 {Save Changes} {Throw Away}
      if {$dialog_button == 1} {
        set armed_person_change 0
      }
    }
    if {$armed_person != ""} {
      DisarmPerson $armed_person
    }
  }
  ExecRPC SignOff $signon
  dp_CloseRPC $server
  exit
}
proc LoadHolidays {} {
  global holiday_list

  set holiday_list [ExecRPC set holiday_list]
}

proc LoadMessen {} {
  global messe_list

  set messe_list [ExecRPC set messe_list]
}

proc CellBind {} {
  global cell_binding

  set cell_binding [ExecRPC set cell_binding]
}

proc LogErr {msg} {
  ExecRPC LogIt "{ERROR: $msg}"
}

proc GetRevCellBinding {string} {
  return "[ExecRPC ServerGetRevCellBinding $string]"
}

proc ConvertFromFileDate {file_date} {
  global month_num year_num monthday_num cell_binding num_cells year_num

  puts "ConvertFromFileDate: $file_date"
  if {[scan $file_date "%d/%d/%d/%d" day month year half] != 4} {
    puts "error trying to convert $file_date to internal format"
    LogErr "ConvertFromFileDate: error converting $file_date to internal format"
    return {-1}
  }
  if {$year > 1900} {set year [expr $year - 1900]}
  if {$year < $year_num} {return {}}
  if {($year == $year_num)&&(($month < $month_num) ||
      (($month == $month_num) && ($day < $monthday_num)))} {
    return {}
  }
  set cell [GetRevCellBinding "${day}_${month}_$year"]
  if {$cell == "error"} {
    LogErr "ConvertFromFileDate: file_date=$file_date (rev_cell_binding)"
    return {-1}
  } else {
    return [expr ($cell * 2) + $half]
  }
}
