
#
# dbForm.tcl
#
# This file contains procedures which integrate database (TclVSdb.tcl)
# functionality with forms (TkVSform.tcl) functionality.
#

#----------------
# Bring in the forms and database procedures
#source "/usr/local/lib/tk/TclVS/TclVSdb.tcl"
#source "/usr/local/lib/tk/TclVS/TkVSform.tcl"
#----------------
# DBFexitMainForm -- delete toplevel form, close database, commit changes 
proc DBFexitMainForm {DB FORM} {
    global $DB $FORM
    # -- puts stderr "DBFexitMainForm -- db=$DB form=$FORM"
    foreach table [set ${DB}(tablenames)] {
        if {[set ${DB}($table,rowdirty)]} {
            dbPutRow $DB $table
        }
    }
    formDIE $FORM
    dbClose $DB
    exit
}

#-----------------
# DBFreadRow - read a row from the database table, set appropriate traces
proc DBFreadRow {DB FORM table seqno} {
    global $DB $FORM
    # -- puts stderr "DBFreadRow -- db=$DB form=$FORM table=$table seqno=$seqno"
    dbGetRow $DB $table $seqno
    formTEXTREFRESH $FORM
}
#-----------------
# DBFwriteRow - write a row to the database table, set appropriate traces
proc DBFwriteRow {DB FORM table} {
    global $DB $FORM
    # -- puts stderr "DBFwriteRow -- db=$DB form=$FORM table=$table"
    dbPutRow $DB $table
    formTEXTREFRESH $FORM
}
#-----------------
# DBFnewRow - create a new row in the database table, set appropriate traces
proc DBFnewRow {DB FORM table} {
    global $DB $FORM
    # -- puts stderr "DBFnewRow -- db=$DB form=$FORM table=$table"
    dbNewRow $DB $table
    formTEXTREFRESH $FORM
}
#-----------------
# DBFclearRow - clear the current row in the database table, set appropriate traces
proc DBFclearRow {DB FORM table} {
    global $DB $FORM
    # -- puts stderr "DBFclearRow -- db=$DB form=$FORM table=$table"
    dbClearRow $DB $table
    formTEXTREFRESH $FORM
}
#-----------------
# DBFdeleteRow - delete the current row from the database table, set appropriate traces
proc DBFdeleteRow {DB FORM table} {
    global $DB $FORM
    # -- puts stderr "DBFdeleteRow -- db=$DB form=$FORM table=$table"
    dbDelRow $DB $table
    formTEXTREFRESH $FORM
}
#-----------------
# DBFfirstRow - get the first row from the database table, set appropriate traces
proc DBFfirstRow {DB FORM table} {
    global $DB $FORM
    # -- puts stderr "DBFfirstRow -- db=$DB form=$FORM table=$table"
    dbFirstRow $DB $table
    formTEXTREFRESH $FORM
}
#-----------------
# DBFnextRow - get the next row from the database table, set appropriate traces
proc DBFnextRow {DB FORM table} {
    global $DB $FORM
    # -- puts stderr "DBFnextRow -- db=$DB form=$FORM table=$table"
    dbNextRow $DB $table
    formTEXTREFRESH $FORM
}
#-----------------
# DBFprevRow - get the previous row from the database table, set appropriate traces
proc DBFprevRow {DB FORM table} {
    global $DB $FORM
    # -- puts stderr "DBFprevRow -- db=$DB form=$FORM table=$table"
    dbPrevRow $DB $table
    formTEXTREFRESH $FORM
}
#-----------------
# DBFlastRow - get the last row from the database table, set appropriate traces
proc DBFlastRow {DB FORM table} {
    global $DB $FORM
    # -- puts stderr "DBFlastRow -- db=$DB form=$FORM table=$table"
    dbLastRow $DB $table
    formTEXTREFRESH $FORM
}
#------------------
#
proc DBFfirst {DB FORM tablename} {
    global $DB $FORM
    # -- puts stderr "DBFfirst -- form=$FORM table=$tablename"
    if {[set ${FORM}($tablename,usesearchlist)]} {
        if {[set ${FORM}($tablename,searchlistlen)] > 0} {
            set ${FORM}($tablename,curselindex) 0
            DBFreadRow $DB $FORM $tablename \
                [lindex [set ${FORM}($tablename,searchlist)] 0]
        }
    } else {
        DBFfirstRow $DB $FORM $tablename
    }
}
#------------------
#
proc DBFnext {DB FORM tablename} {
    global $DB $FORM
    # -- puts stderr "DBFnext -- form=$FORM table=$tablename"
    if {[set ${FORM}($tablename,usesearchlist)]} {
        if {[set ${FORM}($tablename,searchlistlen)] > 0} {
            if {[set ${FORM}($tablename,curselindex)] < \
                [expr [set ${FORM}($tablename,searchlistlen)] - 1]} {
                incr ${FORM}($tablename,curselindex) 1
            }
            DBFreadRow $DB $FORM $tablename \
                [lindex [set ${FORM}($tablename,searchlist)] \
                    [set ${FORM}($tablename,curselindex)]]
        }
    } else {
        DBFnextRow $DB $FORM $tablename
    }
}
#------------------
#
proc DBFprev {DB FORM tablename} {
    global $DB $FORM
    # -- puts stderr "DBFprev -- form=$FORM table=$tablename"
    if {[set ${FORM}($tablename,usesearchlist)]} {
        if {[set ${FORM}($tablename,searchlistlen)] > 0} {
            if {[set ${FORM}($tablename,curselindex)] > 0} {
                incr ${FORM}($tablename,curselindex) -1
            }
            DBFreadRow $DB $FORM $tablename \
                [lindex [set ${FORM}($tablename,searchlist)] \
                    [set ${FORM}($tablename,curselindex)]]
        }
    } else {
        DBFprevRow $DB $FORM $tablename
    }
}
#------------------
#
proc DBFlast {DB FORM tablename} {
    global $DB $FORM
    # -- puts stderr "DBFlast -- form=$FORM table=$tablename"
    if {[set ${FORM}($tablename,usesearchlist)]} {
        if {[set ${FORM}($tablename,searchlistlen)] > 0} {
            if {[set ${FORM}($tablename,curselindex)] > 0} {
                set ${FORM}($tablename,curselindex) \
                [expr [set ${FORM}($tablename,searchlistlen)] - 1]
            }
            DBFreadRow $DB $FORM $tablename \
                [lindex [set ${FORM}($tablename,searchlist)] \
                    [set ${FORM}($tablename,curselindex)]]
        }
    } else {
        DBFlastRow $DB $FORM $tablename
    }
}
#-----------------
#
proc DBFresetSearch {DB FORM tablename} {
    global $DB $FORM
    # -- puts stderr "DBFresetSearch -- form=$FORM table=$tablename"
    set ${FORM}($tablename,searchlistlen) "0"
    set ${FORM}($tablename,searchlist) {}
    set ${FORM}($tablename,searchfield) {}
    set ${FORM}($tablename,searchstring) {}
    set ${FORM}($tablename,searchlvalue) {}
    set ${FORM}($tablename,searchhvalue) {}
    set ${FORM}($tablename,searchldate) {}
    set ${FORM}($tablename,searchhdate) {}
    set ${FORM}($tablename,curselindex) 0
    set ${FORM}($tablename,usesearchlist) 0
    set ${FORM}($tablename,searchlistlen) [set ${DB}($tablename,lastseqno)]
    set ${FORM}($tablename,datasource) "database"
}
#-----------------
#
proc DBFsearchForm {DB FORM tablename title} {
    global $DB search $FORM
    # -- puts stderr "DBFsearchForm -- form=$FORM table=$tablename title=$title"
    set f search

    if {![info exists ${FORM}($tablename,searchfield)]} {
        DBFresetSearch $DB $FORM $tablename
    }
    formBEGIN $f $title "+100+100" "" 
      formGROUP $f
        formNEWLINE $f
          formBUTTON $f "" "Reset Search" DBFresetSearch "$DB $FORM $tablename"
          formLABEL  $f "" "     Items found by search:  " $FORM \
            "$tablename,searchlistlen" 12
      formGROUP $f
        formNEWLINE $f
          formLABEL $f "" "Fields:"
        formNEWLINE $f
          formLIST $f "" $DB "$tablename,fieldnames" \
                $FORM "$tablename,searchfield" 4 25
          formLABEL $f "" "     Field for search:  "
          formENTRY $f "" $FORM "$tablename,searchfield" 25
      formGroup $f
        formNEWLINE $f
          formLABEL $f "" "Search Criteria:"
        formNEWLINE $f
          formLABEL $f "" "Search for Substring:  "
          formENTRY $f "" $FORM "$tablename,searchstring" 25
          formLABEL $f "" "               "
          formBUTTON $f "" "Start String Search" DBFstringSearch \
                  "$DB $FORM $tablename"
        formNEWLINE $f 
          formLABEL $f "" "Search for Value:  "
          formENTRY $f ""  $FORM "$tablename,searchlvalue" 12
          formLABEL $f ""  "     To Value:  "
          formENTRY $f ""  $FORM "$tablename,searchhvalue" 12
          formBUTTON $f "" "Start Numeric Search" DBFnumberSearch \
                  "$DB $FORM $tablename"
        formNEWLINE $f 
          formLABEL $f "" "Search for Date:   "
          formENTRY $f "" $FORM "$tablename,searchldate" 12
          formLABEL $f "" "      To Date:  "
          formENTRY $f "" $FORM "$tablename,searchhdate" 12
          formBUTTON $f "" "Start Date Search" DBFdateSearch \
                  "$DB $FORM $tablename"
      formGROUP $f
        formNEWLINE $f
          formBUTTON $f "" "Exit Search" formDIE $f
    formEND $f
}
    
#-----------------
#
proc DBFstringSearch {DB FORM tablename} {
    global $DB $FORM
    set field [set ${FORM}($tablename,searchfield)]
    if {$field == {}} {
        DBFresetSearch $DB $FORM $tablename
        popmsg "Search Error" \
         "You must select a field name prior to starting the selection." 0 OK
        return
    }
    set strg [set ${FORM}($tablename,searchstring)]
    if {$strg == {}} {
        DBFresetSearch $DB $FORM $tablename
        popmsg "Search Error" \
         "You must specify a search string prior to starting the search." 0 OK
        return
    }
    formCURSOR $FORM busy
    set ${FORM}($tablename,searchlist) \
        [dbsearchstring $DB $tablename $field $strg]
    set ${FORM}($tablename,searchlistlen) \
        [llength [set ${FORM}($tablename,searchlist)]]
    set ${FORM}($tablename,usesearchlist) 1
    if {[set ${FORM}($tablename,searchlistlen)] > 0} {
        DBFfirst $DB $FORM $tablename
        set ${FORM}($tablename,datasource) "selection"
    } else {
        popmsg "Search Warning" \
         "No entries in the database table $tablename, field [set ${FORM}($tablename,searchfield)], matched the selection substring \"[set ${FORM}($tablename,searchstring)]\".  The selection was not successful." 0 OK
        DBFresetSearch $DB $FORM $tablename
    }
    formCURSOR $FORM normal
}
#-----------------
#
proc DBFnumberSearch {DB FORM tablename} {
    global $DB $FORM
    set field [set ${FORM}($tablename,searchfield)]
    if {$field == {}} {
        DBFresetSearch $DB $FORM $tablename
        popmsg "Search Error" \
         "You must select a field name prior to starting the selection." 0 OK
        return
    }
    set val1 [set ${FORM}($tablename,searchlvalue)]
    set val2 [set ${FORM}($tablename,searchhvalue)]
    if {$val1 == {} || $val2 == {}} {
        DBFresetSearch $DB $FORM $tablename
        popmsg "Search Error" \
         "You must specify numeric range values to search between prior to starting the search." 0 OK
        return
    }
    formCURSOR $FORM busy
    set ${FORM}($tablename,searchlist) \
        [dbsearchnum $DB $tablename $field $val1 $val2]
    set ${FORM}($tablename,searchlistlen) \
        [llength [set ${FORM}($tablename,searchlist)]]
    set ${FORM}($tablename,usesearchlist) 1
    if {[set ${FORM}($tablename,searchlistlen)] > 0} {
        DBFfirst $DB $FORM $tablename
        set ${FORM}($tablename,datasource) "selection"
    } else {
        popmsg "Search Warning" \
         "No entries in the database table $tablename, field [set ${FORM}($tablename,searchfield)], fell within the numeric range provided.  The selection was not successful." 0 OK
        DBFresetSearch $DB $FORM $tablename
    }
    formCURSOR $FORM normal
}
#------------------
#
proc DBFdateSearch {DB FORM tablename} {
    global $DB $FORM
    set field [set ${FORM}($tablename,searchfield)]
    if {$field == {}} {
        DBFresetSearch $DB $FORM $tablename
        popmsg "Search Error" \
         "You must select a field name prior to starting the selection." 0 OK
        return
    }
    set date1 [set ${FORM}($tablename,searchldate)]
    set date2 [set ${FORM}($tablename,searchhdate)]
    if {$date1 == {} || $date2 == {}} {
        DBFresetSearch $DB $FORM $tablename
        popmsg "Search Error" \
         "You must specify a range of dates (e.g. \"Mar 23, 1995\") to search between prior to starting the search." 0 OK
        return
    }
    formCURSOR $FORM busy
    set ${FORM}($tablename,searchlist) \
        [dbsearchdate $DB $tablename $field $date1 $date2]
    set ${FORM}($tablename,searchlistlen) \
        [llength [set ${FORM}($tablename,searchlist)]]
    set ${FORM}($tablename,usesearchlist) 1
    if {[set ${FORM}($tablename,searchlistlen)] > 0} {
        DBFfirst $DB $FORM $tablename
        set ${FORM}($tablename,datasource) "selection"
    } else {
        popmsg "Search Warning" \
         "No entries in the database table $tablename, field [set ${FORM}($tablename,searchfield)], fell within the date range provided.  The selection was not successful." 0 OK
        DBFresetSearch $DB $FORM $tablename
    }
    formCURSOR $FORM normal
}


