proc group {m} {
  global selected top pp_shape stretchX stretchY moveX moveY
  set upx 10000 
  set upy 10000
  set lowx -1
  set lowy -1
  set par ""
  for_array_keys s selected {
    if {$selected($s)==$m} {
      if {$par == ""} {set par [winfo parent $s]}
      if {$par != [winfo parent $s]} {
        error "All widgets must have same parent."
        return
      }
      set w_upx [winfo x $s]
      set w_upy [winfo y $s]
      set w_lowx [expr $w_upx + [winfo width $s]]
      set w_lowy [expr $w_upy + [winfo height $s]]
      if {$w_upx < $upx} {set upx $w_upx}
      if {$w_upy < $upy} {set upy $w_upy}
      if {$w_lowx > $lowx} {set lowx $w_lowx}
      if {$w_lowy > $lowy} {set lowy $w_lowy} 
    }
  }
  if {$lowx != -1} {
    for_array_keys s selected {
      if {$selected($s)==$m} {
        if {$pp_shape($s) == "place"} {
          set oldSX $stretchX($s)
          set oldSY $stretchY($s)
          set oldMX $moveX($s)
          set oldMY $moveY($s)
          set stretchX($s) 0
          set stretchY($s) 0
          set moveX($s) 0
          set moveY($s) 0
          set nx [expr [my_winfo x $s]-$upx]
          set ny [expr [my_winfo y $s]-$upy]
          set_position $s $nx $ny
          set_size $s [winfo width $s] [winfo height $s]
          set stretchX($s) $oldSX
          set stretchY($s) $oldSY
          set moveX($s) $oldMX
          set moveY($s) $oldMY
        }
      }
    }
    set W [unique $par.group]
    frame $W -width [expr ($lowx-$upx)+4] \
	-height [expr ($lowy-$upy)+4] \
      -relief raised -border 2
    place $W -x $upx -y $upy
    bind_widget $W
    get_placement_info $W
    reparent $W $m
    #update
    foreach s [winfo child $W] {
      if {$pp_shape($s) == "place"} {
        set_position $s [my_winfo x $s] [my_winfo y $s]
        set_size $s [winfo width $s] [winfo height $s]
      }
    }
  }
}

proc last_elm {a} {
  return [lindex $a [expr [llength $a]-1]]
}

#set align_list ""
set align_rec 0


proc lremove {list elem} {
  upvar $list L
  #echo $L $elem
  set ix [lsearch $L $elem]
  if {$ix > -1} {
    set L "[lrange $L 0 [expr $ix-1]] [lrange $L [expr $ix+1] end]"
  }
}

proc to_side {a} {
  if {$a == "T"} {return top}
  if {$a == "B"} {return bottom}
  if {$a == "M"} {return middle}
  if {$a == "L"} {return left}
  if {$a == "R"} {return right}
  if {$a == "C"} {return centre}
  if {$a == "N"} {return none}
}

proc change_fill {w but} {
  global alignment
  if [info exists alignment($w,F)] {
    if {$alignment($w,F) == "X"} { set alignment($w,F) Y
    } elseif {$alignment($w,F) == "Y"} { set alignment($w,F) B
    } elseif {$alignment($w,F) == "B"} { set alignment($w,F) N
    } elseif {$alignment($w,F) == "N"} { set alignment($w,F) X}
  } else {
    set alignment($w,F) X
  }
  align $w -fill $alignment($w,F)
  $but config -text "Fill $alignment($w,F)"
}

proc to_info {a} {
  if {[llength $a] > 1} {
    set w [lindex $a 0]
    set a [lindex $a 1]
    return [list [to_side $a] $w]
  }
  return "[to_side $a] parent"
}

proc align {w args} {
  #error "usage: align widget ?-side side? ?widget?"
  winfo exists $w
  global redo_align align_rec wait_conf place_info
  set redo_align 1
  #set align_rec 0
  #set wait_conf 0
  global align_list 
  global alignment 
  set opt [lvarpop args]
  if {$w == "forget"} {
    lremove align_list $opt
    #catch "place forget $w"
    unset place_info($opt\ -x)
    unset place_info($opt\ -y)
    unset place_info($opt\ -height)
    unset place_info($opt\ -width)
    unset alignment($opt,T) 
    unset alignment($opt,L) 
    unset alignment($opt,R)
    unset alignment($opt,B)
    unset alignment($opt,M)
    unset alignment($opt,C)
    unset alignment($opt,F)
    unset alignment($opt,X)
    unset alignment($opt,Y)
    return
  }
  if {$w == "info"} {
    if ![winfo exists $opt] return
    if ![isset alignment($opt,T)] return
    return "\
-top [to_info $alignment($opt,T)] \
-bottom [to_info $alignment($opt,B)]\
-middle [to_info $alignment($opt,M)]\
-left [to_info $alignment($opt,L)]\
-right [to_info $alignment($opt,R)]\
-centre [to_info $alignment($opt,C)]\
-fill $alignment($opt,F)\
-xpad $alignment($opt,X)\
-ypad $alignment($opt,Y)"
  }
  if [catch "place $w -anchor nw"] {
    error "Can not align this type of widget $w of class [winfo class $w]"
    return
  }
  set place_info($w\ -x) NULL
  set place_info($w\ -y) NULL
  set place_info($w\ -height) NULL
  set place_info($w\ -width) NULL
  set cmd "place $w -x [Winfo x $w] -y [Winfo y $w]"
  place forget $w
  eval $cmd
  set side [lvarpop args]
  #echo opt = $opt, side = $side, W = $W
  if {$opt == ""} {
    if {$align_list == ""} {
      set alignment($w,T) N
      set alignment($w,L) N
      set alignment($w,R) N
      set alignment($w,B) N
      set alignment($w,M) N
      set alignment($w,C) N
      set alignment($w,F) N
      set alignment($w,X) 0
      set alignment($w,Y) 0
    } else {
      set alignment($w,T) N
      set alignment($w,L) N
      set alignment($w,R) N
      set alignment($w,B) N
      set alignment($w,M) N
      set alignment($w,C) N
      set alignment($w,F) N
      set alignment($w,X) 0
      set alignment($w,Y) 0
    }
  } else {
    if {$side == ""} {
      error "usage: align widget | align widget -side side ?widget?"
      return
    }
    set pad $side
    set side [string toupper [csubstr $side 0 0]]
    set opt [string toupper [csubstr $opt 1 1]]
    if ![isset alignment($w,T)] {
      set alignment($w,T) N
      set alignment($w,B) N
      set alignment($w,R) N
      set alignment($w,L) N
      set alignment($w,M) N
      set alignment($w,C) N
      set alignment($w,F) N
      set alignment($w,X) 0
      set alignment($w,Y) 0
    }
    if {$opt == "F"} {
      set alignment($w,$opt) $side
      if {$args != ""} {eval "align $w $args"}
    } elseif {$opt == "X" || $opt == "Y"} {
      set alignment($w,$opt) $pad
      if {$args != ""} {eval "align $w $args"}
    } else {
      set W [lvarpop args]
      if {$W == "" || $W == "-" || $W == "parent"} {
        #echo set alignment($w,$opt) $side
        set alignment($w,$opt) $side
        if {$args != ""} {eval "align $w $args"}
      } else {
        set alignment($w,$opt) [list $W $side]
        if {$args != ""} {eval "align $w $args"}
      }
    }
  }
  lremove align_list $w
  lappend align_list $w
  process_align_list 1
}

set redo_align 1

proc Winfo {v w {par 0}} {
  global place_info alignment
  if {[info exist alignment($w,X)]} {
    set padx $alignment($w,X)
    set pady $alignment($w,Y)
  } else {set padx 0;set pady 0}
  if {[info exist place_info($w\ -$v)] && $place_info($w\ -$v)!= "NULL"} {
    if {$v == "x"} {return [expr $place_info($w\ -$v)]
    } elseif {$v == "y"} {return [expr $place_info($w\ -$v)]
    } elseif {$v == "height"} {return [expr $place_info($w\ -$v)]
    } elseif {$v == "width"} {return [expr $place_info($w\ -$v)]}
  } else { 
    if {($v == "x" || $v == "y")} {
      set bw [expr [get_widget_value [winfo parent $w] borderwidth]]
    } elseif {$par == 1 && ($v == "height" || $v == "width")} {
      set bw [expr 2*[get_widget_value $w borderwidth]]
    } else {set bw 0}   
    if {($v == "height" || $v == "width") && [lsearch [place info $w] -$v] == -1 && [winfo $v $w]==1} {set v req$v}
    #echo RETURNING [expr [winfo $v $w]-$bw] as $v for $w 
    if {$v == "x"} { return [expr [winfo $v $w]-$bw]
    } elseif {$v == "y"} { return [expr [winfo $v $w]-$bw]
    } elseif {$v == "height" || $v == "reqheight"} {
      return [expr [winfo $v $w]-$bw+2*$pady]
    } elseif {$v == "width" || $v == "reqwidth"} {
      return [expr [winfo $v $w]-$bw+2*$padx]
    }
  }
}

set place_info(1) null
unset place_info(1)

proc resize_parent {w x y} {
  global align_maxX align_maxY
  set p [winfo parent $w]
  if [info exists align_maxX($p)] {
    if {$x > $align_maxX($p)} {set align_maxX($p) $x}
    if {$y > $align_maxY($p)} {set align_maxY($p) $y}
  } else {
    set align_maxX($p) $x
    set align_maxY($p) $y
  }
}

set align_maxX(1) 1
unset align_maxX(1)
set align_maxY(1) 1
unset align_maxY(1)

proc Update {} {
  global place_info alignment align_maxX align_maxY
  global place_info
  set old_w ""
  set cmd ""
  for_array_keys w align_maxX {
    if {$align_maxX($w) != 0} {
      if {[winfo class $w] != "Toplevel"} {
        $w config -width [expr $align_maxX($w)+2*[get_widget_value $w borderwidth]]
        set align_maxX($w) 0
      }
    }
    if {$align_maxY($w) != 0} {
      if {[winfo class $w] != "Toplevel"} {
        $w config -height [expr $align_maxY($w)+2*[get_widget_value $w borderwidth]]
        set align_maxY($w) 0
      }
    }
  }
  for_array_keys p place_info {
    set w [lindex $p 0]
    if {[info exist alignment($w,X)]} {
      set padx $alignment($w,X)
      set pady $alignment($w,Y)
    } else {set padx 0;set pady 0}
    if ![winfo exists $w] continue
    set v [lindex $p 1]
    set pl [place info $w]
    set ix [lsearch $pl $v]
    if {$old_w != $w} {
      if {[llength $cmd] > 2} {
        eval $cmd
        update
      }
      set cmd "place $w"
    }
    set old_w $w
    set old ""
    if {$ix > -1} {set old [lindex $pl [expr $ix +1]]}
    if {$pl == "" || $old != $place_info($w\ $v)} {
      if {$v == "-x"} {
        if {$place_info($w\ $v) == "NULL"} {
	  #echo NULL $w $v
          #lappend cmd $v [expr [Winfo x $w]+2]
        } else {
          lappend cmd $v [expr $place_info($w\ $v)+$padx]
        }
      } elseif {$v == "-y"} {
        if {$place_info($w\ $v) == "NULL"} {
	  #echo NULL $w $v
          #lappend cmd $v [expr [Winfo y $w]+2]
        } else {
          lappend cmd $v [expr $place_info($w\ $v)+$pady]
        }
      } elseif {$v == "-height"} {
        if {$place_info($w\ $v) == "NULL"} {
	  #echo NULL $w $v
          #lappend cmd $v [expr [Winfo height $w]-2]
        } else {
          lappend cmd $v [expr $place_info($w\ $v)-2*$pady]
        }
      } elseif {$v == "-width"} {
        if {$place_info($w\ $v) == "NULL"} {
	  #echo NULL $w $v
          #lappend cmd $v [expr [Winfo width $w]-2]
        } else {
          lappend cmd $v [expr $place_info($w\ $v)-2*$padx]
        }
      }
    }
  }
  if {[llength $cmd] > 2} {
    eval $cmd
    update
  }
}

proc a_place {w opt val} {
  set old ""
  global redo_align place_info align_rec
  if [info exists place_info($w\ $opt)] { 
    set old $place_info($w\ $opt)
  } else {
    set pl [place info $w]
    set ix [lsearch $pl $opt]
    if {$ix > -1} {set old [lindex $pl [expr $ix +1]]}
    if {$pl == ""} { 
      set place_info($w\ $opt) $val
      place $w $opt $val
      set redo_align 1
      #place $w $opt $val
      return
    }
  }
  if {$old != $val} {
    set place_info($w\ $opt) $val
    #place $w $opt $val
    set redo_align 1
  } else {
    set pl [place info $w]
    set ix [lsearch $pl $opt]
    #place $w $opt $val
  }
}

set wait_conf 0

bind all <Configure> {
  #lsearch $align_list %W
  global wait_conf
  if {$wait_conf==0} {
    #echo $wait_conf
    after 0 process_align_list 1
  }
}

proc process_align_list {{check 0}} {
  global align_list
  global alignment redo_align align_rec
  global wait_conf
  if {$check == 1 && $wait_conf != 0} {
    return
  }
  set wait_conf 1
  set r [process_alist]
  if {$redo_align == 1 || $r} {
    incr align_rec
    if {$align_rec > 200} {
      error "Alignment called over 200 times."
    } else {
      #echo recursion enter $align_rec
      set redo_align 0
      process_align_list
      #echo recursion leave $align_rec
    }
  } else Update
  if {$align_rec != 0} {incr align_rec -1}
  set wait_conf 0
}

proc get_next_left {w} {
  global alignment
  if ![isset alignment($w,R)] {return ""}
  if {$w == "N"} {return ""}
  set wi [lindex $alignment($w,R) 0]
  set side [lindex $alignment($w,R) 1]
  if {$side != "L"} {return ""}
  if {[isset alignment($wi,L)] && [lindex $alignment($wi,L) 0] == $w 
      && ($alignment($wi,F) == "X" || $alignment($wi,F) == "B")} {
    return [lindex $wi 0]
  } 
  return [get_next_left $wi]
}
proc get_next_top {w} {
  global alignment
  if ![isset alignment($w,B)] {return ""}
  if {$w == "N"} {return ""}
  set wi [lindex $alignment($w,B) 0]
  set side [lindex $alignment($w,B) 1]
  if {$side != "T"} {return ""}
  if {[isset alignment($wi,T)] && [lindex $alignment($wi,T) 0] == $w 
      && ($alignment($wi,F) == "Y" || $alignment($wi,F) == "B")} {
    return [lindex $wi 0]
  } 
  return [get_next_top $wi]
}

proc process_alist {} {
  global align_list
  global alignment redo_align align_rec
  set prev ""
  foreach w $align_list {
    if ![winfo exists $w] {lremove align_list $w; continue}
    set aT $alignment($w,T)
    set aB $alignment($w,B)
    set aL $alignment($w,L)
    set aR $alignment($w,R)
    set aM $alignment($w,M)
    set aC $alignment($w,C)
    #echo >> $w t= $aT b= $aB r= $aR l= $aL
    set positioned 0
    if {$aT == "T"} {
      a_place $w -y 0 
      set positioned T
    } elseif {$aT == "B"} {
      set positioned T
      set par [winfo parent $w]
      a_place $w -y [Winfo height $par 1]
    } elseif {$aT == "M"} {
      set positioned T
      set par [winfo parent $w]
      a_place $w -y [expr [Winfo height $par 1]/2]
    } elseif {$aT == "N"} {
    } else {
      set wi [lvarpop aT]
      set wi [to_widget $wi $w]
      if ![winfo exists $wi] {set aT N}
      if {$aT == "T"} {
        set positioned T
        a_place $w -y [Winfo y $wi]
      } elseif {$aT == "B"} {
        set positioned T
        a_place $w -y [expr [Winfo y $wi]+[Winfo height $wi]]
      } elseif {$aT == "M"} {
        set positioned T
        a_place $w -y [expr [Winfo y $wi]+[Winfo height $wi]/2]
      }
    }
    if {$positioned == 0} {
      set par [winfo parent $w]
      if {$aM == "M"} {
        a_place $w -y [expr [Winfo height $par 1]/2-[Winfo height $w]/2]
        set positioned M
      } elseif {$aM == "T"} {
        set positioned M
        a_place $w -y -[expr [Winfo height $w]/2]
      } elseif {$aM == "B"} {
        set positioned M
        a_place $w -y [expr [Winfo height $par 1]-[Winfo height $w]/2]
      } elseif {$aM == "N"} {
      } else {
        set wi [lvarpop aM]
        set wi [to_widget $wi $w]
        if ![winfo exists $wi] {set aM N}
        if {$aM == "M"} {
          set positioned M
          a_place $w -y [expr ([Winfo y $wi]+[Winfo height $wi]/2)-[Winfo height $w]/2]
        } elseif {$aM == "B"} {
          set positioned M
          a_place $w -y [expr ([Winfo y $wi]+[Winfo height $wi])-[Winfo height $w]/2]
        } elseif {$aM == "T"} {
          set positioned M
          a_place $w -y [expr [Winfo y $wi]-[Winfo height $w]/2]
        }
      }
    } 
    if {$positioned == 0} {
      set par [winfo parent $w]
      if {$aB == "B"} {
        a_place $w -y [expr [Winfo height $par 1]-[Winfo height $w]]
        set positioned B
      } elseif {$aB == "T"} {
        set positioned B
        a_place $w -y -[Winfo height $w]
      } elseif {$aB == "M"} {
        set positioned B
        a_place $w -y [expr [Winfo height $par 1]/2-[Winfo height $w]/2]
      } elseif {$aB == "N"} {
      } else {
        set wi [lvarpop aB]
        set wi [to_widget $wi $w]
        if ![winfo exists $wi] {set aB N}
        if {$aB == "B"} {
          set positioned B
          a_place $w -y [expr [Winfo y $wi]+[Winfo height $wi]-[Winfo height $w]]
        } elseif {$aB == "T"} {
          set positioned B
          a_place $w -y [expr [Winfo y $wi]-[Winfo height $w]]
        } elseif {$aB == "M"} {
          set positioned B
          a_place $w -y [expr [Winfo y $wi]-[Winfo height $w]+[Winfo height $wi]/2]
        }
      }
    }
    set shaped 0
    if {$positioned != "B" && ($alignment($w,F) == "N" || $alignment($w,F) == "X")} {
      #echo resize_parent $w 0 [expr [Winfo y $w]+[Winfo height $w]]
      if {$aB == "B"} {resize_parent $w 0 [expr [Winfo y $w]+[Winfo height $w]]}
    } elseif {$positioned != "B"} {
      #update
      set par [winfo parent $w]
      if {$aB == "B"} {
        set shaped B
        a_place $w -height [expr [Winfo height $par 1]-[Winfo y $w]]
      } elseif {$aB == "T"} {
        set shaped B
        a_place $w -height 0
      } elseif {$aB == "M"} {
        set shaped B
        a_place $w -height [expr [Winfo height $par 1]/2-[Winfo y $w]]
      } elseif {$aB == "N"} {
      } else {
        set wi [lvarpop aB]
        set wi [to_widget $wi $w]
        if ![winfo exists $wi] {set aB N}
        if {$aB == "B"} {
          set shaped B
          a_place $w -height [expr [Winfo y $wi]+[Winfo height $wi]-[Winfo y $w]]
        } elseif {$aB == "T"} {
          set shaped B
          if {$alignment($w,F) == "B" || $alignment($w,F) == "Y"} {
            set wl [get_next_top $w]
          } else {set wl ""}
          if {$wl != ""} {
	      #echo here ar = l $w $wl
            a_place $w -height [expr ([Winfo height $wl]+[Winfo height $w])/2]
          } elseif {$alignment($w,F) == "Y" || $alignment($w,F) == "B"} {
            a_place $w -height [expr [Winfo y $wi]-[Winfo y $w]]
          } else {
            #echo fixed $w
            #a_place $w -height [winfo reqheight $w]
          }
        } elseif {$aB == "M"} {
          set shaped B
          a_place $w -height [expr [Winfo y $wi]-[Winfo y $w]+[Winfo height $wi]/2]
        }
      }
    }
    if {$positioned != "M" && $shaped != "B"} {
      #update
      set par [winfo parent $w]
      if {$aM == "M"} {
        set shaped M
        a_place $w -height [expr [Winfo height $par 1]-[Winfo y $w]*2]
      } elseif {$aM == "T"} {
        set shaped M
        a_place $w -height 0
      } elseif {$aM == "B"} {
        set shaped M
        a_place $w -height [expr ([Winfo height $par 1]-[Winfo y $w])*2]
      } elseif {$aM == "N"} {
      } else {
        set wi [lvarpop aM]
        set wi [to_widget $wi $w]
        if ![winfo exists $wi] {set aM N}
        if {$aM == "B"} {
          set shaped M
          a_place $w -height [expr ([Winfo y $wi]+[Winfo height $wi]-[Winfo y $w])*2]
        } elseif {$aM == "T"} {
          set shaped M
          a_place $w -height [expr ([Winfo y $wi]-[Winfo y $w])*2]
        } elseif {$aM == "M"} {
          set shaped M
          a_place $w -height [expr ([Winfo y $wi]-[Winfo y $w]+[Winfo height $wi]/2)*2]
        }
      }
    }
    set positioned 0
    set shaped 0
    if {$aL == "L"} {
      set positioned L
      a_place $w -x 0 
    } elseif {$aL == "R"} {
      set par [winfo parent $w]
      set positioned L
      a_place $w -x [Winfo width $par 1]
    } elseif {$aL == "C"} {
      set par [winfo parent $w]
      set positioned L
      a_place $w -x [expr [Winfo width $par 1]/2]
    } elseif {$aL == "N"} {
    } else {
      #echo $aL
      set wi [lvarpop aL]
      set wi [to_widget $wi $w]
      if ![winfo exists $wi] {set aL N}
      if {$aL == "L"} {
        set positioned L
        a_place $w -x [Winfo x $wi]
      } elseif {$aL == "R"} {
        set positioned L
        a_place $w -x [expr [Winfo x $wi]+[Winfo width $wi]]
      } elseif {$aL == "C"} {
        set positioned L
        a_place $w -x [expr [Winfo x $wi]+[Winfo width $wi]/2]
      }
    }
    if {$positioned == 0} {
      set par [winfo parent $w]
      if {$aC == "C"} {
        set positioned C
        a_place $w -x [expr [Winfo width $par 1]/2-[Winfo width $w]/2]
      } elseif {$aC == "L"} {
        set positioned C
        a_place $w -x -[expr [Winfo width $w]/2]
      } elseif {$aC == "R"} {
        set positioned C
        a_place $w -x [expr [Winfo width $par 1]-[Winfo width $w]/2]
      } elseif {$aC == "N"} {
      } else {
        set wi [lvarpop aC]
        set wi [to_widget $wi $w]
        if ![winfo exists $wi] {set aC N}
        if {$aC == "C"} {
          set positioned C
          a_place $w -x [expr ([Winfo x $wi]+[Winfo width $wi]/2)-[Winfo width $w]/2]
        } elseif {$aC == "R"} {
          set positioned C
          a_place $w -x [expr ([Winfo x $wi]+[Winfo width $wi])-[Winfo width $w]/2]
        } elseif {$aC == "L"} {
          set positioned C
          a_place $w -x [expr [Winfo x $wi]+[Winfo width $wi]/2]
        }
      }
    } 
    if {$positioned == 0} {
      set par [winfo parent $w]
      if {$aR == "R"} {
        a_place $w -x [expr [Winfo width $par 1]-[Winfo width $w]]
        set positioned R
      } elseif {$aR == "L"} {
        set positioned R
        a_place $w -x -[Winfo width $w]
      } elseif {$aR == "C"} {
        set positioned R
        a_place $w -x [expr [Winfo width $par 1]/2-[Winfo width $w]/2]
      } elseif {$aR == "N"} {
      } else {
        set wi [lvarpop aR]
        set wi [to_widget $wi $w]
        if ![winfo exists $wi] {set aR N}
        if {$aR == "R"} {
          set positioned R
          a_place $w -x [expr [Winfo x $wi]+[Winfo width $wi]-[Winfo width $w]]
        } elseif {$aR == "L"} {
          set positioned R
          a_place $w -x [expr [Winfo x $wi]-[Winfo width $w]]
        } elseif {$aR == "C"} {
          set positioned R
          a_place $w -x [expr [Winfo x $wi]-[Winfo width $w]+[Winfo width $wi]/2]
        }
      }
    } 
    if {$positioned != "R" && ($alignment($w,F) == "N" || $alignment($w,F) == "Y")} {
      if {$aR == "R"} {resize_parent $w [expr [Winfo x $w]+[Winfo width $w]] 0}
    } elseif {$positioned != "R"} {
      #update
      set par [winfo parent $w]
      if {$aR == "R"} {
        set shaped R
        a_place $w -width [expr [Winfo width $par 1]-[Winfo x $w]]
      } elseif {$aR == "L"} {
        set shaped R
        a_place $w -width 0
      } elseif {$aR == "C"} {
        set shaped R
        a_place $w -width [expr [Winfo width $par 1]/2-[Winfo x $w]]
      } elseif {$aR == "N"} {
        set shaped R
      } else {
        set wi [lvarpop aR]
        set wi [to_widget $wi $w]
        if ![winfo exists $wi] {set aR N}
        if {$aR == "R"} {
          set shaped R
          a_place $w -width [expr [Winfo x $wi]+[Winfo width $wi]-[Winfo x $w]]
        } elseif {$aR == "L"} {
          set shaped R
          if {$alignment($w,F) == "B" || $alignment($w,F) == "X"} {
            set wl [get_next_left $w]
          } else {set wl ""}
          if {$wl != ""} {
	      #echo here ar = l $w $wl
            a_place $w -width [expr ([Winfo width $wl]+[Winfo width $w])/2]
          } elseif {$alignment($w,F) == "X" || $alignment($w,F) == "B"} {
            a_place $w -width [expr [Winfo x $wi]-[Winfo x $w]]
          } else {
            #echo fixed $w
            #a_place $w -width [winfo reqwidth $w]
          }
        } elseif {$aR == "C"} {
          set shaped R
          a_place $w -width [expr [Winfo x $wi]-[Winfo x $w]+[Winfo width $wi]/2]
        }
      }
    } else {
      #update
      set par [winfo parent $w]
      if {$aC == "C"} {
        set shaped C
        a_place $w -width [expr [Winfo width $par 1]-[Winfo x $w]*2]
      } elseif {$aC == "L"} {
        set shaped C
        a_place $w -width 0
      } elseif {$aC == "R"} {
        set shaped C
        a_place $w -width [expr ([Winfo width $par 1]-[Winfo x $w])*2]
      } elseif {$aC == "N"} {
      } else {
        set wi [lvarpop aC]
        set wi [to_widget $wi $w]
        if ![winfo exists $wi] {set aC N}
        if ![winfo exists $wi] {set alignment($w,C) N; return 1}
        if {$aC == "R"} {
          set shaped C
          a_place $w -width [expr ([Winfo x $wi]+[Winfo width $wi]-[Winfo x $w)*2]
        } elseif {$aC == "C"} {
          set shaped C
          a_place $w -width [expr [Winfo x $wi]-[Winfo x $w]]
        } elseif {$aC == "L"} {
          set shaped C
          a_place $w -width [expr ([Winfo x $wi]-[Winfo x $w])*2]
        }
      }
    }
    update
  }
  return 0
}

proc show_edge {x y} {
  set w [winfo containing $x $y]
  if {$w == ""} {return "$w N"}
  set x [expr $x-[winfo rootx $w]]
  set y [expr $y-[winfo rooty $w]]
  set W4 [expr [winfo width $w]-4]
  set H4 [expr [winfo height $w]-4]
  if {[expr abs([winfo width $w]/2-$x)]<2 && ($y < 4 || $H4 < $y)} {
    return "$w C"}
  if {[expr abs([winfo height $w]/2-$y)]<2 && ($x < 4 || $W4 < $x)} {
    return "$w M" }
  if {$x < 4} {return "$w L"}
  if {$W4 < $x} {return "$w R"}
  if {$y < 4} {return "$w T"}
  if {$H4 < $y} {return "$w B"}
  return "$w N"
}

proc do_align {e1 e2} {
  echo $e1 $e2
  set w1 [lvarpop e1]
  set w2 [lvarpop e2]
  if {[winfo parent $w2] == [winfo parent $w1]} {
    align $w1 -$e1 $e2 $w2
    align info $w1
  } elseif {[winfo parent $w1] == $w2} {
    align $w1 -$e1 $e2 
    align info $w1
  } else {
    error "Bad widgets to align"
  }
}

proc get_edge {} {
  catch "destroy .showfeedback"
  menu .showfeedback 
  set T .showfeedback.top
  toplevel $T
  wm geom $T +0-0
  message $T.mes -text "Use mouse button one to select window edge.\
\nUse mouse button two to select where edge will align to.\
\nUse mouse button three to finish." -aspect 800
  pack $T.mes
  label .showfeedback.l -text N -width 20 -relief raised
  pack .showfeedback.l
  .showfeedback post 0 0
  grab .showfeedback
  set edge1 ""
  set edge2 ""
  bind .showfeedback <Motion> { 
    %W.l config -text [show_edge %X %Y]
  }
  bind .showfeedback <1> { 
    set edge1 [show_edge %X %Y]
  }
  bind .showfeedback <2> { 
    set edge2 [show_edge %X %Y]
    do_align $edge1 $edge2
  }
  bind .showfeedback <3> { 
    grab release .showfeedback
    catch "destroy .showfeedback"
    #do_align $edge1 $edge2
  }
}

proc auto_align {w} {
  global Mx My
  set top .gui_m.aa
  catch "destroy $top"
  toplevel $top
  wm title $top "Auto Align"
  wm geom $top +$Mx+$My
  frame $top.f
  label $top.l -text "Select widgets to check"
  listbox $top.f.lb -width 10 -height 20 -yscroll "$top.f.sb set"
  bind $top.f.lb <Any-ButtonRelease-1> "do_flash %W"
  scrollbar $top.f.sb -command "$top.f.lb yview"
  $top.f.lb insert end "[winfo parent $w] [winfo class [winfo parent $w]]"
  foreach sib [winfo child [winfo parent $w]] {
    if {$sib == $w} continue
    $top.f.lb insert end "$sib [winfo class $sib]"
  }
  button $top.do -text "Do it." -command "auto_align_cb $w $top.f.lb"
  button $top.can -text "Cancel" -command "destroy $top"
  pack $top.l -fill x
  pack $top.f.lb -side left 
  pack $top.f.sb -side right -fill y
  pack $top.f -fill both
  pack $top.can -fill x -side bottom
  pack $top.do -fill x -side bottom
}

proc auto_align_cb {w lb} {
  set sibs ""
  foreach wi [$lb curselection] {
    lappend sibs [lindex [$lb get $wi] 0]
  }
  do_auto_align $w $sibs
}

proc do_auto_align {w sibs} {
  global alignment
  set old_align [align info $w]
  set old_place [place info $w]
  set old_x [Winfo x $w]
  set old_y [Winfo y $w] 
  set old_w [Winfo width $w]
  set old_h [Winfo height $w]
  set set_x 0
  set set_y 0
  set set_w 0
  set set_h 0

  set bg [get_widget_value $w background]
  $w configure -bg red
  update
  foreach sib $sibs {
    if {$sib == $w} continue
    if {$sib == [winfo parent $w]} {set sib ""}
    foreach e1 {T} {
      foreach e2 {T B M} {
        eval "place forget $w"
        eval "place $w $old_place"
        eval "align $w $old_align"
        eval "align $w -$e1 $e2 $sib"
        if {[expr abs([Winfo y $w]-$old_y)]<4} {
          echo align $w -$e1 $e2 $sib
          set set_y "align $w -$e1 $e2 $sib"
          set old_place [place info $w]
          set old_align [align info $w]
          set old_y [Winfo y $w] 
        }
      }
    }
    eval "place forget $w"
    eval "place $w $old_place"
    eval "align $w $old_align"
    foreach e1 {B} {
      foreach e2 {T B M} {
        eval "place forget $w"
        eval "place $w $old_place"
        eval "align $w $old_align"
        eval "align $w -$e1 $e2 $sib"
        if {$set_y == 0} {
          if {[expr abs([Winfo y $w]-$old_y)]<4} {
            echo align $w -$e1 $e2 $sib
            set set_y "align $w -$e1 $e2 $sib"
            set old_place [place info $w]
            set old_align [align info $w]
            set old_y [Winfo y $w] 
          }
        } else {
          if {$alignment($w,F)=="N" || $alignment($w,F)=="X"} continue
          if {[expr abs([Winfo height $w]-$old_h)]<4} {
            echo align $w -$e1 $e2 $sib
            set set_h "align $w -$e1 $e2 $sib"
            set old_place [place info $w]
            set old_align [align info $w]
            set old_h [Winfo height $w] 
          }
        }
      }
    }
    eval "place forget $w"
    eval "place $w $old_place"
    eval "align $w $old_align"
    update
    if {$set_y == 0 || $set_h == 0} { 
      foreach e1 {M} {
        foreach e2 {T B M} {
          eval "place forget $w"
          eval "place $w $old_place"
          eval "align $w $old_align"
          eval "align $w -$e1 $e2 $sib"
          if {$set_y == 0} {
            if {[expr abs([Winfo y $w]-$old_y)]<4} {
              echo align $w -$e1 $e2 $sib
              set set_y "align $w -$e1 $e2 $sib"
              set old_place [place info $w]
              set old_align [align info $w]
              set old_y [Winfo y $w] 
            }
          } else {
            if {$alignment($w,F)=="N" || $alignment($w,F)=="X"} continue
            if {[expr abs([Winfo height $w]-$old_h)]<4} {
              echo align $w -$e1 $e2 $sib
              set set_h "align $w -$e1 $e2 $sib"
              set old_place [place info $w]
              set old_align [align info $w]
              set old_h [Winfo height $w] 
            }
          }
        }
      }
    }
    eval "place forget $w"
    eval "place $w $old_place"
    eval "align $w $old_align"
    update
    foreach e1 {L} {
      foreach e2 {L R C} {
        eval "place forget $w"
        eval "place $w $old_place"
        eval "align $w $old_align"
        eval "align $w -$e1 $e2 $sib"
        if {[expr abs([Winfo x $w]-$old_x)]<4} {
          echo align $w -$e1 $e2 $sib
          set set_x "align $w -$e1 $e2 $sib"
          set old_place [place info $w]
          set old_align [align info $w]
          set old_x [Winfo x $w] 
        }
      }
    }
    eval "place forget $w"
    eval "place $w $old_place"
    eval "align $w $old_align"
    update
    foreach e1 {R} {
      foreach e2 {L R C} {
        eval "place forget $w"
        eval "place $w $old_place"
        eval "align $w $old_align"
        eval "align $w -$e1 $e2 $sib"
        if {$set_x == 0} {
          if {[expr abs([Winfo x $w]-$old_x)]<4} {
            echo align $w -$e1 $e2 $sib
            set set_x "align $w -$e1 $e2 $sib"
            set old_place [place info $w]
            set old_align [align info $w]
            set old_x [Winfo x $w] 
          }
        } else {
          if {$alignment($w,F)=="N" || $alignment($w,F)=="Y"} continue
          if {[expr abs([Winfo width $w]-$old_w)]<4} {
            echo align $w -$e1 $e2 $sib
            set set_w "align $w -$e1 $e2 $sib"
            set old_place [place info $w]
            set old_align [align info $w]
            set old_w [Winfo width $w] 
          }
        }
      }
    }
    eval "place forget $w"
    eval "place $w $old_place"
    eval "align $w $old_align"
    update
    if {$set_x == 0 || $set_w == 0} { 
      foreach e1 {C} {
        foreach e2 {L R C} {
          eval "place forget $w"
          eval "place $w $old_place"
          eval "align $w $old_align"
          eval "align $w -$e1 $e2 $sib"
          if {$set_x == 0} {
            if {[expr abs([Winfo x $w]-$old_x)]<4} {
              echo align $w -$e1 $e2 $sib
              set set_x "align $w -$e1 $e2 $sib"
              set old_place [place info $w]
              set old_align [align info $w]
              set old_x [Winfo x $w] 
            }
          } else {
            if {$alignment($w,F)=="N" || $alignment($w,F)=="Y"} continue
            if {[expr abs([Winfo width $w]-$old_w)]<4} {
              echo align $w -$e1 $e2 $sib
              set set_w "align $w -$e1 $e2 $sib"
              set old_place [place info $w]
              set old_align [align info $w]
              set old_w [Winfo width $w] 
            }
          }
        }
      }
    }
  }
  eval "place forget $w"
  eval "place $w $old_place"
  eval "align $w $old_align"
  $w configure -bg $bg
}

proc widest {args} {
  set max 0
  set maxw [lindex $args 0]
  foreach w $args {
    if ![winfo exists $w] continue
    set wid [expr [Winfo width $w]+[Winfo x $w]]
    if {$wid > $max} {
      set max $wid
      set maxw $w
    }
  }
  return $maxw
}

proc lowest {args} {
  set max 0
  set maxw [lindex $args 0]
  foreach w $args {
    if ![winfo exists $w] continue
    set wid [expr [Winfo height $w]+[Winfo y $w]]
    if {$wid > $max} {
      set max $wid
      set maxw $w
    }
  }
  return $maxw
}


proc to_widget {wi sib} {
  if ![winfo exists $wi] {
    set try [winfo parent $sib].$wi
    if [winfo exists $try] {return $try}
    set try [winfo parent $sib]$wi
    if [winfo exists $try] {return $try}
    #echo $wi
    if {[catch "set try \[$wi\]"]==0} {return $try}
    return "N"
  }
  return $wi
}
