/*
 * Startup code for the photo widget and associated commands.
 *
 * Copyright 1993 The Australian National University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, provided that the above copyright
 * notice appears in all copies.  This software is provided without any
 * warranty, express or implied. The Australian National University
 * makes no representations about the suitability of this software for
 * any purpose.
 *
 * Author: Paul Mackerras (paulus@cs.anu.edu.au)
 */

#ifndef lint
static char rcsid[] = "$Header";
#endif /* not lint */

#include "tk.h"
#include "tkInt.h"
#include "tkCanvas.h"

extern Tk_ItemType TkPhotoItemType;
extern int Tk_PhotoCmd _ANSI_ARGS_((ClientData clientData,
	Tcl_Interp *interp, int argc, char **argv));
extern int ReadPPMCmd _ANSI_ARGS_((ClientData clientData,
	Tcl_Interp *interp, int argc, char **argv));
extern int WritePPMCmd _ANSI_ARGS_((ClientData clientData,
	Tcl_Interp *interp, int argc, char **argv));
extern int PhotoCopyCmd _ANSI_ARGS_((ClientData clientData,
	Tcl_Interp *interp, int argc, char **argv));

/*
 *----------------------------------------------------------------------
 *
 * Photo_Init --
 *
 *	This procedure performs initialization for the photo widget
 *	and associated commands.  It registers the "photo" command
 *	and others, and also creates the "photo" canvas item type.
 *
 * Results:
 *	A standard Tcl return value, with a message in interp->result
 *	if an error occurs.
 *
 * Side effects:
 *	Creates commands and the "photo" canvas item type.
 *
 *----------------------------------------------------------------------
 */

int
Photo_Init(interp)
    Tcl_Interp *interp;
{
    Tk_Window main;

    main = Tk_MainWindow(interp);

    /*
     * Create the "photo" command and other useful photo-related commands.
     */
    Tcl_CreateCommand(interp, "photo", Tk_PhotoCmd, (ClientData) main,
		      (void (*)()) NULL);
    Tcl_CreateCommand(interp, "readppm", ReadPPMCmd, (ClientData) NULL,
		      (void (*)()) NULL);
    Tcl_CreateCommand(interp, "writeppm", WritePPMCmd, (ClientData) NULL,
		      (void (*)()) NULL);
    Tcl_CreateCommand(interp, "photocopy", PhotoCopyCmd, (ClientData) NULL,
		      (void (*)()) NULL);

    /*
     * Create the "photo" canvas item type.
     */
    Tk_CreateItemType(&TkPhotoItemType);

}
