'\" nistcl.n - TCL man page for NIS+ macros
'\"
'\" Copyright (C) 1994 Matthew R. Wette -- All rights reserved.
'\"
'\" Permission to use, copy, modify, and distribute this software and its
'\" documentation for any purpose and without fee is hereby granted, provided
'\" that the above copyright notice appears in all copies.  Matthew R. Wette
'\" makes no representations about the suitability of this software for any
'\" purpose.  It is provided "as is" without express or implied warranty.
'\"
.so man.macros
.HS nistcl tcl 7.0
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
nistcl \- TCL interface to the NIS+ library
.SH SYNOPSIS
.nf
\fBsource $nis_library/nis.tcl\fR

\fBnis_result\fR \fIvar\fR \fIoption\fR
\fBnis_object\fR \fIvar\fR \fIoption\fR

\fBnis_local_directory\fR
\fBnis_local_principal\fR
\fBnis_local_group\fR

\fBnis_list\fR \fIname\fR
\fBnis_add_entry\fR \fIname\fR TBD
\fBnis_modify_entry\fR \fIname\fR TBD
\fBnis_first_entry\fR \fIname\fR
\fBnis_next_entry\fR \fIname\fR \fIprevious-result\fR

\fBnis_lookup\fR TBD
\fBnis_add\fR TBD
\fBnis_modify\fR TBD
\fBnis_remove\fR TBD
.fi
.BE

.SH DESCRIPTION
.PP
This TCL library provides a set of commands for calling the SunOS NIS+
library.  Handles are used for internally manipulating the structures
processed by NIS+.  The NIS+ structures \fInis_result\fR appear as
(hashed) strings with name of the form \fInis_resultXXX\fR where
\fIXXX\fR is a three digit number.  The NIS+ \fInis_object\fR structures
is handled similarly.
.
The legal \fIoption\fR's (which may be abbreviated) are:
.TP
\fBnis_result \fIvar\fR expand
Expands the internal represention for a result into a TCL list.
.TP
\fBnis_result \fIvar\fR object \fI?n\?\fR
Return the internal represention for a result's object.
.TP
\fBnis_object \fIvar\fR expand
Expands the internal represention for an object into a TCL list.

.SH KEYWORDS
NIS, buggy, user-friendly-not

.SH AUTHOR
Matt Wette <mwette@csi.jpl.nasa.gov>

'\" $Id: nistcl.n,v 1.2 1994/04/19 17:34:38 mwette Exp $
