# $Id: minterp.tcl,v 1.2 1993/06/08 06:17:15 david Exp $
#
# minterp.tcl - Simple `require' functions built around minterp.
#
# AUTHOR:	David Herron <david@davids.mmdf.com> (home)
#
# Copyright 1993 David Herron.
# Permission to use, copy, modify and distribute this software
# and its documentation for any purpose and without fee is
# hereby granted, provided that the above copyright notice
# appear in all copies.  David Herron makes no representations
# about the suitability of this software for any purpose save
# printing it out and using the paper as bird cage lining.
#
#
#		FUNCTIONS
#
# require module-name
#
#	Load in specific modules if they are not already here.
#
# auto_index_modules dir files
#
#	(re)Build the index file to a minterp module directory.
#
# Define_Module module-name initialization-code
#
#	Define a new module.


proc Define_Module {modname initcode} {
	if ![interp exists $modname] {
		interp new $modname
		$modname -exec $initcode
	}
	return $modname
}

proc require module {
	if ![interp exists InterpBase] {
		if [file exists ./interpBaseC.tcl] {
			source ./interpBaseC.tcl
		} else {
			source [interp library]/interpBaseC.tcl
		}
	}
	if ![interp exists InterpBase] {
		error "Module InterpBase is not loaded."
	}
	if {$module == "InterpBase"} { return }
	return [InterpBase load_module $module]
}

proc auto_index_modules {dir files} {
	set od [pwd]
	cd $dir
	set dir [pwd]
	append index "# MINTERP autoload index file\n"
	append index "# each line identifies a `minterp' style module\n"
	append index "# and the file where the module is defined.\n"
	append index "# Generated by the \"auto_index_modules\" command.\n"
	append index "\n"
	foreach file [glob $files] {
		set f ""
		set f [open $file "r"]
		while {[gets $f line] >= 0} {
			if [regexp {^Define_Module[ 	]+([^ 	]+)} \
					$line match modulename] {
				append index "[list $modulename $file]\n"
			}
		}
		close $f
	}

	set f [open "minterpIndex" "w"]
	puts $f $index nonewline
	close $f

	cd $od
}